struct mdns_window;

enum mdns_view {
    MDNS_VIEW_DEFAULT = 0,
    MDNS_VIEW_URL,
    MDNS_VIEW_XEN,
};

typedef void (*mdns_callback)(struct mdns_window *mdns,
			      char *name, char *type,
			      char *host, int port, char *url);

struct mdns_window *mdns_create_window(int standalone, enum mdns_view view,
				       mdns_callback callback);
void mdns_show_window(struct mdns_window *mdns);
void mdns_destroy_window(struct mdns_window *mdns);

int  mdns_view(struct mdns_window *mdns, enum mdns_view view);
int  mdns_browse(struct mdns_window *mdns, int replace,
		 const char *service, const char *domain);
