#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3


from winswitch.objects.mount_point import MountPoint
from winswitch.fs.fs_client_helper import FS_Client_Helper


class NFS_Client_Helper(FS_Client_Helper):

	def __init__ (self, config):
		FS_Client_Helper.__init__(self, MountPoint.NFS, config.mount_location, "mount -t nfs", "umount")

	def do_mount(self, user, mp):
		mnt_path = self.get_local_mount_point(self.user.host, mp.path)
		self.sdebug("mount path=%s" % mnt_path, user, mp)
		return	False
