/*
 * Decompiled with CFR 0.152.
 */
package rene.viewer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintWriter;
import rene.gui.Global;
import rene.util.list.ListClass;
import rene.util.list.ListElement;
import rene.viewer.ClipboardCopy;
import rene.viewer.Line;
import rene.viewer.TextPosition;
import rene.viewer.Viewer;

public class TextDisplay
extends Canvas
implements ClipboardOwner,
ComponentListener {
    ListClass L = new ListClass();
    Font F = null;
    FontMetrics FM;
    Viewer V;
    int Leading;
    int Height;
    int Ascent;
    int Descent;
    int LineCount;
    int TopLineCount;
    int PageSize;
    ListElement TopLine;
    Image I;
    Graphics IG;
    int W;
    int H;
    public int Tabsize = 4;
    public int Offset;
    boolean LineFinished = true;
    int[] Widths;
    int[] HW;
    long LastScrollTime;
    Color Background;
    int TabWidth = 0;

    public TextDisplay(Viewer viewer) {
        this.V = viewer;
        this.LineCount = 0;
        this.TopLineCount = 0;
        this.TopLine = null;
        this.I = null;
        this.H = 0;
        this.W = 0;
        this.PageSize = 10;
        this.HW = new int[1024];
        this.addKeyListener(viewer);
        this.addComponentListener(this);
    }

    void init(Font font) {
        this.F = font;
        this.FM = this.getFontMetrics(this.F);
        this.Leading = this.FM.getLeading() + Global.getParameter("fixedfont.spacing", -1);
        this.Height = this.FM.getHeight();
        this.Ascent = this.FM.getAscent();
        this.Descent = this.FM.getDescent();
        this.Widths = this.FM.getWidths();
        this.Background = Global.Background != null ? Global.Background : SystemColor.window;
    }

    public Color getBackground() {
        if (Global.Background != null) {
            return Global.Background;
        }
        return SystemColor.window;
    }

    int[] getwidth(char[] cArray) {
        try {
            for (int i = 0; i < cArray.length; ++i) {
                this.HW[i] = cArray[i] < '\u0100' ? this.Widths[cArray[i]] : this.FM.charWidth(cArray[i]);
            }
        }
        catch (Exception exception) {
            return this.HW;
        }
        return this.HW;
    }

    public synchronized void appendLine0(String string) {
        this.appendLine0(string, Color.black);
    }

    public synchronized void appendLine0(String string, Color color) {
        Line line = new Line(string, this, color);
        this.L.append(new ListElement(line));
        ++this.LineCount;
        if (this.LineCount == 1) {
            this.TopLine = this.L.first();
        }
        this.LineFinished = true;
        if (this.TabWidth > 0) {
            line.expandTabs(this.TabWidth);
        }
    }

    public synchronized void appendLine(String string) {
        this.appendLine0(string);
        this.V.setVerticalScrollbar();
    }

    public void append(String string, Color color) {
        this.append(string, color, true);
    }

    public void append(String string, Color color, boolean bl) {
        int n;
        do {
            if ((n = string.indexOf(10)) < 0) {
                this.appendlast(string, color);
                this.LineFinished = false;
                break;
            }
            this.appendlast(string.substring(0, n), color);
            this.LineFinished = true;
        } while (!(string = string.substring(n + 1)).equals(""));
        if (bl) {
            this.doUpdate(true);
        }
        this.repaint();
    }

    public void doUpdate(boolean bl) {
        long l;
        if (bl && (l = System.currentTimeMillis()) - this.LastScrollTime > 10000L) {
            this.showlast();
        }
        this.repaint();
        this.V.setVerticalScrollbar();
    }

    public void setText(String string) {
        this.TopLine = null;
        this.TopLineCount = 0;
        this.LineCount = 0;
        this.L = new ListClass();
        if (!string.equals("")) {
            this.append(string, Color.black);
        }
        this.repaint();
    }

    public synchronized void appendlast(String string, Color color) {
        if (this.LineFinished || this.L.last() == null) {
            Line line = new Line(string, this, color);
            this.L.append(new ListElement(line));
            ++this.LineCount;
            if (this.LineCount == 1) {
                this.TopLine = this.L.first();
            }
            if (this.TabWidth > 0) {
                line.expandTabs(this.TabWidth);
            }
        } else {
            ((Line)this.L.last().content()).append(string);
        }
    }

    public void showlast() {
        ListElement listElement = this.L.last();
        if (listElement == null) {
            return;
        }
        this.TopLineCount = this.LineCount;
        for (int i = 0; i < this.PageSize - 1 && listElement.previous() != null; ++i) {
            listElement = listElement.previous();
            --this.TopLineCount;
        }
        this.TopLine = listElement;
        this.repaint();
    }

    public void makeimage() {
        Dimension dimension = this.getSize();
        if (this.I == null || dimension.width != this.W || dimension.height != this.H) {
            this.W = dimension.width;
            this.H = dimension.height;
            this.I = this.createImage(this.W, this.H);
            this.IG = this.I.getGraphics();
        }
        this.IG.setColor(Color.black);
        this.IG.clearRect(0, 0, this.W, this.H);
        this.IG.setFont(this.F);
        try {
            this.PageSize = this.H / (this.Height + this.Leading);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void paint(Graphics graphics) {
        if (this.F == null) {
            this.init(this.getFont());
        }
        this.makeimage();
        ListElement listElement = this.TopLine;
        this.antialias(true);
        int n = this.Leading + this.Ascent;
        int n2 = this.getSize().height - this.Descent;
        if (this.Background == null) {
            this.Background = this.getBackground();
        }
        this.IG.setColor(this.Background);
        this.IG.fillRect(0, 0, this.W, this.H);
        for (int n3 = 0; n3 < this.PageSize && listElement != null; listElement = listElement.next(), ++n3) {
            Line line = (Line)listElement.content();
            line.draw(this.IG, 2, n);
            n += this.Leading + this.Height;
        }
        graphics.drawImage(this.I, 0, 0, this);
    }

    public void antialias(boolean bl) {
        if (Global.getParameter("font.smooth", true)) {
            this.IG = (Graphics2D)this.IG;
            ((Graphics2D)this.IG).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, bl ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public void showLine(ListElement listElement) {
        ListElement listElement2 = this.TopLine;
        int n = this.Leading + this.Ascent;
        int n2 = this.getSize().height - this.Descent;
        if (this.Background == null) {
            this.Background = this.getBackground();
        }
        for (int n3 = 0; n3 < this.PageSize && listElement2 != null; listElement2 = listElement2.next(), ++n3) {
            if (listElement2 == listElement) {
                return;
            }
            n += this.Leading + this.Height;
        }
        this.TopLine = listElement2 == listElement && this.TopLine.next() != null ? this.TopLine.next() : listElement;
    }

    public ListElement getline(int n) {
        if (this.TopLine == null) {
            return null;
        }
        ListElement listElement = this.TopLine;
        int n2 = this.Leading + this.Height;
        if (n2 == 0) {
            return null;
        }
        n2 = n / n2;
        for (int i = 0; i < n2; ++i) {
            if (listElement.next() == null) {
                return listElement;
            }
            listElement = listElement.next();
        }
        return listElement;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    int computeVertical() {
        if (this.LineCount > 0) {
            return this.TopLineCount * 1000 / this.LineCount;
        }
        return 0;
    }

    public int setVertical(int n) {
        if (this.TopLine == null) {
            return 0;
        }
        int n2 = this.LineCount * n / 1000;
        if (n2 > this.TopLineCount) {
            for (int i = this.TopLineCount; i < n2 && this.TopLine.next() != null; ++i) {
                this.TopLine = this.TopLine.next();
                ++this.TopLineCount;
            }
            this.repaint();
        } else if (n2 < this.TopLineCount) {
            for (int i = this.TopLineCount; i > n2 && this.TopLine.previous() != null; --i) {
                this.TopLine = this.TopLine.previous();
                --this.TopLineCount;
            }
            this.repaint();
        }
        this.LastScrollTime = System.currentTimeMillis();
        return n;
    }

    public void verticalUp() {
        if (this.TopLine == null) {
            return;
        }
        if (this.TopLine.next() == null) {
            return;
        }
        this.TopLine = this.TopLine.next();
        ++this.TopLineCount;
        this.repaint();
        this.LastScrollTime = System.currentTimeMillis();
    }

    public void verticalDown() {
        if (this.TopLine == null) {
            return;
        }
        if (this.TopLine.previous() == null) {
            return;
        }
        this.TopLine = this.TopLine.previous();
        --this.TopLineCount;
        this.repaint();
        this.LastScrollTime = System.currentTimeMillis();
    }

    public void verticalPageUp() {
        if (this.TopLine == null) {
            return;
        }
        for (int i = 0; i < this.PageSize - 1 && this.TopLine.next() != null; ++i) {
            this.TopLine = this.TopLine.next();
            ++this.TopLineCount;
        }
        this.repaint();
        this.LastScrollTime = System.currentTimeMillis();
    }

    public void verticalPageDown() {
        if (this.TopLine == null) {
            return;
        }
        for (int i = 0; i < this.PageSize - 1 && this.TopLine.previous() != null; ++i) {
            this.TopLine = this.TopLine.previous();
            --this.TopLineCount;
        }
        this.repaint();
        this.LastScrollTime = System.currentTimeMillis();
    }

    int computeVerticalSize() {
        if (this.LineCount == 0) {
            return 100;
        }
        int n = this.PageSize * 2000 / this.LineCount;
        if (n < 10) {
            n = 10;
        }
        return n;
    }

    public int setHorizontal(int n) {
        this.Offset = n / 5;
        this.repaint();
        return n;
    }

    public void save(PrintWriter printWriter) {
        for (ListElement listElement = this.L.first(); listElement != null; listElement = listElement.next()) {
            printWriter.println(new String(((Line)listElement.content()).a));
        }
    }

    public TextPosition getposition(int n, int n2) {
        int n3;
        if (this.L.first() == null) {
            return null;
        }
        if (n2 < 0) {
            return new TextPosition(this.TopLine, this.TopLineCount, 0);
        }
        if (this.TopLine == null) {
            return null;
        }
        ListElement listElement = this.TopLine;
        int n4 = this.Leading + this.Height;
        if (n4 == 0) {
            return null;
        }
        n4 = n2 / n4;
        for (n3 = 0; n3 < n4; ++n3) {
            if (listElement.next() == null || n3 == this.PageSize - 1) {
                return new TextPosition(listElement, this.TopLineCount + n3, ((Line)listElement.content()).length());
            }
            listElement = listElement.next();
        }
        return new TextPosition(listElement, this.TopLineCount + n3, ((Line)listElement.content()).getpos(n, 2));
    }

    public void unmark() {
        for (ListElement listElement = this.L.first(); listElement != null; listElement = listElement.next()) {
            ((Line)listElement.content()).block(0, 0);
        }
        this.repaint();
    }

    public void unmark(TextPosition textPosition, TextPosition textPosition2) {
        ListElement listElement;
        TextPosition textPosition3;
        TextPosition textPosition4;
        if (textPosition == null || textPosition2 == null) {
            return;
        }
        if (textPosition.before(textPosition2)) {
            textPosition4 = textPosition;
            textPosition3 = textPosition2;
        } else if (textPosition2.before(textPosition)) {
            textPosition4 = textPosition2;
            textPosition3 = textPosition;
        } else {
            return;
        }
        for (listElement = textPosition4.L; listElement != null && listElement != textPosition3.L; listElement = listElement.next()) {
            ((Line)listElement.content()).block(0, 0);
        }
        if (listElement != null) {
            ((Line)listElement.content()).block(0, 0);
        }
        this.repaint();
    }

    public void mark(TextPosition textPosition, TextPosition textPosition2) {
        TextPosition textPosition3;
        TextPosition textPosition4;
        if (textPosition == null || textPosition2 == null) {
            return;
        }
        if (textPosition.before(textPosition2)) {
            textPosition4 = textPosition;
            textPosition3 = textPosition2;
        } else if (textPosition2.before(textPosition)) {
            textPosition4 = textPosition2;
            textPosition3 = textPosition;
        } else {
            return;
        }
        ListElement listElement = textPosition4.L;
        ((Line)listElement.content()).block(textPosition4.LPos, 1);
        if (listElement != textPosition3.L) {
            listElement = listElement.next();
        }
        while (listElement != null && listElement != textPosition3.L) {
            ((Line)listElement.content()).block(0, 4);
            listElement = listElement.next();
        }
        if (listElement != null) {
            ((Line)listElement.content()).block(textPosition3.LPos, 2);
        }
        this.repaint();
        this.requestFocus();
    }

    void copy(TextPosition textPosition, TextPosition textPosition2) {
        ListElement listElement;
        TextPosition textPosition3;
        TextPosition textPosition4;
        if (textPosition == null || textPosition2 == null) {
            return;
        }
        if (textPosition.before(textPosition2)) {
            textPosition4 = textPosition;
            textPosition3 = textPosition2;
        } else if (textPosition2.before(textPosition)) {
            textPosition4 = textPosition2;
            textPosition3 = textPosition;
        } else {
            return;
        }
        String string = "";
        for (listElement = textPosition4.L; listElement != null && listElement != textPosition3.L; listElement = listElement.next()) {
            string = string + ((Line)listElement.content()).getblock() + "\n";
        }
        if (listElement != null) {
            string = string + ((Line)listElement.content()).getblock();
        }
        new ClipboardCopy(this, this, string);
    }

    public void showFirst() {
        this.TopLine = this.L.first();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    TextPosition lastpos() {
        ListElement listElement = this.L.last();
        if (listElement == null) {
            return null;
        }
        Line line = (Line)listElement.content();
        return new TextPosition(listElement, this.LineCount, line.length());
    }

    public void setTabWidth(int n) {
        this.TabWidth = n;
    }

    public boolean hasFocus() {
        return this.V.hasFocus();
    }

    public void setBackground(Color color) {
        this.Background = color;
        super.setBackground(color);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.V.resized();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

