/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  gengetopt -i cmd_main.ggo --no-handle-version --file-name=cmd_main --func-name=main_cmdline_parser --arg-struct-name=main_args_info

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmd_main.h"

const char *main_args_info_purpose = "sxadm is used to create and manage SX clusters";

const char *main_args_info_usage = "Usage: sxadm <command> [OPTIONS]...";

const char *main_args_info_versiontext = "";

const char *main_args_info_description = "";

const char *main_args_info_help[] = {
  "  -h, --help     Print help and exit",
  "  -V, --version  Print version and exit",
  "\nAvailable commands:\n\n  cluster        Create or manage an SX cluster\n  node           Create or manage a local SX node\n\nSee 'sxadm <command> --help' for more information on a specific command.\n",
    0
};

typedef enum {ARG_NO
} main_cmdline_parser_arg_type;

static
void clear_given (struct main_args_info *args_info);
static
void clear_args (struct main_args_info *args_info);

static int
main_cmdline_parser_internal (int argc, char **argv, struct main_args_info *args_info,
                        struct main_cmdline_parser_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct main_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
}

static
void clear_args (struct main_args_info *args_info)
{
  FIX_UNUSED (args_info);
  
}

static
void init_args_info(struct main_args_info *args_info)
{


  args_info->help_help = main_args_info_help[0] ;
  args_info->version_help = main_args_info_help[1] ;
  
}

void
main_cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(MAIN_CMDLINE_PARSER_PACKAGE_NAME) ? MAIN_CMDLINE_PARSER_PACKAGE_NAME : MAIN_CMDLINE_PARSER_PACKAGE),
     MAIN_CMDLINE_PARSER_VERSION);

  if (strlen(main_args_info_versiontext) > 0)
    printf("\n%s\n", main_args_info_versiontext);
}

static void print_help_common(void) {
  main_cmdline_parser_print_version ();

  if (strlen(main_args_info_purpose) > 0)
    printf("\n%s\n", main_args_info_purpose);

  if (strlen(main_args_info_usage) > 0)
    printf("\n%s\n", main_args_info_usage);

  printf("\n");

  if (strlen(main_args_info_description) > 0)
    printf("%s\n\n", main_args_info_description);
}

void
main_cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (main_args_info_help[i])
    printf("%s\n", main_args_info_help[i++]);
}

void
main_cmdline_parser_init (struct main_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
main_cmdline_parser_params_init(struct main_cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct main_cmdline_parser_params *
main_cmdline_parser_params_create(void)
{
  struct main_cmdline_parser_params *params = 
    (struct main_cmdline_parser_params *)malloc(sizeof(struct main_cmdline_parser_params));
  main_cmdline_parser_params_init(params);  
  return params;
}



static void
main_cmdline_parser_release (struct main_args_info *args_info)
{

  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
main_cmdline_parser_dump(FILE *outfile, struct main_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", MAIN_CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
main_cmdline_parser_file_save(const char *filename, struct main_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", MAIN_CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = main_cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
main_cmdline_parser_free (struct main_args_info *args_info)
{
  main_cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
main_cmdline_parser (int argc, char **argv, struct main_args_info *args_info)
{
  return main_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
main_cmdline_parser_ext (int argc, char **argv, struct main_args_info *args_info,
                   struct main_cmdline_parser_params *params)
{
  int result;
  result = main_cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      main_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
main_cmdline_parser2 (int argc, char **argv, struct main_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct main_cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = main_cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      main_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
main_cmdline_parser_required (struct main_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see main_cmdline_parser_params.check_ambiguity
 * @param override @see main_cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               main_cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  default:
    break;
  };


  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
main_cmdline_parser_internal (
  int argc, char **argv, struct main_args_info *args_info,
                        struct main_cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct main_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    main_cmdline_parser_init (args_info);

  main_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hV", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          main_cmdline_parser_print_help ();
          main_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->version_given),
              &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "version", 'V',
              additional_error))
            goto failure;
          main_cmdline_parser_free (&local_args_info);
          return 0;
        
          break;

        case 0:	/* Long option with no short option */
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", MAIN_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  main_cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  main_cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
