/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  gengetopt --conf-parse --no-handle-version --file-name=cfgfile --no-handle-error

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cfgfile.h"

const char *gengetopt_args_info_purpose = "SX FastCGI Interface";

const char *gengetopt_args_info_usage = "Usage: sx.fcgi";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_full_help[] = {
  "  -h, --help                    Print help and exit",
  "      --full-help               Print help, including hidden options, and exit",
  "  -V, --version                 Print version and exit",
  "      --socket=SOCKET           Set socket for connection with httpd",
  "      --children=N              Start N children processes  (default=`24')",
  "      --reserved-socket=SOCKET  Set httpd socket reserved for internode\n                                  communication",
  "      --reserved-children=N     Start N children processes reserved for\n                                  internode communication  (default=`8')",
  "      --socket-mode=MODE        Set socket mode to MODE (octal number; unix\n                                  sockets only)",
  "      --data-dir=PATH           Path to data directory",
  "      --logfile=FILE            Write all log information to FILE",
  "      --pidfile=FILE            Write process ID to FILE",
  "      --foreground              Do not daemonize  (default=off)",
  "      --debug                   Enable debug messages  (default=off)",
  "      --run-as=user[:group]     Run as specified user[:group]",
  "      --ssl_ca=STRING           Path to SSL CA certificate",
  "      --gc-interval=sec         How often to run the GC  (default=`3600')",
  "      --gc-max-batch=N          Maximum number of rows/transaction in the GC\n                                  (default=`100')",
  "      --gc-max-batch-time=N     Maximum time for a transaction in the GC in\n                                  seconds  (default=`1')",
  "      --gc-yield-time=N         Time to yield between GC transactions\n                                  (default=`1.1')",
  "      --gc-no-slow-check        Don't run the old GC  (default=off)",
  "      --blockmgr-delay=sec      Blockmgr delay  (default=`3')",
  "      --db-min-passive-wal-pages=N\n                                Minimum number of pages in WAL to trigger a\n                                  passive checkpoint  (default=`5000')",
  "      --db-max-passive-wal-pages=N\n                                Maximum number of pages in WAL to trigger a\n                                  passive checkpoint  (default=`10000')",
  "      --db-max-wal-restart-pages=N\n                                Maximum number of pages in WAL before forcing a\n                                  WAL restart  (default=`20000')",
  "      --db-idle-restart=sec     Interval to force a WAL restart when idle\n                                  (default=`60')",
  "      --db-busy-timeout=sec     SQLite database busy timeout  (default=`20')",
  "      --db-max-mmapsize=N       SQLite mmap size (0 to disable)\n                                  (default=`2147418112')",
  "      --db-no-custom-vfs        Do not use custom SQLite VFS  (default=off)",
  "      --worker-max-wait=sec     Maximum time to wait before killing a worker\n                                  (default=`300')",
  "      --worker-max-requests=N   Maximum number of requests / worker\n                                  (default=`5000')",
    0
};

static void
init_help_array(void)
{
  gengetopt_args_info_help[0] = gengetopt_args_info_full_help[0];
  gengetopt_args_info_help[1] = gengetopt_args_info_full_help[1];
  gengetopt_args_info_help[2] = gengetopt_args_info_full_help[2];
  gengetopt_args_info_help[3] = gengetopt_args_info_full_help[3];
  gengetopt_args_info_help[4] = gengetopt_args_info_full_help[4];
  gengetopt_args_info_help[5] = gengetopt_args_info_full_help[5];
  gengetopt_args_info_help[6] = gengetopt_args_info_full_help[6];
  gengetopt_args_info_help[7] = gengetopt_args_info_full_help[7];
  gengetopt_args_info_help[8] = gengetopt_args_info_full_help[8];
  gengetopt_args_info_help[9] = gengetopt_args_info_full_help[9];
  gengetopt_args_info_help[10] = gengetopt_args_info_full_help[10];
  gengetopt_args_info_help[11] = gengetopt_args_info_full_help[11];
  gengetopt_args_info_help[12] = gengetopt_args_info_full_help[12];
  gengetopt_args_info_help[13] = gengetopt_args_info_full_help[13];
  gengetopt_args_info_help[14] = gengetopt_args_info_full_help[14];
  gengetopt_args_info_help[15] = 0; 
  
}

const char *gengetopt_args_info_help[16];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_FLOAT
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);
struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->socket_given = 0 ;
  args_info->children_given = 0 ;
  args_info->reserved_socket_given = 0 ;
  args_info->reserved_children_given = 0 ;
  args_info->socket_mode_given = 0 ;
  args_info->data_dir_given = 0 ;
  args_info->logfile_given = 0 ;
  args_info->pidfile_given = 0 ;
  args_info->foreground_given = 0 ;
  args_info->debug_given = 0 ;
  args_info->run_as_given = 0 ;
  args_info->ssl_ca_given = 0 ;
  args_info->gc_interval_given = 0 ;
  args_info->gc_max_batch_given = 0 ;
  args_info->gc_max_batch_time_given = 0 ;
  args_info->gc_yield_time_given = 0 ;
  args_info->gc_no_slow_check_given = 0 ;
  args_info->blockmgr_delay_given = 0 ;
  args_info->db_min_passive_wal_pages_given = 0 ;
  args_info->db_max_passive_wal_pages_given = 0 ;
  args_info->db_max_wal_restart_pages_given = 0 ;
  args_info->db_idle_restart_given = 0 ;
  args_info->db_busy_timeout_given = 0 ;
  args_info->db_max_mmapsize_given = 0 ;
  args_info->db_no_custom_vfs_given = 0 ;
  args_info->worker_max_wait_given = 0 ;
  args_info->worker_max_requests_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->socket_arg = NULL;
  args_info->socket_orig = NULL;
  args_info->children_arg = 24;
  args_info->children_orig = NULL;
  args_info->reserved_socket_arg = NULL;
  args_info->reserved_socket_orig = NULL;
  args_info->reserved_children_arg = 8;
  args_info->reserved_children_orig = NULL;
  args_info->socket_mode_orig = NULL;
  args_info->data_dir_arg = NULL;
  args_info->data_dir_orig = NULL;
  args_info->logfile_arg = NULL;
  args_info->logfile_orig = NULL;
  args_info->pidfile_arg = NULL;
  args_info->pidfile_orig = NULL;
  args_info->foreground_flag = 0;
  args_info->debug_flag = 0;
  args_info->run_as_arg = NULL;
  args_info->run_as_orig = NULL;
  args_info->ssl_ca_arg = NULL;
  args_info->ssl_ca_orig = NULL;
  args_info->gc_interval_arg = 3600;
  args_info->gc_interval_orig = NULL;
  args_info->gc_max_batch_arg = 100;
  args_info->gc_max_batch_orig = NULL;
  args_info->gc_max_batch_time_arg = 1;
  args_info->gc_max_batch_time_orig = NULL;
  args_info->gc_yield_time_arg = 1.1;
  args_info->gc_yield_time_orig = NULL;
  args_info->gc_no_slow_check_flag = 0;
  args_info->blockmgr_delay_arg = 3;
  args_info->blockmgr_delay_orig = NULL;
  args_info->db_min_passive_wal_pages_arg = 5000;
  args_info->db_min_passive_wal_pages_orig = NULL;
  args_info->db_max_passive_wal_pages_arg = 10000;
  args_info->db_max_passive_wal_pages_orig = NULL;
  args_info->db_max_wal_restart_pages_arg = 20000;
  args_info->db_max_wal_restart_pages_orig = NULL;
  args_info->db_idle_restart_arg = 60;
  args_info->db_idle_restart_orig = NULL;
  args_info->db_busy_timeout_arg = 20;
  args_info->db_busy_timeout_orig = NULL;
  args_info->db_max_mmapsize_arg = 2147418112;
  args_info->db_max_mmapsize_orig = NULL;
  args_info->db_no_custom_vfs_flag = 0;
  args_info->worker_max_wait_arg = 300;
  args_info->worker_max_wait_orig = NULL;
  args_info->worker_max_requests_arg = 5000;
  args_info->worker_max_requests_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{

  init_help_array(); 
  args_info->help_help = gengetopt_args_info_full_help[0] ;
  args_info->full_help_help = gengetopt_args_info_full_help[1] ;
  args_info->version_help = gengetopt_args_info_full_help[2] ;
  args_info->socket_help = gengetopt_args_info_full_help[3] ;
  args_info->children_help = gengetopt_args_info_full_help[4] ;
  args_info->reserved_socket_help = gengetopt_args_info_full_help[5] ;
  args_info->reserved_children_help = gengetopt_args_info_full_help[6] ;
  args_info->socket_mode_help = gengetopt_args_info_full_help[7] ;
  args_info->data_dir_help = gengetopt_args_info_full_help[8] ;
  args_info->logfile_help = gengetopt_args_info_full_help[9] ;
  args_info->pidfile_help = gengetopt_args_info_full_help[10] ;
  args_info->foreground_help = gengetopt_args_info_full_help[11] ;
  args_info->debug_help = gengetopt_args_info_full_help[12] ;
  args_info->run_as_help = gengetopt_args_info_full_help[13] ;
  args_info->ssl_ca_help = gengetopt_args_info_full_help[14] ;
  args_info->gc_interval_help = gengetopt_args_info_full_help[15] ;
  args_info->gc_max_batch_help = gengetopt_args_info_full_help[16] ;
  args_info->gc_max_batch_time_help = gengetopt_args_info_full_help[17] ;
  args_info->gc_yield_time_help = gengetopt_args_info_full_help[18] ;
  args_info->gc_no_slow_check_help = gengetopt_args_info_full_help[19] ;
  args_info->blockmgr_delay_help = gengetopt_args_info_full_help[20] ;
  args_info->db_min_passive_wal_pages_help = gengetopt_args_info_full_help[21] ;
  args_info->db_max_passive_wal_pages_help = gengetopt_args_info_full_help[22] ;
  args_info->db_max_wal_restart_pages_help = gengetopt_args_info_full_help[23] ;
  args_info->db_idle_restart_help = gengetopt_args_info_full_help[24] ;
  args_info->db_busy_timeout_help = gengetopt_args_info_full_help[25] ;
  args_info->db_max_mmapsize_help = gengetopt_args_info_full_help[26] ;
  args_info->db_no_custom_vfs_help = gengetopt_args_info_full_help[27] ;
  args_info->worker_max_wait_help = gengetopt_args_info_full_help[28] ;
  args_info->worker_max_requests_help = gengetopt_args_info_full_help[29] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_full_help[i])
    printf("%s\n", gengetopt_args_info_full_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->socket_arg));
  free_string_field (&(args_info->socket_orig));
  free_string_field (&(args_info->children_orig));
  free_string_field (&(args_info->reserved_socket_arg));
  free_string_field (&(args_info->reserved_socket_orig));
  free_string_field (&(args_info->reserved_children_orig));
  free_string_field (&(args_info->socket_mode_orig));
  free_string_field (&(args_info->data_dir_arg));
  free_string_field (&(args_info->data_dir_orig));
  free_string_field (&(args_info->logfile_arg));
  free_string_field (&(args_info->logfile_orig));
  free_string_field (&(args_info->pidfile_arg));
  free_string_field (&(args_info->pidfile_orig));
  free_string_field (&(args_info->run_as_arg));
  free_string_field (&(args_info->run_as_orig));
  free_string_field (&(args_info->ssl_ca_arg));
  free_string_field (&(args_info->ssl_ca_orig));
  free_string_field (&(args_info->gc_interval_orig));
  free_string_field (&(args_info->gc_max_batch_orig));
  free_string_field (&(args_info->gc_max_batch_time_orig));
  free_string_field (&(args_info->gc_yield_time_orig));
  free_string_field (&(args_info->blockmgr_delay_orig));
  free_string_field (&(args_info->db_min_passive_wal_pages_orig));
  free_string_field (&(args_info->db_max_passive_wal_pages_orig));
  free_string_field (&(args_info->db_max_wal_restart_pages_orig));
  free_string_field (&(args_info->db_idle_restart_orig));
  free_string_field (&(args_info->db_busy_timeout_orig));
  free_string_field (&(args_info->db_max_mmapsize_orig));
  free_string_field (&(args_info->worker_max_wait_orig));
  free_string_field (&(args_info->worker_max_requests_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->socket_given)
    write_into_file(outfile, "socket", args_info->socket_orig, 0);
  if (args_info->children_given)
    write_into_file(outfile, "children", args_info->children_orig, 0);
  if (args_info->reserved_socket_given)
    write_into_file(outfile, "reserved-socket", args_info->reserved_socket_orig, 0);
  if (args_info->reserved_children_given)
    write_into_file(outfile, "reserved-children", args_info->reserved_children_orig, 0);
  if (args_info->socket_mode_given)
    write_into_file(outfile, "socket-mode", args_info->socket_mode_orig, 0);
  if (args_info->data_dir_given)
    write_into_file(outfile, "data-dir", args_info->data_dir_orig, 0);
  if (args_info->logfile_given)
    write_into_file(outfile, "logfile", args_info->logfile_orig, 0);
  if (args_info->pidfile_given)
    write_into_file(outfile, "pidfile", args_info->pidfile_orig, 0);
  if (args_info->foreground_given)
    write_into_file(outfile, "foreground", 0, 0 );
  if (args_info->debug_given)
    write_into_file(outfile, "debug", 0, 0 );
  if (args_info->run_as_given)
    write_into_file(outfile, "run-as", args_info->run_as_orig, 0);
  if (args_info->ssl_ca_given)
    write_into_file(outfile, "ssl_ca", args_info->ssl_ca_orig, 0);
  if (args_info->gc_interval_given)
    write_into_file(outfile, "gc-interval", args_info->gc_interval_orig, 0);
  if (args_info->gc_max_batch_given)
    write_into_file(outfile, "gc-max-batch", args_info->gc_max_batch_orig, 0);
  if (args_info->gc_max_batch_time_given)
    write_into_file(outfile, "gc-max-batch-time", args_info->gc_max_batch_time_orig, 0);
  if (args_info->gc_yield_time_given)
    write_into_file(outfile, "gc-yield-time", args_info->gc_yield_time_orig, 0);
  if (args_info->gc_no_slow_check_given)
    write_into_file(outfile, "gc-no-slow-check", 0, 0 );
  if (args_info->blockmgr_delay_given)
    write_into_file(outfile, "blockmgr-delay", args_info->blockmgr_delay_orig, 0);
  if (args_info->db_min_passive_wal_pages_given)
    write_into_file(outfile, "db-min-passive-wal-pages", args_info->db_min_passive_wal_pages_orig, 0);
  if (args_info->db_max_passive_wal_pages_given)
    write_into_file(outfile, "db-max-passive-wal-pages", args_info->db_max_passive_wal_pages_orig, 0);
  if (args_info->db_max_wal_restart_pages_given)
    write_into_file(outfile, "db-max-wal-restart-pages", args_info->db_max_wal_restart_pages_orig, 0);
  if (args_info->db_idle_restart_given)
    write_into_file(outfile, "db-idle-restart", args_info->db_idle_restart_orig, 0);
  if (args_info->db_busy_timeout_given)
    write_into_file(outfile, "db-busy-timeout", args_info->db_busy_timeout_orig, 0);
  if (args_info->db_max_mmapsize_given)
    write_into_file(outfile, "db-max-mmapsize", args_info->db_max_mmapsize_orig, 0);
  if (args_info->db_no_custom_vfs_given)
    write_into_file(outfile, "db-no-custom-vfs", 0, 0 );
  if (args_info->worker_max_wait_given)
    write_into_file(outfile, "worker-max-wait", args_info->worker_max_wait_orig, 0);
  if (args_info->worker_max_requests_given)
    write_into_file(outfile, "worker-max-requests", args_info->worker_max_requests_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (! args_info->socket_given)
    {
      fprintf (stderr, "%s: '--socket' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  if (! args_info->data_dir_given)
    {
      fprintf (stderr, "%s: '--data-dir' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  if (! args_info->logfile_given)
    {
      fprintf (stderr, "%s: '--logfile' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }
  
  
  /* checks for dependences among options */
  if (args_info->reserved_children_given && ! args_info->reserved_socket_given)
    {
      fprintf (stderr, "%s: '--reserved-children' option depends on option 'reserved-socket'%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_FLOAT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "socket",	1, NULL, 0 },
        { "children",	1, NULL, 0 },
        { "reserved-socket",	1, NULL, 0 },
        { "reserved-children",	1, NULL, 0 },
        { "socket-mode",	1, NULL, 0 },
        { "data-dir",	1, NULL, 0 },
        { "logfile",	1, NULL, 0 },
        { "pidfile",	1, NULL, 0 },
        { "foreground",	0, NULL, 0 },
        { "debug",	0, NULL, 0 },
        { "run-as",	1, NULL, 0 },
        { "ssl_ca",	1, NULL, 0 },
        { "gc-interval",	1, NULL, 0 },
        { "gc-max-batch",	1, NULL, 0 },
        { "gc-max-batch-time",	1, NULL, 0 },
        { "gc-yield-time",	1, NULL, 0 },
        { "gc-no-slow-check",	0, NULL, 0 },
        { "blockmgr-delay",	1, NULL, 0 },
        { "db-min-passive-wal-pages",	1, NULL, 0 },
        { "db-max-passive-wal-pages",	1, NULL, 0 },
        { "db-max-wal-restart-pages",	1, NULL, 0 },
        { "db-idle-restart",	1, NULL, 0 },
        { "db-busy-timeout",	1, NULL, 0 },
        { "db-max-mmapsize",	1, NULL, 0 },
        { "db-no-custom-vfs",	0, NULL, 0 },
        { "worker-max-wait",	1, NULL, 0 },
        { "worker-max-requests",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hV", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->version_given),
              &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "version", 'V',
              additional_error))
            goto failure;
          cmdline_parser_free (&local_args_info);
          return 0;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            cmdline_parser_print_full_help ();
            cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Set socket for connection with httpd.  */
          if (strcmp (long_options[option_index].name, "socket") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->socket_arg), 
                 &(args_info->socket_orig), &(args_info->socket_given),
                &(local_args_info.socket_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "socket", '-',
                additional_error))
              goto failure;
          
          }
          /* Start N children processes.  */
          else if (strcmp (long_options[option_index].name, "children") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->children_arg), 
                 &(args_info->children_orig), &(args_info->children_given),
                &(local_args_info.children_given), optarg, 0, "24", ARG_INT,
                check_ambiguity, override, 0, 0,
                "children", '-',
                additional_error))
              goto failure;
          
          }
          /* Set httpd socket reserved for internode communication.  */
          else if (strcmp (long_options[option_index].name, "reserved-socket") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->reserved_socket_arg), 
                 &(args_info->reserved_socket_orig), &(args_info->reserved_socket_given),
                &(local_args_info.reserved_socket_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "reserved-socket", '-',
                additional_error))
              goto failure;
          
          }
          /* Start N children processes reserved for internode communication.  */
          else if (strcmp (long_options[option_index].name, "reserved-children") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->reserved_children_arg), 
                 &(args_info->reserved_children_orig), &(args_info->reserved_children_given),
                &(local_args_info.reserved_children_given), optarg, 0, "8", ARG_INT,
                check_ambiguity, override, 0, 0,
                "reserved-children", '-',
                additional_error))
              goto failure;
          
          }
          /* Set socket mode to MODE (octal number; unix sockets only).  */
          else if (strcmp (long_options[option_index].name, "socket-mode") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->socket_mode_arg), 
                 &(args_info->socket_mode_orig), &(args_info->socket_mode_given),
                &(local_args_info.socket_mode_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "socket-mode", '-',
                additional_error))
              goto failure;
          
          }
          /* Path to data directory.  */
          else if (strcmp (long_options[option_index].name, "data-dir") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->data_dir_arg), 
                 &(args_info->data_dir_orig), &(args_info->data_dir_given),
                &(local_args_info.data_dir_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "data-dir", '-',
                additional_error))
              goto failure;
          
          }
          /* Write all log information to FILE.  */
          else if (strcmp (long_options[option_index].name, "logfile") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->logfile_arg), 
                 &(args_info->logfile_orig), &(args_info->logfile_given),
                &(local_args_info.logfile_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "logfile", '-',
                additional_error))
              goto failure;
          
          }
          /* Write process ID to FILE.  */
          else if (strcmp (long_options[option_index].name, "pidfile") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->pidfile_arg), 
                 &(args_info->pidfile_orig), &(args_info->pidfile_given),
                &(local_args_info.pidfile_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "pidfile", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not daemonize.  */
          else if (strcmp (long_options[option_index].name, "foreground") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->foreground_flag), 0, &(args_info->foreground_given),
                &(local_args_info.foreground_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "foreground", '-',
                additional_error))
              goto failure;
          
          }
          /* Enable debug messages.  */
          else if (strcmp (long_options[option_index].name, "debug") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->debug_flag), 0, &(args_info->debug_given),
                &(local_args_info.debug_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "debug", '-',
                additional_error))
              goto failure;
          
          }
          /* Run as specified user[:group].  */
          else if (strcmp (long_options[option_index].name, "run-as") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->run_as_arg), 
                 &(args_info->run_as_orig), &(args_info->run_as_given),
                &(local_args_info.run_as_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "run-as", '-',
                additional_error))
              goto failure;
          
          }
          /* Path to SSL CA certificate.  */
          else if (strcmp (long_options[option_index].name, "ssl_ca") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->ssl_ca_arg), 
                 &(args_info->ssl_ca_orig), &(args_info->ssl_ca_given),
                &(local_args_info.ssl_ca_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "ssl_ca", '-',
                additional_error))
              goto failure;
          
          }
          /* How often to run the GC.  */
          else if (strcmp (long_options[option_index].name, "gc-interval") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->gc_interval_arg), 
                 &(args_info->gc_interval_orig), &(args_info->gc_interval_given),
                &(local_args_info.gc_interval_given), optarg, 0, "3600", ARG_INT,
                check_ambiguity, override, 0, 0,
                "gc-interval", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum number of rows/transaction in the GC.  */
          else if (strcmp (long_options[option_index].name, "gc-max-batch") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->gc_max_batch_arg), 
                 &(args_info->gc_max_batch_orig), &(args_info->gc_max_batch_given),
                &(local_args_info.gc_max_batch_given), optarg, 0, "100", ARG_INT,
                check_ambiguity, override, 0, 0,
                "gc-max-batch", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum time for a transaction in the GC in seconds.  */
          else if (strcmp (long_options[option_index].name, "gc-max-batch-time") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->gc_max_batch_time_arg), 
                 &(args_info->gc_max_batch_time_orig), &(args_info->gc_max_batch_time_given),
                &(local_args_info.gc_max_batch_time_given), optarg, 0, "1", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "gc-max-batch-time", '-',
                additional_error))
              goto failure;
          
          }
          /* Time to yield between GC transactions.  */
          else if (strcmp (long_options[option_index].name, "gc-yield-time") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->gc_yield_time_arg), 
                 &(args_info->gc_yield_time_orig), &(args_info->gc_yield_time_given),
                &(local_args_info.gc_yield_time_given), optarg, 0, "1.1", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "gc-yield-time", '-',
                additional_error))
              goto failure;
          
          }
          /* Don't run the old GC.  */
          else if (strcmp (long_options[option_index].name, "gc-no-slow-check") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->gc_no_slow_check_flag), 0, &(args_info->gc_no_slow_check_given),
                &(local_args_info.gc_no_slow_check_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "gc-no-slow-check", '-',
                additional_error))
              goto failure;
          
          }
          /* Blockmgr delay.  */
          else if (strcmp (long_options[option_index].name, "blockmgr-delay") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->blockmgr_delay_arg), 
                 &(args_info->blockmgr_delay_orig), &(args_info->blockmgr_delay_given),
                &(local_args_info.blockmgr_delay_given), optarg, 0, "3", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "blockmgr-delay", '-',
                additional_error))
              goto failure;
          
          }
          /* Minimum number of pages in WAL to trigger a passive checkpoint.  */
          else if (strcmp (long_options[option_index].name, "db-min-passive-wal-pages") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->db_min_passive_wal_pages_arg), 
                 &(args_info->db_min_passive_wal_pages_orig), &(args_info->db_min_passive_wal_pages_given),
                &(local_args_info.db_min_passive_wal_pages_given), optarg, 0, "5000", ARG_INT,
                check_ambiguity, override, 0, 0,
                "db-min-passive-wal-pages", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum number of pages in WAL to trigger a passive checkpoint.  */
          else if (strcmp (long_options[option_index].name, "db-max-passive-wal-pages") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->db_max_passive_wal_pages_arg), 
                 &(args_info->db_max_passive_wal_pages_orig), &(args_info->db_max_passive_wal_pages_given),
                &(local_args_info.db_max_passive_wal_pages_given), optarg, 0, "10000", ARG_INT,
                check_ambiguity, override, 0, 0,
                "db-max-passive-wal-pages", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum number of pages in WAL before forcing a WAL restart.  */
          else if (strcmp (long_options[option_index].name, "db-max-wal-restart-pages") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->db_max_wal_restart_pages_arg), 
                 &(args_info->db_max_wal_restart_pages_orig), &(args_info->db_max_wal_restart_pages_given),
                &(local_args_info.db_max_wal_restart_pages_given), optarg, 0, "20000", ARG_INT,
                check_ambiguity, override, 0, 0,
                "db-max-wal-restart-pages", '-',
                additional_error))
              goto failure;
          
          }
          /* Interval to force a WAL restart when idle.  */
          else if (strcmp (long_options[option_index].name, "db-idle-restart") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->db_idle_restart_arg), 
                 &(args_info->db_idle_restart_orig), &(args_info->db_idle_restart_given),
                &(local_args_info.db_idle_restart_given), optarg, 0, "60", ARG_INT,
                check_ambiguity, override, 0, 0,
                "db-idle-restart", '-',
                additional_error))
              goto failure;
          
          }
          /* SQLite database busy timeout.  */
          else if (strcmp (long_options[option_index].name, "db-busy-timeout") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->db_busy_timeout_arg), 
                 &(args_info->db_busy_timeout_orig), &(args_info->db_busy_timeout_given),
                &(local_args_info.db_busy_timeout_given), optarg, 0, "20", ARG_INT,
                check_ambiguity, override, 0, 0,
                "db-busy-timeout", '-',
                additional_error))
              goto failure;
          
          }
          /* SQLite mmap size (0 to disable).  */
          else if (strcmp (long_options[option_index].name, "db-max-mmapsize") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->db_max_mmapsize_arg), 
                 &(args_info->db_max_mmapsize_orig), &(args_info->db_max_mmapsize_given),
                &(local_args_info.db_max_mmapsize_given), optarg, 0, "2147418112", ARG_INT,
                check_ambiguity, override, 0, 0,
                "db-max-mmapsize", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not use custom SQLite VFS.  */
          else if (strcmp (long_options[option_index].name, "db-no-custom-vfs") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->db_no_custom_vfs_flag), 0, &(args_info->db_no_custom_vfs_given),
                &(local_args_info.db_no_custom_vfs_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "db-no-custom-vfs", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum time to wait before killing a worker.  */
          else if (strcmp (long_options[option_index].name, "worker-max-wait") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->worker_max_wait_arg), 
                 &(args_info->worker_max_wait_orig), &(args_info->worker_max_wait_given),
                &(local_args_info.worker_max_wait_given), optarg, 0, "300", ARG_INT,
                check_ambiguity, override, 0, 0,
                "worker-max-wait", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum number of requests / worker.  */
          else if (strcmp (long_options[option_index].name, "worker-max-requests") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->worker_max_requests_arg), 
                 &(args_info->worker_max_requests_orig), &(args_info->worker_max_requests_given),
                &(local_args_info.worker_max_requests_given), optarg, 0, "5000", ARG_INT,
                check_ambiguity, override, 0, 0,
                "worker-max-requests", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

static int
_cmdline_parser_configfile (const char *filename, int *my_argc)
{
  FILE* file;
  char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];
  char linebuf[CONFIG_FILE_LINE_SIZE];
  int line_num = 0;
  int result = 0, equal;
  char *fopt, *farg;
  char *str_index;
  size_t len, next_token;
  char delimiter;

  if ((file = fopen(filename, "r")) == 0)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != 0)
    {
      ++line_num;
      my_argv[0] = '\0';
      len = strlen(linebuf);
      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))
        {
          fprintf (stderr, "%s:%s:%d: Line too long in configuration file\n",
                   CMDLINE_PARSER_PACKAGE, filename, line_num);
          result = EXIT_FAILURE;
          break;
        }

      /* find first non-whitespace character in the line */
      next_token = strspn (linebuf, " \t\r\n");
      str_index  = linebuf + next_token;

      if ( str_index[0] == '\0' || str_index[0] == '#')
        continue; /* empty line or comment line is skipped */

      fopt = str_index;

      /* truncate fopt at the end of the first non-valid character */
      next_token = strcspn (fopt, " \t\r\n=");

      if (fopt[next_token] == '\0') /* the line is over */
        {
          farg  = 0;
          equal = 0;
          goto noarg;
        }

      /* remember if equal sign is present */
      equal = (fopt[next_token] == '=');
      fopt[next_token++] = '\0';

      /* advance pointers to the next token after the end of fopt */
      next_token += strspn (fopt + next_token, " \t\r\n");

      /* check for the presence of equal sign, and if so, skip it */
      if ( !equal )
        if ((equal = (fopt[next_token] == '=')))
          {
            next_token++;
            next_token += strspn (fopt + next_token, " \t\r\n");
          }
      str_index  += next_token;

      /* find argument */
      farg = str_index;
      if ( farg[0] == '\"' || farg[0] == '\'' )
        { /* quoted argument */
          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */
          if (! str_index)
            {
              fprintf
                (stderr,
                 "%s:%s:%d: unterminated string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }
      else
        { /* read up the remaining part up to a delimiter */
          next_token = strcspn (farg, " \t\r\n#\'\"");
          str_index += next_token;
        }

      /* truncate farg at the delimiter and store it for further check */
      delimiter = *str_index, *str_index++ = '\0';

      /* everything but comment is illegal at the end of line */
      if (delimiter != '\0' && delimiter != '#')
        {
          str_index += strspn(str_index, " \t\r\n");
          if (*str_index != '\0' && *str_index != '#')
            {
              fprintf
                (stderr,
                 "%s:%s:%d: malformed string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }

    noarg:
      if (!strcmp(fopt,"include")) {
        if (farg && *farg) {
          result = _cmdline_parser_configfile(farg, my_argc);
        } else {
          fprintf(stderr, "%s:%s:%d: include requires a filename argument.\n",
                  CMDLINE_PARSER_PACKAGE, filename, line_num);
        }
        continue;
      }
      len = strlen(fopt);
      strcat (my_argv, len > 1 ? "--" : "-");
      strcat (my_argv, fopt);
      if (len > 1 && ((farg && *farg) || equal))
        strcat (my_argv, "=");
      if (farg && *farg)
        strcat (my_argv, farg);
      ++(*my_argc);

      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
      cmd_line_list_tmp->next = cmd_line_list;
      cmd_line_list = cmd_line_list_tmp;
      cmd_line_list->string_arg = gengetopt_strdup(my_argv);
    } /* while */

  if (file)
    fclose(file);
  return result;
}

int
cmdline_parser_configfile (
  const char *filename,
                           struct gengetopt_args_info *args_info,
                           int override, int initialize, int check_required)
{
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;
  
  return cmdline_parser_config_file (filename, args_info, &params);
}

int
cmdline_parser_config_file (const char *filename,
                           struct gengetopt_args_info *args_info,
                           struct cmdline_parser_params *params)
{
  int i, result;
  int my_argc = 1;
  char **my_argv_arg;
  char *additional_error;

  /* store the program name */
  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
  cmd_line_list_tmp->next = cmd_line_list;
  cmd_line_list = cmd_line_list_tmp;
  cmd_line_list->string_arg = gengetopt_strdup (CMDLINE_PARSER_PACKAGE);

  result = _cmdline_parser_configfile(filename, &my_argc);

  if (result != EXIT_FAILURE) {
    my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));
    cmd_line_list_tmp = cmd_line_list;

    for (i = my_argc - 1; i >= 0; --i) {
      my_argv_arg[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

    my_argv_arg[my_argc] = 0;

    additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);
    strcpy (additional_error, ADDITIONAL_ERROR);
    strcat (additional_error, filename);
    result =
      cmdline_parser_internal (my_argc, my_argv_arg, args_info,
                              params,
                              additional_error);

    free (additional_error);
    free (my_argv_arg);
  }

  free_cmd_list();
  return result;
}
