/* Public domain. */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <errno.h>
#include "bytestr.h"
#include "error.h"
#include "pflocal.h"
#include "webipc.h"

static int ipc_bindit (int s, char const *p, int del)
{
  struct sockaddr_un sa ;
  unsigned int l = str_len(p) ;
  if (l > IPCPATH_MAX) return (errno = EPROTO, -1) ;
  byte_zero((char *) &sa, sizeof sa) ;
  sa.sun_family = PF_LOCAL ;
  byte_copy(sa.sun_path, l, p) ;
  if (del) unlink(sa.sun_path) ;
  return bind(s, (struct sockaddr *) &sa, sizeof sa) ;
}

int ipc_bind (int s, char const *p)
{
  return ipc_bindit(s, p, 0) ;
}

int ipc_bind_reuse (int s, char const *p)
{
  unsigned int opt = 1 ;
  setsockopt(s, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof opt) ;
  return ipc_bindit(s, p, 1) ;
}
