/* Public domain. */

#include "bytestr.h"
#include "fmtscan.h"
#include "dns_helper.h"

void dns_name4_domain (char *name, char const *ip)
{
  unsigned int namelen = 0 ;
  unsigned int i = uint_fmt(name + 1, (unsigned int)(unsigned char)ip[3]) ;
  name[namelen++] = i ;
  namelen += i ;
  i = uint_fmt(name + namelen + 1, (unsigned int)(unsigned char)ip[2]) ;
  name[namelen++] = i ;
  namelen += i ;
  i = uint_fmt(name + namelen + 1, (unsigned int)(unsigned char)ip[1]) ;
  name[namelen++] = i ;
  namelen += i ;
  i = uint_fmt(name + namelen + 1, (unsigned int)(unsigned char)ip[0]) ;
  name[namelen++] = i ;
  namelen += i ;
  byte_copy(name + namelen, 14, "\7in-addr\4arpa") ;
}
