// pest. Elegant, efficient grammars
// Copyright (C) 2016  Dragoș Tiselice
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

/// A `struct` representing tokens generated by a parser.
#[derive(Clone, Copy, Debug, Eq, Hash, PartialEq)]
pub struct Token<Rule> {
    /// matched [`Rule`](macro.impl_rdp!#rule)
    pub rule:  Rule,
    /// starting position in `Input`
    pub start: usize,
    /// ending position in `Input`
    pub end:   usize
}

impl<Rule> Token<Rule> {
    /// Creates a new `Token`.
    ///
    /// # Examples
    ///
    /// ```
    /// # #[macro_use] extern crate pest;
    /// # use pest::prelude::*;
    /// # fn main() {
    /// impl_rdp! {
    ///     grammar! {
    ///         expression = _{ paren ~ expression? }
    ///         paren      =  { ["("] ~ expression? ~ [")"] }
    ///     }
    /// }
    ///
    /// let token = Token::new(Rule::paren, 0, 1);
    ///
    /// assert_eq!(token.rule, Rule::paren);
    /// assert_eq!(token.start, 0);
    /// assert_eq!(token.end, 1);
    /// # }
    /// ```
    pub fn new(rule: Rule, start: usize, end: usize) -> Token<Rule> {
        Token {
            rule:  rule,
            start: start,
            end:   end
        }
    }
}
