% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{st_join.stars}
\alias{st_join.stars}
\title{Spatially join a stars and an `sf` object}
\usage{
\method{st_join}{stars}(x, y, join = st_intersects, ...,
  what = "left1", as_points = NA, warn = TRUE)
}
\arguments{
\item{x}{object of class stars}

\item{y}{object of class sf, or one that can be coerced into that by \link{st_as_sf}}

\item{join}{the join function, which should return an sgbp object; see details}

\item{...}{arguments that will be passed on to the join function}

\item{what}{either "left1" or "right"}

\item{as_points}{logical; controls whether grid cells in \code{x} will be treated as points, or as cell areas; the \link{st_intersects.stars} method by default will derive this from \code{x}'s metadata, or else assume areas.}

\item{warn}{logical; if TRUE, warn on 1-to-many matches when \code{what} is \code{"left1"}}
}
\value{
If what is "left1", an object of class stars with the (first) value of y at spatial instances of x
}
\description{
Spatially join a stars and an `sf` object
}
\details{
When there is more than one match to a single x value, the first matching record from y is taken (and if \code{warn} is TRUE a warning is raised). If what is "inner", an object of class \code{sf} with all matching records of x and y.
}
