% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/assay.R, R/seurat.R
\name{WhichCells}
\alias{WhichCells}
\alias{WhichCells.Assay}
\alias{WhichCells.Seurat}
\title{Identify cells matching certain criteria}
\usage{
WhichCells(object, ...)

\method{WhichCells}{Assay}(object, cells = NULL, expression, invert = FALSE, ...)

\method{WhichCells}{Seurat}(
  object,
  cells = NULL,
  idents = NULL,
  expression,
  slot = "data",
  invert = FALSE,
  downsample = Inf,
  seed = 1,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{
  Arguments passed on to \code{\link[=CellsByIdentities]{CellsByIdentities}}
  \describe{
    \item{\code{return.null}}{If no cells are requested, return a \code{NULL};
by default, throws an error}
  }}

\item{cells}{Subset of cell names}

\item{expression}{A predicate expression for feature/variable expression,
can evaluate anything that can be pulled by \code{FetchData}; please note,
you may need to wrap feature names in backticks (\code{``}) if dashes
between numbers are present in the feature name}

\item{invert}{Invert the selection of cells}

\item{idents}{A vector of identity classes to keep}

\item{slot}{Slot to pull feature data for}

\item{downsample}{Maximum number of cells per identity class, default is
\code{Inf}; downsampling will happen after all other operations, including
inverting the cell selection}

\item{seed}{Random seed for downsampling. If NULL, does not set a seed}
}
\value{
A vector of cell names
}
\description{
Returns a list of cells that match a particular set of criteria such as
identity class, high/low values for particular PCs, etc.
}
\examples{
WhichCells(pbmc_small, idents = 2)
WhichCells(pbmc_small, expression = MS4A1 > 3)
levels(pbmc_small)
WhichCells(pbmc_small, idents = c(1, 2), invert = TRUE)

}
\seealso{
\code{\link{FetchData}}
}
\concept{data-access}
