% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logmap.R
\docType{class}
\name{LogMap}
\alias{LogMap}
\alias{[[,LogMap,character,missing-method}
\alias{[[,LogMap,missing,missing-method}
\alias{[[,LogMap,NULL,missing-method}
\alias{[[<-,LogMap,character,missing,character-method}
\alias{[[<-,LogMap,character,missing,integer-method}
\alias{[[<-,LogMap,character,missing,NULL-method}
\alias{[[<-,LogMap,character,missing,numeric-method}
\alias{LogMap-class}
\title{A Logical Map}
\usage{
LogMap(y)

\S4method{[[}{LogMap,character,missing}(x, i, j, ...)

\S4method{[[}{LogMap,missing,missing}(x, i, j, ...)

\S4method{[[}{LogMap,`NULL`,missing}(x, i, j, ...)

\S4method{[[}{LogMap,character,missing,character}(x, i, j, ...) <- value

\S4method{[[}{LogMap,character,missing,integer}(x, i, j, ...) <- value

\S4method{[[}{LogMap,character,missing,`NULL`}(x, i, j, ...) <- value

\S4method{[[}{LogMap,character,missing,numeric}(x, i, j, ...) <- value
}
\arguments{
\item{y}{A character vector}

\item{x}{A \code{LogMap} object}

\item{i}{A character vector of length 1, or \code{NULL}}

\item{j}{Not used}

\item{...}{Ignored}

\item{value}{A character or integer vector of values to record in the map
for \code{i}, or \code{NULL} to remove the record for \code{i}}
}
\value{
\code{LogMap}: A new \code{LogMap} object with zero columns and
\code{length(x = x)} rows; rownames are set to \code{x}

\code{[[}: if \code{i} is a character vector, the rownames that are
mapped to \code{i}; otherwise the rownames of \code{x}

\code{[[<-}: If \code{value} is \code{NULL}, then \code{x} without
the observations for \code{i}; otherwise, \code{x} with a new column for
\code{i} recording a \code{TRUE} for all values present in \code{value}
}
\description{
A simple container for storing mappings of values using logical matrices.
Keeps track of which values (rows) are present in which observations
(columns). \code{LogMap} objects can be created with \code{LogMap()};
queries can be performed with \code{[[} and observations can be added
or removed with \code{[[<-}
}
\section{Slots}{

\describe{
\item{\code{.Data}}{A logical matrix with at least one row}
}}

\examples{
# Create a LogMap
map <- LogMap(letters[1:10])
map

# Get the names of values in the LogMap
map[[NULL]]
rownames(map)

# Add an observation to the LogMap
map[['obs']] <- c(1, 3, 7)
map[['entry']] <- c(2, 7, 10)
map

# Get the names of observations in the LogMap
colnames(map)

# Fetch an observation from the LogMap
map[['obs']]

# Get the full logical matrix
map[[]]

# Remove an observation from the LogMap
map[['obs']] <- NULL
map[['entry']] <- NULL
map

}
\seealso{
Logical map objects, validity, and interaction methods:
\code{\link{LogMap-validity}},
\code{\link{as.matrix.LogMap}()},
\code{\link{droplevels.LogMap}()},
\code{\link{intersect.LogMap}()},
\code{\link{labels.LogMap}()}
}
\concept{logmap}
