% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws-index.R
\name{set_variables}
\alias{set_variables}
\title{Set variable names in \code{draws} objects}
\usage{
set_variables(x, variables, ...)
}
\arguments{
\item{x}{(draws) A \code{\link{draws}} object.}

\item{variables}{(character) new variable names.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
Returns a \code{\link{draws}} object of the same format as \code{x}, with
variables named as specified.
}
\description{
Set variable names for all variables in a \code{\link{draws}} object. Useful
when using pipe operators.
}
\examples{
x <- as_draws(matrix(rnorm(100), ncol = 2))
variables(x)

x <- set_variables(x, c("theta[1]", "theta[2]"))
variables(x)

# this is equivalent to
variables(x) <- c("theta[1]", "theta[2]")
variables(x)

}
\seealso{
\code{\link{variables}}
}
