% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-search-docs.R
\name{build_search}
\alias{build_search}
\title{Build search index}
\usage{
build_search(pkg = ".", override = list())
}
\arguments{
\item{pkg}{Path to package.}

\item{override}{An optional named list used to temporarily override
values in \verb{_pkgdown.yml}}
}
\description{
Generate a JSON search index from the built site. This is used by
\href{https://www.fusejs.io/}{fuse.js} to provide a javascript powered search for
BS5 powered pkgdown sites.

NB: \code{build_search()} is called automatically by \code{\link[=build_site]{build_site()}}; you don't
need call it yourself. This page documents how it works and its customisation
options.
}
\section{YAML config}{
You can exclude some paths from the search index using \code{search.exclude}.
Below we exclude the changelog from the search index:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{search:
  exclude: ['news/index.html']
}\if{html}{\out{</div>}}
}

\section{Debugging and local testing}{
Locally (as opposed to on GitHub Pages or Netlify for instance),
search won't work if you simply use pkgdown preview of the static files.
You can use \code{servr::httw("docs")} instead.

If search is not working, run \code{pkgdown::pkgdown_sitrep()} to eliminate
common issues such as the absence of URL in the pkgdown configuration file
of your package.
}

