% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{auto_heights}
\alias{auto_heights}
\title{Compute optimal row heights}
\usage{
auto_heights(
  wb,
  sheet,
  selected,
  fontsize = NULL,
  factor = 1,
  base_height = 15,
  extra_height = 12
)
}
\arguments{
\item{wb}{workbook}

\item{sheet}{worksheet}

\item{selected}{selected rows}

\item{fontsize}{font size, optional (get base font size by default)}

\item{factor}{factor to manually adjust font width, e.g., for bold fonts,
optional}

\item{base_height}{basic row height, optional}

\item{extra_height}{additional row height per new line of text, optional}
}
\value{
list of indices of columns with fixed widths and optimal row heights
}
\description{
Compute optimal row heights for cell with fixed with and
enabled automatic row heights parameter
}
\examples{
## Create new workbook
wb <- createWorkbook()
addWorksheet(wb, "Sheet")
sheet <- 1

## Write dummy data
long_string <- "ABC ABC ABC ABC ABC ABC ABC ABC ABC ABC ABC"
writeData(wb, sheet, c("A", long_string, "CCC"), startCol = 2, startRow = 3)
writeData(wb, sheet, c(4, 5), startCol = 4, startRow = 3)

## Set column widths and get optimal row heights
setColWidths(wb, sheet, c(1,2,3,4), c(10,20,10,20))
auto_heights(wb, sheet, 1:5)

}
\author{
David Breuer
}
