% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_model.R
\name{is_model}
\alias{is_model}
\title{Checks if an object is a regression model object}
\usage{
is_model(x)
}
\arguments{
\item{x}{An object.}
}
\value{
A logical, \code{TRUE} if \code{x} is a (supported) model object.
}
\description{
Small helper that checks if a model is a regression model
  object.
}
\details{
This function returns \code{TRUE} if \code{x} is a model object.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)

is_model(m)
is_model(mtcars)
}
