% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_images.R
\name{lollipop}
\alias{lollipop}
\title{Mini lollipop chart chunk wrapper}
\usage{
lollipop(
  value,
  min = NULL,
  max = NULL,
  rangecol = "#CCCCCC",
  bg = "transparent",
  width = 1,
  height = 0.2,
  unit = "in",
  raster_width = 30,
  positivecol = "#00CC00",
  negativecol = "#CC0000",
  neutralcol = "#CCCCCC",
  neutralrange = c(0, 0),
  rectanglesize = 2
)
}
\arguments{
\item{value}{values containing the bar size}

\item{min}{min bar size. Default min of value}

\item{max}{max bar size. Default max of value}

\item{rangecol}{bar color}

\item{bg}{background color}

\item{width, height}{size of the resulting png file in inches}

\item{unit}{unit for width and height, one of "in", "cm", "mm".}

\item{raster_width}{number of pixels used as width}

\item{positivecol}{box color of positive values}

\item{negativecol}{box color of negative values}

\item{neutralcol}{box color of neutral values}

\item{neutralrange}{minimal and maximal range of neutral values (default: 0)}

\item{rectanglesize}{size of the rectangle (default: 2, max: 5)
when interpolating value.}
}
\description{
This function is used to insert lollipop charts into
flextable with functions:
\itemize{
\item \code{\link[=compose]{compose()}} and \code{\link[=as_paragraph]{as_paragraph()}},
\item \code{\link[=append_chunks]{append_chunks()}},
\item \code{\link[=prepend_chunks]{prepend_chunks()}}.
}
}
\note{
This chunk option requires package officedown in a R Markdown
context with Word output format.

PowerPoint cannot mix images and text in a paragraph, images
are removed when outputing to PowerPoint format.
}
\examples{
iris$Sepal.Ratio <- (iris$Sepal.Length - mean(iris$Sepal.Length)) / mean(iris$Sepal.Length)
ft <- flextable(tail(iris, n = 10))

ft <- compose(ft,
  j = "Sepal.Ratio", value = as_paragraph(
    lollipop(value = Sepal.Ratio, min = -.25, max = .25)
  ),
  part = "body"
)

ft <- autofit(ft)
ft
}
\seealso{
\code{\link[=compose]{compose()}}, \code{\link[=as_paragraph]{as_paragraph()}}

Other chunk elements for paragraph: 
\code{\link{as_bracket}()},
\code{\link{as_b}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_image}()},
\code{\link{as_i}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{as_word_field}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{grid_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
