% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{TCGAvisualize_EAbarplot}
\alias{TCGAvisualize_EAbarplot}
\title{barPlot for a complete Enrichment Analysis}
\usage{
TCGAvisualize_EAbarplot(
  tf,
  GOMFTab,
  GOBPTab,
  GOCCTab,
  PathTab,
  nBar,
  nRGTab,
  filename = "TCGAvisualize_EAbarplot_Output.pdf",
  text.size = 1,
  mfrow = c(2, 2),
  xlim = NULL,
  color = c("orange", "cyan", "green", "yellow")
)
}
\arguments{
\item{tf}{is a list of gene symbols}

\item{GOMFTab}{is results from TCGAanalyze_EAcomplete related to Molecular Function (MF)}

\item{GOBPTab}{is results from TCGAanalyze_EAcomplete related to Biological Process (BP)}

\item{GOCCTab}{is results from TCGAanalyze_EAcomplete related to Cellular Component (CC)}

\item{PathTab}{is results from TCGAanalyze_EAcomplete related to Pathways EA}

\item{nBar}{is the number of bar histogram selected to show (default = 10)}

\item{nRGTab}{is the gene signature list with gene symbols.}

\item{filename}{Name for the pdf. If null it will return the plot.}

\item{text.size}{Text size}

\item{mfrow}{Vector with number of rows/columns of the plot. Default  2 rows/2 columns "c(2,2)"}

\item{xlim}{Upper limit of the x-axis.}

\item{color}{A vector of colors for each barplot. Deafult:  c("orange", "cyan","green","yellow")}
}
\value{
Complete barPlot from Enrichment Analysis showing significant (default FDR < 0.01)
BP,CC,MF and pathways enriched by list of genes.
}
\description{
The figure shows canonical pathways significantly overrepresented (enriched) by the DEGs
(differentially expressed genes).
The most statistically significant canonical pathways identified
in DEGs list are listed according to their p value corrected FDR (-Log) (colored bars)
and the ratio of list genes found in each pathway over the total number of
genes in that pathway (Ratio, red line).
}
\examples{
Genelist <- c("FN1","COL1A1")
ansEA <- TCGAanalyze_EAcomplete(TFname="DEA genes Normal Vs Tumor",Genelist)
TCGAvisualize_EAbarplot(tf = rownames(ansEA$ResBP),
         GOBPTab = ansEA$ResBP,
         GOCCTab = ansEA$ResCC,
         GOMFTab = ansEA$ResMF,
        PathTab = ansEA$ResPat,
         nRGTab = Genelist,
         nBar = 10,
         filename="a.pdf")
\dontrun{
Genelist <- rownames(dataDEGsFiltLevel)
system.time(ansEA <- TCGAanalyze_EAcomplete(TFname="DEA genes Normal Vs Tumor",Genelist))
# Enrichment Analysis EA (TCGAVisualize)
# Gene Ontology (GO) and Pathway enrichment barPlot
TCGAvisualize_EAbarplot(tf = rownames(ansEA$ResBP),
         GOBPTab = ansEA$ResBP,
         GOCCTab = ansEA$ResCC,
         GOMFTab = ansEA$ResMF,
        PathTab = ansEA$ResPat,
         nRGTab = Genelist,
         nBar = 10)
}
}
