% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{clusterCells}
\alias{clusterCells}
\title{Cluster cells into a specified number of groups based on .}
\usage{
clusterCells(
  cds,
  skip_rho_sigma = F,
  num_clusters = NULL,
  inspect_rho_sigma = F,
  rho_threshold = NULL,
  delta_threshold = NULL,
  peaks = NULL,
  gaussian = T,
  cell_type_hierarchy = NULL,
  frequency_thresh = NULL,
  enrichment_thresh = NULL,
  clustering_genes = NULL,
  k = 50,
  louvain_iter = 1,
  weight = FALSE,
  method = c("leiden", "louvain", "DDRTree"),
  verbose = F,
  resolution_parameter = 0.1,
  ...
)
}
\arguments{
\item{cds}{the CellDataSet upon which to perform this operation}

\item{skip_rho_sigma}{A logic flag to determine whether or not you want to skip the calculation of rho / sigma}

\item{num_clusters}{Number of clusters. The algorithm use 0.5 of the rho as the threshold of rho and the delta 
corresponding to the number_clusters sample with the highest delta as the density peaks and for assigning clusters}

\item{inspect_rho_sigma}{A logical flag to determine whether or not you want to interactively select the rho and sigma for assigning up clusters}

\item{rho_threshold}{The threshold of local density (rho) used to select the density peaks}

\item{delta_threshold}{The threshold of local distance (delta) used to select the density peaks}

\item{peaks}{A numeric vector indicates the index of density peaks used for clustering. This vector should be retrieved from the decision plot with caution. No checking involved.
will automatically calculated based on the top num_cluster product of rho and sigma.}

\item{gaussian}{A logic flag passed to densityClust function in densityClust package to determine whether or not Gaussian kernel will be used for calculating the local density}

\item{cell_type_hierarchy}{A data structure used for organizing functions that can be used for organizing cells}

\item{frequency_thresh}{When a CellTypeHierarchy is provided, cluster cells will impute cell types in clusters that are composed of at least this much of exactly one cell type.}

\item{enrichment_thresh}{fraction to be multipled by each cell type percentage. Only used if frequency_thresh is NULL, both cannot be NULL}

\item{clustering_genes}{a vector of feature ids (from the CellDataSet's featureData) used for ordering cells}

\item{k}{number of kNN used in creating the k nearest neighbor graph for Leiden and Louvain clustering. The number of kNN is related to the resolution of the clustering result, bigger number of kNN gives low resolution and vice versa. Default to be 50}

\item{louvain_iter}{number of iterations used for Leiden and Louvain clustering. The clustering result gives the largest modularity score will be used as the final clustering result.  Default to be 1.}

\item{weight}{A logic argument to determine whether or not we will use Jaccard coefficent for two nearest neighbors (based on the overlapping of their kNN) as the weight used for Louvain clustering. Default to be FALSE.}

\item{method}{method for clustering cells. Three methods are available, including leiden, louvian and DDRTree. By default, we use the leiden algorithm for clustering.}

\item{verbose}{Verbose A logic flag to determine whether or not we should print the running details.}

\item{resolution_parameter}{A real value that controls the resolution of the leiden clustering. Default is .1.}

\item{...}{Additional arguments passed to densityClust}
}
\value{
an updated CellDataSet object, in which phenoData contains values for Cluster for each cell
}
\description{
Unsupervised clustering of cells is a common step in many single-cell expression
workflows. In an experiment containing a mixture of cell types, each cluster might
correspond to a different cell type. This method takes a CellDataSet as input
along with a requested number of clusters, clusters them with an unsupervised 
algorithm (by default, density peak clustering), and then returns the CellDataSet with the 
cluster assignments stored in the pData table. When number of clusters is set 
to NULL (num_clusters = NULL), the decision plot as introduced in the reference 
will be plotted and the users are required to check the decision plot to select 
the rho and delta to determine the number of clusters to cluster. When the dataset 
is big, for example > 50 k, we recommend the user to use the Leiden or Louvain clustering 
algorithm which is inspired from phenograph paper. Note Louvain doesn't support the 
num_cluster argument but the k (number of k-nearest neighbors) is relevant to the final 
clustering number. The implementation of Louvain clustering is based on the Rphenograph
package but updated based on our requirement (for example, changed the jaccard_coeff 
function as well as adding louvain_iter argument, etc.)  The density peak clustering
method was removed because CRAN removed the densityClust package. Consequently,
the parameters skip_rho_sigma, inspect_rho_sigma, rho_threshold, delta_threshold,
peaks, and gaussian no longer have an effect.
}
\references{
Rodriguez, A., & Laio, A. (2014). Clustering by fast search and find of density peaks. Science, 344(6191), 1492-1496. doi:10.1126/science.1242072

Vincent D. Blondel, Jean-Loup Guillaume, Renaud Lambiotte, Etienne Lefebvre: Fast unfolding of communities in large networks. J. Stat. Mech. (2008) P10008

Jacob H. Levine and et.al. Data-Driven Phenotypic Dissection of AML Reveals Progenitor-like Cells that Correlate with Prognosis. Cell, 2015.
}
