% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{subset_by_Nindex}
\alias{subset_by_Nindex}
\title{\code{subset_by_Nindex}}
\usage{
subset_by_Nindex(x, Nindex)
}
\arguments{
\item{x}{An array-like object.}

\item{Nindex}{An unnamed list of subscripts as positive integer vectors, one
vector per dimension in \code{x}. Empty and missing subscripts (represented by
\code{integer(0)} and \code{NULL} list elements, respectively) are allowed. The
subscripts can contain duplicated indices. They cannot contain \code{NA}s or
non-positive values.}
}
\value{
A object of class \code{class(x)} of the appropriate type (e.g., integer,
double, etc.). For example, if \code{x} is a \link{data.frame} representing an M x N
matrix of integers, \verb{subset_by_Nindex(x, list(NULL, 2L)} must return its 2nd
column as a \link{data.frame} with M rows and 1 column of type integer.
}
\description{
\code{subset_by_Nindex()} is an internal generic function not aimed to be used
directly by the user. It is basically an S4 generic for
\code{DelayedArray:::subset_by_Nindex}.
}
\details{
\code{subset_by_Nindex(x, Nindex)} conceptually performs the operation
\code{x[Nindex[1], ..., Nindex[length(Nindex)])}. \code{subset_by_Nindex()}
methods need to support empty and missing subscripts, e.g.,
\code{subset_by_Nindex(x, list(NULL, integer(0)))} must return an M x 0 object
of class \code{class(x)} and \code{subset_by_Nindex(x, list(integer(0), integer(0)))}
a 0 x 0 object of class \code{class(x)}.

Also, subscripts are allowed to contain duplicate indices so things like
\code{subset_by_Nindex(x, list(c(1:3, 3:1), 2L))} need to be supported.
}
