// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{CursorType, Display};
use glib::translate::*;
use std::{fmt, mem};

glib::wrapper! {
    #[doc(alias = "GdkCursor")]
    pub struct Cursor(Object<ffi::GdkCursor>);

    match fn {
        type_ => || ffi::gdk_cursor_get_type(),
    }
}

impl Cursor {
    #[doc(alias = "gdk_cursor_new_for_display")]
    #[doc(alias = "new_for_display")]
    pub fn for_display(display: &Display, cursor_type: CursorType) -> Option<Cursor> {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gdk_cursor_new_for_display(
                display.to_glib_none().0,
                cursor_type.into_glib(),
            ))
        }
    }

    #[doc(alias = "gdk_cursor_new_from_name")]
    #[doc(alias = "new_from_name")]
    pub fn from_name(display: &Display, name: &str) -> Option<Cursor> {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gdk_cursor_new_from_name(
                display.to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gdk_cursor_new_from_pixbuf")]
    #[doc(alias = "new_from_pixbuf")]
    pub fn from_pixbuf(display: &Display, pixbuf: &gdk_pixbuf::Pixbuf, x: i32, y: i32) -> Cursor {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gdk_cursor_new_from_pixbuf(
                display.to_glib_none().0,
                pixbuf.to_glib_none().0,
                x,
                y,
            ))
        }
    }

    #[doc(alias = "gdk_cursor_new_from_surface")]
    #[doc(alias = "new_from_surface")]
    pub fn from_surface(display: &Display, surface: &cairo::Surface, x: f64, y: f64) -> Cursor {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gdk_cursor_new_from_surface(
                display.to_glib_none().0,
                mut_override(surface.to_glib_none().0),
                x,
                y,
            ))
        }
    }

    #[doc(alias = "gdk_cursor_get_cursor_type")]
    #[doc(alias = "get_cursor_type")]
    pub fn cursor_type(&self) -> CursorType {
        unsafe { from_glib(ffi::gdk_cursor_get_cursor_type(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_cursor_get_display")]
    #[doc(alias = "get_display")]
    pub fn display(&self) -> Display {
        unsafe { from_glib_none(ffi::gdk_cursor_get_display(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_cursor_get_image")]
    #[doc(alias = "get_image")]
    pub fn image(&self) -> Option<gdk_pixbuf::Pixbuf> {
        unsafe { from_glib_full(ffi::gdk_cursor_get_image(self.to_glib_none().0)) }
    }

    #[doc(alias = "gdk_cursor_get_surface")]
    #[doc(alias = "get_surface")]
    pub fn surface(&self) -> (Option<cairo::Surface>, f64, f64) {
        unsafe {
            let mut x_hot = mem::MaybeUninit::uninit();
            let mut y_hot = mem::MaybeUninit::uninit();
            let ret = from_glib_full(ffi::gdk_cursor_get_surface(
                self.to_glib_none().0,
                x_hot.as_mut_ptr(),
                y_hot.as_mut_ptr(),
            ));
            (ret, x_hot.assume_init(), y_hot.assume_init())
        }
    }
}

impl fmt::Display for Cursor {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Cursor")
    }
}
