/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OWWSURL_H
#define OWWSURL_H

#include <util/NonCopyable.h>

#include <string>

class QuteComAccount;

/**
 * Helper class that stores all the url related to QuteCom.
 *
 * FIXME
 * This class does not take a QuteComAccount, it uses QuteCom::instance
 * which is a big hack. A real solution must be find for the implementation
 * of openQuteComUrlWithAuth(). Check QuteCom::instance.
 * It has been done in order to keep WsUrl methods static thus easier to use,
 * I would like to keep them static since it is easier to use.
 *
 * @ingroup model
 * @author Tanguy Krotoff
 */
class WsUrl : NonCopyable {
	friend class UserProfileHandler;
public:
	enum Page {
		Account,
		AccountCreation,
		FAQ,
		Forum,
		SmartDirectory,
		CallOut,
		SMS,
		VoiceMail,
		BuyQuteComs,
		PhoneNumber,
		Wiki,
		LostPassword,
		Launchpad,
		Directory
	};

	static std::string getPageUrl(Page);

	static bool hasPage(Page);

	/**
	 * Opens a web browser and shows the QuteCom account informations inside.
	 */
	static void showQuteComAccount();

	/**
	 * Opens a web browser and shows the QuteCom account creation page.
	 */
	static void showQuteComAccountCreation();

	/**
	 * Opens a web browser and shows the QuteCom help center page.
	 */
	static void showQuteComFAQ();

	/**
	 * Opens a web browser and shows the QuteCom forum page.
	 */
	static void showQuteComForum();

	/**
	 * Opens a web browser and shows the QuteCom smart directory page.
	 */
	static void showQuteComSmartDirectory();

	/**
	 * Opens a web browser and shows the QuteCom callout page.
	 */
	static void showQuteComCallOut();

	/**
	 * Opens a web browser and shows the QuteCom SMS page.
	 */
	static void showQuteComSMS();

	/**
	 * Opens a web browser and shows the QuteCom voice mail page.
	 */
	static void showQuteComVoiceMail();

	/**
	 * Opens a web browser and shows the QuteCom buy page.
	 */
	static void showQuteComBuyQuteComs();

	/**
	 * Opens a web browser and shows the QuteCom download page.
	 */
	static void showQuteComDownload();

	/**
	 * Opens a web browser and shows the QuteCom phone number associated with the QuteCom account.
	 */
	static void showQuteComNumber();

	/**
	 * Opens a web browser and shows the QuteCom wiki page.
	 */
	static void showWikiPage();

	/**
	 * Opens a web browser and shows the lost password page.
	 */
	static void showLostPasswordPage();

	/**
	 * Opens a web browser and shows launchpad QuteCom page.
	 */
	static void showLauchpadPage();

	/**
	 * Gets the QuteCom directory url.
	 *
	 * @return QuteCom directory url
	 */
	static std::string getQuteComDirectoryUrl();

private:

	/**
	 * Opens a web browser with the given url.
	 *
	 * @param url the url to open
	 */
	static void openQuteComUrlWithoutAuth(const std::string & url);

	/**
	 * Opens a web browser with the given url.
	 *
	 * @param url the url to open
	 */
	static void openQuteComUrlWithAuth(const std::string & url);

	/**
	 * Gets url without authentication.
	 *
	 * @param url the url to transform
	 */
	static std::string getUrlWithoutAuth(const std::string & url);

	/**
	 * Gets url with authentication.
	 *
	 * @param url the url to transform
	 */
	static std::string getUrlWithAuth(const std::string & url);

	/**
	 * Sets the value of _qutecomAccount.
	 */
	static void setQuteComAccount(QuteComAccount * qutecomAccount) {
		_qutecomAccount = qutecomAccount;
	}

	/** Link to the current QuteComAccount. */
	static QuteComAccount * _qutecomAccount;
};

#endif	//OWWSURL_H
