#!/usr/bin/python

import distutils.core
import os

def setup(**attrs):
    '''Install quickly unity lens template files'''
    v = attrs.setdefault('data_files', [])
    for (path, dirs, files) in os.walk('.'):
        if '.bzr' in path or 'debian' in path:
            continue
        for f in files:
            if path == '.' and ('setup.py' in f or 'COPYING' in f):
                continue
            f = os.path.join(path, f)
            v.append((os.path.join('share', 'quickly', 'templates', os.path.dirname(f[2:])), [f]))
    distutils.core.setup(**attrs)

setup(
    name='quickly-lens-templates',
    version='0.0.3',
    license='GPL-3',
    description='Unity lens templates for quickly',
    author='Michael Hall',
    author_email='mhall119@ubuntu.com',
    url='https://launchpad.net/unity-quickly-templates',
    )

