/*
 * Copyright (C) 2009  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */


#include <QFile>
#include <QMessageBox>
#include <QTextStream>

#include "customhelpform.h"
#include "ui_customhelpform.h"

CustomHelpForm::CustomHelpForm(QWidget *parent, Qt::WindowFlags f) :
    QWidget(parent, f),
    ui(new Ui::CustomHelpForm)
{
    ui->setupUi(this);
}

CustomHelpForm::~CustomHelpForm()
{
    delete ui;
}

bool CustomHelpForm::setHtmlHelpFileDir(const QString &path) {
    QFile file(path + "/index.html");
    if (!file.open(QFile::ReadOnly | QFile::Text)) {
        QMessageBox::warning(this, tr("QSource-Highlight"),
                              tr("Cannot open help file %1:\n%2.")
                              .arg(path + "/index.html")
                              .arg(file.errorString()));
        return false;
    }

    QTextStream in(&file);
    ui->webView->setHtml(in.readAll(), path + "/");
    return true;
}

void CustomHelpForm::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
