r"""
    This code was generated by
   ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
    |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
    |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \

    Twilio - Autopilot
    This is the public Twilio REST API.

    NOTE: This class is auto generated by OpenAPI Generator.
    https://openapi-generator.tech
    Do not edit the class manually.
"""


from datetime import datetime
from typing import Any, Dict, List, Optional, Union, Iterator, AsyncIterator
from twilio.base import deserialize, serialize, values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.version import Version
from twilio.base.page import Page
from twilio.rest.autopilot.v1.assistant.defaults import DefaultsList
from twilio.rest.autopilot.v1.assistant.dialogue import DialogueList
from twilio.rest.autopilot.v1.assistant.field_type import FieldTypeList
from twilio.rest.autopilot.v1.assistant.model_build import ModelBuildList
from twilio.rest.autopilot.v1.assistant.query import QueryList
from twilio.rest.autopilot.v1.assistant.style_sheet import StyleSheetList
from twilio.rest.autopilot.v1.assistant.task import TaskList
from twilio.rest.autopilot.v1.assistant.webhook import WebhookList


class AssistantInstance(InstanceResource):

    """
    :ivar account_sid: The SID of the [Account](https://www.twilio.com/docs/iam/api/account) that created the Assistant resource.
    :ivar date_created: The date and time in GMT when the resource was created specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
    :ivar date_updated: The date and time in GMT when the resource was last updated specified in [RFC 2822](https://www.ietf.org/rfc/rfc2822.txt) format.
    :ivar friendly_name: The string that you assigned to describe the resource. It is not unique and can be up to 255 characters long.
    :ivar latest_model_build_sid: Reserved.
    :ivar links: A list of the URLs of the Assistant's related resources.
    :ivar log_queries: Whether queries should be logged and kept after training. Can be: `true` or `false` and defaults to `true`. If `true`, queries are stored for 30 days, and then deleted. If `false`, no queries are stored.
    :ivar development_stage: A string describing the state of the assistant.
    :ivar needs_model_build: Whether model needs to be rebuilt.
    :ivar sid: The unique string that we created to identify the Assistant resource.
    :ivar unique_name: An application-defined string that uniquely identifies the resource. It can be used in place of the resource's `sid` in the URL to address the resource. It can be up to 64 characters long.
    :ivar url: The absolute URL of the Assistant resource.
    :ivar callback_url: Reserved.
    :ivar callback_events: Reserved.
    """

    def __init__(
        self, version: Version, payload: Dict[str, Any], sid: Optional[str] = None
    ):
        super().__init__(version)

        self.account_sid: Optional[str] = payload.get("account_sid")
        self.date_created: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("date_created")
        )
        self.date_updated: Optional[datetime] = deserialize.iso8601_datetime(
            payload.get("date_updated")
        )
        self.friendly_name: Optional[str] = payload.get("friendly_name")
        self.latest_model_build_sid: Optional[str] = payload.get(
            "latest_model_build_sid"
        )
        self.links: Optional[Dict[str, object]] = payload.get("links")
        self.log_queries: Optional[bool] = payload.get("log_queries")
        self.development_stage: Optional[str] = payload.get("development_stage")
        self.needs_model_build: Optional[bool] = payload.get("needs_model_build")
        self.sid: Optional[str] = payload.get("sid")
        self.unique_name: Optional[str] = payload.get("unique_name")
        self.url: Optional[str] = payload.get("url")
        self.callback_url: Optional[str] = payload.get("callback_url")
        self.callback_events: Optional[str] = payload.get("callback_events")

        self._solution = {
            "sid": sid or self.sid,
        }
        self._context: Optional[AssistantContext] = None

    @property
    def _proxy(self) -> "AssistantContext":
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions. All instance actions are proxied to the context

        :returns: AssistantContext for this AssistantInstance
        """
        if self._context is None:
            self._context = AssistantContext(
                self._version,
                sid=self._solution["sid"],
            )
        return self._context

    def delete(self) -> bool:
        """
        Deletes the AssistantInstance


        :returns: True if delete succeeds, False otherwise
        """
        return self._proxy.delete()

    async def delete_async(self) -> bool:
        """
        Asynchronous coroutine that deletes the AssistantInstance


        :returns: True if delete succeeds, False otherwise
        """
        return await self._proxy.delete_async()

    def fetch(self) -> "AssistantInstance":
        """
        Fetch the AssistantInstance


        :returns: The fetched AssistantInstance
        """
        return self._proxy.fetch()

    async def fetch_async(self) -> "AssistantInstance":
        """
        Asynchronous coroutine to fetch the AssistantInstance


        :returns: The fetched AssistantInstance
        """
        return await self._proxy.fetch_async()

    def update(
        self,
        friendly_name: Union[str, object] = values.unset,
        log_queries: Union[bool, object] = values.unset,
        unique_name: Union[str, object] = values.unset,
        callback_url: Union[str, object] = values.unset,
        callback_events: Union[str, object] = values.unset,
        style_sheet: Union[object, object] = values.unset,
        defaults: Union[object, object] = values.unset,
        development_stage: Union[str, object] = values.unset,
    ) -> "AssistantInstance":
        """
        Update the AssistantInstance

        :param friendly_name: A descriptive string that you create to describe the resource. It is not unique and can be up to 255 characters long.
        :param log_queries: Whether queries should be logged and kept after training. Can be: `true` or `false` and defaults to `true`. If `true`, queries are stored for 30 days, and then deleted. If `false`, no queries are stored.
        :param unique_name: An application-defined string that uniquely identifies the resource. It can be used as an alternative to the `sid` in the URL path to address the resource. The first 64 characters must be unique.
        :param callback_url: Reserved.
        :param callback_events: Reserved.
        :param style_sheet: The JSON string that defines the Assistant's [style sheet](https://www.twilio.com/docs/autopilot/api/assistant/stylesheet)
        :param defaults: A JSON object that defines the Assistant's [default tasks](https://www.twilio.com/docs/autopilot/api/assistant/defaults) for various scenarios, including initiation actions and fallback tasks.
        :param development_stage: A string describing the state of the assistant.

        :returns: The updated AssistantInstance
        """
        return self._proxy.update(
            friendly_name=friendly_name,
            log_queries=log_queries,
            unique_name=unique_name,
            callback_url=callback_url,
            callback_events=callback_events,
            style_sheet=style_sheet,
            defaults=defaults,
            development_stage=development_stage,
        )

    async def update_async(
        self,
        friendly_name: Union[str, object] = values.unset,
        log_queries: Union[bool, object] = values.unset,
        unique_name: Union[str, object] = values.unset,
        callback_url: Union[str, object] = values.unset,
        callback_events: Union[str, object] = values.unset,
        style_sheet: Union[object, object] = values.unset,
        defaults: Union[object, object] = values.unset,
        development_stage: Union[str, object] = values.unset,
    ) -> "AssistantInstance":
        """
        Asynchronous coroutine to update the AssistantInstance

        :param friendly_name: A descriptive string that you create to describe the resource. It is not unique and can be up to 255 characters long.
        :param log_queries: Whether queries should be logged and kept after training. Can be: `true` or `false` and defaults to `true`. If `true`, queries are stored for 30 days, and then deleted. If `false`, no queries are stored.
        :param unique_name: An application-defined string that uniquely identifies the resource. It can be used as an alternative to the `sid` in the URL path to address the resource. The first 64 characters must be unique.
        :param callback_url: Reserved.
        :param callback_events: Reserved.
        :param style_sheet: The JSON string that defines the Assistant's [style sheet](https://www.twilio.com/docs/autopilot/api/assistant/stylesheet)
        :param defaults: A JSON object that defines the Assistant's [default tasks](https://www.twilio.com/docs/autopilot/api/assistant/defaults) for various scenarios, including initiation actions and fallback tasks.
        :param development_stage: A string describing the state of the assistant.

        :returns: The updated AssistantInstance
        """
        return await self._proxy.update_async(
            friendly_name=friendly_name,
            log_queries=log_queries,
            unique_name=unique_name,
            callback_url=callback_url,
            callback_events=callback_events,
            style_sheet=style_sheet,
            defaults=defaults,
            development_stage=development_stage,
        )

    @property
    def defaults(self) -> DefaultsList:
        """
        Access the defaults
        """
        return self._proxy.defaults

    @property
    def dialogues(self) -> DialogueList:
        """
        Access the dialogues
        """
        return self._proxy.dialogues

    @property
    def field_types(self) -> FieldTypeList:
        """
        Access the field_types
        """
        return self._proxy.field_types

    @property
    def model_builds(self) -> ModelBuildList:
        """
        Access the model_builds
        """
        return self._proxy.model_builds

    @property
    def queries(self) -> QueryList:
        """
        Access the queries
        """
        return self._proxy.queries

    @property
    def style_sheet(self) -> StyleSheetList:
        """
        Access the style_sheet
        """
        return self._proxy.style_sheet

    @property
    def tasks(self) -> TaskList:
        """
        Access the tasks
        """
        return self._proxy.tasks

    @property
    def webhooks(self) -> WebhookList:
        """
        Access the webhooks
        """
        return self._proxy.webhooks

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Autopilot.V1.AssistantInstance {}>".format(context)


class AssistantContext(InstanceContext):
    def __init__(self, version: Version, sid: str):
        """
        Initialize the AssistantContext

        :param version: Version that contains the resource
        :param sid: The Twilio-provided string that uniquely identifies the Assistant resource to update.
        """
        super().__init__(version)

        # Path Solution
        self._solution = {
            "sid": sid,
        }
        self._uri = "/Assistants/{sid}".format(**self._solution)

        self._defaults: Optional[DefaultsList] = None
        self._dialogues: Optional[DialogueList] = None
        self._field_types: Optional[FieldTypeList] = None
        self._model_builds: Optional[ModelBuildList] = None
        self._queries: Optional[QueryList] = None
        self._style_sheet: Optional[StyleSheetList] = None
        self._tasks: Optional[TaskList] = None
        self._webhooks: Optional[WebhookList] = None

    def delete(self) -> bool:
        """
        Deletes the AssistantInstance


        :returns: True if delete succeeds, False otherwise
        """
        return self._version.delete(
            method="DELETE",
            uri=self._uri,
        )

    async def delete_async(self) -> bool:
        """
        Asynchronous coroutine that deletes the AssistantInstance


        :returns: True if delete succeeds, False otherwise
        """
        return await self._version.delete_async(
            method="DELETE",
            uri=self._uri,
        )

    def fetch(self) -> AssistantInstance:
        """
        Fetch the AssistantInstance


        :returns: The fetched AssistantInstance
        """

        payload = self._version.fetch(
            method="GET",
            uri=self._uri,
        )

        return AssistantInstance(
            self._version,
            payload,
            sid=self._solution["sid"],
        )

    async def fetch_async(self) -> AssistantInstance:
        """
        Asynchronous coroutine to fetch the AssistantInstance


        :returns: The fetched AssistantInstance
        """

        payload = await self._version.fetch_async(
            method="GET",
            uri=self._uri,
        )

        return AssistantInstance(
            self._version,
            payload,
            sid=self._solution["sid"],
        )

    def update(
        self,
        friendly_name: Union[str, object] = values.unset,
        log_queries: Union[bool, object] = values.unset,
        unique_name: Union[str, object] = values.unset,
        callback_url: Union[str, object] = values.unset,
        callback_events: Union[str, object] = values.unset,
        style_sheet: Union[object, object] = values.unset,
        defaults: Union[object, object] = values.unset,
        development_stage: Union[str, object] = values.unset,
    ) -> AssistantInstance:
        """
        Update the AssistantInstance

        :param friendly_name: A descriptive string that you create to describe the resource. It is not unique and can be up to 255 characters long.
        :param log_queries: Whether queries should be logged and kept after training. Can be: `true` or `false` and defaults to `true`. If `true`, queries are stored for 30 days, and then deleted. If `false`, no queries are stored.
        :param unique_name: An application-defined string that uniquely identifies the resource. It can be used as an alternative to the `sid` in the URL path to address the resource. The first 64 characters must be unique.
        :param callback_url: Reserved.
        :param callback_events: Reserved.
        :param style_sheet: The JSON string that defines the Assistant's [style sheet](https://www.twilio.com/docs/autopilot/api/assistant/stylesheet)
        :param defaults: A JSON object that defines the Assistant's [default tasks](https://www.twilio.com/docs/autopilot/api/assistant/defaults) for various scenarios, including initiation actions and fallback tasks.
        :param development_stage: A string describing the state of the assistant.

        :returns: The updated AssistantInstance
        """
        data = values.of(
            {
                "FriendlyName": friendly_name,
                "LogQueries": log_queries,
                "UniqueName": unique_name,
                "CallbackUrl": callback_url,
                "CallbackEvents": callback_events,
                "StyleSheet": serialize.object(style_sheet),
                "Defaults": serialize.object(defaults),
                "DevelopmentStage": development_stage,
            }
        )

        payload = self._version.update(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return AssistantInstance(self._version, payload, sid=self._solution["sid"])

    async def update_async(
        self,
        friendly_name: Union[str, object] = values.unset,
        log_queries: Union[bool, object] = values.unset,
        unique_name: Union[str, object] = values.unset,
        callback_url: Union[str, object] = values.unset,
        callback_events: Union[str, object] = values.unset,
        style_sheet: Union[object, object] = values.unset,
        defaults: Union[object, object] = values.unset,
        development_stage: Union[str, object] = values.unset,
    ) -> AssistantInstance:
        """
        Asynchronous coroutine to update the AssistantInstance

        :param friendly_name: A descriptive string that you create to describe the resource. It is not unique and can be up to 255 characters long.
        :param log_queries: Whether queries should be logged and kept after training. Can be: `true` or `false` and defaults to `true`. If `true`, queries are stored for 30 days, and then deleted. If `false`, no queries are stored.
        :param unique_name: An application-defined string that uniquely identifies the resource. It can be used as an alternative to the `sid` in the URL path to address the resource. The first 64 characters must be unique.
        :param callback_url: Reserved.
        :param callback_events: Reserved.
        :param style_sheet: The JSON string that defines the Assistant's [style sheet](https://www.twilio.com/docs/autopilot/api/assistant/stylesheet)
        :param defaults: A JSON object that defines the Assistant's [default tasks](https://www.twilio.com/docs/autopilot/api/assistant/defaults) for various scenarios, including initiation actions and fallback tasks.
        :param development_stage: A string describing the state of the assistant.

        :returns: The updated AssistantInstance
        """
        data = values.of(
            {
                "FriendlyName": friendly_name,
                "LogQueries": log_queries,
                "UniqueName": unique_name,
                "CallbackUrl": callback_url,
                "CallbackEvents": callback_events,
                "StyleSheet": serialize.object(style_sheet),
                "Defaults": serialize.object(defaults),
                "DevelopmentStage": development_stage,
            }
        )

        payload = await self._version.update_async(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return AssistantInstance(self._version, payload, sid=self._solution["sid"])

    @property
    def defaults(self) -> DefaultsList:
        """
        Access the defaults
        """
        if self._defaults is None:
            self._defaults = DefaultsList(
                self._version,
                self._solution["sid"],
            )
        return self._defaults

    @property
    def dialogues(self) -> DialogueList:
        """
        Access the dialogues
        """
        if self._dialogues is None:
            self._dialogues = DialogueList(
                self._version,
                self._solution["sid"],
            )
        return self._dialogues

    @property
    def field_types(self) -> FieldTypeList:
        """
        Access the field_types
        """
        if self._field_types is None:
            self._field_types = FieldTypeList(
                self._version,
                self._solution["sid"],
            )
        return self._field_types

    @property
    def model_builds(self) -> ModelBuildList:
        """
        Access the model_builds
        """
        if self._model_builds is None:
            self._model_builds = ModelBuildList(
                self._version,
                self._solution["sid"],
            )
        return self._model_builds

    @property
    def queries(self) -> QueryList:
        """
        Access the queries
        """
        if self._queries is None:
            self._queries = QueryList(
                self._version,
                self._solution["sid"],
            )
        return self._queries

    @property
    def style_sheet(self) -> StyleSheetList:
        """
        Access the style_sheet
        """
        if self._style_sheet is None:
            self._style_sheet = StyleSheetList(
                self._version,
                self._solution["sid"],
            )
        return self._style_sheet

    @property
    def tasks(self) -> TaskList:
        """
        Access the tasks
        """
        if self._tasks is None:
            self._tasks = TaskList(
                self._version,
                self._solution["sid"],
            )
        return self._tasks

    @property
    def webhooks(self) -> WebhookList:
        """
        Access the webhooks
        """
        if self._webhooks is None:
            self._webhooks = WebhookList(
                self._version,
                self._solution["sid"],
            )
        return self._webhooks

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        context = " ".join("{}={}".format(k, v) for k, v in self._solution.items())
        return "<Twilio.Autopilot.V1.AssistantContext {}>".format(context)


class AssistantPage(Page):
    def get_instance(self, payload: Dict[str, Any]) -> AssistantInstance:
        """
        Build an instance of AssistantInstance

        :param payload: Payload response from the API
        """
        return AssistantInstance(self._version, payload)

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Autopilot.V1.AssistantPage>"


class AssistantList(ListResource):
    def __init__(self, version: Version):
        """
        Initialize the AssistantList

        :param version: Version that contains the resource

        """
        super().__init__(version)

        self._uri = "/Assistants"

    def create(
        self,
        friendly_name: Union[str, object] = values.unset,
        log_queries: Union[bool, object] = values.unset,
        unique_name: Union[str, object] = values.unset,
        callback_url: Union[str, object] = values.unset,
        callback_events: Union[str, object] = values.unset,
        style_sheet: Union[object, object] = values.unset,
        defaults: Union[object, object] = values.unset,
    ) -> AssistantInstance:
        """
        Create the AssistantInstance

        :param friendly_name: A descriptive string that you create to describe the new resource. It is not unique and can be up to 255 characters long.
        :param log_queries: Whether queries should be logged and kept after training. Can be: `true` or `false` and defaults to `true`. If `true`, queries are stored for 30 days, and then deleted. If `false`, no queries are stored.
        :param unique_name: An application-defined string that uniquely identifies the new resource. It can be used as an alternative to the `sid` in the URL path to address the resource. The first 64 characters must be unique.
        :param callback_url: Reserved.
        :param callback_events: Reserved.
        :param style_sheet: The JSON string that defines the Assistant's [style sheet](https://www.twilio.com/docs/autopilot/api/assistant/stylesheet)
        :param defaults: A JSON object that defines the Assistant's [default tasks](https://www.twilio.com/docs/autopilot/api/assistant/defaults) for various scenarios, including initiation actions and fallback tasks.

        :returns: The created AssistantInstance
        """
        data = values.of(
            {
                "FriendlyName": friendly_name,
                "LogQueries": log_queries,
                "UniqueName": unique_name,
                "CallbackUrl": callback_url,
                "CallbackEvents": callback_events,
                "StyleSheet": serialize.object(style_sheet),
                "Defaults": serialize.object(defaults),
            }
        )

        payload = self._version.create(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return AssistantInstance(self._version, payload)

    async def create_async(
        self,
        friendly_name: Union[str, object] = values.unset,
        log_queries: Union[bool, object] = values.unset,
        unique_name: Union[str, object] = values.unset,
        callback_url: Union[str, object] = values.unset,
        callback_events: Union[str, object] = values.unset,
        style_sheet: Union[object, object] = values.unset,
        defaults: Union[object, object] = values.unset,
    ) -> AssistantInstance:
        """
        Asynchronously create the AssistantInstance

        :param friendly_name: A descriptive string that you create to describe the new resource. It is not unique and can be up to 255 characters long.
        :param log_queries: Whether queries should be logged and kept after training. Can be: `true` or `false` and defaults to `true`. If `true`, queries are stored for 30 days, and then deleted. If `false`, no queries are stored.
        :param unique_name: An application-defined string that uniquely identifies the new resource. It can be used as an alternative to the `sid` in the URL path to address the resource. The first 64 characters must be unique.
        :param callback_url: Reserved.
        :param callback_events: Reserved.
        :param style_sheet: The JSON string that defines the Assistant's [style sheet](https://www.twilio.com/docs/autopilot/api/assistant/stylesheet)
        :param defaults: A JSON object that defines the Assistant's [default tasks](https://www.twilio.com/docs/autopilot/api/assistant/defaults) for various scenarios, including initiation actions and fallback tasks.

        :returns: The created AssistantInstance
        """
        data = values.of(
            {
                "FriendlyName": friendly_name,
                "LogQueries": log_queries,
                "UniqueName": unique_name,
                "CallbackUrl": callback_url,
                "CallbackEvents": callback_events,
                "StyleSheet": serialize.object(style_sheet),
                "Defaults": serialize.object(defaults),
            }
        )

        payload = await self._version.create_async(
            method="POST",
            uri=self._uri,
            data=data,
        )

        return AssistantInstance(self._version, payload)

    def stream(
        self,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> Iterator[AssistantInstance]:
        """
        Streams AssistantInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param limit: Upper limit for the number of records to return. stream()
                      guarantees to never return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, stream() will attempt to read the
                          limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        """
        limits = self._version.read_limits(limit, page_size)
        page = self.page(page_size=limits["page_size"])

        return self._version.stream(page, limits["limit"])

    async def stream_async(
        self,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> AsyncIterator[AssistantInstance]:
        """
        Asynchronously streams AssistantInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param limit: Upper limit for the number of records to return. stream()
                      guarantees to never return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, stream() will attempt to read the
                          limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        """
        limits = self._version.read_limits(limit, page_size)
        page = await self.page_async(page_size=limits["page_size"])

        return self._version.stream_async(page, limits["limit"])

    def list(
        self,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> List[AssistantInstance]:
        """
        Lists AssistantInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param limit: Upper limit for the number of records to return. list() guarantees
                      never to return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, list() will attempt to read the limit
                          with the most efficient page size, i.e. min(limit, 1000)

        :returns: list that will contain up to limit results
        """
        return list(
            self.stream(
                limit=limit,
                page_size=page_size,
            )
        )

    async def list_async(
        self,
        limit: Optional[int] = None,
        page_size: Optional[int] = None,
    ) -> List[AssistantInstance]:
        """
        Asynchronously lists AssistantInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param limit: Upper limit for the number of records to return. list() guarantees
                      never to return more than limit.  Default is no limit
        :param page_size: Number of records to fetch per request, when not set will use
                          the default value of 50 records.  If no page_size is defined
                          but a limit is defined, list() will attempt to read the limit
                          with the most efficient page size, i.e. min(limit, 1000)

        :returns: list that will contain up to limit results
        """
        return [
            record
            async for record in await self.stream_async(
                limit=limit,
                page_size=page_size,
            )
        ]

    def page(
        self,
        page_token: Union[str, object] = values.unset,
        page_number: Union[int, object] = values.unset,
        page_size: Union[int, object] = values.unset,
    ) -> AssistantPage:
        """
        Retrieve a single page of AssistantInstance records from the API.
        Request is executed immediately

        :param page_token: PageToken provided by the API
        :param page_number: Page Number, this value is simply for client state
        :param page_size: Number of records to return, defaults to 50

        :returns: Page of AssistantInstance
        """
        data = values.of(
            {
                "PageToken": page_token,
                "Page": page_number,
                "PageSize": page_size,
            }
        )

        response = self._version.page(method="GET", uri=self._uri, params=data)
        return AssistantPage(self._version, response)

    async def page_async(
        self,
        page_token: Union[str, object] = values.unset,
        page_number: Union[int, object] = values.unset,
        page_size: Union[int, object] = values.unset,
    ) -> AssistantPage:
        """
        Asynchronously retrieve a single page of AssistantInstance records from the API.
        Request is executed immediately

        :param page_token: PageToken provided by the API
        :param page_number: Page Number, this value is simply for client state
        :param page_size: Number of records to return, defaults to 50

        :returns: Page of AssistantInstance
        """
        data = values.of(
            {
                "PageToken": page_token,
                "Page": page_number,
                "PageSize": page_size,
            }
        )

        response = await self._version.page_async(
            method="GET", uri=self._uri, params=data
        )
        return AssistantPage(self._version, response)

    def get_page(self, target_url: str) -> AssistantPage:
        """
        Retrieve a specific page of AssistantInstance records from the API.
        Request is executed immediately

        :param target_url: API-generated URL for the requested results page

        :returns: Page of AssistantInstance
        """
        response = self._version.domain.twilio.request("GET", target_url)
        return AssistantPage(self._version, response)

    async def get_page_async(self, target_url: str) -> AssistantPage:
        """
        Asynchronously retrieve a specific page of AssistantInstance records from the API.
        Request is executed immediately

        :param target_url: API-generated URL for the requested results page

        :returns: Page of AssistantInstance
        """
        response = await self._version.domain.twilio.request_async("GET", target_url)
        return AssistantPage(self._version, response)

    def get(self, sid: str) -> AssistantContext:
        """
        Constructs a AssistantContext

        :param sid: The Twilio-provided string that uniquely identifies the Assistant resource to update.
        """
        return AssistantContext(self._version, sid=sid)

    def __call__(self, sid: str) -> AssistantContext:
        """
        Constructs a AssistantContext

        :param sid: The Twilio-provided string that uniquely identifies the Assistant resource to update.
        """
        return AssistantContext(self._version, sid=sid)

    def __repr__(self) -> str:
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        """
        return "<Twilio.Autopilot.V1.AssistantList>"
