# PySNMP SMI module. Autogenerated from smidump -f python RAQMON-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:31 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( InetAddress, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType", "InetPortNumber")
( rmon, ) = mibBuilder.importSymbols("RMON-MIB", "rmon")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32")
( DateAndTime, RowPointer, RowStatus, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "RowPointer", "RowStatus", "TruthValue")

# Objects

raqmonMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 16, 31)).setRevisions(("2006-10-10 00:00",))
if mibBuilder.loadTexts: raqmonMIB.setOrganization("IETF RMON MIB Working Group")
if mibBuilder.loadTexts: raqmonMIB.setContactInfo("WG Charter:\nhttp://www.ietf.org/html.charters/rmonmib-charter.html\n\nMailing lists:\n    General Discussion: rmonmib@ietf.org\n    To Subscribe: rmonmib-requests@ietf.org\n    In Body: subscribe your_email_address\n\nChair: Andy Bierman\n       Email: ietf@andybierman.com\n\nEditor: Dan Romascanu\n        Avaya\n        Email:  dromasca@avaya.com")
if mibBuilder.loadTexts: raqmonMIB.setDescription("Real-Time Application QoS Monitoring MIB.\n\nCopyright (c) The Internet Society (2006).\nThis version of this MIB module is part of\nRFC 4711; See the RFC itself for full legal notices.")
raqmonNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 0))
raqmonMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 1))
raqmonSession = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 1, 1))
raqmonParticipantTable = MibTable((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1))
if mibBuilder.loadTexts: raqmonParticipantTable.setDescription("This table contains information about participants in\nboth active and closed (terminated) sessions.")
raqmonParticipantEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1)).setIndexNames((0, "RAQMON-MIB", "raqmonParticipantStartDate"), (0, "RAQMON-MIB", "raqmonParticipantIndex"))
if mibBuilder.loadTexts: raqmonParticipantEntry.setDescription("Each row contains information for a single session\n(application) run by one participant.\nIndexation by the start time of the session aims\nto ease sorting by management applications.  Agents MUST\nNOT report identical start times for any two sessions\non the same host.\nRows are removed for inactive sessions\nwhen implementation-specific age or space limits are\nreached.")
raqmonParticipantStartDate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 1), DateAndTime()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: raqmonParticipantStartDate.setDescription("The date and time of this entry.\nIt will be the date and time\nof the first report received.")
raqmonParticipantIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: raqmonParticipantIndex.setDescription("The index of the conceptual row, which is for SNMP\npurposes only and has no relation to any protocol value.\n\nThere is no requirement that these rows be created or\nmaintained sequentially.  The index will be unique for a\nparticular date and time.")
raqmonParticipantReportCaps = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 3), Bits().subtype(namedValues=NamedValues(("raqmonPartRepDsrcName", 0), ("raqmonPartRepRecvName", 1), ("raqmonPartApplicationDelay", 10), ("raqmonPartRepIAJitter", 11), ("raqmonPartRepIPDV", 12), ("raqmonPartRepRcvdPackets", 13), ("raqmonPartRepRcvdOctets", 14), ("raqmonPartRepSentPackets", 15), ("raqmonPartRepSentOctets", 16), ("raqmonPartRepCumPacketsLoss", 17), ("raqmonPartRepFractionPacketsLoss", 18), ("raqmonPartRepCumDiscards", 19), ("raqmonPartRepDsrcPort", 2), ("raqmonPartRepFractionDiscards", 20), ("raqmonPartRepSrcPayloadType", 21), ("raqmonPartRepDestPayloadType", 22), ("raqmonPartRepSrcLayer2Priority", 23), ("raqmonPartRepSrcTosDscp", 24), ("raqmonPartRepDestLayer2Priority", 25), ("raqmonPartRepDestTosDscp", 26), ("raqmonPartRepCPU", 27), ("raqmonPartRepMemory", 28), ("raqmonPartRepAppName", 29), ("raqmonPartRepRecvPort", 3), ("raqmonPartRepSetupTime", 4), ("raqmonPartRepSetupDelay", 5), ("raqmonPartRepSessionDuration", 6), ("raqmonPartRepSetupStatus", 7), ("raqmonPartRepRTEnd2EndNetDelay", 8), ("raqmonPartRepOWEnd2EndNetDelay", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantReportCaps.setDescription("The Report capabilities of the participant, as perceived\nby the Collector.\n\nIf the participant can report the Data Source Name as\ndefined in [RFC4710], Section 5.3, then the\nraqmonPartRepDsrcName bit will be set.\n\nIf the participant can report the Receiver Name as\ndefined in [RFC4710], Section 5.4, then the\nraqmonPartRepRecvName bit will be set.\n\nIf the participant can report the Data Source Port as\ndefined in [RFC4710], Section 5.5, then the\nraqmonPartRepDsrcPort bit will be set.\n\nIf the participant can report the Receiver Port as\ndefined in [RFC4710], Section 5.6, then the\nraqmonPartRepRecvPort bit will be set.\n\nIf the participant can report the Session Setup Time as\ndefined in [RFC4710], Section 5.7, then the\nraqmonPartRepSetupTime bit will be set.\n\nIf the participant can report the Session Setup Delay as\ndefined in [RFC4710], Section 5.8, then the\nraqmonPartRepSetupDelay bit will be set.\n\n\n\n\nIf the participant can report the Session Duration as\ndefined in [RFC4710], Section 5.9, then the\nraqmonPartRepSessionDuration bit will be set.\n\nIf the participant can report the Setup Status as\ndefined in [RFC4710], Section 5.10, then the\nraqmonPartRepSetupStatus bit will be set.\n\nIf the participant can report the Round-Trip End-to-end\nNetwork Delay as defined in [RFC4710], Section 5.11,\nthen the raqmonPartRepRTEnd2EndNetDelay bit will be set.\n\nIf the participant can report the One-way End-to-end\nNetwork Delay as defined in [RFC4710], Section 5.12,\nthen the raqmonPartRepOWEnd2EndNetDelay bit will be set.\n\nIf the participant can report the Application Delay as\ndefined in [RFC4710], Section 5.13, then the\nraqmonPartApplicationDelay bit will be set.\n\nIf the participant can report the Inter-Arrival Jitter\nas defined in [RFC4710], Section 5.14, then the\nraqmonPartRepIAJitter bit will be set.\n\nIf the participant can report the IP Packet Delay\nVariation as defined in [RFC4710], Section 5.15, then\nthe raqmonPartRepIPDV bit will be set.\n\nIf the participant can report the number of application\npackets received as defined in [RFC4710], Section 5.16,\nthen the raqmonPartRepRcvdPackets bit will be set.\n\nIf the participant can report the number of application\noctets received as defined in [RFC4710], Section 5.17,\nthen the raqmonPartRepRcvdOctets bit will be set.\n\nIf the participant can report the number of application\npackets sent as defined in [RFC4710], Section 5.18, then\nthe raqmonPartRepSentPackets bit will be set.\n\nIf the participant can report the number of application\noctets sent as defined in [RFC4710], Section 5.19, then\nthe raqmonPartRepSentOctets bit will be set.\n\nIf the participant can report the number of cumulative\npackets lost as defined in [RFC4710], Section 5.20, then\nthe raqmonPartRepCumPacketsLoss bit will be set.\n\n\n\n\nIf the participant can report the fraction of packet\nloss as defined in [RFC4710], Section 5.21, then the\nraqmonPartRepFractionPacketsLoss bit will be set.\n\nIf the participant can report the number of cumulative\ndiscards as defined in [RFC4710], Section 5.22, then the\nraqmonPartRepCumDiscards bit will be set.\n\nIf the participant can report the fraction of discards\nas defined in [RFC4710], Section 5.23, then the\nraqmonPartRepFractionDiscards bit will be set.\n\nIf the participant can report the Source Payload Type as\ndefined in [RFC4710], Section 5.24, then the\nraqmonPartRepSrcPayloadType bit will be set.\n\nIf the participant can report the Destination Payload\nType as defined in [RFC4710], Section 5.25, then the\nraqmonPartRepDestPayloadType bit will be set.\n\nIf the participant can report the Source Layer 2\nPriority as defined in [RFC4710], Section 5.26, then the\nraqmonPartRepSrcLayer2Priority bit will be set.\n\nIf the participant can report the Source DSCP/ToS value\nas defined in [RFC4710], Section 5.27, then the\nraqmonPartRepSrcToSDscp bit will be set.\n\nIf the participant can report the Destination Layer 2\nPriority as defined in [RFC4710], Section 5.28, then the\nraqmonPartRepDestLayer2Priority bit will be set.\n\nIf the participant can report the Destination DSCP/ToS\nValue as defined in [RFC4710], Section 5.29, then the\nraqmonPartRepDestToSDscp bit will be set.\n\nIf the participant can report the CPU utilization as\ndefined in [RFC4710], Section 5.30, then the\nraqmonPartRepCPU bit will be set.\n\nIf the participant can report the memory utilization as\ndefined in [RFC4710], Section 5.31, then the\nraqmonPartRepMemory bit will be set.\n\nIf the participant can report the Application Name as\ndefined in [RFC4710], Section 5.32, then the\nraqmonPartRepAppName bit will be set.\n\n\n\n\nThe capability of reporting of a specific metric does\nnot mandate that the metric must be reported permanently\nby the data source to the respective collector.  Some\ndata sources MAY be configured not to send a metric, or\nsome metrics may not be relevant to the specific\napplication.")
raqmonParticipantAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 4), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAddrType.setDescription("The type of the Internet address of the participant for\nthis session.")
raqmonParticipantAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 5), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAddr.setDescription("The Internet Address of the participant for this\nsession.  Formatting of this object is determined\nby the value of raqmonParticipantAddrType.")
raqmonParticipantSendPort = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 6), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantSendPort.setDescription("Port from which session data is sent.\nIf the value was not reported to the collector,\nthis object will have the value 0.")
raqmonParticipantRecvPort = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 7), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantRecvPort.setDescription("Port on which session data is received.\nIf the value was not reported to the collector,\nthis object will have the value 0.")
raqmonParticipantSetupDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantSetupDelay.setDescription("Session setup time.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantName = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 9), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantName.setDescription("The data source name for the participant.")
raqmonParticipantAppName = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 10), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAppName.setDescription("A string giving the name and possibly the version\nof the application generating the stream, e.g.,\n'videotool 1.2.'\n\nThis information may be useful for debugging purposes\nand is similar to the Mailer or Mail-System-Version SMTP\nheaders.  The tool value is expected to remain constant\nfor the duration of the session.")
raqmonParticipantQosCount = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantQosCount.setDescription("The current number of entries in the raqmonQosTable\nfor this participant and session.")
raqmonParticipantEndDate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 12), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantEndDate.setDescription("The date and time of the most recent report received.")
raqmonParticipantDestPayloadType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantDestPayloadType.setDescription("Destination Payload Type.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantSrcPayloadType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 127))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantSrcPayloadType.setDescription("Source Payload Type.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantActive = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 15), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantActive.setDescription("Value 'true' indicates that the session\nfor this participant is active (open).\nValue 'false' indicates that the session\nis closed (terminated).")
raqmonParticipantPeer = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 16), RowPointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantPeer.setDescription("The pointer to the corresponding entry in this table for\nthe other peer participant.  If there is no such entry\nin the participant table of the collector represented by\nthis SNMP agent, then the value will be { 0 0 }.")
raqmonParticipantPeerAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 17), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantPeerAddrType.setDescription("The type of the Internet address of the peer participant\nfor this session.")
raqmonParticipantPeerAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 18), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantPeerAddr.setDescription("The Internet Address of the peer participant for this\nsession.  Formatting of this object is determined by\nthe value of raqmonParticipantPeerAddrType.")
raqmonParticipantSrcL2Priority = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantSrcL2Priority.setDescription("Source Layer 2 Priority.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantDestL2Priority = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantDestL2Priority.setDescription("Destination Layer 2 Priority.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantSrcDSCP = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 21), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantSrcDSCP.setDescription("Source Layer 3 DSCP value.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantDestDSCP = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 22), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 63))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantDestDSCP.setDescription("Destination Layer 3 DSCP value.")
raqmonParticipantCpuMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantCpuMean.setDescription("Mean CPU utilization.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantCpuMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 24), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantCpuMin.setDescription("Minimum CPU utilization.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantCpuMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 25), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantCpuMax.setDescription("Maximum CPU utilization.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantMemoryMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 26), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantMemoryMean.setDescription("Mean memory utilization.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantMemoryMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 27), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantMemoryMin.setDescription("Minimum memory utilization.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantMemoryMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 28), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantMemoryMax.setDescription("Maximum memory utilization.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantNetRTTMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 29), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetRTTMean.setDescription("Mean round-trip end-to-end network\ndelay over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantNetRTTMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 30), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetRTTMin.setDescription("Minimum round-trip end-to-end network delay\nover the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantNetRTTMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 31), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetRTTMax.setDescription("Maximum round-trip end-to-end network delay\nover the entire session.\nIf the value was not reported to the collector,\n\n\n\nthis object will have the value -1.")
raqmonParticipantIAJitterMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 32), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIAJitterMean.setDescription("Mean inter-arrival jitter over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantIAJitterMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 33), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIAJitterMin.setDescription("Minimum inter-arrival jitter over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantIAJitterMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 34), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIAJitterMax.setDescription("Maximum inter-arrival jitter over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantIPDVMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 35), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIPDVMean.setDescription("Mean IP packet delay variation over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantIPDVMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 36), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIPDVMin.setDescription("Minimum IP packet delay variation over the entire\nsession.  If the value was not reported to the\ncollector, this object will have the value -1.")
raqmonParticipantIPDVMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 37), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantIPDVMax.setDescription("Maximum IP packet delay variation over the entire\nsession.  If the value was not reported to the\ncollector, this object will have the value -1.")
raqmonParticipantNetOwdMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 38), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetOwdMean.setDescription("Mean Network one-way delay over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantNetOwdMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 39), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetOwdMin.setDescription("Minimum Network one-way delay over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantNetOwdMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 40), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantNetOwdMax.setDescription("Maximum Network one-way delay over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantAppDelayMean = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 41), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAppDelayMean.setDescription("Mean application delay over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantAppDelayMin = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 42), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAppDelayMin.setDescription("Minimum application delay over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantAppDelayMax = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 43), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAppDelayMax.setDescription("Maximum application delay over the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantPacketsRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 44), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantPacketsRcvd.setDescription("Count of packets received for the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantPacketsSent = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 45), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantPacketsSent.setDescription("Count of packets sent for the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantOctetsRcvd = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 46), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantOctetsRcvd.setDescription("Count of octets received for the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantOctetsSent = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 47), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantOctetsSent.setDescription("Count of octets sent for the entire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantLostPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 48), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantLostPackets.setDescription("Count of packets lost by this receiver for the entire\nsession.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantLostPacketsFrct = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 49), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantLostPacketsFrct.setDescription("Fraction of lost packets out of total packets received.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 50), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantDiscards.setDescription("Count of packets discarded by this receiver for the\nentire session.\nIf the value was not reported to the collector,\nthis object will have the value -1.")
raqmonParticipantDiscardsFrct = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 1, 1, 51), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantDiscardsFrct.setDescription("Fraction of discarded packets out of total packets\nreceived.  If the value was not reported to the\ncollector, this object will have the value -1.")
raqmonQosTable = MibTable((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2))
if mibBuilder.loadTexts: raqmonQosTable.setDescription("Table of historical information about quality-of-service\ndata during sessions.")
raqmonQosEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1)).setIndexNames((0, "RAQMON-MIB", "raqmonParticipantStartDate"), (0, "RAQMON-MIB", "raqmonParticipantIndex"), (0, "RAQMON-MIB", "raqmonQosTime"))
if mibBuilder.loadTexts: raqmonQosEntry.setDescription("Each entry contains information from a single RAQMON\npacket, related to a single session\n(application) run by one participant.\nIndexation by the start time of the session aims\nto ease sorting by management applications.  Agents MUST\nNOT report identical start times for any two sessions\n\n\n\non the same host.\nRows are removed for inactive sessions when\nimplementation-specific time or space limits are\nreached.")
raqmonQosTime = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 2147483647))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: raqmonQosTime.setDescription("Time of this entry measured from the start of the\ncorresponding participant session.")
raqmonQoSEnd2EndNetDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQoSEnd2EndNetDelay.setDescription("The round-trip time.\nWill contain the previous value if there was no report\nfor this time, or -1 if the value has never\nbeen reported.")
raqmonQoSInterArrivalJitter = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQoSInterArrivalJitter.setDescription("An estimate of delay variation as observed by this\nreceiver.  Will contain the previous value if there\nwas no report for this time, or -1 if the value\nhas never been reported.")
raqmonQosRcvdPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosRcvdPackets.setDescription("Count of packets received by this receiver since the\nprevious entry.  Will contain the previous value if\nthere was no report for this time, or -1 if the value\nhas never been reported.")
raqmonQosRcvdOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosRcvdOctets.setDescription("Count of octets received by this receiver since the\nprevious report.  Will contain the previous value if\nthere was no report for this time, or -1 if the value\nhas never been reported.")
raqmonQosSentPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosSentPackets.setDescription("Count of packets sent since the previous report.\nWill contain the previous value if there\n\n\n\nwas no report for this time, or -1 if the value\nhas never been reported.")
raqmonQosSentOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosSentOctets.setDescription("Count of octets sent since the previous report.\nWill contain the previous value if there\nwas no report for this time, or -1 if the value\nhas never been reported.")
raqmonQosLostPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosLostPackets.setDescription("A count of packets lost as observed by this receiver\nsince the previous report.  Will contain the previous\nvalue if there was no report for this time, or -1 if\nthe value has never been reported.")
raqmonQosSessionStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 2, 1, 9), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonQosSessionStatus.setDescription("The session status.  Will contain the previous value\nif there was no report for this time or the zero-length\nstring if no value was ever reported.")
raqmonParticipantAddrTable = MibTable((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 3))
if mibBuilder.loadTexts: raqmonParticipantAddrTable.setDescription("Maps raqmonParticipantAddr to the index of the\nraqmonParticipantTable.  This table allows\nmanagement applications to find entries\nsorted by raqmonParticipantAddr rather than\nraqmonParticipantStartDate.")
raqmonParticipantAddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 3, 1)).setIndexNames((0, "RAQMON-MIB", "raqmonParticipantAddrType"), (0, "RAQMON-MIB", "raqmonParticipantAddr"), (0, "RAQMON-MIB", "raqmonParticipantStartDate"), (0, "RAQMON-MIB", "raqmonParticipantIndex"))
if mibBuilder.loadTexts: raqmonParticipantAddrEntry.setDescription("Each entry corresponds to exactly one entry in the\nraqmonParticipantEntry: the entry containing the\nindex pair raqmonParticipantStartDate,\nraqmonParticipantIndex.\n\nNote that there is no concern about the indexation of\nthis table exceeding the limits defined by RFC 2578,\nSection 3.5.  According to [RFC4710], Section\n5.1, only IPv4 and IPv6 addresses can be reported as\nparticipant addresses.")
raqmonParticipantAddrEndDate = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 1, 3, 1, 1), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonParticipantAddrEndDate.setDescription("The value of raqmonParticipantEndDate for the\ncorresponding raqmonParticipantEntry.")
raqmonException = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 1, 2))
raqmonSessionExceptionTable = MibTable((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2))
if mibBuilder.loadTexts: raqmonSessionExceptionTable.setDescription("This table defines thresholds for the management\nstation to get notifications about sessions that\nencountered poor quality of service.\n\nThe information in this table MUST be persistent\nacross agent reboots.")
raqmonSessionExceptionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1)).setIndexNames((0, "RAQMON-MIB", "raqmonSessionExceptionIndex"))
if mibBuilder.loadTexts: raqmonSessionExceptionEntry.setDescription("A conceptual row in the raqmonSessionExceptionTable.")
raqmonSessionExceptionIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: raqmonSessionExceptionIndex.setDescription("An index that uniquely identifies an\nentry in the raqmonSessionExceptionTable.\nManagement applications can determine unused indices\nby performing GetNext or GetBulk operations on the\nTable.")
raqmonSessionExceptionIAJitterThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1, 3), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: raqmonSessionExceptionIAJitterThreshold.setDescription("Threshold for jitter.\nThe value during a session must be greater than or\nequal to this value for an exception to be created.")
raqmonSessionExceptionNetRTTThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1, 4), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: raqmonSessionExceptionNetRTTThreshold.setDescription("Threshold for round-trip time.\nThe value during a session must be greater than or\nequal to this value for an exception to be created.")
raqmonSessionExceptionLostPacketsThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 1000))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: raqmonSessionExceptionLostPacketsThreshold.setDescription("Threshold for lost packets in units of tenths\nof a percent.  The value during a session must\nbe greater than or equal to this value for an\nexception to be created.")
raqmonSessionExceptionRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 16, 31, 1, 2, 2, 1, 7), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: raqmonSessionExceptionRowStatus.setDescription("This object has a value of 'active' when\nexceptions are being monitored by the system.\nA newly-created conceptual row must have all\nthe read-create objects initialized before\nbecoming 'active'.  A conceptual row that is in\nthe 'notReady' or 'notInService' state MAY be\nremoved after 5 minutes.  No writeable objects\ncan be changed while the row is active.")
raqmonConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 1, 3))
raqmonConfigPort = MibScalar((1, 3, 6, 1, 2, 1, 16, 31, 1, 3, 1), InetPortNumber()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: raqmonConfigPort.setDescription("The UDP port to listen on for RAQMON reports,\nrunning on transport protocols other than SNMP.\nIf the RAQMON PDU transport protocol is SNMP,\na write operation on this object has no effect, as\nthe standard port 162 is always used.\nThe value of this object MUST be persistent across\nagent reboots.")
raqmonConfigPduTransport = MibScalar((1, 3, 6, 1, 2, 1, 16, 31, 1, 3, 2), Bits().subtype(namedValues=NamedValues(("other", 0), ("tcp", 1), ("snmp", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: raqmonConfigPduTransport.setDescription("The PDU transport(s) used by this collector.\nIf other(0) is set, the collector supports a\ntransport other than SNMP or TCP.\nIf tcp(1) is set, the collector supports TCP as a\ntransport protocol.\nIf snmp(2) is set, the collector supports SNMP as a\ntransport protocol.")
raqmonConfigRaqmonPdus = MibScalar((1, 3, 6, 1, 2, 1, 16, 31, 1, 3, 3), Counter32()).setMaxAccess("readonly").setUnits("PDUs")
if mibBuilder.loadTexts: raqmonConfigRaqmonPdus.setDescription("Count of RAQMON PDUs received by the Collector.")
raqmonConfigRDSTimeout = MibScalar((1, 3, 6, 1, 2, 1, 16, 31, 1, 3, 4), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: raqmonConfigRDSTimeout.setDescription("The number of seconds since the reception of the\nlast RAQMON PDU from a RDS after which a session\n\n\n\nbetween the respective RDS and the collector will be\nconsidered terminated.\nThe value of this object MUST be persistent across\nagent reboots.")
raqmonConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 2))
raqmonCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 2, 1))
raqmonGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 16, 31, 2, 2))

# Augmentions

# Notifications

raqmonSessionAlarm = NotificationType((1, 3, 6, 1, 2, 1, 16, 31, 0, 1)).setObjects(*(("RAQMON-MIB", "raqmonParticipantAddr"), ("RAQMON-MIB", "raqmonQosLostPackets"), ("RAQMON-MIB", "raqmonParticipantPeerAddrType"), ("RAQMON-MIB", "raqmonQoSInterArrivalJitter"), ("RAQMON-MIB", "raqmonQoSEnd2EndNetDelay"), ("RAQMON-MIB", "raqmonQosRcvdPackets"), ("RAQMON-MIB", "raqmonParticipantName"), ("RAQMON-MIB", "raqmonParticipantPeerAddr"), ) )
if mibBuilder.loadTexts: raqmonSessionAlarm.setDescription("A notification generated by an entry in the\nraqmonSessionExceptionTable.")

# Groups

raqmonCollectorGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 16, 31, 2, 2, 1)).setObjects(*(("RAQMON-MIB", "raqmonParticipantNetOwdMax"), ("RAQMON-MIB", "raqmonParticipantPeerAddrType"), ("RAQMON-MIB", "raqmonParticipantAddrEndDate"), ("RAQMON-MIB", "raqmonQoSEnd2EndNetDelay"), ("RAQMON-MIB", "raqmonQosSentOctets"), ("RAQMON-MIB", "raqmonParticipantSendPort"), ("RAQMON-MIB", "raqmonParticipantNetOwdMin"), ("RAQMON-MIB", "raqmonParticipantPeerAddr"), ("RAQMON-MIB", "raqmonParticipantNetOwdMean"), ("RAQMON-MIB", "raqmonSessionExceptionRowStatus"), ("RAQMON-MIB", "raqmonConfigRaqmonPdus"), ("RAQMON-MIB", "raqmonParticipantEndDate"), ("RAQMON-MIB", "raqmonParticipantIPDVMean"), ("RAQMON-MIB", "raqmonParticipantCpuMax"), ("RAQMON-MIB", "raqmonParticipantDestDSCP"), ("RAQMON-MIB", "raqmonParticipantSrcPayloadType"), ("RAQMON-MIB", "raqmonParticipantMemoryMax"), ("RAQMON-MIB", "raqmonParticipantAddrType"), ("RAQMON-MIB", "raqmonQosSentPackets"), ("RAQMON-MIB", "raqmonConfigRDSTimeout"), ("RAQMON-MIB", "raqmonConfigPduTransport"), ("RAQMON-MIB", "raqmonParticipantMemoryMin"), ("RAQMON-MIB", "raqmonParticipantReportCaps"), ("RAQMON-MIB", "raqmonParticipantMemoryMean"), ("RAQMON-MIB", "raqmonParticipantLostPackets"), ("RAQMON-MIB", "raqmonParticipantCpuMean"), ("RAQMON-MIB", "raqmonParticipantAppDelayMean"), ("RAQMON-MIB", "raqmonParticipantIPDVMin"), ("RAQMON-MIB", "raqmonParticipantNetRTTMin"), ("RAQMON-MIB", "raqmonParticipantIAJitterMin"), ("RAQMON-MIB", "raqmonParticipantCpuMin"), ("RAQMON-MIB", "raqmonParticipantDiscards"), ("RAQMON-MIB", "raqmonParticipantSrcDSCP"), ("RAQMON-MIB", "raqmonSessionExceptionNetRTTThreshold"), ("RAQMON-MIB", "raqmonParticipantNetRTTMax"), ("RAQMON-MIB", "raqmonParticipantIPDVMax"), ("RAQMON-MIB", "raqmonParticipantAppName"), ("RAQMON-MIB", "raqmonParticipantDestL2Priority"), ("RAQMON-MIB", "raqmonParticipantAddr"), ("RAQMON-MIB", "raqmonParticipantAppDelayMax"), ("RAQMON-MIB", "raqmonParticipantDestPayloadType"), ("RAQMON-MIB", "raqmonParticipantActive"), ("RAQMON-MIB", "raqmonParticipantSrcL2Priority"), ("RAQMON-MIB", "raqmonParticipantLostPacketsFrct"), ("RAQMON-MIB", "raqmonParticipantIAJitterMax"), ("RAQMON-MIB", "raqmonQosRcvdOctets"), ("RAQMON-MIB", "raqmonParticipantOctetsRcvd"), ("RAQMON-MIB", "raqmonParticipantPeer"), ("RAQMON-MIB", "raqmonQosLostPackets"), ("RAQMON-MIB", "raqmonParticipantSetupDelay"), ("RAQMON-MIB", "raqmonParticipantIAJitterMean"), ("RAQMON-MIB", "raqmonQoSInterArrivalJitter"), ("RAQMON-MIB", "raqmonSessionExceptionIAJitterThreshold"), ("RAQMON-MIB", "raqmonQosSessionStatus"), ("RAQMON-MIB", "raqmonConfigPort"), ("RAQMON-MIB", "raqmonQosRcvdPackets"), ("RAQMON-MIB", "raqmonParticipantName"), ("RAQMON-MIB", "raqmonParticipantRecvPort"), ("RAQMON-MIB", "raqmonParticipantPacketsSent"), ("RAQMON-MIB", "raqmonParticipantQosCount"), ("RAQMON-MIB", "raqmonSessionExceptionLostPacketsThreshold"), ("RAQMON-MIB", "raqmonParticipantPacketsRcvd"), ("RAQMON-MIB", "raqmonParticipantDiscardsFrct"), ("RAQMON-MIB", "raqmonParticipantNetRTTMean"), ("RAQMON-MIB", "raqmonParticipantOctetsSent"), ("RAQMON-MIB", "raqmonParticipantAppDelayMin"), ) )
if mibBuilder.loadTexts: raqmonCollectorGroup.setDescription("Objects used in RAQMON by a collector.")
raqmonCollectorNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 16, 31, 2, 2, 2)).setObjects(*(("RAQMON-MIB", "raqmonSessionAlarm"), ) )
if mibBuilder.loadTexts: raqmonCollectorNotificationsGroup.setDescription("Notifications emitted by a RAQMON collector.")

# Compliances

raqmonCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 16, 31, 2, 1, 1)).setObjects(*(("RAQMON-MIB", "raqmonCollectorGroup"), ("RAQMON-MIB", "raqmonCollectorNotificationsGroup"), ) )
if mibBuilder.loadTexts: raqmonCompliance.setDescription("Describes the requirements for conformance to the\nRAQMON MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("RAQMON-MIB", PYSNMP_MODULE_ID=raqmonMIB)

# Objects
mibBuilder.exportSymbols("RAQMON-MIB", raqmonMIB=raqmonMIB, raqmonNotifications=raqmonNotifications, raqmonMIBObjects=raqmonMIBObjects, raqmonSession=raqmonSession, raqmonParticipantTable=raqmonParticipantTable, raqmonParticipantEntry=raqmonParticipantEntry, raqmonParticipantStartDate=raqmonParticipantStartDate, raqmonParticipantIndex=raqmonParticipantIndex, raqmonParticipantReportCaps=raqmonParticipantReportCaps, raqmonParticipantAddrType=raqmonParticipantAddrType, raqmonParticipantAddr=raqmonParticipantAddr, raqmonParticipantSendPort=raqmonParticipantSendPort, raqmonParticipantRecvPort=raqmonParticipantRecvPort, raqmonParticipantSetupDelay=raqmonParticipantSetupDelay, raqmonParticipantName=raqmonParticipantName, raqmonParticipantAppName=raqmonParticipantAppName, raqmonParticipantQosCount=raqmonParticipantQosCount, raqmonParticipantEndDate=raqmonParticipantEndDate, raqmonParticipantDestPayloadType=raqmonParticipantDestPayloadType, raqmonParticipantSrcPayloadType=raqmonParticipantSrcPayloadType, raqmonParticipantActive=raqmonParticipantActive, raqmonParticipantPeer=raqmonParticipantPeer, raqmonParticipantPeerAddrType=raqmonParticipantPeerAddrType, raqmonParticipantPeerAddr=raqmonParticipantPeerAddr, raqmonParticipantSrcL2Priority=raqmonParticipantSrcL2Priority, raqmonParticipantDestL2Priority=raqmonParticipantDestL2Priority, raqmonParticipantSrcDSCP=raqmonParticipantSrcDSCP, raqmonParticipantDestDSCP=raqmonParticipantDestDSCP, raqmonParticipantCpuMean=raqmonParticipantCpuMean, raqmonParticipantCpuMin=raqmonParticipantCpuMin, raqmonParticipantCpuMax=raqmonParticipantCpuMax, raqmonParticipantMemoryMean=raqmonParticipantMemoryMean, raqmonParticipantMemoryMin=raqmonParticipantMemoryMin, raqmonParticipantMemoryMax=raqmonParticipantMemoryMax, raqmonParticipantNetRTTMean=raqmonParticipantNetRTTMean, raqmonParticipantNetRTTMin=raqmonParticipantNetRTTMin, raqmonParticipantNetRTTMax=raqmonParticipantNetRTTMax, raqmonParticipantIAJitterMean=raqmonParticipantIAJitterMean, raqmonParticipantIAJitterMin=raqmonParticipantIAJitterMin, raqmonParticipantIAJitterMax=raqmonParticipantIAJitterMax, raqmonParticipantIPDVMean=raqmonParticipantIPDVMean, raqmonParticipantIPDVMin=raqmonParticipantIPDVMin, raqmonParticipantIPDVMax=raqmonParticipantIPDVMax, raqmonParticipantNetOwdMean=raqmonParticipantNetOwdMean, raqmonParticipantNetOwdMin=raqmonParticipantNetOwdMin, raqmonParticipantNetOwdMax=raqmonParticipantNetOwdMax, raqmonParticipantAppDelayMean=raqmonParticipantAppDelayMean, raqmonParticipantAppDelayMin=raqmonParticipantAppDelayMin, raqmonParticipantAppDelayMax=raqmonParticipantAppDelayMax, raqmonParticipantPacketsRcvd=raqmonParticipantPacketsRcvd, raqmonParticipantPacketsSent=raqmonParticipantPacketsSent, raqmonParticipantOctetsRcvd=raqmonParticipantOctetsRcvd, raqmonParticipantOctetsSent=raqmonParticipantOctetsSent, raqmonParticipantLostPackets=raqmonParticipantLostPackets, raqmonParticipantLostPacketsFrct=raqmonParticipantLostPacketsFrct, raqmonParticipantDiscards=raqmonParticipantDiscards, raqmonParticipantDiscardsFrct=raqmonParticipantDiscardsFrct, raqmonQosTable=raqmonQosTable, raqmonQosEntry=raqmonQosEntry, raqmonQosTime=raqmonQosTime, raqmonQoSEnd2EndNetDelay=raqmonQoSEnd2EndNetDelay, raqmonQoSInterArrivalJitter=raqmonQoSInterArrivalJitter, raqmonQosRcvdPackets=raqmonQosRcvdPackets, raqmonQosRcvdOctets=raqmonQosRcvdOctets, raqmonQosSentPackets=raqmonQosSentPackets, raqmonQosSentOctets=raqmonQosSentOctets, raqmonQosLostPackets=raqmonQosLostPackets, raqmonQosSessionStatus=raqmonQosSessionStatus, raqmonParticipantAddrTable=raqmonParticipantAddrTable, raqmonParticipantAddrEntry=raqmonParticipantAddrEntry, raqmonParticipantAddrEndDate=raqmonParticipantAddrEndDate, raqmonException=raqmonException, raqmonSessionExceptionTable=raqmonSessionExceptionTable, raqmonSessionExceptionEntry=raqmonSessionExceptionEntry, raqmonSessionExceptionIndex=raqmonSessionExceptionIndex, raqmonSessionExceptionIAJitterThreshold=raqmonSessionExceptionIAJitterThreshold, raqmonSessionExceptionNetRTTThreshold=raqmonSessionExceptionNetRTTThreshold, raqmonSessionExceptionLostPacketsThreshold=raqmonSessionExceptionLostPacketsThreshold, raqmonSessionExceptionRowStatus=raqmonSessionExceptionRowStatus, raqmonConfig=raqmonConfig, raqmonConfigPort=raqmonConfigPort, raqmonConfigPduTransport=raqmonConfigPduTransport, raqmonConfigRaqmonPdus=raqmonConfigRaqmonPdus, raqmonConfigRDSTimeout=raqmonConfigRDSTimeout, raqmonConformance=raqmonConformance, raqmonCompliances=raqmonCompliances, raqmonGroups=raqmonGroups)

# Notifications
mibBuilder.exportSymbols("RAQMON-MIB", raqmonSessionAlarm=raqmonSessionAlarm)

# Groups
mibBuilder.exportSymbols("RAQMON-MIB", raqmonCollectorGroup=raqmonCollectorGroup, raqmonCollectorNotificationsGroup=raqmonCollectorNotificationsGroup)

# Compliances
mibBuilder.exportSymbols("RAQMON-MIB", raqmonCompliance=raqmonCompliance)
