import uuid

from globus_sdk.testing.models import RegisteredResponse, ResponseSet

from ._common import ENDPOINT_ID as SRC_ENDPOINT_ID
from ._common import TASK_ID

DEST_ENDPOINT_ID = str(uuid.uuid4())
OWNER_ID = str(uuid.uuid4())


RESPONSES = ResponseSet(
    default=RegisteredResponse(
        service="transfer",
        method="GET",
        path="/v0.10/endpoint_manager/task_list",
        metadata={
            "task_id": TASK_ID,
            "source": SRC_ENDPOINT_ID,
            "destination": DEST_ENDPOINT_ID,
            "owner_id": OWNER_ID,
        },
        json={
            "DATA": [
                {
                    "DATA_TYPE": "task",
                    "bytes_checksummed": 0,
                    "bytes_transferred": 14,
                    "canceled_by_admin": None,
                    "canceled_by_admin_message": None,
                    "command": "API 0.10",
                    "completion_time": "2024-02-06T06:59:02+00:00",
                    "deadline": "2024-02-07T06:58:59+00:00",
                    "delete_destination_extra": False,
                    "destination_base_path": None,
                    "destination_endpoint": f"pliny_the_elder#{DEST_ENDPOINT_ID}",
                    "destination_endpoint_display_name": "Ercolano",
                    "destination_endpoint_id": DEST_ENDPOINT_ID,
                    "destination_host_endpoint": None,
                    "destination_host_endpoint_display_name": None,
                    "destination_host_endpoint_id": None,
                    "destination_host_path": None,
                    "destination_local_user": "pliny",
                    "destination_local_user_status": "OK",
                    "destination_mapped_collection_display_name": None,
                    "destination_mapped_collection_id": None,
                    "directories": 2,
                    "effective_bytes_per_second": 5,
                    "encrypt_data": False,
                    "fail_on_quota_errors": False,
                    "fatal_error": None,
                    "faults": 0,
                    "files": 3,
                    "files_skipped": 0,
                    "files_transferred": 3,
                    "filter_rules": None,
                    "history_deleted": False,
                    "is_ok": None,
                    "is_paused": False,
                    "label": None,
                    "nice_status": None,
                    "nice_status_details": None,
                    "nice_status_expires_in": None,
                    "nice_status_short_description": None,
                    "owner_id": OWNER_ID,
                    "owner_string": "pliny-the-elder@globus.org",
                    "preserve_timestamp": False,
                    "recursive_symlinks": "ignore",
                    "request_time": "2024-02-06T06:58:59+00:00",
                    "skip_source_errors": False,
                    "source_base_path": None,
                    "source_endpoint": f"pliny#{SRC_ENDPOINT_ID}",
                    "source_endpoint_display_name": "Pompeii",
                    "source_endpoint_id": SRC_ENDPOINT_ID,
                    "source_host_endpoint": None,
                    "source_host_endpoint_display_name": None,
                    "source_host_endpoint_id": None,
                    "source_host_path": None,
                    "source_local_user": None,
                    "source_local_user_status": "NO_PERMISSION",
                    "source_mapped_collection_display_name": None,
                    "source_mapped_collection_id": None,
                    "status": "SUCCEEDED",
                    "subtasks_canceled": 0,
                    "subtasks_expired": 0,
                    "subtasks_failed": 0,
                    "subtasks_pending": 0,
                    "subtasks_retrying": 0,
                    "subtasks_skipped_errors": 0,
                    "subtasks_succeeded": 6,
                    "subtasks_total": 6,
                    "symlinks": 0,
                    "sync_level": None,
                    "task_id": TASK_ID,
                    "type": "TRANSFER",
                    "username": "pliny",
                    "verify_checksum": True,
                }
            ],
            "DATA_TYPE": "task_list",
            "has_next_page": False,
            "last_key": "complete,2024-02-06T06:59:02.291996",
        },
    ),
)
