---
title: PICOTOOL-OTP
section: 1
header: User Commands
---
# NAME

picotool\-otp \- Commands related to the RP2350 OTP \(One\-Time\-Programmable\) Memory

# SYNOPSIS

picotool otp list \[\-p\] \[\-n\] \[\-f\] \[\-i \<filename\>\] \[\<selector\>\.\.\]

picotool otp get \[\-c \<copies\>\] \[\-r\] \[\-e\] \[\-n\] \[\-i \<filename\>\] \[device\-selection\] \[\-z\] \[\<selector\>\.\.\]

picotool otp set \[\-c \<copies\>\] \[\-r\] \[\-e\] \[\-s\] \[\-i \<filename\>\] \[\-z\] \<selector\> \<value\> \[device\-selection\]

picotool otp load \[\-r\] \[\-e\] \[\-s \<row\>\] \[\-i \<filename\>\] \<filename\> \[\-t \<type\>\] \[device\-selection\]

picotool otp dump \[\-r\] \[\-e\] \[\-p\] \[\-\-output \<filename\>\] \[device\-selection\]

picotool otp dump \[\-r\] \[\-e\] \[\-p\] \[\-\-output \<filename\>\] \<input\> \[\-t \<type\>\]

picotool otp permissions \<filename\> \[\-\-led \<pin\>\] \[\-\-hash\] \[\-\-sign\] \<key\> \[device\-selection\]

picotool otp white\-label \-s \<row\> \<filename\> \[device\-selection\]


# SUB COMMANDS

**list**
: List matching known registers/fields

**get**
: Get the value of one or more OTP registers/fields \(RP2350only\)

**set**
: Set the value of an OTP row/field \(RP2350 only\)

**load**
: Load the row range stored in a file into OTP and verify\. Datais 2 bytes/row for ECC, 4 bytes/row for raw \(MSB is ignored\)\.\(RP2350 only\)

**dump**
: Dump entire OTP \(RP2350 only\)

**permissions**
: Set the OTP access permissions \(RP2350 only\)

**white\-label**
: Set the white labelling values in OTP \(RP2350 only\)

