# Setup test to use keyring component

# The following environment variables must be defined when mysql-test-run.pl is run:
#   MTR_VAULT_ADDRESS - Hashicorp Vault server URL including protocol and optional port (e.g. http://128.0.0.1:8200)
#   MTR_VAULT_PLUGIN_TOKEN - Hashicorp Vault server token
#   MTR_VAULT_CA - path to Hashicorp Vault server CA certificate (optional)
# The following MTR variables must be defined when this file is included
#   $vault_conf_timeout - HTTP client timeout while connecting to vault server
#   $vault_conf_mount_point_uuid - unique identifier used as a stem for the mount point (usually generated by 'SELECT UUID()')
#   $vault_conf_mount_point_suffix - optional mount point suffix (e.g. '_1', '_2')
#   $vault_conf_mount_point_directory - optional directory within mount point
#   $vault_conf_mount_point_version - optional Hashicorp Vault server version that will be written to the configuration file
#   $vault_conf_address - optional Hashicorp Vault server URL, if not defined, taken from MTR_VAULT_ADDRESS environment variable
#   $vault_conf_token - optional Hashicorp Vault server token, if not defined, taken from MTR_VAULT_PLUGIN_TOKEN environment variable
#   $vault_conf_ca - optional path to Hashicorp Vault server CA certificate, if not defined, taken from MTR_VAULT_CA environment variable
#   $skip_vault_conf_ca - do not fill in vault_conf_ca even in case it is provided in MTR_VAULT_CA environment variable

--echo # ----------------------------------------------------------------------
--echo # Setup

--let PLUGIN_DIR_OPT = $KEYRING_VAULT_COMPONENT_OPT

# Data directory location
--let CURRENT_DATADIR = `SELECT @@datadir`

--let COMPONENT_LIBRARY = `SELECT SUBSTRING_INDEX('$KEYRING_VAULT_COMPONENT_LOAD', '=', -1)`
--let COMPONENT_DIR = $KEYRING_VAULT_COMPONENT_DIR
--let COMPONENT_NAME = `SELECT SUBSTRING_INDEX('$COMPONENT_LIBRARY', '.', 1)`

# Create local keyring config
--source generate_comp_config_content.inc
--let KEYRING_VAULT_PATH = `SELECT CONCAT( '$MYSQLTEST_VARDIR', '/keyring_vault')`
--let KEYRING_CONFIG_CONTENT = `SELECT CONCAT('{ ', '$config_content', ' }')`
--source include/keyring_tests/helper/local_keyring_create_config.inc

# Create local manifest file for current server instance
--let LOCAL_MANIFEST_CONTENT = `SELECT CONCAT('{ \"components\": \"file://', '$COMPONENT_NAME', '\" }')`
--source include/keyring_tests/helper/instance_create_manifest.inc

# Restart server with manifest file
--source include/keyring_tests/helper/start_server_with_manifest.inc
--echo # ----------------------------------------------------------------------
