/*
 * We used to say "THIS FILE WAS GENERATED BY PDL::PP! Do not modify!"
 * but it has been hand-modified since then.
 */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "pdl.h"
#include "pdlcore.h"
#include "pdlsimple.h"

static Core* PDL; /* Structure hold core C functions */
SV* CoreSV;       /* Get's pointer to perl var holding core structure */

/*
 * Call an external C routine loaded dynamically - pass PDL args list
 *
 * Not sure whether should be 'ENABLE' or 'DISABLE' for the PROTOTYPES
 * argument below. We only seem to need the line to stop perl from
 * complaining about the line being missing during build time anyway.
 */

MODULE = PDL::CallExt PACKAGE = PDL::CallExt

PROTOTYPES: DISABLE

void
_callext_int(...)
     PPCODE:
        int (*symref)(int npdl, pdlsimple **x);
        int npdl = items-1;
        pdlsimple **x;
	pdl *t;
        int i;

        symref = (int(*)(int, pdlsimple**)) INT2PTR(void*,SvIV(ST(0)));

        New( 42, x, npdl, pdlsimple* ); /* Ptr array */
        for(i=0; i<npdl; i++) {
           t = PDL->SvPDLV(ST(i+1));
	   PDL->barf_if_error(PDL->make_physical(t));
	   PDL->barf_if_error(PDL->make_physdims(t));
	   New(42, x[i], 1, pdlsimple); /* Each ptr */
	   x[i]->datatype = t->datatype;
	   x[i]->data     = t->data;
	   x[i]->nvals    = t->nvals;
	   x[i]->dims     = t->dims;
	   x[i]->ndims    = t->ndims;
	}
		   
        i = (*symref)(npdl, x); 
        if (i==0)
           barf("Error calling external routine");
	   
        for(i=0; i<npdl; i++) /* Free stuff */
	   Safefree(x[i]);
	Safefree(x);

BOOT:
   /* Get pointer to structure of core shared C routines */
   if (!(CoreSV = perl_get_sv("PDL::SHARE",FALSE))) /* SV* value */
     Perl_croak(aTHX_ "We require the PDL::Core module, which was not found");
   if (!(PDL = INT2PTR(Core*,SvIV( CoreSV )))) /* Core* value */
     Perl_croak(aTHX_ "Got NULL pointer for PDL");
