# OpenVAS
# $Id$
# Description: RPM spec file for openvas-libnasl
#
# Authors:
# Jan-Oliver Wagner <jan-oliver.wagner@intevation.de>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.de
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

%define PACKAGE_NAME openvas-libnasl
%define PACKAGE_VERSION 1.0.0
%define release 1.suse102.openvas
%define _prefix /usr

Summary: Support library for Open Vulnerability Assessment (OpenVAS) Server
Name:    %PACKAGE_NAME
Version: %PACKAGE_VERSION
Release: %{release}
Source0: %{name}-%{version}.tar.gz
# The first two patches will be obsolete with version 1.0.1 since this
# has been fixed upstream already.
Patch0:  %{name}-%{version}-configure.diff
Patch1:  %{name}-%{version}-configure.in.diff
Patch2:  %{name}-%{version}-Makefile.diff
Patch3:  %{name}-%{version}-nasl-Makefile.diff
License: GNU GPLv2 and GNU LGPLv2
Group: Productivity/Networking/Security
Vendor: OpenVAS Development Team, http://www.openvas.org 
Distribution: OpenSUSE 10.2
BuildRoot: %{_builddir}/%{name}-root
Prefix: %{_prefix}
BuildRequires: openvas-libraries-devel

%package devel
Summary: Development files for openvas-libnasl
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}

%description
openvas-libnasl is the NASL interpreter library
for the OpenVAS network security scanner.

%description devel
This package contains the development files (mainly C header files)
for openvas-libnasl.

%prep
%setup -b 0
%patch0
%patch1
%patch2
%patch3

%build
%configure --prefix=%{_prefix}
make

%install
%makeinstall

%post
%{run_ldconfig}

%postun
%{run_ldconfig}

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc COPYING
# for release > 1.0.0 this file should be added: CHANGES
%doc doc/signatures-howto.txt doc/nasl2_reference.lyx doc/nasl_guide.tex
%{_mandir}/man1/openvas-nasl.1.gz
%{_libdir}/lib*
%{_bindir}/openvas-nasl

%files devel
%defattr(-,root,root,-)
%{_includedir}/openvas/
%{_bindir}/openvas-libnasl-config
%{_mandir}/man1/openvas-libnasl-config.1.gz

%changelog
* Tue Apr 15 2008 Jan-Oliver Wagner <jan-oliver.wagner@intevation.de>
  Initial SUSE 10.2 spec file, tested for i586
