/*
 * StereogramWindow.java
 *
 * Created on 9 de Janeiro de 2008, 18:47
 */
package br.gfca.openstereogram.gui;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/**
 *
 * @author  Gustavo
 */
public class StereogramWindow extends javax.swing.JFrame {

    /**
     * 
     */
    private static final long serialVersionUID = -2929272496487947728L;
    private BufferedImage image;

    /** Creates new form StereogramWindow */
    public StereogramWindow(BufferedImage i) {
        this.image = i;
        initComponents();
        this.setLocationRelativeTo(null);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Cdigo Gerado ">//GEN-BEGIN:initComponents
    private void initComponents() {
        saveToFileFileChooser = new javax.swing.JFileChooser();
        imagePanel = new br.gfca.openstereogram.gui.ImagePanel();
        menuBar = new javax.swing.JMenuBar();
        imageMenu = new javax.swing.JMenu();
        saveToFileMenuItem = new javax.swing.JMenuItem();

        saveToFileFileChooser.setCurrentDirectory(new File("./images/myStereograms/"));
        saveToFileFileChooser.setDialogTitle("Save stereogram");
        saveToFileFileChooser.setDialogType(javax.swing.JFileChooser.SAVE_DIALOG);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Open Stereogram");
        imagePanel.setImage( image );
        getContentPane().add(imagePanel, java.awt.BorderLayout.CENTER);

        imageMenu.setText("Image");
        saveToFileMenuItem.setText("Save to file...");
        saveToFileMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveToFileMenuItemActionPerformed(evt);
            }
        });

        imageMenu.add(saveToFileMenuItem);

        menuBar.add(imageMenu);

        setJMenuBar(menuBar);

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void saveToFileMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveToFileMenuItemActionPerformed
        int button = this.saveToFileFileChooser.showSaveDialog(this);
        try {
            if (button == JFileChooser.APPROVE_OPTION) {
                File f = this.saveToFileFileChooser.getSelectedFile();
                if (f != null) {
                    if (!f.getName().toUpperCase().endsWith(".PNG")) {
                        f = new File(f.getParent(), f.getName() + ".png");
                    }

                    if (f.exists()) {
                        if (f.isFile()) {
                            int yesNo = JOptionPane.showConfirmDialog(this,
                                    "Do you want to overwrite the file \"" + f.getName() + "\"?",
                                    "Confirm overwrite",
                                    JOptionPane.YES_NO_OPTION,
                                    JOptionPane.QUESTION_MESSAGE);

                            if (yesNo == JOptionPane.YES_OPTION) {
                                this.saveFile(f);
                            }
                        } else {
                            throw new Exception("Invalid file.");
                        }
                    } else {
                        this.saveFile(f);
                    }
                } else {
                    throw new Exception("Empty file name.");
                }
            }
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error while saving: " + e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_saveToFileMenuItemActionPerformed

    private void saveFile(File file) {
        try {
            ImageIO.write(this.image, "png", file);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Error while saving: " + ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
        }
    }
    
    // Declarao de variveis - no modifique//GEN-BEGIN:variables
    private javax.swing.JMenu imageMenu;
    private br.gfca.openstereogram.gui.ImagePanel imagePanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JFileChooser saveToFileFileChooser;
    private javax.swing.JMenuItem saveToFileMenuItem;
    // Fim da declarao de variveis//GEN-END:variables
}