#!/bin/bash

function explain_usage()
{
  echo "This script configures the \"commandergenius\" SDL Android port"
  echo "for the build of openMSX."
  echo ""
  echo "The script depends on the Android SDK and NDK and on the"
  echo "\"commandergenius\" SDL Android port."
  echo ""
  echo "First download and install the Android SDK and NDK"
  echo "as per the instructions on the Android website."
  echo ""
  echo "Please make sure to add the Android SDK and NDK tools locations"
  echo "to your PATH variable, as per the instructions on the Android"
  echo "website. Otherwise the setup will fail."
  echo ""
  echo "Subsequently download the \"commandergenius\" SDL Android port"
  echo "into your favorite location."
  echo ""
  echo "Example:"
  echo "> cd /opt"
  echo "> git clone https://github.com/pelya/commandergenius.git"
  echo ""
  echo "Once that is done, you can launch this script."
  echo "You must specify the path to the \"commandergenius\" SDL Android port"
  echo "on the command line or in environment parameter SDL_ANDROID_PORT_PATH."
  echo ""
  echo "Example 1:"
  echo "> export SDL_ANDROID_PORT_PATH=/opt/commandergenius"
  echo "> ./setup_anddev.sh"
  echo ""
  echo "Example 2:"
  echo "> ./setup_anddev.sh /opt/commandergenius"
  echo ""
}

if [ $# -eq 0 -a -z "$SDL_ANDROID_PORT_PATH" ]; then
  explain_usage
  exit 1
fi

if [ $# -eq 1 ]; then
    sdl_android_port_path="$1"
else
    sdl_android_port_path="$SDL_ANDROID_PORT_PATH"
fi

if [ ! -d "${sdl_android_port_path}" ]; then
  echo "Can not find directory ${sdl_android_port_path}"
  exit 1
fi
sdl_port_app_dir="${sdl_android_port_path}/project/jni/application"
if [ ! -d "${sdl_port_app_dir}" ]; then
    echo "Can not find expected sub-directory project/jni/application"
    echo "in specified directory ${sdl_android_port_path}"
    exit 1
fi

this_script_dir=$(dirname $0)
this_script_dir=$(cd ${this_script_dir}; pwd)
my_home_dir=${this_script_dir%/*}
my_home_dir=${my_home_dir%/*}
my_android_dir="${my_home_dir}/build/android/openmsx"
my_relative_dir="${my_android_dir##*/}"

echo "Setting-up softlink to this application in the SDL android port."
if [ -h "${sdl_port_app_dir}/${my_relative_dir}" ]; then
    rm "${sdl_port_app_dir}/${my_relative_dir}"
fi
if [ -d "${sdl_port_app_dir}/${my_relative_dir}" ]; then
    echo "ERROR: found directory ${my_relative_dir} in ${sdl_port_app_dir}"
    echo "This seems to be another app with the same name."
    echo "Please resolve the conflict and then re-run this script."
    exit 1
fi
ln -s "${my_android_dir}" "${sdl_port_app_dir}/${my_relative_dir}"
rm -f "${sdl_port_app_dir}/src"
ln -s "${my_relative_dir}" "${sdl_port_app_dir}/src"

echo "Making environment.props file for the build script"
cat > "${my_android_dir}/environment.props" << @EOT
# Do not edit this file. It is generated by setup_anddev.sh
sdl_android_port_path="${sdl_android_port_path}"
my_home_dir="${my_home_dir}"
@EOT

cd "${my_android_dir}"
./generate_AndroidAppSettings.sh
if [ $? -ne 0 ]; then
	exit 1
fi

echo "Configuring SDL android port to build this application"
cd "${sdl_android_port_path}"
./changeAppSettings.sh -a
if [ $? -ne 0 ]; then
    echo "ERROR: an unexpected problem occurred while running changeAppSettings.sh -a"
    echo "       in ${sdl_android_port_path}"
    exit 1
fi

echo ""
echo "You can now build the application from the openMSX android build directory"
echo ""
echo "Example"
echo "> cd ${my_android_dir}"
echo "> ./launch_anddev_build.sh"
