/*
 * Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "Structure.h"
#include "TemplateObjectDescriptor.h"

namespace JSC {

class JSTemplateObjectDescriptor final : public JSCell {
public:
    using Base = JSCell;

    static const unsigned StructureFlags = Base::StructureFlags | StructureIsImmortal;
    static const bool needsDestruction = true;
    DECLARE_INFO;

    static JSTemplateObjectDescriptor* create(VM&, Ref<TemplateObjectDescriptor>&&);

    static Structure* createStructure(VM& vm, JSGlobalObject* globalObject, JSValue prototype)
    {
        return Structure::create(vm, globalObject, prototype, TypeInfo(CellType, StructureFlags), info());
    }

    const TemplateObjectDescriptor& descriptor() const { return m_descriptor.get(); }

    JSArray* createTemplateObject(ExecState*);

protected:
    static void destroy(JSCell*);

private:
    JSTemplateObjectDescriptor(VM&, Ref<TemplateObjectDescriptor>&&);

    Ref<TemplateObjectDescriptor> m_descriptor;
};

inline bool isTemplateObjectDescriptor(VM& vm, JSCell* cell)
{
    return cell->classInfo(vm) == JSTemplateObjectDescriptor::info();
}

inline bool isTemplateObjectDescriptor(VM& vm, JSValue v)
{
    return v.isCell() && isTemplateObjectDescriptor(vm, v.asCell());
}

} // namespace JSC
