#!/bin/bash

#################################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
#################################################################################

if test "$3" = pegasus
then
	
	cimmof -aE -n $1 $6/mof/OpenDRIM_SSHProtocolCapabilities.mof

	OUTFILE=./TEMP_REGISTRATION
	
cat >> $OUTFILE << EOFC
instance of PG_ProviderModule {
Caption = "OpenDRIM_SSHProtocolCapabilities provider module";
Name = "SSH_OpenDRIM_SSHProtocolCapabilitiesModule";
Location = "cmpiSSH_OpenDRIM_SSHProtocolCapabilitiesProvider";
Vendor = "$2";
Version = "$5";
InterfaceType = "CMPI";
InterfaceVersion = "2.0.0";
};

instance of PG_Provider {
Caption = "OpenDRIM_SSHProtocolCapabilities provider";
Name = "SSH_OpenDRIM_SSHProtocolCapabilitiesProvider";
ProviderModuleName = "SSH_OpenDRIM_SSHProtocolCapabilitiesModule";
};

instance of PG_ProviderCapabilities {
Caption = "OpenDRIM_SSHProtocolCapabilities provider capabilities";
ProviderModuleName = "SSH_OpenDRIM_SSHProtocolCapabilitiesModule";
ProviderName = "SSH_OpenDRIM_SSHProtocolCapabilitiesProvider";
ClassName = "OpenDRIM_SSHProtocolCapabilities";
ProviderType = {2, 3};
Namespaces = {"$1"};
SupportedProperties = {"ManagedElement", "Capabilities", "Characteristics"};
CapabilityID = "SSH_OpenDRIM_SSHProtocolCapabilities";
};

EOFC
	
	cimmof -n root/PG_InterOp $OUTFILE
	
	rm -f $OUTFILE
	
fi

if test "$3" = sfcb
then
	
	OUTFILE=./OpenDRIM_SSHProtocolCapabilities.reg
	
cat >> $OUTFILE <<EOFC
[OpenDRIM_SSHProtocolCapabilities]   
   provider: SSH_OpenDRIM_SSHProtocolCapabilitiesProvider
   location: cmpiSSH_OpenDRIM_SSHProtocolCapabilitiesProvider
   type: instance association
   namespace: $1
#
EOFC
	
	sfcbstage -r $OUTFILE -n $1 $6/mof/OpenDRIM_SSHProtocolCapabilities.mof
	
	rm -f $OUTFILE
	
	sfcbrepos -f
	
fi

if test "$3" = openwbem
then
	
	OUTFILE=./OpenDRIM_SSHProtocolCapabilities-reg.mof
	rm -f $OUTFILE
	sed "s/Provider *( *\"cmpi:/Provider(\"cmpi::/g" < $6/mof/OpenDRIM_SSHProtocolCapabilities.mof >> $OUTFILE
	owmofc -u http://localhost/$1 $OUTFILE
	
	rm -f $OUTFILE
	
fi
