/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "cmpiOpenDRIM_RegisteredSSHProfile.h"

CMPIObjectPath* SSH_OpenDRIM_RegisteredSSHProfile_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_RegisteredSSHProfile& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_RegisteredSSHProfile_classnames[0], OpenDRIM_RegisteredSSHProfile_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* SSH_OpenDRIM_RegisteredSSHProfile_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_RegisteredSSHProfile& instance) {
	_E_;
	Objectpath op(broker, SSH_OpenDRIM_RegisteredSSHProfile_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.Generation_isNULL)
		ci.setProperty("Generation", instance.Generation);

	if (!instance.OtherSpecificationType_isNULL)
		ci.setProperty("OtherSpecificationType", instance.OtherSpecificationType);

	if (!instance.RegisteredOrganization_isNULL)
		ci.setProperty("RegisteredOrganization", instance.RegisteredOrganization);

	if (!instance.OtherRegisteredOrganization_isNULL)
		ci.setProperty("OtherRegisteredOrganization", instance.OtherRegisteredOrganization);

	if (!instance.RegisteredName_isNULL)
		ci.setProperty("RegisteredName", instance.RegisteredName);

	if (!instance.RegisteredVersion_isNULL)
		ci.setProperty("RegisteredVersion", instance.RegisteredVersion);

	if (!instance.AdvertiseTypes_isNULL)
		ci.setProperty("AdvertiseTypes", instance.AdvertiseTypes);

	if (!instance.AdvertiseTypeDescriptions_isNULL)
		ci.setProperty("AdvertiseTypeDescriptions", instance.AdvertiseTypeDescriptions);

	if (!instance.SpecificationType_isNULL)
		ci.setProperty("SpecificationType", instance.SpecificationType);

	if (!instance.ImplementedFeatures_isNULL)
		ci.setProperty("ImplementedFeatures", instance.ImplementedFeatures);

	_L_;
	return ci.getHdl();
}

void SSH_OpenDRIM_RegisteredSSHProfile_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_RegisteredSSHProfile& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void SSH_OpenDRIM_RegisteredSSHProfile_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_RegisteredSSHProfile& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("Generation", instance.Generation) == OK)
		instance.Generation_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("OtherSpecificationType", instance.OtherSpecificationType) == OK)
		instance.OtherSpecificationType_isNULL = false;

	if (inst.getProperty("RegisteredOrganization", instance.RegisteredOrganization) == OK)
		instance.RegisteredOrganization_isNULL = false;

	if (inst.getProperty("OtherRegisteredOrganization", instance.OtherRegisteredOrganization) == OK)
		instance.OtherRegisteredOrganization_isNULL = false;

	if (inst.getProperty("RegisteredName", instance.RegisteredName) == OK)
		instance.RegisteredName_isNULL = false;

	if (inst.getProperty("RegisteredVersion", instance.RegisteredVersion) == OK)
		instance.RegisteredVersion_isNULL = false;

	if (inst.getProperty("AdvertiseTypes", instance.AdvertiseTypes) == OK)
		instance.AdvertiseTypes_isNULL = false;

	if (inst.getProperty("AdvertiseTypeDescriptions", instance.AdvertiseTypeDescriptions) == OK)
		instance.AdvertiseTypeDescriptions_isNULL = false;

	if (inst.getProperty("SpecificationType", instance.SpecificationType) == OK)
		instance.SpecificationType_isNULL = false;

	if (inst.getProperty("ImplementedFeatures", instance.ImplementedFeatures) == OK)
		instance.ImplementedFeatures_isNULL = false;

	_L_;
}

void SSH_OpenDRIM_RegisteredSSHProfile_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_RegisteredSSHProfile_CloseConformantInstances_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	string EnumerationContext;
	data = in->ft->getArg(in, "EnumerationContext", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, EnumerationContext);	
		args.setEnumerationContext(EnumerationContext);
	}			

	_L_;
}

void SSH_OpenDRIM_RegisteredSSHProfile_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	string ResultClass;
	data = in->ft->getArg(in, "ResultClass", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, ResultClass);	
		args.setResultClass(ResultClass);
	}			

	vector<string> IncludedPropertyList;
	data = in->ft->getArg(in, "IncludedPropertyList", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, IncludedPropertyList);	
		args.setIncludedPropertyList(IncludedPropertyList);
	}			

	unsigned int OperationTimeout;
	data = in->ft->getArg(in, "OperationTimeout", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, OperationTimeout);	
		args.setOperationTimeout(OperationTimeout);
	}			

	bool ContinueOnError;
	data = in->ft->getArg(in, "ContinueOnError", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, ContinueOnError);	
		args.setContinueOnError(ContinueOnError);
	}			

	unsigned int MaxObjectCount;
	data = in->ft->getArg(in, "MaxObjectCount", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, MaxObjectCount);	
		args.setMaxObjectCount(MaxObjectCount);
	}			

	string EnumerationContext;
	data = in->ft->getArg(in, "EnumerationContext", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, EnumerationContext);	
		args.setEnumerationContext(EnumerationContext);
	}			

	bool EndOfSequence;
	data = in->ft->getArg(in, "EndOfSequence", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, EndOfSequence);	
		args.setEndOfSequence(EndOfSequence);
	}			

	vector<unsigned short> InstanceType;
	data = in->ft->getArg(in, "InstanceType", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, InstanceType);	
		args.setInstanceType(InstanceType);
	}			

	vector<string> InstanceWithPathList;
	data = in->ft->getArg(in, "InstanceWithPathList", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, InstanceWithPathList);	
		args.setInstanceWithPathList(InstanceWithPathList);
	}			

	_L_;
}

void SSH_OpenDRIM_RegisteredSSHProfile_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_RegisteredSSHProfile_OpenConformantInstances_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	string EnumerationContext;
	errorMessage = args.getEnumerationContext(EnumerationContext);
	if (errorMessage == OK) {
		value = CT_toCMPI(broker, EnumerationContext);
		out->ft->addArg(out, "EnumerationContext", &value, CMPI_string);
	}

	bool EndOfSequence;
	errorMessage = args.getEndOfSequence(EndOfSequence);
	if (errorMessage == OK) {
		value = CT_toCMPI(EndOfSequence);
		out->ft->addArg(out, "EndOfSequence", &value, CMPI_boolean);
	}

	vector<unsigned short> InstanceType;
	errorMessage = args.getInstanceType(InstanceType);
	if (errorMessage == OK) {
		value = CT_toCMPI(broker, InstanceType);
		out->ft->addArg(out, "InstanceType", &value, CMPI_uint16A);
	}

	vector<string> InstanceWithPathList;
	errorMessage = args.getInstanceWithPathList(InstanceWithPathList);
	if (errorMessage == OK) {
		value = CT_toCMPI(broker, InstanceWithPathList);
		out->ft->addArg(out, "InstanceWithPathList", &value, CMPI_stringA);
	}

	_L_;
}
void SSH_OpenDRIM_RegisteredSSHProfile_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_RegisteredSSHProfile_PullConformantInstances_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned int MaxObjectCount;
	data = in->ft->getArg(in, "MaxObjectCount", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, MaxObjectCount);	
		args.setMaxObjectCount(MaxObjectCount);
	}			

	string EnumerationContext;
	data = in->ft->getArg(in, "EnumerationContext", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, EnumerationContext);	
		args.setEnumerationContext(EnumerationContext);
	}			

	bool EndOfSequence;
	data = in->ft->getArg(in, "EndOfSequence", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, EndOfSequence);	
		args.setEndOfSequence(EndOfSequence);
	}			

	vector<unsigned short> InstanceType;
	data = in->ft->getArg(in, "InstanceType", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, InstanceType);	
		args.setInstanceType(InstanceType);
	}			

	vector<string> InstanceWithPathList;
	data = in->ft->getArg(in, "InstanceWithPathList", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, InstanceWithPathList);	
		args.setInstanceWithPathList(InstanceWithPathList);
	}			

	_L_;
}

void SSH_OpenDRIM_RegisteredSSHProfile_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_RegisteredSSHProfile_PullConformantInstances_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	string EnumerationContext;
	errorMessage = args.getEnumerationContext(EnumerationContext);
	if (errorMessage == OK) {
		value = CT_toCMPI(broker, EnumerationContext);
		out->ft->addArg(out, "EnumerationContext", &value, CMPI_string);
	}

	bool EndOfSequence;
	errorMessage = args.getEndOfSequence(EndOfSequence);
	if (errorMessage == OK) {
		value = CT_toCMPI(EndOfSequence);
		out->ft->addArg(out, "EndOfSequence", &value, CMPI_boolean);
	}

	vector<unsigned short> InstanceType;
	errorMessage = args.getInstanceType(InstanceType);
	if (errorMessage == OK) {
		value = CT_toCMPI(broker, InstanceType);
		out->ft->addArg(out, "InstanceType", &value, CMPI_uint16A);
	}

	vector<string> InstanceWithPathList;
	errorMessage = args.getInstanceWithPathList(InstanceWithPathList);
	if (errorMessage == OK) {
		value = CT_toCMPI(broker, InstanceWithPathList);
		out->ft->addArg(out, "InstanceWithPathList", &value, CMPI_stringA);
	}

	_L_;
}
