/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BOOTCONFIGSETTINGACCESS_H_
#define OPENDRIM_BOOTCONFIGSETTINGACCESS_H_

#include "Boot_Common.h"

#include "OpenDRIM_BootConfigSetting.h"

int Boot_OpenDRIM_BootConfigSetting_load(const CMPIBroker* broker, string& errorMessage);

int Boot_OpenDRIM_BootConfigSetting_unload(string& errorMessage);

int Boot_OpenDRIM_BootConfigSetting_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BootConfigSetting>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Boot_OpenDRIM_BootConfigSetting_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BootConfigSetting& instance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootConfigSetting_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSetting& newInstance, const OpenDRIM_BootConfigSetting& oldInstance, const char** properties, string& errorMessage);

int Boot_OpenDRIM_BootConfigSetting_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSetting& instance, string& errorMessage);

int Boot_OpenDRIM_BootConfigSetting_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSetting& instance, string& errorMessage);

int Boot_OpenDRIM_BootConfigSetting_ChangeBootOrder(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSetting& instance, unsigned int& returnValue, const OpenDRIM_BootConfigSetting_ChangeBootOrder_In& in, OpenDRIM_BootConfigSetting_ChangeBootOrder_Out& out, string& errorMessage);

int Boot_OpenDRIM_BootConfigSetting_ValidateSettings(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BootConfigSetting& instance, unsigned int& returnValue, string& errorMessage);

int Boot_OpenDRIM_BootConfigSetting_populate(OpenDRIM_BootConfigSetting& instance, string& errorMessage);

#endif /*OPENDRIM_BOOTCONFIGSETTINGACCESS_H_*/
