/*###############################################################################
# Linux Management Providers (LMP), Battery provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BATTERY_H_
#define OPENDRIM_BATTERY_H_

#include <Instance.h>

const static char* OpenDRIM_Battery_classnames[] = {"OpenDRIM_Battery"};
static string OpenDRIM_Battery_NAMESPACE = _NAMESPACE;

class OpenDRIM_Battery {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	unsigned short EnabledState;
	bool EnabledState_isNULL;
	
	string OtherEnabledState;
	bool OtherEnabledState_isNULL;
	
	unsigned short RequestedState;
	bool RequestedState_isNULL;
	
	unsigned short EnabledDefault;
	bool EnabledDefault_isNULL;
	
	string TimeOfLastStateChange;
	bool TimeOfLastStateChange_isNULL;
	
	vector<unsigned short> AvailableRequestedStates;
	bool AvailableRequestedStates_isNULL;
	
	unsigned short TransitioningToState;
	bool TransitioningToState_isNULL;
	
	string SystemCreationClassName;
	bool SystemCreationClassName_isNULL;
	
	string SystemName;
	bool SystemName_isNULL;
	
	string CreationClassName;
	bool CreationClassName_isNULL;
	
	string DeviceID;
	bool DeviceID_isNULL;
	
	bool PowerManagementSupported;
	bool PowerManagementSupported_isNULL;
	
	vector<unsigned short> PowerManagementCapabilities;
	bool PowerManagementCapabilities_isNULL;
	
	unsigned short Availability;
	bool Availability_isNULL;
	
	unsigned short StatusInfo;
	bool StatusInfo_isNULL;
	
	unsigned int LastErrorCode;
	bool LastErrorCode_isNULL;
	
	string ErrorDescription;
	bool ErrorDescription_isNULL;
	
	bool ErrorCleared;
	bool ErrorCleared_isNULL;
	
	vector<string> OtherIdentifyingInfo;
	bool OtherIdentifyingInfo_isNULL;
	
	unsigned long long PowerOnHours;
	bool PowerOnHours_isNULL;
	
	unsigned long long TotalPowerOnHours;
	bool TotalPowerOnHours_isNULL;
	
	vector<string> IdentifyingDescriptions;
	bool IdentifyingDescriptions_isNULL;
	
	vector<unsigned short> AdditionalAvailability;
	bool AdditionalAvailability_isNULL;
	
	unsigned long long MaxQuiesceTime;
	bool MaxQuiesceTime_isNULL;
	
	unsigned short LocationIndicator;
	bool LocationIndicator_isNULL;
	
	unsigned int MaxPowerProduced;
	bool MaxPowerProduced_isNULL;
	
	string MaxPowerProducedUnits;
	bool MaxPowerProducedUnits_isNULL;
	
	unsigned int MaxPowerConsumed;
	bool MaxPowerConsumed_isNULL;
	
	string MaxPowerConsumedUnits;
	bool MaxPowerConsumedUnits_isNULL;
	
	unsigned short BatteryStatus;
	bool BatteryStatus_isNULL;
	
	unsigned int TimeOnBattery;
	bool TimeOnBattery_isNULL;
	
	unsigned int EstimatedRunTime;
	bool EstimatedRunTime_isNULL;
	
	unsigned short EstimatedChargeRemaining;
	bool EstimatedChargeRemaining_isNULL;
	
	unsigned short Chemistry;
	bool Chemistry_isNULL;
	
	unsigned int DesignCapacity;
	bool DesignCapacity_isNULL;
	
	unsigned int FullChargeCapacity;
	bool FullChargeCapacity_isNULL;
	
	unsigned long long DesignVoltage;
	bool DesignVoltage_isNULL;
	
	string SmartBatteryVersion;
	bool SmartBatteryVersion_isNULL;
	
	unsigned int TimeToFullCharge;
	bool TimeToFullCharge_isNULL;
	
	unsigned int ExpectedLife;
	bool ExpectedLife_isNULL;
	
	unsigned int MaxRechargeTime;
	bool MaxRechargeTime_isNULL;
	
	unsigned int RechargeCount;
	bool RechargeCount_isNULL;
	
	unsigned int MaxRechargeCount;
	bool MaxRechargeCount_isNULL;
	
	unsigned int RemainingCapacity;
	bool RemainingCapacity_isNULL;
	
	unsigned char RemainingCapacityMaxError;
	bool RemainingCapacityMaxError_isNULL;
	
	OpenDRIM_Battery() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		InstallDate_isNULL = true;
		Name_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		PrimaryStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		CommunicationStatus_isNULL = true;
		EnabledState_isNULL = true;
		OtherEnabledState_isNULL = true;
		RequestedState_isNULL = true;
		EnabledDefault_isNULL = true;
		TimeOfLastStateChange_isNULL = true;
		AvailableRequestedStates_isNULL = true;
		TransitioningToState_isNULL = true;
		SystemCreationClassName_isNULL = true;
		SystemName_isNULL = true;
		CreationClassName_isNULL = true;
		DeviceID_isNULL = true;
		PowerManagementSupported_isNULL = true;
		PowerManagementCapabilities_isNULL = true;
		Availability_isNULL = true;
		StatusInfo_isNULL = true;
		LastErrorCode_isNULL = true;
		ErrorDescription_isNULL = true;
		ErrorCleared_isNULL = true;
		OtherIdentifyingInfo_isNULL = true;
		PowerOnHours_isNULL = true;
		TotalPowerOnHours_isNULL = true;
		IdentifyingDescriptions_isNULL = true;
		AdditionalAvailability_isNULL = true;
		MaxQuiesceTime_isNULL = true;
		LocationIndicator_isNULL = true;
		MaxPowerProduced_isNULL = true;
		MaxPowerProducedUnits_isNULL = true;
		MaxPowerConsumed_isNULL = true;
		MaxPowerConsumedUnits_isNULL = true;
		BatteryStatus_isNULL = true;
		TimeOnBattery_isNULL = true;
		EstimatedRunTime_isNULL = true;
		EstimatedChargeRemaining_isNULL = true;
		Chemistry_isNULL = true;
		DesignCapacity_isNULL = true;
		FullChargeCapacity_isNULL = true;
		DesignVoltage_isNULL = true;
		SmartBatteryVersion_isNULL = true;
		TimeToFullCharge_isNULL = true;
		ExpectedLife_isNULL = true;
		MaxRechargeTime_isNULL = true;
		RechargeCount_isNULL = true;
		MaxRechargeCount_isNULL = true;
		RemainingCapacity_isNULL = true;
		RemainingCapacityMaxError_isNULL = true;
	}
	
	~OpenDRIM_Battery() {}
	
	string getKeys() const {
		return CF_toLowCase(".SystemCreationClassName=\"" + CF_quoteString(SystemCreationClassName) + "\""".SystemName=\"" + CF_quoteString(SystemName) + "\""".CreationClassName=\"" + CF_quoteString(CreationClassName) + "\""".DeviceID=\"" + CF_quoteString(DeviceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getEnabledState(unsigned short& value) const {
		if (EnabledState_isNULL==true)
			return NOT_FOUND;
		value = EnabledState;
		return OK;
	}
	
	int setEnabledState(const unsigned short& newValue) {
		EnabledState = newValue;
		EnabledState_isNULL = false;
		return OK;
	}

	int getOtherEnabledState(string& value) const {
		if (OtherEnabledState_isNULL==true)
			return NOT_FOUND;
		value = OtherEnabledState;
		return OK;
	}
	
	int setOtherEnabledState(const string& newValue) {
		OtherEnabledState = newValue;
		OtherEnabledState_isNULL = false;
		return OK;
	}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL==true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	
	int setRequestedState(const unsigned short& newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getEnabledDefault(unsigned short& value) const {
		if (EnabledDefault_isNULL==true)
			return NOT_FOUND;
		value = EnabledDefault;
		return OK;
	}
	
	int setEnabledDefault(const unsigned short& newValue) {
		EnabledDefault = newValue;
		EnabledDefault_isNULL = false;
		return OK;
	}

	int getTimeOfLastStateChange(string& value) const {
		if (TimeOfLastStateChange_isNULL==true)
			return NOT_FOUND;
		value = TimeOfLastStateChange;
		return OK;
	}
	
	int setTimeOfLastStateChange(const string& newValue) {
		TimeOfLastStateChange = newValue;
		TimeOfLastStateChange_isNULL = false;
		return OK;
	}

	int getAvailableRequestedStates(vector<unsigned short>& value) const {
		if (AvailableRequestedStates_isNULL==true)
			return NOT_FOUND;
		value = AvailableRequestedStates;
		return OK;
	}
	
	int setAvailableRequestedStates(const vector<unsigned short>& newValue) {
		AvailableRequestedStates = newValue;
		AvailableRequestedStates_isNULL = false;
		return OK;
	}

	int getTransitioningToState(unsigned short& value) const {
		if (TransitioningToState_isNULL==true)
			return NOT_FOUND;
		value = TransitioningToState;
		return OK;
	}
	
	int setTransitioningToState(const unsigned short& newValue) {
		TransitioningToState = newValue;
		TransitioningToState_isNULL = false;
		return OK;
	}

	int getSystemCreationClassName(string& value) const {
		if (SystemCreationClassName_isNULL==true)
			return NOT_FOUND;
		value = SystemCreationClassName;
		return OK;
	}
	
	int setSystemCreationClassName(const string& newValue) {
		SystemCreationClassName = newValue;
		SystemCreationClassName_isNULL = false;
		return OK;
	}

	int getSystemName(string& value) const {
		if (SystemName_isNULL==true)
			return NOT_FOUND;
		value = SystemName;
		return OK;
	}
	
	int setSystemName(const string& newValue) {
		SystemName = newValue;
		SystemName_isNULL = false;
		return OK;
	}

	int getCreationClassName(string& value) const {
		if (CreationClassName_isNULL==true)
			return NOT_FOUND;
		value = CreationClassName;
		return OK;
	}
	
	int setCreationClassName(const string& newValue) {
		CreationClassName = newValue;
		CreationClassName_isNULL = false;
		return OK;
	}

	int getDeviceID(string& value) const {
		if (DeviceID_isNULL==true)
			return NOT_FOUND;
		value = DeviceID;
		return OK;
	}
	
	int setDeviceID(const string& newValue) {
		DeviceID = newValue;
		DeviceID_isNULL = false;
		return OK;
	}

	int getPowerManagementSupported(bool& value) const {
		if (PowerManagementSupported_isNULL==true)
			return NOT_FOUND;
		value = PowerManagementSupported;
		return OK;
	}
	
	int setPowerManagementSupported(const bool& newValue) {
		PowerManagementSupported = newValue;
		PowerManagementSupported_isNULL = false;
		return OK;
	}

	int getPowerManagementCapabilities(vector<unsigned short>& value) const {
		if (PowerManagementCapabilities_isNULL==true)
			return NOT_FOUND;
		value = PowerManagementCapabilities;
		return OK;
	}
	
	int setPowerManagementCapabilities(const vector<unsigned short>& newValue) {
		PowerManagementCapabilities = newValue;
		PowerManagementCapabilities_isNULL = false;
		return OK;
	}

	int getAvailability(unsigned short& value) const {
		if (Availability_isNULL==true)
			return NOT_FOUND;
		value = Availability;
		return OK;
	}
	
	int setAvailability(const unsigned short& newValue) {
		Availability = newValue;
		Availability_isNULL = false;
		return OK;
	}

	int getStatusInfo(unsigned short& value) const {
		if (StatusInfo_isNULL==true)
			return NOT_FOUND;
		value = StatusInfo;
		return OK;
	}
	
	int setStatusInfo(const unsigned short& newValue) {
		StatusInfo = newValue;
		StatusInfo_isNULL = false;
		return OK;
	}

	int getLastErrorCode(unsigned int& value) const {
		if (LastErrorCode_isNULL==true)
			return NOT_FOUND;
		value = LastErrorCode;
		return OK;
	}
	
	int setLastErrorCode(const unsigned int& newValue) {
		LastErrorCode = newValue;
		LastErrorCode_isNULL = false;
		return OK;
	}

	int getErrorDescription(string& value) const {
		if (ErrorDescription_isNULL==true)
			return NOT_FOUND;
		value = ErrorDescription;
		return OK;
	}
	
	int setErrorDescription(const string& newValue) {
		ErrorDescription = newValue;
		ErrorDescription_isNULL = false;
		return OK;
	}

	int getErrorCleared(bool& value) const {
		if (ErrorCleared_isNULL==true)
			return NOT_FOUND;
		value = ErrorCleared;
		return OK;
	}
	
	int setErrorCleared(const bool& newValue) {
		ErrorCleared = newValue;
		ErrorCleared_isNULL = false;
		return OK;
	}

	int getOtherIdentifyingInfo(vector<string>& value) const {
		if (OtherIdentifyingInfo_isNULL==true)
			return NOT_FOUND;
		value = OtherIdentifyingInfo;
		return OK;
	}
	
	int setOtherIdentifyingInfo(const vector<string>& newValue) {
		OtherIdentifyingInfo = newValue;
		OtherIdentifyingInfo_isNULL = false;
		return OK;
	}

	int getPowerOnHours(unsigned long long& value) const {
		if (PowerOnHours_isNULL==true)
			return NOT_FOUND;
		value = PowerOnHours;
		return OK;
	}
	
	int setPowerOnHours(const unsigned long long& newValue) {
		PowerOnHours = newValue;
		PowerOnHours_isNULL = false;
		return OK;
	}

	int getTotalPowerOnHours(unsigned long long& value) const {
		if (TotalPowerOnHours_isNULL==true)
			return NOT_FOUND;
		value = TotalPowerOnHours;
		return OK;
	}
	
	int setTotalPowerOnHours(const unsigned long long& newValue) {
		TotalPowerOnHours = newValue;
		TotalPowerOnHours_isNULL = false;
		return OK;
	}

	int getIdentifyingDescriptions(vector<string>& value) const {
		if (IdentifyingDescriptions_isNULL==true)
			return NOT_FOUND;
		value = IdentifyingDescriptions;
		return OK;
	}
	
	int setIdentifyingDescriptions(const vector<string>& newValue) {
		IdentifyingDescriptions = newValue;
		IdentifyingDescriptions_isNULL = false;
		return OK;
	}

	int getAdditionalAvailability(vector<unsigned short>& value) const {
		if (AdditionalAvailability_isNULL==true)
			return NOT_FOUND;
		value = AdditionalAvailability;
		return OK;
	}
	
	int setAdditionalAvailability(const vector<unsigned short>& newValue) {
		AdditionalAvailability = newValue;
		AdditionalAvailability_isNULL = false;
		return OK;
	}

	int getMaxQuiesceTime(unsigned long long& value) const {
		if (MaxQuiesceTime_isNULL==true)
			return NOT_FOUND;
		value = MaxQuiesceTime;
		return OK;
	}
	
	int setMaxQuiesceTime(const unsigned long long& newValue) {
		MaxQuiesceTime = newValue;
		MaxQuiesceTime_isNULL = false;
		return OK;
	}

	int getLocationIndicator(unsigned short& value) const {
		if (LocationIndicator_isNULL==true)
			return NOT_FOUND;
		value = LocationIndicator;
		return OK;
	}
	
	int setLocationIndicator(const unsigned short& newValue) {
		LocationIndicator = newValue;
		LocationIndicator_isNULL = false;
		return OK;
	}

	int getMaxPowerProduced(unsigned int& value) const {
		if (MaxPowerProduced_isNULL==true)
			return NOT_FOUND;
		value = MaxPowerProduced;
		return OK;
	}
	
	int setMaxPowerProduced(const unsigned int& newValue) {
		MaxPowerProduced = newValue;
		MaxPowerProduced_isNULL = false;
		return OK;
	}

	int getMaxPowerProducedUnits(string& value) const {
		if (MaxPowerProducedUnits_isNULL==true)
			return NOT_FOUND;
		value = MaxPowerProducedUnits;
		return OK;
	}
	
	int setMaxPowerProducedUnits(const string& newValue) {
		MaxPowerProducedUnits = newValue;
		MaxPowerProducedUnits_isNULL = false;
		return OK;
	}

	int getMaxPowerConsumed(unsigned int& value) const {
		if (MaxPowerConsumed_isNULL==true)
			return NOT_FOUND;
		value = MaxPowerConsumed;
		return OK;
	}
	
	int setMaxPowerConsumed(const unsigned int& newValue) {
		MaxPowerConsumed = newValue;
		MaxPowerConsumed_isNULL = false;
		return OK;
	}

	int getMaxPowerConsumedUnits(string& value) const {
		if (MaxPowerConsumedUnits_isNULL==true)
			return NOT_FOUND;
		value = MaxPowerConsumedUnits;
		return OK;
	}
	
	int setMaxPowerConsumedUnits(const string& newValue) {
		MaxPowerConsumedUnits = newValue;
		MaxPowerConsumedUnits_isNULL = false;
		return OK;
	}

	int getBatteryStatus(unsigned short& value) const {
		if (BatteryStatus_isNULL==true)
			return NOT_FOUND;
		value = BatteryStatus;
		return OK;
	}
	
	int setBatteryStatus(const unsigned short& newValue) {
		BatteryStatus = newValue;
		BatteryStatus_isNULL = false;
		return OK;
	}

	int getTimeOnBattery(unsigned int& value) const {
		if (TimeOnBattery_isNULL==true)
			return NOT_FOUND;
		value = TimeOnBattery;
		return OK;
	}
	
	int setTimeOnBattery(const unsigned int& newValue) {
		TimeOnBattery = newValue;
		TimeOnBattery_isNULL = false;
		return OK;
	}

	int getEstimatedRunTime(unsigned int& value) const {
		if (EstimatedRunTime_isNULL==true)
			return NOT_FOUND;
		value = EstimatedRunTime;
		return OK;
	}
	
	int setEstimatedRunTime(const unsigned int& newValue) {
		EstimatedRunTime = newValue;
		EstimatedRunTime_isNULL = false;
		return OK;
	}

	int getEstimatedChargeRemaining(unsigned short& value) const {
		if (EstimatedChargeRemaining_isNULL==true)
			return NOT_FOUND;
		value = EstimatedChargeRemaining;
		return OK;
	}
	
	int setEstimatedChargeRemaining(const unsigned short& newValue) {
		EstimatedChargeRemaining = newValue;
		EstimatedChargeRemaining_isNULL = false;
		return OK;
	}

	int getChemistry(unsigned short& value) const {
		if (Chemistry_isNULL==true)
			return NOT_FOUND;
		value = Chemistry;
		return OK;
	}
	
	int setChemistry(const unsigned short& newValue) {
		Chemistry = newValue;
		Chemistry_isNULL = false;
		return OK;
	}

	int getDesignCapacity(unsigned int& value) const {
		if (DesignCapacity_isNULL==true)
			return NOT_FOUND;
		value = DesignCapacity;
		return OK;
	}
	
	int setDesignCapacity(const unsigned int& newValue) {
		DesignCapacity = newValue;
		DesignCapacity_isNULL = false;
		return OK;
	}

	int getFullChargeCapacity(unsigned int& value) const {
		if (FullChargeCapacity_isNULL==true)
			return NOT_FOUND;
		value = FullChargeCapacity;
		return OK;
	}
	
	int setFullChargeCapacity(const unsigned int& newValue) {
		FullChargeCapacity = newValue;
		FullChargeCapacity_isNULL = false;
		return OK;
	}

	int getDesignVoltage(unsigned long long& value) const {
		if (DesignVoltage_isNULL==true)
			return NOT_FOUND;
		value = DesignVoltage;
		return OK;
	}
	
	int setDesignVoltage(const unsigned long long& newValue) {
		DesignVoltage = newValue;
		DesignVoltage_isNULL = false;
		return OK;
	}

	int getSmartBatteryVersion(string& value) const {
		if (SmartBatteryVersion_isNULL==true)
			return NOT_FOUND;
		value = SmartBatteryVersion;
		return OK;
	}
	
	int setSmartBatteryVersion(const string& newValue) {
		SmartBatteryVersion = newValue;
		SmartBatteryVersion_isNULL = false;
		return OK;
	}

	int getTimeToFullCharge(unsigned int& value) const {
		if (TimeToFullCharge_isNULL==true)
			return NOT_FOUND;
		value = TimeToFullCharge;
		return OK;
	}
	
	int setTimeToFullCharge(const unsigned int& newValue) {
		TimeToFullCharge = newValue;
		TimeToFullCharge_isNULL = false;
		return OK;
	}

	int getExpectedLife(unsigned int& value) const {
		if (ExpectedLife_isNULL==true)
			return NOT_FOUND;
		value = ExpectedLife;
		return OK;
	}
	
	int setExpectedLife(const unsigned int& newValue) {
		ExpectedLife = newValue;
		ExpectedLife_isNULL = false;
		return OK;
	}

	int getMaxRechargeTime(unsigned int& value) const {
		if (MaxRechargeTime_isNULL==true)
			return NOT_FOUND;
		value = MaxRechargeTime;
		return OK;
	}
	
	int setMaxRechargeTime(const unsigned int& newValue) {
		MaxRechargeTime = newValue;
		MaxRechargeTime_isNULL = false;
		return OK;
	}

	int getRechargeCount(unsigned int& value) const {
		if (RechargeCount_isNULL==true)
			return NOT_FOUND;
		value = RechargeCount;
		return OK;
	}
	
	int setRechargeCount(const unsigned int& newValue) {
		RechargeCount = newValue;
		RechargeCount_isNULL = false;
		return OK;
	}

	int getMaxRechargeCount(unsigned int& value) const {
		if (MaxRechargeCount_isNULL==true)
			return NOT_FOUND;
		value = MaxRechargeCount;
		return OK;
	}
	
	int setMaxRechargeCount(const unsigned int& newValue) {
		MaxRechargeCount = newValue;
		MaxRechargeCount_isNULL = false;
		return OK;
	}

	int getRemainingCapacity(unsigned int& value) const {
		if (RemainingCapacity_isNULL==true)
			return NOT_FOUND;
		value = RemainingCapacity;
		return OK;
	}
	
	int setRemainingCapacity(const unsigned int& newValue) {
		RemainingCapacity = newValue;
		RemainingCapacity_isNULL = false;
		return OK;
	}

	int getRemainingCapacityMaxError(unsigned char& value) const {
		if (RemainingCapacityMaxError_isNULL==true)
			return NOT_FOUND;
		value = RemainingCapacityMaxError;
		return OK;
	}
	
	int setRemainingCapacityMaxError(const unsigned char& newValue) {
		RemainingCapacityMaxError = newValue;
		RemainingCapacityMaxError_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Battery_RequestStateChange_In {

public:

	unsigned short RequestedState;
	bool RequestedState_isNULL;

	Objectpath Job;
	bool Job_isNULL;

	string TimeoutPeriod;
	bool TimeoutPeriod_isNULL;

	OpenDRIM_Battery_RequestStateChange_In() {
		RequestedState_isNULL = true;
		Job_isNULL = true;
		TimeoutPeriod_isNULL = true;
	}

	~OpenDRIM_Battery_RequestStateChange_In() {}

	int getRequestedState(unsigned short& value) const {
		if (RequestedState_isNULL == true)
			return NOT_FOUND;
		value = RequestedState;
		return OK;
	}
	int setRequestedState(const unsigned short&  newValue) {
		RequestedState = newValue;
		RequestedState_isNULL = false;
		return OK;
	}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

	int getTimeoutPeriod(string& value) const {
		if (TimeoutPeriod_isNULL == true)
			return NOT_FOUND;
		value = TimeoutPeriod;
		return OK;
	}
	int setTimeoutPeriod(const string&  newValue) {
		TimeoutPeriod = newValue;
		TimeoutPeriod_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Battery_RequestStateChange_Out {

public:

	Objectpath Job;
	bool Job_isNULL;

	OpenDRIM_Battery_RequestStateChange_Out() {
		Job_isNULL = true;
	}

	~OpenDRIM_Battery_RequestStateChange_Out() {}

	int getJob(Objectpath& value) const {
		if (Job_isNULL == true)
			return NOT_FOUND;
		value = Job;
		return OK;
	}
	int setJob(const Objectpath&  newValue) {
		Job = newValue;
		Job_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Battery_SetPowerState_In {

public:

	unsigned short PowerState;
	bool PowerState_isNULL;

	string Time;
	bool Time_isNULL;

	OpenDRIM_Battery_SetPowerState_In() {
		PowerState_isNULL = true;
		Time_isNULL = true;
	}

	~OpenDRIM_Battery_SetPowerState_In() {}

	int getPowerState(unsigned short& value) const {
		if (PowerState_isNULL == true)
			return NOT_FOUND;
		value = PowerState;
		return OK;
	}
	int setPowerState(const unsigned short&  newValue) {
		PowerState = newValue;
		PowerState_isNULL = false;
		return OK;
	}

	int getTime(string& value) const {
		if (Time_isNULL == true)
			return NOT_FOUND;
		value = Time;
		return OK;
	}
	int setTime(const string&  newValue) {
		Time = newValue;
		Time_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Battery_EnableDevice_In {

public:

	bool Enabled;
	bool Enabled_isNULL;

	OpenDRIM_Battery_EnableDevice_In() {
		Enabled_isNULL = true;
	}

	~OpenDRIM_Battery_EnableDevice_In() {}

	int getEnabled(bool& value) const {
		if (Enabled_isNULL == true)
			return NOT_FOUND;
		value = Enabled;
		return OK;
	}
	int setEnabled(const bool&  newValue) {
		Enabled = newValue;
		Enabled_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Battery_OnlineDevice_In {

public:

	bool Online;
	bool Online_isNULL;

	OpenDRIM_Battery_OnlineDevice_In() {
		Online_isNULL = true;
	}

	~OpenDRIM_Battery_OnlineDevice_In() {}

	int getOnline(bool& value) const {
		if (Online_isNULL == true)
			return NOT_FOUND;
		value = Online;
		return OK;
	}
	int setOnline(const bool&  newValue) {
		Online = newValue;
		Online_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Battery_QuiesceDevice_In {

public:

	bool Quiesce;
	bool Quiesce_isNULL;

	OpenDRIM_Battery_QuiesceDevice_In() {
		Quiesce_isNULL = true;
	}

	~OpenDRIM_Battery_QuiesceDevice_In() {}

	int getQuiesce(bool& value) const {
		if (Quiesce_isNULL == true)
			return NOT_FOUND;
		value = Quiesce;
		return OK;
	}
	int setQuiesce(const bool&  newValue) {
		Quiesce = newValue;
		Quiesce_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_BATTERY_H_*/
