/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import jline.Completor;
import jline.SimpleCompletor$SimpleCompletorFilter;

public class SimpleCompletor
implements Cloneable,
Completor {
    private SortedSet candidates;
    private String delimiter;
    private SimpleCompletor$SimpleCompletorFilter filter;

    public SimpleCompletor(String string) {
        this(new String[]{string});
    }

    public SimpleCompletor(String[] stringArray) {
        this(stringArray, null);
    }

    public SimpleCompletor(String[] stringArray, SimpleCompletor$SimpleCompletorFilter simpleCompletor$SimpleCompletorFilter) {
        this.filter = simpleCompletor$SimpleCompletorFilter;
        this.setCandidateStrings(stringArray);
    }

    public SimpleCompletor(Reader reader) {
        this(SimpleCompletor.getStrings(reader));
    }

    public SimpleCompletor(InputStream inputStream) {
        this(SimpleCompletor.getStrings(new InputStreamReader(inputStream)));
    }

    private static String[] getStrings(Reader reader) {
        String string;
        Reader reader2 = reader instanceof BufferedReader ? reader : new BufferedReader(reader);
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = ((BufferedReader)reader2).readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                linkedList.add(stringTokenizer.nextToken());
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public int complete(String string, int n, List list) {
        String string2;
        String string3 = string == null ? "" : string;
        Iterator iterator = this.candidates.tailSet(string3).iterator();
        while (iterator.hasNext() && (string2 = (String)iterator.next()).startsWith(string3)) {
            int n2;
            if (this.delimiter != null && (n2 = string2.indexOf(this.delimiter, n)) != -1) {
                string2 = string2.substring(0, n2 + 1);
            }
            list.add(string2);
        }
        if (list.size() == 1) {
            list.set(0, (String)list.get(0) + " ");
        }
        if (list.size() == 0) {
            return -1;
        }
        return 0;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setCandidates(SortedSet sortedSet) {
        if (this.filter != null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if ((string = this.filter.filter(string)) == null) continue;
                treeSet.add(string);
            }
            this.candidates = treeSet;
            return;
        }
        this.candidates = sortedSet;
    }

    public SortedSet getCandidates() {
        return Collections.unmodifiableSortedSet(this.candidates);
    }

    public void setCandidateStrings(String[] stringArray) {
        this.setCandidates(new TreeSet<String>(Arrays.asList(stringArray)));
    }

    public void addCandidateString(String string) {
        String string2 = this.filter == null ? string : this.filter.filter(string);
        if (string2 != null) {
            this.candidates.add(string2);
        }
    }

    public Object clone() {
        return super.clone();
    }
}

