// Created on: 1996-12-02
// Created by: Laurent PAINNOT
// Copyright (c) 1996-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef OCCT_DEBUG
  #define No_Standard_OutOfRange
  #define No_Standard_RangeError
#endif

#include <AppCont_ContMatrices.hxx>
#include <math_Matrix.hxx>
#include <Standard_DimensionError.hxx>

static const Standard_Real VBMatrix[] = {0.5,
                                         0.5,

                                         0.788675134594813,
                                         0.211324865405187,
                                         0.211324865405187,
                                         0.788675134594813,

                                         0.887298334620741,
                                         0.5,
                                         0.112701665379259,
                                         0.112701665379259,
                                         0.5,
                                         0.887298334620741,

                                         0.930568155797026,
                                         0.669990521792428,
                                         0.330009478207572,
                                         0.0694318442029735,
                                         0.0694318442029735,
                                         0.330009478207572,
                                         0.669990521792428,
                                         0.930568155797026,

                                         0.953089922969332,
                                         0.769234655052841,
                                         0.5,
                                         0.230765344947159,
                                         0.0469100770306681,
                                         0.046910077030668,
                                         0.230765344947159,
                                         0.5,
                                         0.769234655052841,
                                         0.953089922969332,

                                         0.966234757101576,
                                         0.830604693233133,
                                         0.619309593041598,
                                         0.380690406958402,
                                         0.169395306766867,
                                         0.033765242898424,
                                         0.033765242898424,
                                         0.169395306766867,
                                         0.380690406958402,
                                         0.619309593041598,
                                         0.830604693233133,
                                         0.966234757101576,

                                         0.974553956171379,
                                         0.870765592799697,
                                         0.702922575688699,
                                         0.5,
                                         0.297077424311301,
                                         0.129234407200303,
                                         0.025446043828621,
                                         0.025446043828621,
                                         0.129234407200303,
                                         0.297077424311301,
                                         0.5,
                                         0.702922575688699,
                                         0.870765592799697,
                                         0.974553956171379,

                                         0.980144928248768,
                                         0.898333238706813,
                                         0.762766204958164,
                                         0.591717321247825,
                                         0.408282678752175,
                                         0.237233795041836,
                                         0.101666761293187,
                                         0.019855071751232,
                                         0.019855071751232,
                                         0.101666761293187,
                                         0.237233795041836,
                                         0.408282678752175,
                                         0.591717321247825,
                                         0.762766204958164,
                                         0.898333238706813,
                                         0.980144928248768,

                                         0.984080119753813,
                                         0.918015553663318,
                                         0.806685716350295,
                                         0.662126711701905,
                                         0.5,
                                         0.337873288298095,
                                         0.193314283649705,
                                         0.081984446336682,
                                         0.0159198802461871,
                                         0.015919880246187,
                                         0.081984446336682,
                                         0.193314283649705,
                                         0.337873288298095,
                                         0.5,
                                         0.662126711701905,
                                         0.806685716350295,
                                         0.918015553663318,
                                         0.984080119753813,

                                         0.986953264258586,
                                         0.932531683344493,
                                         0.839704784149512,
                                         0.716697697064623,
                                         0.574437169490815,
                                         0.425562830509185,
                                         0.283302302935377,
                                         0.160295215850488,
                                         0.0674683166555075,
                                         0.013046735741414,
                                         0.013046735741414,
                                         0.0674683166555075,
                                         0.160295215850488,
                                         0.283302302935377,
                                         0.425562830509185,
                                         0.574437169490815,
                                         0.716697697064623,
                                         0.839704784149512,
                                         0.932531683344493,
                                         0.986953264258586,

                                         0.989114329073028,
                                         0.943531299884047,
                                         0.865076002787025,
                                         0.759548064603406,
                                         0.634771577976172,
                                         0.5,
                                         0.365228422023828,
                                         0.240451935396594,
                                         0.134923997212975,
                                         0.0564687001159525,
                                         0.0108856709269716,
                                         0.0108856709269715,
                                         0.0564687001159525,
                                         0.134923997212975,
                                         0.240451935396594,
                                         0.365228422023827,
                                         0.5,
                                         0.634771577976172,
                                         0.759548064603406,
                                         0.865076002787025,
                                         0.943531299884047,
                                         0.989114329073028,

                                         0.99078031712336,
                                         0.952058628185237,
                                         0.884951337097152,
                                         0.793658977143308,
                                         0.68391574949909,
                                         0.562616704255735,
                                         0.437383295744265,
                                         0.31608425050091,
                                         0.206341022856692,
                                         0.115048662902848,
                                         0.0479413718147625,
                                         0.00921968287664043,
                                         0.00921968287664049,
                                         0.0479413718147625,
                                         0.115048662902847,
                                         0.206341022856691,
                                         0.31608425050091,
                                         0.437383295744265,
                                         0.562616704255735,
                                         0.68391574949909,
                                         0.793658977143308,
                                         0.884951337097152,
                                         0.952058628185237,
                                         0.99078031712336,

                                         0.992091527359294,
                                         0.958799199611489,
                                         0.900789045366655,
                                         0.82117466972017,
                                         0.724246375518223,
                                         0.615229157977567,
                                         0.5,
                                         0.384770842022433,
                                         0.275753624481777,
                                         0.17882533027983,
                                         0.0992109546333451,
                                         0.0412008003885109,
                                         0.00790847264070593,
                                         0.00790847264070599,
                                         0.041200800388511,
                                         0.099210954633345,
                                         0.17882533027983,
                                         0.275753624481777,
                                         0.384770842022433,
                                         0.5,
                                         0.615229157977567,
                                         0.724246375518223,
                                         0.82117466972017,
                                         0.900789045366655,
                                         0.958799199611489,
                                         0.992091527359294,

                                         0.993141904348406,
                                         0.964217441831787,
                                         0.913600657534883,
                                         0.843646452405842,
                                         0.757624318179077,
                                         0.659556184463945,
                                         0.554027474353672,
                                         0.445972525646328,
                                         0.340443815536055,
                                         0.242375681820923,
                                         0.156353547594158,
                                         0.0863993424651175,
                                         0.035782558168213,
                                         0.00685809565159401,
                                         0.00685809565159401,
                                         0.035782558168213,
                                         0.0863993424651175,
                                         0.156353547594157,
                                         0.242375681820923,
                                         0.340443815536055,
                                         0.445972525646328,
                                         0.554027474353672,
                                         0.659556184463945,
                                         0.757624318179077,
                                         0.843646452405842,
                                         0.913600657534883,
                                         0.964217441831787,
                                         0.993141904348406,

                                         0.993996259010242,
                                         0.968636696200353,
                                         0.924103291705213,
                                         0.862208865680085,
                                         0.78548608630427,
                                         0.697075673538782,
                                         0.600597046998718,
                                         0.5,
                                         0.399402953001282,
                                         0.302924326461218,
                                         0.21451391369573,
                                         0.137791134319915,
                                         0.0758967082947866,
                                         0.031363303799647,
                                         0.00600374098975753,
                                         0.00600374098975748,
                                         0.031363303799647,
                                         0.0758967082947865,
                                         0.137791134319915,
                                         0.21451391369573,
                                         0.302924326461218,
                                         0.399402953001282,
                                         0.5,
                                         0.600597046998718,
                                         0.697075673538782,
                                         0.78548608630427,
                                         0.862208865680085,
                                         0.924103291705213,
                                         0.968636696200353,
                                         0.993996259010242,

                                         0.994700467495825,
                                         0.972287511536617,
                                         0.932815601193916,
                                         0.877702204177502,
                                         0.808938122201322,
                                         0.729008388828614,
                                         0.64080177538963,
                                         0.547506254918819,
                                         0.452493745081181,
                                         0.35919822461037,
                                         0.270991611171386,
                                         0.191061877798678,
                                         0.122297795822498,
                                         0.0671843988060841,
                                         0.0277124884633835,
                                         0.00529953250417492,
                                         0.00529953250417498,
                                         0.0277124884633835,
                                         0.067184398806084,
                                         0.122297795822499,
                                         0.191061877798678,
                                         0.270991611171386,
                                         0.35919822461037,
                                         0.452493745081181,
                                         0.547506254918819,
                                         0.64080177538963,
                                         0.729008388828614,
                                         0.808938122201322,
                                         0.877702204177502,
                                         0.932815601193916,
                                         0.972287511536617,
                                         0.994700467495825,

                                         0.995287737657208,
                                         0.975337760884384,
                                         0.940119576863493,
                                         0.890757001948401,
                                         0.828835579608346,
                                         0.756345268543239,
                                         0.675615881726938,
                                         0.589242090747924,
                                         0.5,
                                         0.410757909252076,
                                         0.324384118273062,
                                         0.243654731456761,
                                         0.171164420391654,
                                         0.109242998051599,
                                         0.059880423136507,
                                         0.0246622391156159,
                                         0.00471226234279154,
                                         0.00471226234279148,
                                         0.024662239115616,
                                         0.059880423136507,
                                         0.109242998051599,
                                         0.171164420391655,
                                         0.243654731456761,
                                         0.324384118273062,
                                         0.410757909252076,
                                         0.5,
                                         0.589242090747924,
                                         0.675615881726938,
                                         0.756345268543239,
                                         0.828835579608346,
                                         0.890757001948401,
                                         0.940119576863493,
                                         0.975337760884384,
                                         0.995287737657208,

                                         0.995782584210466,
                                         0.977911974785699,
                                         0.946301233248778,
                                         0.901852479486261,
                                         0.845843521530177,
                                         0.779885415536974,
                                         0.705875580731422,
                                         0.625943112845753,
                                         0.542387506520868,
                                         0.457612493479132,
                                         0.374056887154247,
                                         0.294124419268578,
                                         0.220114584463026,
                                         0.154156478469823,
                                         0.0981475205137385,
                                         0.053698766751222,
                                         0.022088025214301,
                                         0.0042174157895345,
                                         0.0042174157895345,
                                         0.022088025214301,
                                         0.053698766751222,
                                         0.0981475205137385,
                                         0.154156478469823,
                                         0.220114584463026,
                                         0.294124419268578,
                                         0.374056887154247,
                                         0.457612493479132,
                                         0.542387506520868,
                                         0.625943112845753,
                                         0.705875580731422,
                                         0.779885415536974,
                                         0.845843521530177,
                                         0.901852479486261,
                                         0.946301233248778,
                                         0.977911974785699,
                                         0.995782584210466,

                                         0.996203421921792,
                                         0.980104076067415,
                                         0.951577951807409,
                                         0.911357328268572,
                                         0.860483088667614,
                                         0.800272652330841,
                                         0.73228537068798,
                                         0.658282049981815,
                                         0.580179322820113,
                                         0.5,
                                         0.419820677179887,
                                         0.341717950018185,
                                         0.26771462931202,
                                         0.199727347669159,
                                         0.139516911332386,
                                         0.0886426717314285,
                                         0.048422048192591,
                                         0.019895923932585,
                                         0.00379657807820799,
                                         0.00379657807820799,
                                         0.019895923932585,
                                         0.048422048192591,
                                         0.0886426717314285,
                                         0.139516911332385,
                                         0.19972734766916,
                                         0.26771462931202,
                                         0.341717950018185,
                                         0.419820677179887,
                                         0.5,
                                         0.580179322820113,
                                         0.658282049981815,
                                         0.73228537068798,
                                         0.800272652330841,
                                         0.860483088667614,
                                         0.911357328268572,
                                         0.951577951807409,
                                         0.980104076067415,
                                         0.996203421921792,

                                         0.996564299592547,
                                         0.981985963638957,
                                         0.956117214125663,
                                         0.919558485911109,
                                         0.873165953230076,
                                         0.818026840363258,
                                         0.755433500975414,
                                         0.68685304435771,
                                         0.613892925570823,
                                         0.538263260566749,
                                         0.461736739433251,
                                         0.386107074429177,
                                         0.31314695564229,
                                         0.244566499024586,
                                         0.181973159636742,
                                         0.126834046769924,
                                         0.0804415140888906,
                                         0.043882785874337,
                                         0.018014036361043,
                                         0.00343570040745256,
                                         0.0034357004074525,
                                         0.018014036361043,
                                         0.043882785874337,
                                         0.0804415140888905,
                                         0.126834046769924,
                                         0.181973159636742,
                                         0.244566499024586,
                                         0.31314695564229,
                                         0.386107074429177,
                                         0.461736739433251,
                                         0.538263260566749,
                                         0.613892925570823,
                                         0.68685304435771,
                                         0.755433500975414,
                                         0.818026840363258,
                                         0.873165953230076,
                                         0.919558485911109,
                                         0.956117214125663,
                                         0.981985963638957,
                                         0.996564299592547,

                                         0.996876085310195,
                                         0.983613419283153,
                                         0.960049667075201,
                                         0.926681682291658,
                                         0.884219981737839,
                                         0.833569402098706,
                                         0.77580941794361,
                                         0.712171060103719,
                                         0.644010658401201,
                                         0.572780927080447,
                                         0.5,
                                         0.427219072919553,
                                         0.355989341598799,
                                         0.287828939896281,
                                         0.22419058205639,
                                         0.166430597901294,
                                         0.115780018262161,
                                         0.0733183177083415,
                                         0.0399503329247994,
                                         0.0163865807168471,
                                         0.00312391468980544,
                                         0.0031239146898055,
                                         0.016386580716847,
                                         0.0399503329247995,
                                         0.0733183177083415,
                                         0.115780018262161,
                                         0.166430597901294,
                                         0.22419058205639,
                                         0.287828939896281,
                                         0.355989341598799,
                                         0.427219072919553,
                                         0.5,
                                         0.572780927080447,
                                         0.644010658401201,
                                         0.712171060103719,
                                         0.77580941794361,
                                         0.833569402098706,
                                         0.884219981737839,
                                         0.926681682291658,
                                         0.960049667075201,
                                         0.983613419283153,
                                         0.996876085310195,

                                         0.9971472927412,
                                         0.985030248917715,
                                         0.963478386093587,
                                         0.93290628886015,
                                         0.893908402989604,
                                         0.847243631593341,
                                         0.793820201753456,
                                         0.734677918993379,
                                         0.670967910446042,
                                         0.60393021334411,
                                         0.534869636659861,
                                         0.465130363340139,
                                         0.39606978665589,
                                         0.329032089553958,
                                         0.265322081006621,
                                         0.206179798246544,
                                         0.152756368406659,
                                         0.106091597010396,
                                         0.06709371113985,
                                         0.0365216139064131,
                                         0.0149697510822855,
                                         0.00285270725880049,
                                         0.00285270725880049,
                                         0.0149697510822855,
                                         0.036521613906413,
                                         0.06709371113985,
                                         0.106091597010396,
                                         0.152756368406659,
                                         0.206179798246544,
                                         0.265322081006621,
                                         0.329032089553958,
                                         0.396069786655889,
                                         0.465130363340139,
                                         0.534869636659861,
                                         0.60393021334411,
                                         0.670967910446042,
                                         0.734677918993379,
                                         0.793820201753456,
                                         0.847243631593341,
                                         0.893908402989604,
                                         0.93290628886015,
                                         0.963478386093587,
                                         0.985030248917715,
                                         0.9971472927412,

                                         0.997384667498776,
                                         0.986271235609057,
                                         0.966485543413008,
                                         0.938376179135221,
                                         0.90244420080942,
                                         0.859330681565975,
                                         0.809804937881823,
                                         0.754750738923004,
                                         0.695150519015145,
                                         0.632067840485173,
                                         0.566628412149233,
                                         0.5,
                                         0.433371587850767,
                                         0.367932159514827,
                                         0.304849480984855,
                                         0.245249261076996,
                                         0.190195062118177,
                                         0.140669318434025,
                                         0.09755579919058,
                                         0.061623820864779,
                                         0.033514456586992,
                                         0.0137287643909425,
                                         0.00261533250122392,
                                         0.00261533250122398,
                                         0.0137287643909425,
                                         0.033514456586992,
                                         0.061623820864779,
                                         0.09755579919058,
                                         0.140669318434025,
                                         0.190195062118177,
                                         0.245249261076996,
                                         0.304849480984855,
                                         0.367932159514827,
                                         0.433371587850767,
                                         0.5,
                                         0.566628412149233,
                                         0.632067840485173,
                                         0.695150519015145,
                                         0.754750738923004,
                                         0.809804937881823,
                                         0.859330681565975,
                                         0.90244420080942,
                                         0.938376179135221,
                                         0.966485543413008,
                                         0.986271235609057,
                                         0.997384667498776,

                                         0.997593609998511,
                                         0.987364277985655,
                                         0.969137276001367,
                                         0.9432077635022,
                                         0.910000992986951,
                                         0.870062095789277,
                                         0.824046825968488,
                                         0.77271073569442,
                                         0.716896753813023,
                                         0.657521339848081,
                                         0.595559433736808,
                                         0.532028446431303,
                                         0.467971553568697,
                                         0.404440566263192,
                                         0.342478660151919,
                                         0.283103246186977,
                                         0.22728926430558,
                                         0.175953174031512,
                                         0.129937904210723,
                                         0.0899990070130485,
                                         0.0567922364977995,
                                         0.0308627239986334,
                                         0.0126357220143455,
                                         0.00240639000148946,
                                         0.00240639000148951,
                                         0.0126357220143455,
                                         0.0308627239986335,
                                         0.0567922364977995,
                                         0.0899990070130485,
                                         0.129937904210723,
                                         0.175953174031512,
                                         0.22728926430558,
                                         0.283103246186977,
                                         0.342478660151919,
                                         0.404440566263192,
                                         0.467971553568697,
                                         0.532028446431303,
                                         0.595559433736808,
                                         0.657521339848081,
                                         0.716896753813023,
                                         0.77271073569442,
                                         0.824046825968488,
                                         0.870062095789277,
                                         0.910000992986951,
                                         0.9432077635022,
                                         0.969137276001367,
                                         0.987364277985655,
                                         0.997593609998511,

                                         0.25,
                                         0.5,
                                         0.25,

                                         0.622008467928146,
                                         0.0446581987385204,
                                         0.333333333333333,
                                         0.333333333333333,
                                         0.0446581987385204,
                                         0.622008467928146,

                                         0.787298334620741,
                                         0.25,
                                         0.0127016653792584,
                                         0.2,
                                         0.5,
                                         0.2,
                                         0.0127016653792584,
                                         0.25,
                                         0.787298334620741,

                                         0.865957092583479,
                                         0.44888729929169,
                                         0.108906255706834,
                                         0.00482078098942599,
                                         0.129222126427095,
                                         0.442206445001476,
                                         0.442206445001476,
                                         0.129222126427095,
                                         0.00482078098942598,
                                         0.108906255706834,
                                         0.44888729929169,
                                         0.865957092583479,

                                         0.908380401265687,
                                         0.591721954534264,
                                         0.25,
                                         0.0532526444285811,
                                         0.00220055532702321,
                                         0.0894190434072896,
                                         0.355025401037155,
                                         0.5,
                                         0.355025401037155,
                                         0.0894190434072897,
                                         0.00220055532702321,
                                         0.0532526444285811,
                                         0.25,
                                         0.591721954534264,
                                         0.908380401265687,

                                         0.933609605831142,
                                         0.689904156420906,
                                         0.38354437203335,
                                         0.144925185950153,
                                         0.0286947699546411,
                                         0.00114009162798957,
                                         0.0652503025408688,
                                         0.281401073624453,
                                         0.471530442016496,
                                         0.471530442016496,
                                         0.281401073624453,
                                         0.0652503025408688,
                                         0.00114009162798957,
                                         0.0286947699546411,
                                         0.144925185950153,
                                         0.38354437203335,
                                         0.689904156420906,
                                         0.933609605831142,

                                         0.949755413489286,
                                         0.758232717603808,
                                         0.494100147412834,
                                         0.25,
                                         0.088254996035437,
                                         0.0167015320044137,
                                         0.000647501146528103,
                                         0.0495970853641858,
                                         0.225065750391779,
                                         0.417644856551729,
                                         0.5,
                                         0.417644856551729,
                                         0.225065750391779,
                                         0.0495970853641859,
                                         0.0006475011465281,
                                         0.0167015320044137,
                                         0.088254996035437,
                                         0.25,
                                         0.494100147412834,
                                         0.758232717603808,
                                         0.949755413489286,

                                         0.960684080371783,
                                         0.807002607765473,
                                         0.581812283426281,
                                         0.350129388264702,
                                         0.166694745769052,
                                         0.0562798735099516,
                                         0.0103361303518458,
                                         0.000394223874246572,
                                         0.0389216957539709,
                                         0.182661261882682,
                                         0.361907843063768,
                                         0.483175865966247,
                                         0.483175865966247,
                                         0.361907843063768,
                                         0.182661261882682,
                                         0.0389216957539709,
                                         0.000394223874246572,
                                         0.0103361303518458,
                                         0.0562798735099516,
                                         0.166694745769052,
                                         0.350129388264702,
                                         0.581812283426281,
                                         0.807002607765473,
                                         0.960684080371783,

                                         0.968413682094679,
                                         0.842752556767768,
                                         0.650741844963589,
                                         0.438411782349177,
                                         0.25,
                                         0.114158358945368,
                                         0.0373704122629986,
                                         0.00672144944113229,
                                         0.000253442587052937,
                                         0.0313328753182682,
                                         0.150525993791099,
                                         0.311887742773413,
                                         0.447429858705455,
                                         0.5,
                                         0.447429858705455,
                                         0.311887742773413,
                                         0.150525993791099,
                                         0.0313328753182683,
                                         0.000253442587052935,
                                         0.00672144944113229,
                                         0.0373704122629986,
                                         0.114158358945368,
                                         0.25,
                                         0.438411782349177,
                                         0.650741844963589,
                                         0.842752556767768,
                                         0.968413682094679,

                                         0.974076745830678,
                                         0.869615340441313,
                                         0.705104124523579,
                                         0.513655588977735,
                                         0.32997806169262,
                                         0.181103722710989,
                                         0.0802601948484878,
                                         0.0256945562245545,
                                         0.00455197375232782,
                                         0.00017021731350629,
                                         0.0257530368558155,
                                         0.125832685806359,
                                         0.269201319251867,
                                         0.406084216173777,
                                         0.488918215596391,
                                         0.488918215596391,
                                         0.406084216173777,
                                         0.269201319251867,
                                         0.125832685806359,
                                         0.0257530368558155,
                                         0.00017021731350629,
                                         0.00455197375232783,
                                         0.0256945562245545,
                                         0.0802601948484878,
                                         0.181103722710989,
                                         0.32997806169262,
                                         0.513655588977735,
                                         0.705104124523579,
                                         0.869615340441313,
                                         0.974076745830678,

                                         0.978347155977587,
                                         0.89025131386088,
                                         0.748356490597976,
                                         0.57691326244278,
                                         0.40293495620636,
                                         0.25,
                                         0.133391800254015,
                                         0.0578171332359678,
                                         0.018204485023927,
                                         0.00318871409278537,
                                         0.000118497831530314,
                                         0.0215343461908824,
                                         0.106559972046334,
                                         0.233439024378097,
                                         0.365269604321252,
                                         0.463673243539625,
                                         0.5,
                                         0.463673243539625,
                                         0.365269604321252,
                                         0.233439024378097,
                                         0.106559972046334,
                                         0.0215343461908825,
                                         0.000118497831530313,
                                         0.00318871409278537,
                                         0.018204485023927,
                                         0.0578171332359678,
                                         0.133391800254015,
                                         0.25,
                                         0.40293495620636,
                                         0.57691326244278,
                                         0.748356490597976,
                                         0.89025131386088,
                                         0.978347155977587,

                                         0.981645636799065,
                                         0.906415631501956,
                                         0.783138869030038,
                                         0.629894572000163,
                                         0.467740752412902,
                                         0.316537555907585,
                                         0.191304147396116,
                                         0.0999092534147221,
                                         0.0425766177135457,
                                         0.013236194835733,
                                         0.00229837513148131,
                                         8.50025523458168e-05,
                                         0.0182693606485893,
                                         0.0912859933665624,
                                         0.203624936134229,
                                         0.327528810286292,
                                         0.432349994172376,
                                         0.4921582966963,
                                         0.4921582966963,
                                         0.432349994172376,
                                         0.327528810286292,
                                         0.203624936134229,
                                         0.0912859933665625,
                                         0.0182693606485892,
                                         8.50025523458178e-05,
                                         0.0022983751314813,
                                         0.013236194835733,
                                         0.0425766177135457,
                                         0.099909253414722,
                                         0.191304147396116,
                                         0.316537555907585,
                                         0.467740752412902,
                                         0.629894572000163,
                                         0.783138869030038,
                                         0.906415631501956,
                                         0.981645636799065,

                                         0.984245598658097,
                                         0.919295905175632,
                                         0.81142090425257,
                                         0.67432783819003,
                                         0.524532812451284,
                                         0.378506916825787,
                                         0.25,
                                         0.148048600870652,
                                         0.0760400614148366,
                                         0.0319784987496903,
                                         0.00984281351925965,
                                         0.00169750595265392,
                                         6.25439395087943e-05,
                                         0.0156918574023944,
                                         0.0790065888717141,
                                         0.178736282228171,
                                         0.293693663060279,
                                         0.39942712613388,
                                         0.473444482303562,
                                         0.5,
                                         0.473444482303562,
                                         0.39942712613388,
                                         0.293693663060279,
                                         0.178736282228171,
                                         0.079006588871714,
                                         0.0156918574023943,
                                         6.25439395087951e-05,
                                         0.00169750595265393,
                                         0.00984281351925964,
                                         0.0319784987496903,
                                         0.0760400614148366,
                                         0.148048600870652,
                                         0.25,
                                         0.378506916825787,
                                         0.524532812451284,
                                         0.67432783819003,
                                         0.81142090425257,
                                         0.919295905175632,
                                         0.984245598658097,

                                         0.986330842172778,
                                         0.929715275132636,
                                         0.83466616144817,
                                         0.711739336656963,
                                         0.573994607496311,
                                         0.435014360464637,
                                         0.306946442338709,
                                         0.198891493631365,
                                         0.115901991536747,
                                         0.0587459711381573,
                                         0.0244464318452785,
                                         0.00746484637840465,
                                         0.00128039146906154,
                                         4.70334759664127e-05,
                                         0.0136221243512552,
                                         0.0690043333983029,
                                         0.157868992173426,
                                         0.263814231497758,
                                         0.367259421365531,
                                         0.449083647998615,
                                         0.494162064029927,
                                         0.494162064029927,
                                         0.449083647998615,
                                         0.367259421365531,
                                         0.263814231497758,
                                         0.157868992173426,
                                         0.0690043333983028,
                                         0.0136221243512552,
                                         4.70334759664127e-05,
                                         0.00128039146906155,
                                         0.00746484637840465,
                                         0.0244464318452785,
                                         0.0587459711381573,
                                         0.115901991536747,
                                         0.198891493631365,
                                         0.306946442338709,
                                         0.435014360464637,
                                         0.573994607496311,
                                         0.711739336656963,
                                         0.83466616144817,
                                         0.929715275132636,
                                         0.986330842172778,

                                         0.988028562926357,
                                         0.938257049225935,
                                         0.853966893740411,
                                         0.743404128057339,
                                         0.616988391777598,
                                         0.485914494639546,
                                         0.36071681286358,
                                         0.25,
                                         0.159522718866145,
                                         0.0917631475619829,
                                         0.0460162191690593,
                                         0.0189863966971688,
                                         0.00576031032998392,
                                         0.000983656825228953,
                                         3.60449058720948e-05,
                                         0.0119353921677708,
                                         0.0607592939488361,
                                         0.140272795929605,
                                         0.237609475245492,
                                         0.336995389053342,
                                         0.422322357798471,
                                         0.479760468270276,
                                         0.5,
                                         0.479760468270276,
                                         0.422322357798471,
                                         0.336995389053342,
                                         0.237609475245492,
                                         0.140272795929605,
                                         0.0607592939488361,
                                         0.0119353921677709,
                                         3.60449058720941e-05,
                                         0.000983656825228953,
                                         0.00576031032998392,
                                         0.0189863966971689,
                                         0.0460162191690593,
                                         0.0917631475619829,
                                         0.159522718866145,
                                         0.25,
                                         0.36071681286358,
                                         0.485914494639546,
                                         0.616988391777598,
                                         0.743404128057339,
                                         0.853966893740411,
                                         0.938257049225935,
                                         0.988028562926357,

                                         0.989429020036413,
                                         0.945343005090066,
                                         0.870144945830767,
                                         0.770361159218045,
                                         0.654380885550601,
                                         0.531453230982491,
                                         0.410626915342501,
                                         0.299763099175231,
                                         0.204750589337593,
                                         0.129023364563242,
                                         0.0734364533252639,
                                         0.036504641147957,
                                         0.0149567508630415,
                                         0.00451374344293495,
                                         0.000767982016833162,
                                         2.80850447628065e-05,
                                         0.0105428949188243,
                                         0.0538890128931006,
                                         0.125341310726298,
                                         0.214682089918914,
                                         0.309114473301442,
                                         0.395110315692245,
                                         0.460349720094257,
                                         0.495486311487176,
                                         0.495486311487176,
                                         0.460349720094257,
                                         0.395110315692245,
                                         0.309114473301442,
                                         0.214682089918914,
                                         0.125341310726298,
                                         0.0538890128931006,
                                         0.0105428949188242,
                                         2.80850447628071e-05,
                                         0.000767982016833162,
                                         0.00451374344293494,
                                         0.0149567508630415,
                                         0.036504641147957,
                                         0.0734364533252639,
                                         0.129023364563242,
                                         0.204750589337593,
                                         0.29976309917523,
                                         0.410626915342501,
                                         0.531453230982491,
                                         0.654380885550601,
                                         0.770361159218045,
                                         0.870144945830767,
                                         0.945343005090066,
                                         0.989429020036413,

                                         0.990597680730804,
                                         0.951283747806964,
                                         0.883824818801993,
                                         0.793448036520103,
                                         0.686968418024702,
                                         0.572058165247744,
                                         0.456456819641668,
                                         0.347206241508985,
                                         0.25,
                                         0.168722060013137,
                                         0.105225056187792,
                                         0.0593676281612665,
                                         0.029297258808011,
                                         0.0119340326233018,
                                         0.00358566507500712,
                                         0.000608226038195817,
                                         2.22054163872912e-05,
                                         0.00938011385280839,
                                         0.0481080261548403,
                                         0.112589516123,
                                         0.194617930856595,
                                         0.283734323167287,
                                         0.36857420659099,
                                         0.43831812417054,
                                         0.484071698477879,
                                         0.5,
                                         0.484071698477879,
                                         0.43831812417054,
                                         0.36857420659099,
                                         0.283734323167287,
                                         0.194617930856595,
                                         0.112589516123,
                                         0.0481080261548402,
                                         0.0093801138528085,
                                         2.22054163872907e-05,
                                         0.000608226038195819,
                                         0.00358566507500712,
                                         0.0119340326233018,
                                         0.029297258808011,
                                         0.0593676281612665,
                                         0.105225056187792,
                                         0.168722060013137,
                                         0.25,
                                         0.347206241508985,
                                         0.456456819641668,
                                         0.572058165247744,
                                         0.686968418024702,
                                         0.793448036520103,
                                         0.883824818801993,
                                         0.951283747806964,
                                         0.990597680730804,

                                         0.991582955016873,
                                         0.956311830429266,
                                         0.895486024048158,
                                         0.813337894755518,
                                         0.71545126291457,
                                         0.608221261367279,
                                         0.498260335472922,
                                         0.391804780519031,
                                         0.294184207229924,
                                         0.209409194188189,
                                         0.139918554827525,
                                         0.0865091740100785,
                                         0.0484504302933306,
                                         0.0237642198542172,
                                         0.00963293578299473,
                                         0.00288355755060214,
                                         0.000487880857867596,
                                         1.77865959418149e-05,
                                         0.00839925838718536,
                                         0.0432002887128668,
                                         0.10163041840124,
                                         0.177029169461488,
                                         0.260784517231213,
                                         0.343328308339391,
                                         0.415230490517,
                                         0.468276664653444,
                                         0.496406598581887,
                                         0.496406598581887,
                                         0.468276664653444,
                                         0.415230490517,
                                         0.343328308339391,
                                         0.260784517231213,
                                         0.177029169461488,
                                         0.10163041840124,
                                         0.0432002887128668,
                                         0.00839925838718536,
                                         1.77865959418149e-05,
                                         0.000487880857867596,
                                         0.00288355755060214,
                                         0.00963293578299472,
                                         0.0237642198542172,
                                         0.0484504302933306,
                                         0.0865091740100785,
                                         0.139918554827525,
                                         0.209409194188189,
                                         0.294184207229924,
                                         0.391804780519031,
                                         0.498260335472922,
                                         0.608221261367279,
                                         0.71545126291457,
                                         0.813337894755518,
                                         0.895486024048158,
                                         0.956311830429266,
                                         0.991582955016873,

                                         0.992421257848688,
                                         0.960603999923961,
                                         0.905500598365984,
                                         0.830572179788829,
                                         0.740431145882958,
                                         0.640436318068638,
                                         0.536241864123633,
                                         0.433335257328261,
                                         0.336608046628004,
                                         0.25,
                                         0.176249400987779,
                                         0.116771157364631,
                                         0.071671122747672,
                                         0.0398910134069573,
                                         0.0194649685477287,
                                         0.00785752325168579,
                                         0.0023446947511656,
                                         0.000395847789131208,
                                         1.44140051039295e-05,
                                         0.00756432814620812,
                                         0.0390001522869076,
                                         0.0921547068828508,
                                         0.161570296959485,
                                         0.240103885569314,
                                         0.319672668524404,
                                         0.392087013128695,
                                         0.449893585307108,
                                         0.487142552384216,
                                         0.5,
                                         0.487142552384216,
                                         0.449893585307108,
                                         0.392087013128695,
                                         0.319672668524404,
                                         0.240103885569314,
                                         0.161570296959485,
                                         0.0921547068828508,
                                         0.0390001522869076,
                                         0.00756432814620812,
                                         1.44140051039295e-05,
                                         0.000395847789131208,
                                         0.0023446947511656,
                                         0.00785752325168579,
                                         0.0194649685477287,
                                         0.0398910134069573,
                                         0.071671122747672,
                                         0.116771157364631,
                                         0.176249400987779,
                                         0.25,
                                         0.336608046628004,
                                         0.433335257328261,
                                         0.536241864123633,
                                         0.640436318068638,
                                         0.740431145882958,
                                         0.830572179788829,
                                         0.905500598365984,
                                         0.960603999923961,
                                         0.992421257848688,

                                         0.993140403222385,
                                         0.964296432783931,
                                         0.914160127147419,
                                         0.845587809011132,
                                         0.762418781880186,
                                         0.669167911554694,
                                         0.57067977439597,
                                         0.471767104543454,
                                         0.376864524065903,
                                         0.289727337675948,
                                         0.21320081654245,
                                         0.149078672924258,
                                         0.0980610158280343,
                                         0.0598127724451431,
                                         0.0331142308281793,
                                         0.0160868754200354,
                                         0.00647083718891318,
                                         0.00192569889609291,
                                         0.000324505506016981,
                                         1.18040372897697e-05,
                                         0.00684779274032547,
                                         0.035379061710052,
                                         0.0839141739564882,
                                         0.147941353799955,
                                         0.221494342699778,
                                         0.297717857617126,
                                         0.369507453158887,
                                         0.430171879628511,
                                         0.474056803009838,
                                         0.497071845781602,
                                         0.497071845781602,
                                         0.474056803009838,
                                         0.430171879628511,
                                         0.369507453158887,
                                         0.297717857617126,
                                         0.221494342699778,
                                         0.147941353799955,
                                         0.0839141739564882,
                                         0.0353790617100521,
                                         0.00684779274032558,
                                         1.18040372897693e-05,
                                         0.000324505506016979,
                                         0.00192569889609291,
                                         0.00647083718891317,
                                         0.0160868754200354,
                                         0.0331142308281794,
                                         0.0598127724451431,
                                         0.0980610158280343,
                                         0.149078672924258,
                                         0.21320081654245,
                                         0.289727337675948,
                                         0.376864524065903,
                                         0.471767104543454,
                                         0.57067977439597,
                                         0.669167911554694,
                                         0.762418781880186,
                                         0.845587809011132,
                                         0.914160127147419,
                                         0.964296432783931,
                                         0.993140403222385,

                                         0.993761929463378,
                                         0.967495358593896,
                                         0.921695363251203,
                                         0.858738940294898,
                                         0.781844976104464,
                                         0.694837948115194,
                                         0.601880252970003,
                                         0.507187618849256,
                                         0.414749728134348,
                                         0.328077990427137,
                                         0.25,
                                         0.182516136266242,
                                         0.126728411331947,
                                         0.0828454986418167,
                                         0.0502614170827829,
                                         0.0276991439177822,
                                         0.0134050126287863,
                                         0.00537557571158131,
                                         0.00159602910080231,
                                         0.000268520027589744,
                                         9.75884298918222e-06,
                                         0.00622831169363263,
                                         0.0322361213785145,
                                         0.0767086076479944,
                                         0.13588548399352,
                                         0.204750011266749,
                                         0.277462907967024,
                                         0.347858329947214,
                                         0.409966882508928,
                                         0.458521860533705,
                                         0.489405873306621,
                                         0.5,
                                         0.489405873306621,
                                         0.458521860533705,
                                         0.409966882508928,
                                         0.347858329947214,
                                         0.277462907967024,
                                         0.204750011266749,
                                         0.13588548399352,
                                         0.0767086076479942,
                                         0.0322361213785146,
                                         0.00622831169363252,
                                         9.75884298918257e-06,
                                         0.000268520027589742,
                                         0.00159602910080232,
                                         0.00537557571158131,
                                         0.0134050126287863,
                                         0.0276991439177822,
                                         0.0502614170827829,
                                         0.0828454986418167,
                                         0.126728411331947,
                                         0.182516136266242,
                                         0.25,
                                         0.328077990427137,
                                         0.414749728134348,
                                         0.507187618849256,
                                         0.601880252970003,
                                         0.694837948115194,
                                         0.781844976104464,
                                         0.858738940294898,
                                         0.921695363251203,
                                         0.967495358593896,
                                         0.993761929463378,

                                         0.994302723421103,
                                         0.970284591282895,
                                         0.928290600469503,
                                         0.870314143794818,
                                         0.799072232935424,
                                         0.717821771275474,
                                         0.630150512711898,
                                         0.539751644656441,
                                         0.450197936848328,
                                         0.364731702589863,
                                         0.286085528220652,
                                         0.21634625490093,
                                         0.156871275901642,
                                         0.108262115956244,
                                         0.0703958066696842,
                                         0.0425101092049856,
                                         0.0233345080887908,
                                         0.0112554269562163,
                                         0.00450156607451763,
                                         0.0013338282823291,
                                         0.000224093447465588,
                                         8.13793870441301e-06,
                                         0.00568913864019216,
                                         0.0294913152696398,
                                         0.0703755712481678,
                                         0.125184290130665,
                                         0.189672340108359,
                                         0.258843720635735,
                                         0.327339378083117,
                                         0.389852548673875,
                                         0.441539947195428,
                                         0.478397021508495,
                                         0.497568216878419,
                                         0.497568216878419,
                                         0.478397021508495,
                                         0.441539947195428,
                                         0.389852548673875,
                                         0.327339378083117,
                                         0.258843720635735,
                                         0.189672340108359,
                                         0.125184290130665,
                                         0.0703755712481679,
                                         0.0294913152696398,
                                         0.00568913864019216,
                                         8.13793870441301e-06,
                                         0.000224093447465588,
                                         0.0013338282823291,
                                         0.00450156607451763,
                                         0.0112554269562163,
                                         0.0233345080887908,
                                         0.0425101092049856,
                                         0.0703958066696842,
                                         0.108262115956244,
                                         0.156871275901642,
                                         0.21634625490093,
                                         0.286085528220652,
                                         0.364731702589863,
                                         0.450197936848328,
                                         0.539751644656441,
                                         0.630150512711898,
                                         0.717821771275474,
                                         0.799072232935424,
                                         0.870314143794818,
                                         0.928290600469503,
                                         0.970284591282895,
                                         0.994302723421103,

                                         0.994776174961644,
                                         0.972730950189817,
                                         0.934094305626337,
                                         0.880549853568416,
                                         0.814405535574553,
                                         0.738449220280643,
                                         0.655784037417783,
                                         0.56964867790482,
                                         0.483234244087026,
                                         0.399509754975589,
                                         0.321067757454761,
                                         0.25,
                                         0.187810933156295,
                                         0.135374074005244,
                                         0.0929332060567352,
                                         0.0601472000588126,
                                         0.0361741616541372,
                                         0.0197878571486931,
                                         0.00951713395571277,
                                         0.00379749529797437,
                                         0.00112321880032137,
                                         0.000188478971702011,
                                         6.83996409195817e-06,
                                         0.00521698507426404,
                                         0.027080570838481,
                                         0.0647824755733412,
                                         0.115652651133609,
                                         0.176077330469734,
                                         0.241762922570664,
                                         0.30804180092808,
                                         0.370204122036367,
                                         0.423832549856239,
                                         0.465116171019166,
                                         0.491121309388944,
                                         0.5,
                                         0.491121309388944,
                                         0.465116171019166,
                                         0.423832549856239,
                                         0.370204122036367,
                                         0.30804180092808,
                                         0.241762922570664,
                                         0.176077330469734,
                                         0.115652651133609,
                                         0.0647824755733413,
                                         0.027080570838481,
                                         0.00521698507426393,
                                         6.83996409195846e-06,
                                         0.000188478971702011,
                                         0.00112321880032137,
                                         0.00379749529797437,
                                         0.00951713395571277,
                                         0.0197878571486931,
                                         0.0361741616541372,
                                         0.0601472000588126,
                                         0.0929332060567352,
                                         0.135374074005244,
                                         0.187810933156295,
                                         0.25,
                                         0.321067757454761,
                                         0.399509754975589,
                                         0.483234244087026,
                                         0.56964867790482,
                                         0.655784037417783,
                                         0.738449220280643,
                                         0.814405535574553,
                                         0.880549853568416,
                                         0.934094305626337,
                                         0.972730950189817,
                                         0.994776174961644,

                                         0.99519301070986,
                                         0.974888217442133,
                                         0.939227059735349,
                                         0.889640885130823,
                                         0.828101807237238,
                                         0.757008050529229,
                                         0.67905317138874,
                                         0.597081881057412,
                                         0.513940955627649,
                                         0.432334312355616,
                                         0.354691039112907,
                                         0.283054267812106,
                                         0.2189973749495,
                                         0.163572171639291,
                                         0.117291632659453,
                                         0.0801474480016044,
                                         0.0516604096685718,
                                         0.0309595194517636,
                                         0.016883858950675,
                                         0.00809982126333476,
                                         0.00322535812642199,
                                         0.000952507732615824,
                                         0.000159661470823815,
                                         5.79071283926842e-06,
                                         0.00480119857730049,
                                         0.0249521210870433,
                                         0.0598204325320353,
                                         0.107133756742755,
                                         0.163798371499428,
                                         0.226108090520096,
                                         0.289987309159497,
                                         0.351257709274016,
                                         0.405911596370746,
                                         0.45037405498493,
                                         0.481736789247801,
                                         0.497948357238394,
                                         0.497948357238394,
                                         0.481736789247801,
                                         0.45037405498493,
                                         0.405911596370746,
                                         0.351257709274016,
                                         0.289987309159497,
                                         0.226108090520096,
                                         0.163798371499428,
                                         0.107133756742755,
                                         0.0598204325320352,
                                         0.0249521210870433,
                                         0.00480119857730037,
                                         5.79071283926869e-06,
                                         0.000159661470823815,
                                         0.000952507732615828,
                                         0.00322535812642199,
                                         0.00809982126333476,
                                         0.016883858950675,
                                         0.0309595194517636,
                                         0.0516604096685718,
                                         0.0801474480016044,
                                         0.117291632659453,
                                         0.163572171639291,
                                         0.2189973749495,
                                         0.283054267812106,
                                         0.354691039112907,
                                         0.432334312355616,
                                         0.513940955627649,
                                         0.597081881057412,
                                         0.67905317138874,
                                         0.757008050529229,
                                         0.828101807237238,
                                         0.889640885130823,
                                         0.939227059735349,
                                         0.974888217442133,
                                         0.99519301070986,

                                         0.125,
                                         0.375,
                                         0.375,
                                         0.125,

                                         0.490562612162344,
                                         0.00943738783765592,
                                         0.394337567297406,
                                         0.105662432702593,
                                         0.105662432702593,
                                         0.394337567297406,
                                         0.00943738783765592,
                                         0.490562612162344,

                                         0.698568501158667,
                                         0.125,
                                         0.00143149884133249,
                                         0.266189500386223,
                                         0.375,
                                         0.0338104996137776,
                                         0.0338104996137776,
                                         0.375,
                                         0.266189500386223,
                                         0.00143149884133249,
                                         0.125,
                                         0.698568501158667,

                                         0.805832094644763,
                                         0.300750235878433,
                                         0.0359400966193527,
                                         0.000334715714594482,
                                         0.180374993816148,
                                         0.44441119023977,
                                         0.218898477262444,
                                         0.0134581958244945,
                                         0.0134581958244945,
                                         0.218898477262444,
                                         0.44441119023977,
                                         0.180374993816148,
                                         0.000334715714594481,
                                         0.0359400966193527,
                                         0.300750235878433,
                                         0.805832094644763,

                                         0.865768206669165,
                                         0.455173033583358,
                                         0.125,
                                         0.0122888648609099,
                                         0.000103228219900906,
                                         0.127836583789568,
                                         0.409646762852719,
                                         0.375,
                                         0.122891338703014,
                                         0.00629198132136692,
                                         0.0062919813213669,
                                         0.122891338703014,
                                         0.375,
                                         0.409646762852719,
                                         0.127836583789568,
                                         0.000103228219900906,
                                         0.0122888648609099,
                                         0.125,
                                         0.455173033583358,
                                         0.865768206669165,

                                         0.902086050717951,
                                         0.57303763020425,
                                         0.23753270895737,
                                         0.0551716280178859,
                                         0.00486075935907112,
                                         3.84954707455275e-05,
                                         0.0945706653395711,
                                         0.350599578649969,
                                         0.438034989227942,
                                         0.269260673796802,
                                         0.07150203178671,
                                         0.00330478847173213,
                                         0.00330478847173213,
                                         0.07150203178671,
                                         0.269260673796802,
                                         0.438034989227942,
                                         0.350599578649969,
                                         0.0945706653395711,
                                         3.84954707455275e-05,
                                         0.00486075935907113,
                                         0.0551716280178859,
                                         0.23753270895737,
                                         0.57303763020425,
                                         0.902086050717951,

                                         0.925587895611168,
                                         0.660242961824405,
                                         0.347314148267595,
                                         0.125,
                                         0.0262185669048118,
                                         0.0021584125879273,
                                         1.64763425536365e-05,
                                         0.0725025536343552,
                                         0.293969267338208,
                                         0.440357997435717,
                                         0.375,
                                         0.186109287391876,
                                         0.0436293582494593,
                                         0.0018930744119234,
                                         0.00189307441192339,
                                         0.0436293582494593,
                                         0.186109287391876,
                                         0.375,
                                         0.440357997435717,
                                         0.293969267338208,
                                         0.0725025536343554,
                                         1.64763425536364e-05,
                                         0.0021584125879273,
                                         0.0262185669048118,
                                         0.125,
                                         0.347314148267595,
                                         0.660242961824405,
                                         0.925587895611168,

                                         0.941609629025734,
                                         0.724957266278801,
                                         0.443786747427108,
                                         0.207177623714129,
                                         0.0680585773365012,
                                         0.0133514879772403,
                                         0.00105084089717636,
                                         7.82734330921435e-06,
                                         0.0572233540381443,
                                         0.246136024460014,
                                         0.414076607997518,
                                         0.428855293651718,
                                         0.295908505297651,
                                         0.128785156598134,
                                         0.0278558683640082,
                                         0.00115918959281207,
                                         0.00115918959281207,
                                         0.0278558683640082,
                                         0.128785156598134,
                                         0.295908505297652,
                                         0.428855293651718,
                                         0.414076607997518,
                                         0.246136024460014,
                                         0.0572233540381443,
                                         7.82734330921435e-06,
                                         0.00105084089717636,
                                         0.0133514879772403,
                                         0.0680585773365012,
                                         0.207177623714129,
                                         0.443786747427108,
                                         0.724957266278801,
                                         0.941609629025734,

                                         0.952996652246962,
                                         0.77365995500234,
                                         0.524944151363565,
                                         0.290284151818232,
                                         0.125,
                                         0.0385710601235858,
                                         0.00722423447631573,
                                         0.000551054311011232,
                                         4.0347756351666e-06,
                                         0.0462510895431489,
                                         0.207277805296286,
                                         0.377393080800071,
                                         0.444382891592836,
                                         0.375,
                                         0.226761896465347,
                                         0.0904385333600487,
                                         0.0185111853903632,
                                         0.000748223434253312,
                                         0.000748223434253307,
                                         0.0185111853903632,
                                         0.0904385333600486,
                                         0.226761896465347,
                                         0.375,
                                         0.444382891592836,
                                         0.377393080800071,
                                         0.207277805296286,
                                         0.0462510895431491,
                                         4.03477563516656e-06,
                                         0.000551054311011232,
                                         0.00722423447631572,
                                         0.0385710601235858,
                                         0.125,
                                         0.290284151818232,
                                         0.524944151363565,
                                         0.77365995500234,
                                         0.952996652246962,

                                         0.961368223935969,
                                         0.810943857283931,
                                         0.592079306686002,
                                         0.368135777704715,
                                         0.189551663752774,
                                         0.0770710128526389,
                                         0.0227378980346186,
                                         0.00411871443619747,
                                         0.000307114006529612,
                                         2.22078030792999e-06,
                                         0.0381255656841281,
                                         0.176014449472144,
                                         0.339074453512729,
                                         0.436559433819058,
                                         0.421279193819537,
                                         0.31209812957505,
                                         0.172566890441608,
                                         0.0647275253650712,
                                         0.0127345792373946,
                                         0.00050398959959508,
                                         0.00050398959959508,
                                         0.0127345792373947,
                                         0.0647275253650712,
                                         0.172566890441608,
                                         0.31209812957505,
                                         0.421279193819537,
                                         0.436559433819058,
                                         0.339074453512729,
                                         0.176014449472144,
                                         0.0381255656841281,
                                         2.22078030792999e-06,
                                         0.000307114006529613,
                                         0.00411871443619747,
                                         0.0227378980346186,
                                         0.0770710128526389,
                                         0.189551663752774,
                                         0.368135777704715,
                                         0.592079306686002,
                                         0.810943857283931,
                                         0.961368223935969,

                                         0.967697190785277,
                                         0.839979979390638,
                                         0.647385241546223,
                                         0.43819335193245,
                                         0.255771657972871,
                                         0.125,
                                         0.0487184767176915,
                                         0.0139022415856712,
                                         0.00245622188663198,
                                         0.000180062539861009,
                                         1.28992839959871e-06,
                                         0.0319498955769315,
                                         0.150814003410728,
                                         0.30291374715526,
                                         0.416159731530989,
                                         0.441489894700467,
                                         0.375,
                                         0.254019970608971,
                                         0.13174467495089,
                                         0.0472447894118851,
                                         0.0090259546587731,
                                         0.000351623709392146,
                                         0.000351623709392142,
                                         0.0090259546587731,
                                         0.0472447894118851,
                                         0.13174467495089,
                                         0.254019970608971,
                                         0.375,
                                         0.441489894700467,
                                         0.416159731530989,
                                         0.30291374715526,
                                         0.150814003410728,
                                         0.0319498955769316,
                                         1.28992839959869e-06,
                                         0.000180062539861009,
                                         0.00245622188663198,
                                         0.0139022415856712,
                                         0.0487184767176915,
                                         0.125,
                                         0.255771657972871,
                                         0.43819335193245,
                                         0.647385241546223,
                                         0.839979979390638,
                                         0.967697190785277,

                                         0.97259517533054,
                                         0.862960822693408,
                                         0.693039789280884,
                                         0.499921481721771,
                                         0.319895267257738,
                                         0.178089316477891,
                                         0.0836732384776598,
                                         0.0315797414836979,
                                         0.00878530284879135,
                                         0.00152280651777266,
                                         0.000110187256748149,
                                         7.83696576333459e-07,
                                         0.0271513844055756,
                                         0.130364426425644,
                                         0.270297239247462,
                                         0.389919270835174,
                                         0.443536455465491,
                                         0.415344718289082,
                                         0.322892726755367,
                                         0.204988535793072,
                                         0.101373944594263,
                                         0.0351401649538812,
                                         0.00656456362419948,
                                         0.00025265656730845,
                                         0.000252656567308453,
                                         0.00656456362419946,
                                         0.0351401649538811,
                                         0.101373944594263,
                                         0.204988535793072,
                                         0.322892726755368,
                                         0.415344718289082,
                                         0.443536455465492,
                                         0.389919270835174,
                                         0.270297239247462,
                                         0.130364426425644,
                                         0.0271513844055754,
                                         7.83696576333474e-07,
                                         0.000110187256748149,
                                         0.00152280651777266,
                                         0.00878530284879134,
                                         0.0315797414836979,
                                         0.0836732384776598,
                                         0.178089316477891,
                                         0.319895267257738,
                                         0.499921481721771,
                                         0.693039789280884,
                                         0.862960822693408,
                                         0.97259517533054,

                                         0.976461719269374,
                                         0.881420178088515,
                                         0.73091906173222,
                                         0.553740939808814,
                                         0.379890988258222,
                                         0.232868491727414,
                                         0.125,
                                         0.0569647848172437,
                                         0.0209683225409581,
                                         0.00571856560076649,
                                         0.000976514925523745,
                                         6.99386039136033e-05,
                                         4.94627034447266e-07,
                                         0.0233516381661685,
                                         0.11362718126135,
                                         0.241505527561048,
                                         0.361760695143648,
                                         0.433925472579184,
                                         0.436915275295118,
                                         0.375,
                                         0.273251448160224,
                                         0.165215216621636,
                                         0.0787797994467713,
                                         0.0265988957812077,
                                         0.00488270204622096,
                                         0.000186147937423041,
                                         0.000186147937423044,
                                         0.00488270204622097,
                                         0.0265988957812077,
                                         0.0787797994467714,
                                         0.165215216621636,
                                         0.273251448160224,
                                         0.375,
                                         0.436915275295118,
                                         0.433925472579184,
                                         0.361760695143648,
                                         0.241505527561049,
                                         0.11362718126135,
                                         0.0233516381661684,
                                         4.94627034447277e-07,
                                         6.99386039136036e-05,
                                         0.000976514925523743,
                                         0.0057185656007665,
                                         0.0209683225409581,
                                         0.0569647848172437,
                                         0.125,
                                         0.232868491727414,
                                         0.379890988258222,
                                         0.553740939808814,
                                         0.73091906173222,
                                         0.881420178088515,
                                         0.976461719269374,

                                         0.97956649091304,
                                         0.896447684220326,
                                         0.762551553921164,
                                         0.600456366408335,
                                         0.43487227314286,
                                         0.28691641177508,
                                         0.17005676221076,
                                         0.0887001417443503,
                                         0.0394581162269978,
                                         0.0142385948088432,
                                         0.00382228634502808,
                                         0.000644957818697276,
                                         4.58156822197784e-05,
                                         3.22560077004606e-07,
                                         0.0202930537792146,
                                         0.0998027727369291,
                                         0.216343822581016,
                                         0.333848910745886,
                                         0.417367003060355,
                                         0.444293846068674,
                                         0.410669040383847,
                                         0.330574055661043,
                                         0.229331625929249,
                                         0.133522128987943,
                                         0.0618724365007512,
                                         0.0204596656791221,
                                         0.0037037273605253,
                                         0.000140132747668224,
                                         0.000140132747668224,
                                         0.00370372736052531,
                                         0.0204596656791221,
                                         0.0618724365007512,
                                         0.133522128987942,
                                         0.229331625929249,
                                         0.330574055661043,
                                         0.410669040383847,
                                         0.444293846068674,
                                         0.417367003060355,
                                         0.333848910745886,
                                         0.216343822581016,
                                         0.099802772736929,
                                         0.0202930537792146,
                                         3.22560077004606e-07,
                                         4.58156822197786e-05,
                                         0.000644957818697276,
                                         0.00382228634502807,
                                         0.0142385948088431,
                                         0.0394581162269978,
                                         0.0887001417443503,
                                         0.17005676221076,
                                         0.28691641177508,
                                         0.43487227314286,
                                         0.600456366408335,
                                         0.762551553921164,
                                         0.896447684220326,
                                         0.97956649091304,

                                         0.982096695344065,
                                         0.908830208348901,
                                         0.78915361751279,
                                         0.640969629994211,
                                         0.484635797152551,
                                         0.338719173633118,
                                         0.216645452608655,
                                         0.125,
                                         0.0637138449859316,
                                         0.0277972896691751,
                                         0.0098711192674354,
                                         0.00261615713755078,
                                         0.000437188592802236,
                                         3.0850727844252e-05,
                                         2.16404278856247e-07,
                                         0.0177956027468764,
                                         0.0882805226311001,
                                         0.194439828682863,
                                         0.307303494189384,
                                         0.397057783875142,
                                         0.441585963019283,
                                         0.432214080764774,
                                         0.375,
                                         0.287426621640639,
                                         0.191897573678423,
                                         0.108435299704872,
                                         0.0491107186788542,
                                         0.0159693652115451,
                                         0.0028584182921541,
                                         0.000107485504779716,
                                         0.000107485504779714,
                                         0.0028584182921541,
                                         0.015969365211545,
                                         0.0491107186788542,
                                         0.108435299704872,
                                         0.191897573678423,
                                         0.287426621640639,
                                         0.375,
                                         0.432214080764774,
                                         0.441585963019283,
                                         0.397057783875142,
                                         0.307303494189384,
                                         0.194439828682863,
                                         0.0882805226311001,
                                         0.0177956027468766,
                                         2.16404278856241e-07,
                                         3.0850727844252e-05,
                                         0.000437188592802235,
                                         0.00261615713755079,
                                         0.0098711192674354,
                                         0.0277972896691751,
                                         0.0637138449859316,
                                         0.125,
                                         0.216645452608655,
                                         0.338719173633118,
                                         0.484635797152551,
                                         0.640969629994211,
                                         0.78915361751279,
                                         0.908830208348901,
                                         0.982096695344065,

                                         0.984185508784156,
                                         0.919145197967567,
                                         0.811684780770974,
                                         0.676147687458413,
                                         0.529353644761741,
                                         0.387433863656307,
                                         0.263130456374242,
                                         0.164122171792289,
                                         0.0926483609769465,
                                         0.0463449634843732,
                                         0.0199006628053256,
                                         0.00697464528609555,
                                         0.00182917766321623,
                                         0.000303253139578489,
                                         2.1282692781575e-05,
                                         1.48837607601701e-07,
                                         0.0157305337567709,
                                         0.0785934213674962,
                                         0.175380495179378,
                                         0.282640415278895,
                                         0.375081722366579,
                                         0.432058101978553,
                                         0.442489376904778,
                                         0.406922782148825,
                                         0.33630668508194,
                                         0.248035203236607,
                                         0.160607371559815,
                                         0.0885899875855843,
                                         0.0393827195994759,
                                         0.0126314709100694,
                                         0.00224009797215476,
                                         8.38086214656144e-05,
                                         8.38086214656161e-05,
                                         0.00224009797215476,
                                         0.0126314709100694,
                                         0.0393827195994759,
                                         0.0885899875855843,
                                         0.160607371559815,
                                         0.248035203236607,
                                         0.33630668508194,
                                         0.406922782148825,
                                         0.442489376904778,
                                         0.432058101978553,
                                         0.375081722366579,
                                         0.282640415278895,
                                         0.175380495179378,
                                         0.0785934213674962,
                                         0.0157305337567707,
                                         1.48837607601705e-07,
                                         2.1282692781575e-05,
                                         0.000303253139578488,
                                         0.00182917766321623,
                                         0.00697464528609555,
                                         0.0199006628053256,
                                         0.0463449634843732,
                                         0.0926483609769465,
                                         0.164122171792289,
                                         0.263130456374242,
                                         0.387433863656307,
                                         0.529353644761741,
                                         0.676147687458413,
                                         0.811684780770974,
                                         0.919145197967567,
                                         0.984185508784156,

                                         0.98592972458304,
                                         0.927822960551749,
                                         0.830901014673583,
                                         0.706769394212492,
                                         0.569383866926132,
                                         0.432673486616657,
                                         0.308389476672479,
                                         0.204588531667483,
                                         0.125,
                                         0.0693039206156993,
                                         0.0341333370717103,
                                         0.0144652034968583,
                                         0.0050146483229375,
                                         0.00130370950261508,
                                         0.000214711141917221,
                                         1.5000215990329e-05,
                                         1.04637747447839e-07,
                                         0.0140038684432931,
                                         0.0703823617656441,
                                         0.15877141238523,
                                         0.260035926922833,
                                         0.35275365329571,
                                         0.41815403589326,
                                         0.444202028907566,
                                         0.427853129524506,
                                         0.375,
                                         0.298254418192312,
                                         0.213275157348245,
                                         0.134707273993225,
                                         0.0728478314552206,
                                         0.03189096936206,
                                         0.0101128617992697,
                                         0.00177967746661646,
                                         6.63023359195301e-05,
                                         6.63023359195286e-05,
                                         0.00177967746661647,
                                         0.0101128617992697,
                                         0.0318909693620601,
                                         0.0728478314552206,
                                         0.134707273993225,
                                         0.213275157348245,
                                         0.298254418192312,
                                         0.375,
                                         0.427853129524506,
                                         0.444202028907566,
                                         0.41815403589326,
                                         0.35275365329571,
                                         0.260035926922833,
                                         0.15877141238523,
                                         0.0703823617656439,
                                         0.0140038684432932,
                                         1.04637747447835e-07,
                                         1.50002159903291e-05,
                                         0.000214711141917221,
                                         0.00130370950261508,
                                         0.0050146483229375,
                                         0.0144652034968583,
                                         0.0341333370717103,
                                         0.0693039206156993,
                                         0.125,
                                         0.204588531667483,
                                         0.308389476672479,
                                         0.432673486616657,
                                         0.569383866926132,
                                         0.706769394212492,
                                         0.830901014673583,
                                         0.927822960551749,
                                         0.98592972458304,

                                         0.987401037405751,
                                         0.93518879060601,
                                         0.847399528913817,
                                         0.7335107970454,
                                         0.605159815706872,
                                         0.474342891159843,
                                         0.351709803657381,
                                         0.245247503945929,
                                         0.159561838617257,
                                         0.095828263509913,
                                         0.0523374990739049,
                                         0.0254444605671187,
                                         0.0106646463310713,
                                         0.00366340844630878,
                                         0.000945448762369001,
                                         0.000154843484323509,
                                         1.07763246901542e-05,
                                         7.50134705670802e-08,
                                         0.0125457528333643,
                                         0.0633691194697678,
                                         0.144259485403024,
                                         0.239481293130354,
                                         0.330874341623094,
                                         0.401635110622308,
                                         0.43965159544662,
                                         0.439671829719305,
                                         0.403867105838002,
                                         0.340742792034828,
                                         0.262743167260861,
                                         0.183194140328879,
                                         0.113357351886778,
                                         0.0603024342237251,
                                         0.0260624610618772,
                                         0.0081861421988359,
                                         0.00143131359953232,
                                         5.31347474137434e-05,
                                         5.31347474137434e-05,
                                         0.00143131359953232,
                                         0.0081861421988359,
                                         0.0260624610618772,
                                         0.0603024342237251,
                                         0.113357351886778,
                                         0.183194140328879,
                                         0.262743167260861,
                                         0.340742792034828,
                                         0.403867105838002,
                                         0.439671829719305,
                                         0.43965159544662,
                                         0.401635110622308,
                                         0.330874341623094,
                                         0.239481293130354,
                                         0.144259485403024,
                                         0.0633691194697678,
                                         0.0125457528333643,
                                         7.50134705670802e-08,
                                         1.07763246901542e-05,
                                         0.000154843484323509,
                                         0.000945448762368999,
                                         0.00366340844630878,
                                         0.0106646463310713,
                                         0.0254444605671187,
                                         0.0523374990739049,
                                         0.095828263509913,
                                         0.159561838617257,
                                         0.245247503945929,
                                         0.351709803657381,
                                         0.474342891159843,
                                         0.605159815706872,
                                         0.7335107970454,
                                         0.847399528913817,
                                         0.93518879060601,
                                         0.987401037405751,

                                         0.988653453056792,
                                         0.941491895812137,
                                         0.861654404753486,
                                         0.756948042706551,
                                         0.637128479355068,
                                         0.512523670909787,
                                         0.392682072248188,
                                         0.285256821523445,
                                         0.195293028548436,
                                         0.125,
                                         0.073993142875239,
                                         0.0399028005158925,
                                         0.0191874080587693,
                                         0.00796732630360646,
                                         0.00271569229096114,
                                         0.00069651185422125,
                                         0.000113534922237856,
                                         7.87575750143646e-06,
                                         5.47238957967567e-08,
                                         0.0113034143756878,
                                         0.057336312335472,
                                         0.131538580837493,
                                         0.220872411246834,
                                         0.309907999583667,
                                         0.383737941476554,
                                         0.430679375626334,
                                         0.444235307414448,
                                         0.423945054238704,
                                         0.375,
                                         0.306768774337621,
                                         0.230605070546215,
                                         0.157451144066708,
                                         0.0957710613100525,
                                         0.0502478287703028,
                                         0.0214830341923936,
                                         0.00669347948678325,
                                         0.00116391609488932,
                                         4.30778436243982e-05,
                                         4.30778436243982e-05,
                                         0.00116391609488932,
                                         0.00669347948678325,
                                         0.0214830341923936,
                                         0.0502478287703027,
                                         0.0957710613100526,
                                         0.157451144066708,
                                         0.230605070546215,
                                         0.306768774337621,
                                         0.375,
                                         0.423945054238704,
                                         0.444235307414448,
                                         0.430679375626334,
                                         0.383737941476554,
                                         0.309907999583668,
                                         0.220872411246834,
                                         0.131538580837493,
                                         0.057336312335472,
                                         0.0113034143756878,
                                         5.47238957967567e-08,
                                         7.87575750143646e-06,
                                         0.000113534922237856,
                                         0.00069651185422125,
                                         0.00271569229096114,
                                         0.00796732630360647,
                                         0.0191874080587693,
                                         0.0399028005158925,
                                         0.073993142875239,
                                         0.125,
                                         0.195293028548436,
                                         0.285256821523445,
                                         0.392682072248188,
                                         0.512523670909787,
                                         0.637128479355068,
                                         0.756948042706551,
                                         0.861654404753486,
                                         0.941491895812137,
                                         0.988653453056792,

                                         0.989728270334376,
                                         0.946925561780937,
                                         0.874044234032952,
                                         0.777567445359169,
                                         0.665718122440926,
                                         0.547397312361567,
                                         0.431110619907807,
                                         0.324034671983494,
                                         0.231354465222673,
                                         0.155949581452779,
                                         0.0984426498748178,
                                         0.0575603302625696,
                                         0.0307075085737394,
                                         0.0146282003538629,
                                         0.00602590121274422,
                                         0.00204036350940672,
                                         0.000520523940898876,
                                         8.45050323156925e-05,
                                         5.84565398474856e-06,
                                         4.05551357260468e-08,
                                         0.0102363986640261,
                                         0.0521126130089813,
                                         0.120347679343401,
                                         0.204061090955889,
                                         0.290101978317781,
                                         0.365311797579384,
                                         0.41870746346449,
                                         0.443197297679882,
                                         0.436530176529691,
                                         0.401333268669506,
                                         0.344274500002897,
                                         0.274555027985066,
                                         0.202060521762885,
                                         0.135553716273841,
                                         0.0812649888463054,
                                         0.042139535731886,
                                         0.0178509397440429,
                                         0.00552358159133166,
                                         0.000955979556096696,
                                         3.52904464621309e-05,
                                         3.52904464621297e-05,
                                         0.000955979556096691,
                                         0.00552358159133166,
                                         0.0178509397440429,
                                         0.042139535731886,
                                         0.0812649888463054,
                                         0.13555371627384,
                                         0.202060521762885,
                                         0.274555027985066,
                                         0.344274500002897,
                                         0.401333268669506,
                                         0.436530176529691,
                                         0.443197297679882,
                                         0.41870746346449,
                                         0.365311797579384,
                                         0.290101978317781,
                                         0.204061090955889,
                                         0.120347679343401,
                                         0.0521126130089815,
                                         0.0102363986640262,
                                         4.05551357260449e-08,
                                         5.84565398474851e-06,
                                         8.45050323156925e-05,
                                         0.000520523940898875,
                                         0.00204036350940672,
                                         0.00602590121274422,
                                         0.0146282003538629,
                                         0.0307075085737394,
                                         0.0575603302625696,
                                         0.0984426498748178,
                                         0.155949581452779,
                                         0.231354465222673,
                                         0.324034671983494,
                                         0.431110619907807,
                                         0.547397312361567,
                                         0.665718122440926,
                                         0.777567445359169,
                                         0.874044234032952,
                                         0.946925561780937,
                                         0.989728270334376,

                                         0.990657501973758,
                                         0.951641417807122,
                                         0.884873326634074,
                                         0.795777645841832,
                                         0.691322950492911,
                                         0.579195652965874,
                                         0.466944368728411,
                                         0.361204344187356,
                                         0.26710324548752,
                                         0.187916815511546,
                                         0.125,
                                         0.0779743745285226,
                                         0.0451139637119216,
                                         0.0238453320492528,
                                         0.0112681363507681,
                                         0.00460998508359048,
                                         0.00155203260696538,
                                         0.000394128167886962,
                                         6.37618939347207e-05,
                                         4.40012510618934e-06,
                                         3.04857929694112e-08,
                                         0.0093132824688603,
                                         0.0475618223603211,
                                         0.110466109851389,
                                         0.188883883359198,
                                         0.271566076834661,
                                         0.34692688544796,
                                         0.404807652724777,
                                         0.4379498239857,
                                         0.442939447940483,
                                         0.420483524746774,
                                         0.375,
                                         0.313625285213158,
                                         0.244843342860076,
                                         0.177000499777692,
                                         0.116979842196045,
                                         0.0692674765025752,
                                         0.0355589400654629,
                                         0.014944342631083,
                                         0.00459680162060278,
                                         0.000792359707450664,
                                         2.91850715886384e-05,
                                         2.91850715886395e-05,
                                         0.000792359707450659,
                                         0.00459680162060279,
                                         0.014944342631083,
                                         0.0355589400654629,
                                         0.0692674765025752,
                                         0.116979842196045,
                                         0.177000499777691,
                                         0.244843342860076,
                                         0.313625285213158,
                                         0.375,
                                         0.420483524746774,
                                         0.442939447940483,
                                         0.4379498239857,
                                         0.404807652724777,
                                         0.34692688544796,
                                         0.271566076834661,
                                         0.188883883359198,
                                         0.110466109851389,
                                         0.0475618223603213,
                                         0.00931328246886014,
                                         3.04857929694128e-08,
                                         4.4001251061893e-06,
                                         6.3761893934721e-05,
                                         0.000394128167886962,
                                         0.00155203260696538,
                                         0.00460998508359048,
                                         0.0112681363507681,
                                         0.0238453320492528,
                                         0.0451139637119216,
                                         0.0779743745285226,
                                         0.125,
                                         0.187916815511546,
                                         0.26710324548752,
                                         0.361204344187356,
                                         0.466944368728411,
                                         0.579195652965874,
                                         0.691322950492911,
                                         0.795777645841832,
                                         0.884873326634074,
                                         0.951641417807122,
                                         0.990657501973758,

                                         0.991466268824555,
                                         0.955759672472413,
                                         0.894387929566203,
                                         0.811921538030122,
                                         0.714297383616642,
                                         0.608169924332197,
                                         0.500226207136002,
                                         0.396543615069448,
                                         0.302068368974242,
                                         0.220272494958456,
                                         0.153018462533024,
                                         0.100629212149348,
                                         0.0621319727788005,
                                         0.0356217102326158,
                                         0.0186775619197404,
                                         0.00876472573932248,
                                         0.00356449471419948,
                                         0.00119410622081884,
                                         0.000302026773880634,
                                         4.87135615446777e-05,
                                         3.35462312773106e-06,
                                         2.32151568137525e-08,
                                         0.00850936378964544,
                                         0.0435747564314461,
                                         0.101708012709898,
                                         0.175177817294086,
                                         0.254324547956347,
                                         0.328955540829829,
                                         0.389772916727686,
                                         0.42962408876098,
                                         0.444388703622258,
                                         0.433377622894219,
                                         0.399201197062882,
                                         0.347151128254746,
                                         0.284217909368524,
                                         0.217921217170884,
                                         0.155154734249831,
                                         0.101236150396989,
                                         0.0593100401237739,
                                         0.0301839622061922,
                                         0.012598617901911,
                                         0.00385534416235328,
                                         0.000662216473013569,
                                         2.43441706427978e-05,
                                         2.43441706427978e-05,
                                         0.000662216473013569,
                                         0.00385534416235327,
                                         0.012598617901911,
                                         0.0301839622061923,
                                         0.0593100401237739,
                                         0.101236150396989,
                                         0.155154734249831,
                                         0.217921217170884,
                                         0.284217909368524,
                                         0.347151128254746,
                                         0.399201197062882,
                                         0.433377622894219,
                                         0.444388703622258,
                                         0.42962408876098,
                                         0.389772916727686,
                                         0.328955540829829,
                                         0.254324547956347,
                                         0.175177817294086,
                                         0.101708012709899,
                                         0.0435747564314461,
                                         0.00850936378964544,
                                         2.32151568137525e-08,
                                         3.35462312773106e-06,
                                         4.87135615446774e-05,
                                         0.000302026773880635,
                                         0.00119410622081884,
                                         0.00356449471419948,
                                         0.00876472573932248,
                                         0.0186775619197404,
                                         0.0356217102326158,
                                         0.0621319727788004,
                                         0.100629212149348,
                                         0.153018462533024,
                                         0.220272494958456,
                                         0.302068368974242,
                                         0.396543615069448,
                                         0.500226207136002,
                                         0.608169924332197,
                                         0.714297383616642,
                                         0.811921538030122,
                                         0.894387929566203,
                                         0.955759672472413,
                                         0.991466268824555,

                                         0.992174504499824,
                                         0.959376556158883,
                                         0.902788642572267,
                                         0.826287007129609,
                                         0.734955552686345,
                                         0.634572071765628,
                                         0.531057151684999,
                                         0.429942760575175,
                                         0.335920535582988,
                                         0.252517268080181,
                                         0.181926113598906,
                                         0.125,
                                         0.0813919223176779,
                                         0.0498084753910697,
                                         0.0283306396326543,
                                         0.014751056370274,
                                         0.0068801469228816,
                                         0.00278354437837652,
                                         0.000928451609053365,
                                         0.000234016169977213,
                                         3.7644067721064e-05,
                                         2.58758339514403e-06,
                                         1.78887803969028e-08,
                                         0.00780501138546137,
                                         0.0400631820928009,
                                         0.0939169891622109,
                                         0.162788539316422,
                                         0.238349948664623,
                                         0.311631445545046,
                                         0.374180657198353,
                                         0.419117751988935,
                                         0.441941125512115,
                                         0.440977460686225,
                                         0.417424931567564,
                                         0.375,
                                         0.319257032515852,
                                         0.256696795842524,
                                         0.193807699272243,
                                         0.136188431065616,
                                         0.0878820441937668,
                                         0.0510129383109499,
                                         0.0257660470399782,
                                         0.0106904373839915,
                                         0.00325672419780093,
                                         0.000557674164920601,
                                         2.04662259346838e-05,
                                         2.04662259346847e-05,
                                         0.000557674164920601,
                                         0.00325672419780092,
                                         0.0106904373839915,
                                         0.0257660470399782,
                                         0.0510129383109498,
                                         0.0878820441937668,
                                         0.136188431065616,
                                         0.193807699272243,
                                         0.256696795842524,
                                         0.319257032515852,
                                         0.375,
                                         0.417424931567564,
                                         0.440977460686225,
                                         0.441941125512115,
                                         0.419117751988935,
                                         0.374180657198353,
                                         0.311631445545046,
                                         0.238349948664623,
                                         0.162788539316422,
                                         0.0939169891622111,
                                         0.0400631820928009,
                                         0.00780501138546121,
                                         1.78887803969039e-08,
                                         2.58758339514403e-06,
                                         3.76440677210638e-05,
                                         0.000234016169977213,
                                         0.000928451609053365,
                                         0.00278354437837651,
                                         0.0068801469228816,
                                         0.014751056370274,
                                         0.0283306396326543,
                                         0.0498084753910697,
                                         0.0813919223176779,
                                         0.125,
                                         0.181926113598906,
                                         0.252517268080181,
                                         0.335920535582988,
                                         0.429942760575175,
                                         0.531057151684999,
                                         0.634572071765628,
                                         0.734955552686345,
                                         0.826287007129609,
                                         0.902788642572267,
                                         0.959376556158883,
                                         0.992174504499824,

                                         0.992798188199336,
                                         0.962569800931473,
                                         0.910239954218689,
                                         0.839116189584362,
                                         0.753573466880175,
                                         0.658644010972816,
                                         0.559571610546727,
                                         0.461371579581681,
                                         0.368442602741025,
                                         0.284269036322364,
                                         0.211239594405603,
                                         0.150592922359824,
                                         0.102484541782584,
                                         0.0661552217226951,
                                         0.0401698812002406,
                                         0.0226900027028562,
                                         0.0117418565072945,
                                         0.00544742571402813,
                                         0.00219385324704017,
                                         0.000728975870683305,
                                         0.000183175301505857,
                                         2.93969832582863e-05,
                                         2.01743796173126e-06,
                                         1.39347134779122e-08,
                                         0.00718446753157336,
                                         0.0369552495319788,
                                         0.0869613165499804,
                                         0.151574086639384,
                                         0.223585021071187,
                                         0.295092118669239,
                                         0.358444682526039,
                                         0.407130904427193,
                                         0.436495058659875,
                                         0.444195828099757,
                                         0.430354334121913,
                                         0.397384036356843,
                                         0.349538499500748,
                                         0.292250849749789,
                                         0.231365254377638,
                                         0.172372335896245,
                                         0.119755659483832,
                                         0.0765362812132063,
                                         0.0440700171109045,
                                         0.0221125361779544,
                                         0.0091265484747484,
                                         0.00276933224807261,
                                         0.000472932098586252,
                                         1.73303343773715e-05,
                                         1.73303343773723e-05,
                                         0.000472932098586252,
                                         0.00276933224807262,
                                         0.00912654847474841,
                                         0.0221125361779544,
                                         0.0440700171109046,
                                         0.0765362812132063,
                                         0.119755659483832,
                                         0.172372335896245,
                                         0.231365254377638,
                                         0.292250849749789,
                                         0.349538499500748,
                                         0.397384036356843,
                                         0.430354334121913,
                                         0.444195828099757,
                                         0.436495058659875,
                                         0.407130904427193,
                                         0.358444682526039,
                                         0.295092118669239,
                                         0.223585021071187,
                                         0.151574086639384,
                                         0.0869613165499802,
                                         0.0369552495319788,
                                         0.00718446753157319,
                                         1.39347134779131e-08,
                                         2.01743796173126e-06,
                                         2.93969832582865e-05,
                                         0.000183175301505857,
                                         0.000728975870683305,
                                         0.00219385324704017,
                                         0.00544742571402813,
                                         0.0117418565072946,
                                         0.0226900027028562,
                                         0.0401698812002406,
                                         0.0661552217226951,
                                         0.102484541782584,
                                         0.150592922359824,
                                         0.211239594405603,
                                         0.284269036322364,
                                         0.368442602741025,
                                         0.461371579581681,
                                         0.559571610546727,
                                         0.658644010972816,
                                         0.753573466880175,
                                         0.839116189584362,
                                         0.910239954218689,
                                         0.962569800931473,
                                         0.992798188199336,

                                         0.0625,
                                         0.25,
                                         0.375,
                                         0.25,
                                         0.0625,

                                         0.38689453417432,
                                         0.00199435471456919,
                                         0.414672311952097,
                                         0.0297721324923469,
                                         0.166666666666667,
                                         0.166666666666667,
                                         0.0297721324923469,
                                         0.414672311952097,
                                         0.00199435471456919,
                                         0.38689453417432,

                                         0.619838667696593,
                                         0.0625,
                                         0.00016133230340665,
                                         0.314919333848297,
                                         0.25,
                                         0.00508066615170335,
                                         0.0600000000000002,
                                         0.375,
                                         0.0600000000000002,
                                         0.00508066615170335,
                                         0.25,
                                         0.314919333848297,
                                         0.00016133230340665,
                                         0.0625,
                                         0.619838667696593,

                                         0.749881686195632,
                                         0.201499807465387,
                                         0.0118605725320823,
                                         2.3239929348011e-05,
                                         0.223801633796524,
                                         0.397001713652184,
                                         0.0963180963490815,
                                         0.00124590314098588,
                                         0.0250475369375102,
                                         0.293319810001265,
                                         0.293319810001265,
                                         0.0250475369375102,
                                         0.00124590314098588,
                                         0.0963180963490815,
                                         0.397001713652184,
                                         0.223801633796524,
                                         2.3239929348011e-05,
                                         0.0118605725320823,
                                         0.201499807465387,
                                         0.749881686195632,

                                         0.825154953403611,
                                         0.35013487147785,
                                         0.0625,
                                         0.00283584413863688,
                                         4.84244374729024e-06,
                                         0.162453013062215,
                                         0.420152648422032,
                                         0.25,
                                         0.037812082889092,
                                         0.000393543104614463,
                                         0.0119936479858121,
                                         0.189064553072389,
                                         0.375,
                                         0.189064553072389,
                                         0.0119936479858121,
                                         0.000393543104614461,
                                         0.037812082889092,
                                         0.25,
                                         0.420152648422032,
                                         0.162453013062215,
                                         4.84244374729021e-06,
                                         0.00283584413863688,
                                         0.0625,
                                         0.35013487147785,
                                         0.825154953403611,

                                         0.87162689610018,
                                         0.475967745046842,
                                         0.147106285318457,
                                         0.0210033095226865,
                                         0.000823389822749775,
                                         1.29980892021191e-06,
                                         0.121836618471087,
                                         0.388279540629631,
                                         0.36170569455565,
                                         0.136673273980797,
                                         0.0161494781452854,
                                         0.000148782647301262,
                                         0.00638640297251237,
                                         0.118779846355492,
                                         0.333511436622409,
                                         0.333511436622409,
                                         0.118779846355492,
                                         0.00638640297251237,
                                         0.000148782647301262,
                                         0.0161494781452854,
                                         0.136673273980797,
                                         0.36170569455565,
                                         0.388279540629631,
                                         0.121836618471087,
                                         1.29980892021191e-06,
                                         0.000823389822749776,
                                         0.0210033095226865,
                                         0.147106285318457,
                                         0.475967745046842,
                                         0.87162689610018,

                                         0.902035345452205,
                                         0.574916854044856,
                                         0.244134955673384,
                                         0.0625,
                                         0.00778894432521501,
                                         0.000278941171294456,
                                         4.19257734755207e-07,
                                         0.0942102006358513,
                                         0.341304431118197,
                                         0.412716770376842,
                                         0.25,
                                         0.073718490318387,
                                         0.00751788566653136,
                                         6.42283392755251e-05,
                                         0.00368980631493349,
                                         0.0759818879991215,
                                         0.261640839306171,
                                         0.375,
                                         0.261640839306171,
                                         0.0759818879991215,
                                         0.00368980631493351,
                                         6.42283392755246e-05,
                                         0.00751788566653136,
                                         0.073718490318387,
                                         0.25,
                                         0.412716770376842,
                                         0.341304431118197,
                                         0.0942102006358515,
                                         4.19257734755204e-07,
                                         0.000278941171294456,
                                         0.00778894432521501,
                                         0.0625,
                                         0.244134955673384,
                                         0.574916854044856,
                                         0.902035345452205,

                                         0.922913902279778,
                                         0.651253208940273,
                                         0.338505533145703,
                                         0.122590588526614,
                                         0.0277871382670088,
                                         0.00316742416229615,
                                         0.000106835590650347,
                                         1.55412463025977e-07,
                                         0.0747829069838277,
                                         0.294816229354112,
                                         0.421124857125621,
                                         0.338348140750059,
                                         0.16108575627797,
                                         0.0407362552597765,
                                         0.00377602122610407,
                                         3.06877233847535e-05,
                                         0.00227234760054701,
                                         0.0500477048888603,
                                         0.196465930306603,
                                         0.350188376178348,
                                         0.350188376178348,
                                         0.196465930306603,
                                         0.0500477048888603,
                                         0.00227234760054701,
                                         3.06877233847535e-05,
                                         0.00377602122610407,
                                         0.0407362552597765,
                                         0.16108575627797,
                                         0.338348140750059,
                                         0.421124857125621,
                                         0.294816229354112,
                                         0.0747829069838277,
                                         1.55412463025977e-07,
                                         0.000106835590650347,
                                         0.00316742416229615,
                                         0.0277871382670088,
                                         0.122590588526614,
                                         0.338505533145703,
                                         0.651253208940273,
                                         0.922913902279778,

                                         0.937825059668174,
                                         0.71023187193861,
                                         0.423464948786615,
                                         0.192204890902582,
                                         0.0625,
                                         0.0130321309170995,
                                         0.00139654771270648,
                                         4.51778825896976e-05,
                                         6.42331449320857e-08,
                                         0.0606863703151551,
                                         0.253712332254917,
                                         0.405916810307799,
                                         0.392317043662598,
                                         0.25,
                                         0.102155716825945,
                                         0.023310747054437,
                                         0.00202350571368614,
                                         1.58821699609381e-05,
                                         0.00147262361356521,
                                         0.0339871122101972,
                                         0.145910946138442,
                                         0.300290217691775,
                                         0.375,
                                         0.300290217691775,
                                         0.145910946138442,
                                         0.0339871122101972,
                                         0.00147262361356522,
                                         1.58821699609379e-05,
                                         0.00202350571368614,
                                         0.023310747054437,
                                         0.102155716825945,
                                         0.25,
                                         0.392317043662598,
                                         0.4059168103078,
                                         0.253712332254917,
                                         0.0606863703151553,
                                         6.42331449320848e-08,
                                         4.51778825896976e-05,
                                         0.00139654771270648,
                                         0.0130321309170995,
                                         0.0625,
                                         0.192204890902582,
                                         0.423464948786615,
                                         0.71023187193861,
                                         0.937825059668174,

                                         0.948825506768084,
                                         0.756230840330861,
                                         0.497171826420162,
                                         0.263842064088064,
                                         0.108885521198418,
                                         0.0327985583797788,
                                         0.00644169887711723,
                                         0.000660210219576795,
                                         2.07204650418815e-05,
                                         2.89739338172986e-08,
                                         0.0501708686715405,
                                         0.218852067812284,
                                         0.37962992106336,
                                         0.417174854466607,
                                         0.322664570217423,
                                         0.177089817891441,
                                         0.0651847966300056,
                                         0.0138340168664827,
                                         0.00114557416595092,
                                         8.76722549645076e-06,
                                         0.000994828360945484,
                                         0.0237507972258629,
                                         0.108704025430418,
                                         0.247356585938207,
                                         0.358561532312939,
                                         0.358561532312939,
                                         0.247356585938207,
                                         0.108704025430418,
                                         0.0237507972258629,
                                         0.000994828360945484,
                                         8.76722549645076e-06,
                                         0.00114557416595093,
                                         0.0138340168664827,
                                         0.0651847966300056,
                                         0.177089817891441,
                                         0.322664570217423,
                                         0.417174854466607,
                                         0.37962992106336,
                                         0.218852067812284,
                                         0.0501708686715405,
                                         2.89739338172986e-08,
                                         2.07204650418815e-05,
                                         0.000660210219576795,
                                         0.00644169887711723,
                                         0.0327985583797788,
                                         0.108885521198418,
                                         0.263842064088064,
                                         0.497171826420162,
                                         0.756230840330861,
                                         0.948825506768084,

                                         0.957163157609433,
                                         0.792547401831024,
                                         0.560037437020119,
                                         0.332828912382372,
                                         0.162356578933021,
                                         0.0625,
                                         0.0177933723750071,
                                         0.00334282089562565,
                                         0.000331403274986382,
                                         1.01678975655281e-05,
                                         1.40417360773867e-08,
                                         0.0421361327033732,
                                         0.189730310238456,
                                         0.349391218104416,
                                         0.421457758200314,
                                         0.373660316159399,
                                         0.25,
                                         0.123700417370738,
                                         0.0422376827601822,
                                         0.00849927444658239,
                                         0.000679578569181923,
                                         5.10354665408531e-06,
                                         0.000695592098803157,
                                         0.0170325414637733,
                                         0.0817406671538966,
                                         0.200132825761506,
                                         0.322489315161834,
                                         0.375,
                                         0.322489315161835,
                                         0.200132825761506,
                                         0.0817406671538966,
                                         0.0170325414637733,
                                         0.000695592098803164,
                                         5.10354665408523e-06,
                                         0.000679578569181923,
                                         0.0084992744465824,
                                         0.0422376827601822,
                                         0.123700417370738,
                                         0.25,
                                         0.373660316159399,
                                         0.421457758200314,
                                         0.349391218104416,
                                         0.189730310238456,
                                         0.0421361327033734,
                                         1.40417360773864e-08,
                                         1.01678975655281e-05,
                                         0.000331403274986383,
                                         0.00334282089562565,
                                         0.017793372375007,
                                         0.0625,
                                         0.162356578933021,
                                         0.332828912382372,
                                         0.560037437020119,
                                         0.792547401831024,
                                         0.957163157609433,

                                         0.963628156246642,
                                         0.82158929703109,
                                         0.613306488185647,
                                         0.396767171835268,
                                         0.218781411467788,
                                         0.100196024299947,
                                         0.0365972768109547,
                                         0.00998185891788715,
                                         0.00181276837592541,
                                         0.000175196853729486,
                                         5.28252824501172e-06,
                                         7.22543390530333e-09,
                                         0.0358680763355925,
                                         0.165486102649272,
                                         0.318933204380947,
                                         0.412617239546012,
                                         0.404455423159802,
                                         0.311573168711773,
                                         0.18830384666682,
                                         0.086391530263243,
                                         0.0278901378914638,
                                         0.00539043865617271,
                                         0.00041961891401255,
                                         3.10588456971262e-06,
                                         0.000500654307762337,
                                         0.0124996988773801,
                                         0.0621946719235032,
                                         0.16091268235133,
                                         0.28038977619128,
                                         0.363329683510505,
                                         0.363329683510505,
                                         0.28038977619128,
                                         0.16091268235133,
                                         0.0621946719235033,
                                         0.0124996988773801,
                                         0.000500654307762331,
                                         3.10588456971268e-06,
                                         0.000419618914012548,
                                         0.0053904386561727,
                                         0.0278901378914637,
                                         0.086391530263243,
                                         0.18830384666682,
                                         0.311573168711773,
                                         0.404455423159802,
                                         0.412617239546012,
                                         0.318933204380948,
                                         0.165486102649272,
                                         0.0358680763355923,
                                         7.2254339053035e-09,
                                         5.2825282450117e-06,
                                         0.000175196853729486,
                                         0.00181276837592541,
                                         0.00998185891788714,
                                         0.0365972768109547,
                                         0.100196024299947,
                                         0.218781411467788,
                                         0.396767171835268,
                                         0.613306488185647,
                                         0.82158929703109,
                                         0.963628156246642,

                                         0.968739398477836,
                                         0.845104961272685,
                                         0.658403883858058,
                                         0.45471803335804,
                                         0.275134671338053,
                                         0.143267486084963,
                                         0.0625,
                                         0.0219183882197575,
                                         0.00578209093997213,
                                         0.00102262438228394,
                                         9.68809779749206e-05,
                                         2.8815264592955e-06,
                                         3.91174436927972e-09,
                                         0.0308892831661543,
                                         0.145260867263323,
                                         0.29006071149665,
                                         0.396091625803099,
                                         0.419025267680675,
                                         0.358404022569804,
                                         0.25,
                                         0.140185586389945,
                                         0.0607449264039438,
                                         0.0187837648739302,
                                         0.0035185357901953,
                                         0.000268228309817231,
                                         1.96286116031195e-06,
                                         0.000369351583105619,
                                         0.00936306162771609,
                                         0.0479199878771224,
                                         0.129383951582647,
                                         0.239313043637356,
                                         0.336224516735531,
                                         0.375,
                                         0.336224516735531,
                                         0.239313043637356,
                                         0.129383951582647,
                                         0.0479199878771225,
                                         0.00936306162771607,
                                         0.000369351583105614,
                                         1.96286116031199e-06,
                                         0.000268228309817232,
                                         0.00351853579019529,
                                         0.0187837648739302,
                                         0.0607449264039438,
                                         0.140185586389945,
                                         0.25,
                                         0.358404022569804,
                                         0.419025267680675,
                                         0.396091625803099,
                                         0.29006071149665,
                                         0.145260867263323,
                                         0.0308892831661541,
                                         3.91174436927983e-09,
                                         2.88152645929552e-06,
                                         9.68809779749204e-05,
                                         0.00102262438228394,
                                         0.00578209093997213,
                                         0.0219183882197575,
                                         0.0625,
                                         0.143267486084963,
                                         0.275134671338053,
                                         0.45471803335804,
                                         0.658403883858058,
                                         0.845104961272685,
                                         0.968739398477836,

                                         0.972848530221262,
                                         0.864370492814952,
                                         0.696667601066622,
                                         0.506572883344894,
                                         0.329469809434844,
                                         0.189237493810458,
                                         0.0942161184643902,
                                         0.0395578262389152,
                                         0.0134332716421843,
                                         0.00345108912496521,
                                         0.000597628029965846,
                                         5.57239314531811e-05,
                                         1.63940231404558e-06,
                                         2.21214786148312e-09,
                                         0.0268718427671117,
                                         0.128308765621495,
                                         0.263535811418169,
                                         0.375533932253762,
                                         0.421609854832061,
                                         0.390715671858488,
                                         0.303362574985478,
                                         0.19656926202174,
                                         0.104099378339254,
                                         0.0431500227355117,
                                         0.0128986332602489,
                                         0.00235693554897638,
                                         0.000176705119622931,
                                         1.28139171657249e-06,
                                         0.00027834340776159,
                                         0.00714239704161622,
                                         0.0373839280347797,
                                         0.104396923111129,
                                         0.202319223872617,
                                         0.302514184349616,
                                         0.366294218289476,
                                         0.366294218289476,
                                         0.302514184349616,
                                         0.202319223872617,
                                         0.104396923111129,
                                         0.0373839280347797,
                                         0.0071423970416162,
                                         0.00027834340776159,
                                         1.28139171657249e-06,
                                         0.000176705119622932,
                                         0.00235693554897638,
                                         0.0128986332602489,
                                         0.0431500227355117,
                                         0.104099378339254,
                                         0.19656926202174,
                                         0.303362574985478,
                                         0.390715671858488,
                                         0.421609854832061,
                                         0.375533932253762,
                                         0.263535811418169,
                                         0.128308765621494,
                                         0.0268718427671117,
                                         2.21214786148312e-09,
                                         1.63940231404559e-06,
                                         5.57239314531811e-05,
                                         0.000597628029965845,
                                         0.00345108912496521,
                                         0.0134332716421843,
                                         0.0395578262389152,
                                         0.0942161184643902,
                                         0.189237493810458,
                                         0.329469809434844,
                                         0.506572883344894,
                                         0.696667601066622,
                                         0.864370492814952,
                                         0.972848530221262,

                                         0.976200441158322,
                                         0.880326290422158,
                                         0.729259455604646,
                                         0.552649697612692,
                                         0.380674675588307,
                                         0.236112896100805,
                                         0.130116619082459,
                                         0.0625,
                                         0.025447497834447,
                                         0.00842047525048224,
                                         0.0021174924266149,
                                         0.000360483259542264,
                                         3.31811750977195e-05,
                                         9.67580749819504e-07,
                                         1.29923523932817e-09,
                                         0.0235850167429701,
                                         0.114015671706972,
                                         0.239576647632575,
                                         0.353279729526074,
                                         0.415844486256976,
                                         0.410425110129251,
                                         0.346115334104785,
                                         0.25,
                                         0.153065388605938,
                                         0.0775072576747713,
                                         0.031014507363282,
                                         0.00902269551203407,
                                         0.00161602967081806,
                                         0.00011953258837773,
                                         8.60420174467677e-07,
                                         0.000213680379297726,
                                         0.00553753770174161,
                                         0.029514685916863,
                                         0.0846873940896574,
                                         0.17034883836482,
                                         0.26753426084469,
                                         0.345255160372371,
                                         0.375,
                                         0.345255160372371,
                                         0.26753426084469,
                                         0.17034883836482,
                                         0.0846873940896573,
                                         0.029514685916863,
                                         0.00553753770174161,
                                         0.00021368037929773,
                                         8.60420174467653e-07,
                                         0.00011953258837773,
                                         0.00161602967081806,
                                         0.00902269551203409,
                                         0.031014507363282,
                                         0.0775072576747713,
                                         0.153065388605938,
                                         0.25,
                                         0.346115334104785,
                                         0.410425110129251,
                                         0.415844486256976,
                                         0.353279729526074,
                                         0.239576647632575,
                                         0.114015671706972,
                                         0.0235850167429703,
                                         1.29923523932812e-09,
                                         9.67580749819504e-07,
                                         3.31811750977194e-05,
                                         0.000360483259542265,
                                         0.0021174924266149,
                                         0.00842047525048224,
                                         0.025447497834447,
                                         0.0625,
                                         0.130116619082459,
                                         0.236112896100805,
                                         0.380674675588307,
                                         0.552649697612692,
                                         0.729259455604646,
                                         0.880326290422158,
                                         0.976200441158322,

                                         0.978969785690217,
                                         0.893673397272717,
                                         0.757152226754828,
                                         0.593456315631769,
                                         0.428214343373989,
                                         0.282442536721729,
                                         0.168614463603698,
                                         0.0898579156271391,
                                         0.0419228038340917,
                                         0.0166470286032193,
                                         0.00539291267699367,
                                         0.00133258882534111,
                                         0.000223704396379093,
                                         2.03738798686383e-05,
                                         5.89796378179132e-07,
                                         7.88769739328845e-10,
                                         0.0208628923757585,
                                         0.101887202779402,
                                         0.218130216064584,
                                         0.330765487306574,
                                         0.40455720555101,
                                         0.419965307738311,
                                         0.378063971082177,
                                         0.297057024660599,
                                         0.202902228571419,
                                         0.118791739524615,
                                         0.0580310005133277,
                                         0.0225682258430177,
                                         0.00642189306734854,
                                         0.0011315170388394,
                                         8.27715856135834e-05,
                                         5.92195351449487e-07,
                                         0.000166728949904058,
                                         0.00435603856588915,
                                         0.0235656662618796,
                                         0.069132599597929,
                                         0.143327636406642,
                                         0.234168242349638,
                                         0.317882797186291,
                                         0.368260027306751,
                                         0.368260027306751,
                                         0.317882797186291,
                                         0.234168242349638,
                                         0.143327636406642,
                                         0.0691325995979289,
                                         0.0235656662618797,
                                         0.00435603856588915,
                                         0.000166728949904055,
                                         5.92195351449506e-07,
                                         8.27715856135834e-05,
                                         0.0011315170388394,
                                         0.00642189306734855,
                                         0.0225682258430177,
                                         0.0580310005133277,
                                         0.118791739524616,
                                         0.202902228571419,
                                         0.297057024660599,
                                         0.378063971082177,
                                         0.419965307738311,
                                         0.40455720555101,
                                         0.330765487306574,
                                         0.218130216064584,
                                         0.101887202779402,
                                         0.0208628923757583,
                                         7.88769739328878e-10,
                                         5.89796378179132e-07,
                                         2.03738798686382e-05,
                                         0.000223704396379094,
                                         0.00133258882534111,
                                         0.00539291267699367,
                                         0.0166470286032193,
                                         0.0419228038340917,
                                         0.089857915627139,
                                         0.168614463603698,
                                         0.282442536721729,
                                         0.428214343373989,
                                         0.593456315631769,
                                         0.757152226754828,
                                         0.893673397272717,
                                         0.978969785690217,

                                         0.981283765069248,
                                         0.904940768841663,
                                         0.781146310330376,
                                         0.629559786657607,
                                         0.471925607363362,
                                         0.327250544426615,
                                         0.208352828197386,
                                         0.120552174142795,
                                         0.0625,
                                         0.0284671335350765,
                                         0.011072312449724,
                                         0.00352451527349441,
                                         0.000858329373663579,
                                         0.000142421134654031,
                                         1.28569940301258e-05,
                                         3.69938913539379e-07,
                                         4.93080516932981e-10,
                                         0.0185838380551658,
                                         0.0915287668403439,
                                         0.199018817372829,
                                         0.308838430219542,
                                         0.389833038251081,
                                         0.421691768760169,
                                         0.400146593900373,
                                         0.336145430098749,
                                         0.25,
                                         0.163347148322491,
                                         0.0922440984879453,
                                         0.0437627528934554,
                                         0.0166252757970957,
                                         0.00464515347184419,
                                         0.000807416591548383,
                                         5.85211083071584e-05,
                                         4.16578667723622e-07,
                                         0.000131979803837472,
                                         0.0034715732707722,
                                         0.0190145987112168,
                                         0.0568142085163538,
                                         0.120757749214798,
                                         0.203770418646267,
                                         0.288184166964572,
                                         0.351488113900887,
                                         0.375,
                                         0.351488113900887,
                                         0.288184166964572,
                                         0.203770418646266,
                                         0.120757749214798,
                                         0.0568142085163538,
                                         0.0190145987112168,
                                         0.00347157327077219,
                                         0.000131979803837475,
                                         4.16578667723608e-07,
                                         5.85211083071588e-05,
                                         0.000807416591548383,
                                         0.0046451534718442,
                                         0.0166252757970957,
                                         0.0437627528934555,
                                         0.0922440984879453,
                                         0.163347148322491,
                                         0.25,
                                         0.336145430098749,
                                         0.400146593900373,
                                         0.421691768760169,
                                         0.389833038251081,
                                         0.308838430219541,
                                         0.199018817372829,
                                         0.0915287668403437,
                                         0.018583838055166,
                                         4.93080516932958e-10,
                                         3.69938913539382e-07,
                                         1.28569940301258e-05,
                                         0.000142421134654031,
                                         0.00085832937366358,
                                         0.00352451527349441,
                                         0.011072312449724,
                                         0.0284671335350765,
                                         0.0625,
                                         0.120552174142795,
                                         0.208352828197386,
                                         0.327250544426615,
                                         0.471925607363362,
                                         0.629559786657607,
                                         0.781146310330376,
                                         0.904940768841663,
                                         0.981283765069248,

                                         0.983236756679994,
                                         0.914532317018973,
                                         0.801895219265578,
                                         0.661518531045338,
                                         0.511870509606053,
                                         0.369933102779203,
                                         0.248263361905588,
                                         0.153510986037566,
                                         0.086544347783499,
                                         0.0438522106105466,
                                         0.0195772019850231,
                                         0.00748383718790605,
                                         0.00234744419560889,
                                         0.000564738145279569,
                                         9.27934517993002e-05,
                                         8.31490414763463e-06,
                                         2.38027731473621e-07,
                                         3.16362995197385e-10,
                                         0.016657122903031,
                                         0.0826258943481487,
                                         0.182017238592954,
                                         0.287969064000248,
                                         0.373157224403275,
                                         0.417639153522556,
                                         0.413785767007172,
                                         0.366946071633453,
                                         0.292069963335031,
                                         0.207904211597465,
                                         0.131041188355527,
                                         0.0718424935168508,
                                         0.0332688085418495,
                                         0.0123946812041168,
                                         0.0034106212422788,
                                         0.000586114320703499,
                                         4.21531878347225e-05,
                                         2.98788430287531e-07,
                                         0.000105821312182055,
                                         0.00279939741731256,
                                         0.0154931129166166,
                                         0.0470089902603361,
                                         0.102012846641275,
                                         0.176811490960782,
                                         0.258624540382482,
                                         0.328924551988431,
                                         0.369629266673458,
                                         0.369629266673458,
                                         0.328924551988431,
                                         0.258624540382483,
                                         0.176811490960782,
                                         0.102012846641275,
                                         0.0470089902603361,
                                         0.0154931129166166,
                                         0.00279939741731256,
                                         0.000105821312182055,
                                         2.98788430287531e-07,
                                         4.21531878347225e-05,
                                         0.000586114320703499,
                                         0.0034106212422788,
                                         0.0123946812041168,
                                         0.0332688085418495,
                                         0.0718424935168508,
                                         0.131041188355527,
                                         0.207904211597465,
                                         0.292069963335031,
                                         0.366946071633453,
                                         0.413785767007172,
                                         0.417639153522556,
                                         0.373157224403275,
                                         0.287969064000248,
                                         0.182017238592954,
                                         0.0826258943481487,
                                         0.016657122903031,
                                         3.16362995197385e-10,
                                         2.38027731473621e-07,
                                         8.31490414763463e-06,
                                         9.27934517993e-05,
                                         0.000564738145279569,
                                         0.00234744419560889,
                                         0.00748383718790605,
                                         0.0195772019850231,
                                         0.0438522106105466,
                                         0.086544347783499,
                                         0.153510986037566,
                                         0.248263361905588,
                                         0.369933102779203,
                                         0.511870509606053,
                                         0.661518531045338,
                                         0.801895219265578,
                                         0.914532317018973,
                                         0.983236756679994,

                                         0.984899953029972,
                                         0.922760044669914,
                                         0.819931333641154,
                                         0.689850145839167,
                                         0.54823828179355,
                                         0.410158677501314,
                                         0.287555336838789,
                                         0.18777944524375,
                                         0.113304977054721,
                                         0.0625,
                                         0.031063851348551,
                                         0.0136355031922754,
                                         0.00513674983591187,
                                         0.00159129295063405,
                                         0.000378885000564069,
                                         6.17406716507828e-05,
                                         5.49759347614354e-06,
                                         1.56695472160065e-07,
                                         2.07763543136105e-10,
                                         0.0150140001072802,
                                         0.0749274045688941,
                                         0.166892284449326,
                                         0.268391587469536,
                                         0.355560790246075,
                                         0.409459973633892,
                                         0.420506941637598,
                                         0.389909505118779,
                                         0.327952205974863,
                                         0.25,
                                         0.171717166106752,
                                         0.105069189294469,
                                         0.0562026328914296,
                                         0.0255041334118897,
                                         0.00934722916158829,
                                         0.00253908473028187,
                                         0.00043214931504685,
                                         3.08762481171056e-05,
                                         2.18064529014483e-07,
                                         8.58285904552746e-05,
                                         0.00228151781760297,
                                         0.0127387350009962,
                                         0.0391574412893644,
                                         0.086474813798223,
                                         0.153285922502271,
                                         0.230598338796272,
                                         0.303606357150727,
                                         0.355961799515113,
                                         0.375,
                                         0.355961799515113,
                                         0.303606357150727,
                                         0.230598338796272,
                                         0.153285922502271,
                                         0.0864748137982231,
                                         0.0391574412893644,
                                         0.0127387350009962,
                                         0.00228151781760297,
                                         8.58285904552746e-05,
                                         2.18064529014483e-07,
                                         3.08762481171056e-05,
                                         0.00043214931504685,
                                         0.00253908473028187,
                                         0.00934722916158828,
                                         0.0255041334118897,
                                         0.0562026328914296,
                                         0.105069189294469,
                                         0.171717166106752,
                                         0.25,
                                         0.327952205974863,
                                         0.389909505118779,
                                         0.420506941637598,
                                         0.409459973633892,
                                         0.355560790246075,
                                         0.268391587469536,
                                         0.166892284449326,
                                         0.0749274045688941,
                                         0.0150140001072802,
                                         2.07763543136105e-10,
                                         1.56695472160065e-07,
                                         5.49759347614354e-06,
                                         6.17406716507828e-05,
                                         0.000378885000564068,
                                         0.00159129295063405,
                                         0.00513674983591187,
                                         0.0136355031922754,
                                         0.031063851348551,
                                         0.0625,
                                         0.113304977054721,
                                         0.18777944524375,
                                         0.287555336838789,
                                         0.410158677501314,
                                         0.54823828179355,
                                         0.689850145839167,
                                         0.819931333641154,
                                         0.922760044669914,
                                         0.984899953029972,

                                         0.986327860512721,
                                         0.929867610279814,
                                         0.835688738066185,
                                         0.715018742748247,
                                         0.581282398963667,
                                         0.447785693854471,
                                         0.325675404904635,
                                         0.222564200929315,
                                         0.14202686949942,
                                         0.0839419301967926,
                                         0.0454545881743675,
                                         0.022224450720858,
                                         0.009615962825226,
                                         0.00357756774757447,
                                         0.00109655228334194,
                                         0.000258787560779739,
                                         4.18717339254218e-05,
                                         3.70831623841347e-06,
                                         1.05303823435337e-07,
                                         1.39335296338273e-10,
                                         0.0136016392866203,
                                         0.0682318060044914,
                                         0.153421983867068,
                                         0.250194810443689,
                                         0.337742893909035,
                                         0.398446474028381,
                                         0.421740860012686,
                                         0.405881884216716,
                                         0.357310382893013,
                                         0.288030605023946,
                                         0.211952246801801,
                                         0.141343518166847,
                                         0.0843661829940535,
                                         0.0442025304251537,
                                         0.0197173957176091,
                                         0.00712630379450791,
                                         0.00191460882789382,
                                         0.000323186864309116,
                                         2.29614006452529e-05,
                                         1.61663201718834e-07,
                                         7.03383981216812e-05,
                                         0.0018775170112255,
                                         0.0105623828861997,
                                         0.032829966246245,
                                         0.0735896157720102,
                                         0.132953884116197,
                                         0.20480363690995,
                                         0.27757176903469,
                                         0.337094778719863,
                                         0.370620629803093,
                                         0.370620629803093,
                                         0.337094778719863,
                                         0.27757176903469,
                                         0.20480363690995,
                                         0.132953884116197,
                                         0.0735896157720102,
                                         0.0328299662462451,
                                         0.0105623828861997,
                                         0.00187751701122551,
                                         7.03383981216835e-05,
                                         1.61663201718826e-07,
                                         2.29614006452527e-05,
                                         0.000323186864309116,
                                         0.00191460882789381,
                                         0.00712630379450791,
                                         0.0197173957176091,
                                         0.0442025304251537,
                                         0.0843661829940535,
                                         0.141343518166847,
                                         0.211952246801801,
                                         0.288030605023946,
                                         0.357310382893013,
                                         0.405881884216716,
                                         0.421740860012686,
                                         0.39844647402838,
                                         0.337742893909035,
                                         0.250194810443689,
                                         0.153421983867068,
                                         0.0682318060044916,
                                         0.0136016392866205,
                                         1.39335296338264e-10,
                                         1.05303823435335e-07,
                                         3.70831623841347e-06,
                                         4.18717339254217e-05,
                                         0.000258787560779739,
                                         0.00109655228334194,
                                         0.00357756774757447,
                                         0.009615962825226,
                                         0.022224450720858,
                                         0.0454545881743675,
                                         0.0839419301967926,
                                         0.14202686949942,
                                         0.222564200929315,
                                         0.325675404904635,
                                         0.447785693854471,
                                         0.581282398963667,
                                         0.715018742748247,
                                         0.835688738066185,
                                         0.929867610279814,
                                         0.986327860512721,

                                         0.987562772450777,
                                         0.936047268900731,
                                         0.849522342638768,
                                         0.737432567578805,
                                         0.61128156665979,
                                         0.482799774140933,
                                         0.362259838915235,
                                         0.257239280713978,
                                         0.172017336987515,
                                         0.107635167802709,
                                         0.0625,
                                         0.0333121399975574,
                                         0.0160600902387191,
                                         0.00686337664521125,
                                         0.00252621004716946,
                                         0.000767242573778011,
                                         0.000179694363577921,
                                         2.88968142309429e-05,
                                         2.54730889060784e-06,
                                         7.21030052167969e-08,
                                         9.5235016487511e-11,
                                         0.0123789180919274,
                                         0.0623765956255645,
                                         0.141403935981224,
                                         0.23338031305211,
                                         0.320165535332481,
                                         0.385583515299763,
                                         0.418738119252704,
                                         0.415860253893511,
                                         0.380343634000019,
                                         0.321126590835349,
                                         0.25,
                                         0.178648938123861,
                                         0.11621549389281,
                                         0.0679278216161664,
                                         0.0349677052143945,
                                         0.0153709700392499,
                                         0.00548935297354984,
                                         0.00146092541462408,
                                         0.000244858340176451,
                                         1.73120884038902e-05,
                                         1.21562231811695e-07,
                                         5.81877998295614e-05,
                                         0.00155875128229548,
                                         0.00882631573094091,
                                         0.0276972971402299,
                                         0.062883850670601,
                                         0.115478497946276,
                                         0.181508126570497,
                                         0.252109267131133,
                                         0.315363444880936,
                                         0.359277163240525,
                                         0.375,
                                         0.359277163240525,
                                         0.315363444880936,
                                         0.252109267131133,
                                         0.181508126570497,
                                         0.115478497946276,
                                         0.062883850670601,
                                         0.0276972971402299,
                                         0.00882631573094088,
                                         0.00155875128229549,
                                         5.81877998295593e-05,
                                         1.21562231811701e-07,
                                         1.731208840389e-05,
                                         0.000244858340176453,
                                         0.00146092541462408,
                                         0.00548935297354984,
                                         0.0153709700392499,
                                         0.0349677052143945,
                                         0.0679278216161664,
                                         0.11621549389281,
                                         0.178648938123861,
                                         0.25,
                                         0.321126590835349,
                                         0.380343634000019,
                                         0.415860253893511,
                                         0.418738119252704,
                                         0.385583515299763,
                                         0.320165535332481,
                                         0.23338031305211,
                                         0.141403935981224,
                                         0.0623765956255647,
                                         0.0123789180919271,
                                         9.52350164875178e-11,
                                         7.2103005216796e-08,
                                         2.54730889060786e-06,
                                         2.88968142309429e-05,
                                         0.000179694363577921,
                                         0.000767242573778011,
                                         0.00252621004716946,
                                         0.00686337664521124,
                                         0.0160600902387191,
                                         0.0333121399975574,
                                         0.0625,
                                         0.107635167802709,
                                         0.172017336987515,
                                         0.257239280713978,
                                         0.362259838915235,
                                         0.482799774140933,
                                         0.61128156665979,
                                         0.737432567578805,
                                         0.849522342638768,
                                         0.936047268900731,
                                         0.987562772450777,

                                         0.988637905802623,
                                         0.941452188081014,
                                         0.86172343892003,
                                         0.757446708889307,
                                         0.638516433448405,
                                         0.515268095317059,
                                         0.397089668671067,
                                         0.291331837909333,
                                         0.202678182342491,
                                         0.1330292148741,
                                         0.0818449294572894,
                                         0.046805702009658,
                                         0.024608597203009,
                                         0.0117206857513232,
                                         0.00495556959667556,
                                         0.0018071093846198,
                                         0.000544499267745842,
                                         0.000126684635966719,
                                         2.0264097123248e-05,
                                         1.77909788674101e-06,
                                         5.0217873197012e-08,
                                         6.62260463567833e-11,
                                         0.0113134520877266,
                                         0.0572299375655949,
                                         0.130657962584692,
                                         0.217899316563263,
                                         0.303123800672948,
                                         0.371607316060555,
                                         0.412546153859739,
                                         0.420847108640458,
                                         0.397560746527003,
                                         0.348973120337425,
                                         0.28469413230294,
                                         0.215294040558759,
                                         0.150093502303166,
                                         0.0956040979251705,
                                         0.0548879692922594,
                                         0.0278304654188107,
                                         0.0120799817858145,
                                         0.00426968633940849,
                                         0.00112705070702954,
                                         0.000187737854631747,
                                         1.32176210181362e-05,
                                         9.25957230695827e-08,
                                         4.85494477009912e-05,
                                         0.00130460651449993,
                                         0.00742908154275892,
                                         0.0235066597432777,
                                         0.0539633949032718,
                                         0.100500107568826,
                                         0.160726602665763,
                                         0.227977514561274,
                                         0.292436287454013,
                                         0.3432955652823,
                                         0.371361195671353,
                                         0.371361195671353,
                                         0.3432955652823,
                                         0.292436287454013,
                                         0.227977514561274,
                                         0.160726602665763,
                                         0.100500107568826,
                                         0.0539633949032717,
                                         0.0235066597432776,
                                         0.00742908154275894,
                                         0.00130460651449993,
                                         4.85494477009912e-05,
                                         9.25957230695827e-08,
                                         1.32176210181362e-05,
                                         0.000187737854631746,
                                         0.00112705070702955,
                                         0.0042696863394085,
                                         0.0120799817858145,
                                         0.0278304654188107,
                                         0.0548879692922594,
                                         0.0956040979251705,
                                         0.150093502303166,
                                         0.215294040558759,
                                         0.28469413230294,
                                         0.348973120337425,
                                         0.397560746527003,
                                         0.420847108640458,
                                         0.412546153859739,
                                         0.371607316060555,
                                         0.303123800672948,
                                         0.217899316563263,
                                         0.130657962584692,
                                         0.0572299375655949,
                                         0.0113134520877266,
                                         6.62260463567833e-11,
                                         5.0217873197012e-08,
                                         1.779097886741e-06,
                                         2.02640971232481e-05,
                                         0.00012668463596672,
                                         0.000544499267745842,
                                         0.0018071093846198,
                                         0.00495556959667556,
                                         0.0117206857513232,
                                         0.024608597203009,
                                         0.046805702009658,
                                         0.0818449294572894,
                                         0.1330292148741,
                                         0.202678182342491,
                                         0.291331837909333,
                                         0.397089668671067,
                                         0.515268095317059,
                                         0.638516433448405,
                                         0.757446708889307,
                                         0.86172343892003,
                                         0.941452188081014,
                                         0.988637905802623,

                                         0.98957963827132,
                                         0.946205501457184,
                                         0.872532171803549,
                                         0.775368044619359,
                                         0.663256376374474,
                                         0.54530725093309,
                                         0.430052703731969,
                                         0.32449961623871,
                                         0.23351533465836,
                                         0.159608044320656,
                                         0.103084504877029,
                                         0.0625,
                                         0.0352729466130383,
                                         0.0183261399127774,
                                         0.0086365807879836,
                                         0.00361768567491482,
                                         0.00130856997137965,
                                         0.000391559290537087,
                                         9.0575838730981e-05,
                                         1.44209705381375e-05,
                                         1.26162047339539e-06,
                                         3.55243227738474e-08,
                                         4.67851087792772e-11,
                                         0.0103794649140167,
                                         0.0526842188067965,
                                         0.121025883074871,
                                         0.203675850040998,
                                         0.286796705247483,
                                         0.357059283330152,
                                         0.404017791812122,
                                         0.421772577345862,
                                         0.409620803698513,
                                         0.371636895038103,
                                         0.315366434887508,
                                         0.25,
                                         0.184475902818558,
                                         0.125929341913169,
                                         0.0787762353786826,
                                         0.0445334827814369,
                                         0.0222863078060078,
                                         0.00956794035135772,
                                         0.00335150308128954,
                                         0.000878380797756304,
                                         0.000145529788990674,
                                         1.02082362894807e-05,
                                         7.1367981152494e-08,
                                         4.08253998976406e-05,
                                         0.00110003597540698,
                                         0.00629515371211583,
                                         0.0200633035713485,
                                         0.0465048394580221,
                                         0.0876739660948632,
                                         0.142334626678522,
                                         0.205576637959076,
                                         0.269451045476462,
                                         0.324499578815295,
                                         0.361800210803866,
                                         0.375,
                                         0.361800210803866,
                                         0.324499578815295,
                                         0.269451045476462,
                                         0.205576637959076,
                                         0.142334626678522,
                                         0.0876739660948632,
                                         0.0465048394580221,
                                         0.0200633035713485,
                                         0.00629515371211585,
                                         0.00110003597540698,
                                         4.08253998976389e-05,
                                         7.13679811524985e-08,
                                         1.02082362894807e-05,
                                         0.000145529788990674,
                                         0.000878380797756304,
                                         0.00335150308128954,
                                         0.00956794035135771,
                                         0.0222863078060078,
                                         0.0445334827814368,
                                         0.0787762353786826,
                                         0.125929341913169,
                                         0.184475902818558,
                                         0.25,
                                         0.315366434887508,
                                         0.371636895038103,
                                         0.409620803698513,
                                         0.421772577345863,
                                         0.404017791812122,
                                         0.357059283330152,
                                         0.286796705247483,
                                         0.203675850040998,
                                         0.121025883074871,
                                         0.0526842188067965,
                                         0.0103794649140165,
                                         4.67851087792812e-11,
                                         3.55243227738474e-08,
                                         1.26162047339538e-06,
                                         1.44209705381375e-05,
                                         9.0575838730981e-05,
                                         0.000391559290537086,
                                         0.00130856997137965,
                                         0.00361768567491482,
                                         0.0086365807879836,
                                         0.0183261399127774,
                                         0.0352729466130383,
                                         0.0625,
                                         0.103084504877029,
                                         0.159608044320656,
                                         0.23351533465836,
                                         0.32449961623871,
                                         0.430052703731969,
                                         0.54530725093309,
                                         0.663256376374474,
                                         0.775368044619359,
                                         0.872532171803549,
                                         0.946205501457184,
                                         0.98957963827132,

                                         0.990409128565756,
                                         0.950407036507499,
                                         0.882147469739109,
                                         0.791460904496354,
                                         0.685752603149579,
                                         0.573061188566064,
                                         0.461113209573105,
                                         0.356506772687057,
                                         0.264135305871462,
                                         0.186912957640004,
                                         0.125805733226994,
                                         0.0801197185266472,
                                         0.0479598502347719,
                                         0.0267558553347938,
                                         0.0137573270919201,
                                         0.00642361342116988,
                                         0.00266879792712466,
                                         0.000958491844684126,
                                         0.000285064693066289,
                                         6.56071044979699e-05,
                                         1.04029350436764e-05,
                                         9.07270980692938e-07,
                                         2.5491785265624e-08,
                                         3.35323551868682e-11,
                                         0.00955623853431914,
                                         0.0486510576958959,
                                         0.112369937918321,
                                         0.19062114035203,
                                         0.271283454922385,
                                         0.342331289627009,
                                         0.393833603894487,
                                         0.419459227578494,
                                         0.417229187478252,
                                         0.389424314729441,
                                         0.341735444714437,
                                         0.281892815332709,
                                         0.218098766191249,
                                         0.157597465551605,
                                         0.105650216433282,
                                         0.0650655571267452,
                                         0.0362922343206795,
                                         0.017955735477376,
                                         0.00763515421589551,
                                         0.00265347506474134,
                                         0.000691089465848724,
                                         0.000113958849110374,
                                         7.96778470586254e-06,
                                         5.56047244909011e-08,
                                         3.45772616680083e-05,
                                         0.000933912520113709,
                                         0.00536772622247969,
                                         0.0172164627507237,
                                         0.0402448597587967,
                                         0.0766873028979659,
                                         0.126138959210348,
                                         0.185072967486644,
                                         0.247146336102371,
                                         0.304255184105354,
                                         0.348105501172171,
                                         0.371928849714623,
                                         0.371928849714623,
                                         0.348105501172171,
                                         0.304255184105354,
                                         0.247146336102371,
                                         0.185072967486644,
                                         0.126138959210348,
                                         0.0766873028979658,
                                         0.0402448597587967,
                                         0.0172164627507237,
                                         0.00536772622247967,
                                         0.000933912520113709,
                                         3.45772616680067e-05,
                                         5.5604724490905e-08,
                                         7.96778470586254e-06,
                                         0.000113958849110374,
                                         0.000691089465848724,
                                         0.00265347506474134,
                                         0.00763515421589552,
                                         0.017955735477376,
                                         0.0362922343206796,
                                         0.0650655571267452,
                                         0.105650216433282,
                                         0.157597465551605,
                                         0.218098766191248,
                                         0.281892815332709,
                                         0.341735444714437,
                                         0.389424314729441,
                                         0.417229187478252,
                                         0.419459227578494,
                                         0.393833603894487,
                                         0.342331289627008,
                                         0.271283454922385,
                                         0.19062114035203,
                                         0.112369937918321,
                                         0.0486510576958959,
                                         0.00955623853431892,
                                         3.35323551868712e-11,
                                         2.5491785265624e-08,
                                         9.07270980692945e-07,
                                         1.04029350436764e-05,
                                         6.56071044979699e-05,
                                         0.000285064693066289,
                                         0.000958491844684126,
                                         0.00266879792712467,
                                         0.00642361342116988,
                                         0.0137573270919201,
                                         0.0267558553347938,
                                         0.0479598502347719,
                                         0.0801197185266472,
                                         0.125805733226994,
                                         0.186912957640004,
                                         0.264135305871462,
                                         0.356506772687057,
                                         0.461113209573105,
                                         0.573061188566064,
                                         0.685752603149579,
                                         0.791460904496354,
                                         0.882147469739109,
                                         0.950407036507499,
                                         0.990409128565756,

                                         0.03125,
                                         0.15625,
                                         0.3125,
                                         0.3125,
                                         0.15625,
                                         0.03125,

                                         0.305134098813929,
                                         0.000421456741626533,
                                         0.408802176801953,
                                         0.00786448986471326,
                                         0.219076426276337,
                                         0.0587013515014408,
                                         0.0587013515014408,
                                         0.219076426276337,
                                         0.00786448986471326,
                                         0.408802176801953,
                                         0.000421456741626533,
                                         0.305134098813929,

                                         0.549981817580726,
                                         0.03125,
                                         1.81824192734013e-05,
                                         0.349284250579334,
                                         0.15625,
                                         0.000715749420666245,
                                         0.0887298334620744,
                                         0.3125,
                                         0.0112701665379259,
                                         0.0112701665379259,
                                         0.3125,
                                         0.0887298334620744,
                                         0.000715749420666245,
                                         0.15625,
                                         0.349284250579334,
                                         1.81824192734013e-05,
                                         0.03125,
                                         0.549981817580726,

                                         0.697816017789034,
                                         0.135002961144809,
                                         0.00391410135255554,
                                         1.61359115377922e-06,
                                         0.260328342032991,
                                         0.332484231602893,
                                         0.0397323558976338,
                                         0.000108131690971159,
                                         0.0388474004253279,
                                         0.327535820924673,
                                         0.161330529077436,
                                         0.00289849447052239,
                                         0.00289849447052239,
                                         0.161330529077436,
                                         0.327535820924673,
                                         0.038847400425328,
                                         0.000108131690971159,
                                         0.0397323558976338,
                                         0.332484231602893,
                                         0.260328342032991,
                                         1.61359115377921e-06,
                                         0.00391410135255554,
                                         0.135002961144809,
                                         0.697816017789034,

                                         0.78644687097721,
                                         0.269335877083235,
                                         0.03125,
                                         0.000654414550868918,
                                         2.27159409202062e-07,
                                         0.193540412132003,
                                         0.403994971973075,
                                         0.15625,
                                         0.0109071479388398,
                                         2.30764216904409e-05,
                                         0.0190517083915316,
                                         0.242391677108931,
                                         0.3125,
                                         0.0727159113450503,
                                         0.000937704918155274,
                                         0.000937704918155271,
                                         0.0727159113450503,
                                         0.3125,
                                         0.242391677108931,
                                         0.0190517083915316,
                                         2.30764216904408e-05,
                                         0.0109071479388398,
                                         0.15625,
                                         0.403994971973075,
                                         0.193540412132004,
                                         2.27159409202061e-07,
                                         0.000654414550868918,
                                         0.03125,
                                         0.269335877083235,
                                         0.78644687097721,

                                         0.842196202236558,
                                         0.395341042863498,
                                         0.0911043336944349,
                                         0.0079957584496648,
                                         0.000139478371613415,
                                         4.38883639124933e-08,
                                         0.14715346931811,
                                         0.40313351091672,
                                         0.280009758120111,
                                         0.0650377553651086,
                                         0.0034195572556818,
                                         6.27960278149708e-06,
                                         0.0102846075414971,
                                         0.164431829740637,
                                         0.344244720148905,
                                         0.211607674221776,
                                         0.0335345808518499,
                                         0.000359397412690162,
                                         0.000359397412690162,
                                         0.0335345808518499,
                                         0.211607674221776,
                                         0.344244720148905,
                                         0.164431829740637,
                                         0.0102846075414971,
                                         6.27960278149708e-06,
                                         0.0034195572556818,
                                         0.0650377553651086,
                                         0.280009758120111,
                                         0.40313351091672,
                                         0.14715346931811,
                                         4.38883639124933e-08,
                                         0.000139478371613415,
                                         0.0079957584496648,
                                         0.0911043336944349,
                                         0.395341042863498,
                                         0.842196202236558,

                                         0.879082114516863,
                                         0.500617815222906,
                                         0.171607971857582,
                                         0.03125,
                                         0.002313919518239,
                                         3.60487969159972e-05,
                                         1.06684506940694e-08,
                                         0.11476615467671,
                                         0.37149519410975,
                                         0.362634919079014,
                                         0.15625,
                                         0.02737512403488,
                                         0.00121446187189229,
                                         2.04294642030569e-06,
                                         0.00599319223620762,
                                         0.110270689575992,
                                         0.306522087784078,
                                         0.3125,
                                         0.129545977726207,
                                         0.0163657904225438,
                                         0.000156484955348201,
                                         0.0001564849553482,
                                         0.0163657904225438,
                                         0.129545977726207,
                                         0.3125,
                                         0.306522087784078,
                                         0.110270689575992,
                                         0.00599319223620765,
                                         2.04294642030567e-06,
                                         0.00121446187189229,
                                         0.02737512403488,
                                         0.15625,
                                         0.362634919079014,
                                         0.37149519410975,
                                         0.114766154676711,
                                         1.06684506940693e-08,
                                         3.60487969159972e-05,
                                         0.002313919518239,
                                         0.03125,
                                         0.171607971857582,
                                         0.500617815222906,
                                         0.879082114516863,

                                         0.904589380529803,
                                         0.585042404405521,
                                         0.258200580874888,
                                         0.0725389746531626,
                                         0.0113450072465114,
                                         0.000751420054528723,
                                         1.08616284922655e-05,
                                         3.08572560441647e-09,
                                         0.0916226087498726,
                                         0.331054022673763,
                                         0.401524761354074,
                                         0.250258069367259,
                                         0.0822106551024868,
                                         0.0120800205388372,
                                         0.00047986981079041,
                                         7.61633687107802e-07,
                                         0.00371204995982402,
                                         0.0749325280377545,
                                         0.249762620105905,
                                         0.34535421314063,
                                         0.238293080489951,
                                         0.077680597071767,
                                         0.00848031344367935,
                                         7.51960410876682e-05,
                                         7.51960410876682e-05,
                                         0.00848031344367935,
                                         0.077680597071767,
                                         0.238293080489951,
                                         0.34535421314063,
                                         0.249762620105905,
                                         0.0749325280377545,
                                         0.00371204995982402,
                                         7.61633687107802e-07,
                                         0.00047986981079041,
                                         0.0120800205388372,
                                         0.0822106551024869,
                                         0.250258069367259,
                                         0.401524761354074,
                                         0.331054022673762,
                                         0.0916226087498726,
                                         3.08572560441647e-09,
                                         1.08616284922655e-05,
                                         0.000751420054528723,
                                         0.0113450072465114,
                                         0.0725389746531626,
                                         0.258200580874888,
                                         0.585042404405521,
                                         0.904589380529803,

                                         0.922894997026383,
                                         0.652003905147058,
                                         0.341603125561172,
                                         0.12726399238635,
                                         0.03125,
                                         0.00440320892649167,
                                         0.000269972620664487,
                                         3.70388369077998e-06,
                                         1.02258397515478e-09,
                                         0.0746503132089526,
                                         0.291139833957761,
                                         0.409309116127218,
                                         0.324704492581161,
                                         0.15625,
                                         0.043144609953039,
                                         0.00563287546020995,
                                         0.000207369994494588,
                                         3.16052804784654e-07,
                                         0.00241529936998257,
                                         0.0520011627217691,
                                         0.196173793515064,
                                         0.331383623994174,
                                         0.3125,
                                         0.169100072158785,
                                         0.0470111167156726,
                                         0.00464402429522616,
                                         3.90733192927759e-05,
                                         3.90733192927754e-05,
                                         0.00464402429522616,
                                         0.0470111167156726,
                                         0.169100072158785,
                                         0.3125,
                                         0.331383623994174,
                                         0.196173793515064,
                                         0.0520011627217691,
                                         0.00241529936998259,
                                         3.1605280478465e-07,
                                         0.000207369994494588,
                                         0.00563287546020995,
                                         0.043144609953039,
                                         0.15625,
                                         0.324704492581161,
                                         0.409309116127218,
                                         0.291139833957761,
                                         0.0746503132089528,
                                         1.02258397515476e-09,
                                         3.70388369077998e-06,
                                         0.000269972620664486,
                                         0.00440320892649167,
                                         0.03125,
                                         0.12726399238635,
                                         0.341603125561172,
                                         0.652003905147058,
                                         0.922894997026383,

                                         0.936446431116567,
                                         0.705209218530758,
                                         0.417477561189361,
                                         0.189094999720692,
                                         0.0625478905957517,
                                         0.0139578473407194,
                                         0.00182494812670354,
                                         0.00010582853965376,
                                         1.39797489669503e-06,
                                         3.78015257903514e-10,
                                         0.0618953782575821,
                                         0.255108109000515,
                                         0.398471326154006,
                                         0.373735321836858,
                                         0.231688153013334,
                                         0.0942035551952969,
                                         0.0230837537520685,
                                         0.00277190839961517,
                                         9.66124507259321e-05,
                                         1.42979592796975e-07,
                                         0.00163641516368694,
                                         0.0369139515296794,
                                         0.152132150350388,
                                         0.295466492492801,
                                         0.34328511951689,
                                         0.254317434338008,
                                         0.116794484070877,
                                         0.0290412253669764,
                                         0.00267071051342544,
                                         2.16321045555329e-05,
                                         2.16321045555329e-05,
                                         0.00267071051342545,
                                         0.0290412253669764,
                                         0.116794484070877,
                                         0.254317434338008,
                                         0.34328511951689,
                                         0.295466492492801,
                                         0.152132150350388,
                                         0.0369139515296794,
                                         0.00163641516368694,
                                         1.42979592796975e-07,
                                         9.66124507259325e-05,
                                         0.00277190839961517,
                                         0.0230837537520685,
                                         0.0942035551952969,
                                         0.231688153013334,
                                         0.373735321836858,
                                         0.398471326154006,
                                         0.255108109000515,
                                         0.0618953782575821,
                                         3.78015257903514e-10,
                                         1.39797489669504e-06,
                                         0.00010582853965376,
                                         0.00182494812670354,
                                         0.0139578473407194,
                                         0.0625478905957517,
                                         0.189094999720692,
                                         0.417477561189361,
                                         0.705209218530758,
                                         0.936446431116567,

                                         0.946743794452276,
                                         0.74779328026935,
                                         0.484474947428454,
                                         0.252799556244087,
                                         0.103059341804127,
                                         0.03125,
                                         0.00649864531500619,
                                         0.000803787754037363,
                                         4.47142545506336e-05,
                                         5.74167958437527e-07,
                                         1.52853718181816e-10,
                                         0.0520968157857863,
                                         0.223770607808367,
                                         0.377812447958322,
                                         0.400146780691424,
                                         0.296486185644472,
                                         0.15625,
                                         0.0564736353000043,
                                         0.0126951657079414,
                                         0.00143344510217874,
                                         4.79686480354526e-05,
                                         6.94444117960244e-08,
                                         0.00114670018686031,
                                         0.026784559979405,
                                         0.117853149344396,
                                         0.253350834117938,
                                         0.341178419109555,
                                         0.3125,
                                         0.196303772826836,
                                         0.0802038754845725,
                                         0.0183812959120985,
                                         0.0016030091268839,
                                         1.26199778116212e-05,
                                         1.2619977811621e-05,
                                         0.0016030091268839,
                                         0.0183812959120985,
                                         0.0802038754845726,
                                         0.196303772826836,
                                         0.3125,
                                         0.341178419109555,
                                         0.253350834117938,
                                         0.117853149344396,
                                         0.0267845599794049,
                                         0.00114670018686032,
                                         6.9444411796023e-08,
                                         4.79686480354526e-05,
                                         0.00143344510217875,
                                         0.0126951657079414,
                                         0.0564736353000043,
                                         0.15625,
                                         0.296486185644472,
                                         0.400146780691424,
                                         0.377812447958322,
                                         0.223770607808367,
                                         0.0520968157857866,
                                         1.52853718181812e-10,
                                         5.74167958437527e-07,
                                         4.47142545506337e-05,
                                         0.000803787754037364,
                                         0.00649864531500619,
                                         0.03125,
                                         0.103059341804127,
                                         0.252799556244087,
                                         0.484474947428454,
                                         0.74779328026935,
                                         0.946743794452276,

                                         0.954743810235046,
                                         0.782201179063093,
                                         0.542746396770247,
                                         0.314897827762822,
                                         0.149628053000461,
                                         0.0563719569711638,
                                         0.0160070375468406,
                                         0.00315510839466618,
                                         0.000374048480890713,
                                         2.01561637663631e-05,
                                         2.53251650716092e-07,
                                         6.66162092530223e-11,
                                         0.0444217300579791,
                                         0.196940589839984,
                                         0.352800457076999,
                                         0.409346720362229,
                                         0.345766792336634,
                                         0.219120336643917,
                                         0.102951196320571,
                                         0.0341337526161048,
                                         0.0071935994751735,
                                         0.000775203449815615,
                                         2.51463829714782e-05,
                                         3.57940884802515e-08,
                                         0.000826730723023241,
                                         0.0198340769432118,
                                         0.0917320967983715,
                                         0.212849658140572,
                                         0.319604973226236,
                                         0.340692248491599,
                                         0.264857224025909,
                                         0.147711320425898,
                                         0.0553381457783124,
                                         0.0119256897408005,
                                         0.000998754519088418,
                                         7.69312324732106e-06,
                                         7.6931232473212e-06,
                                         0.000998754519088415,
                                         0.0119256897408005,
                                         0.0553381457783123,
                                         0.147711320425898,
                                         0.264857224025909,
                                         0.340692248491599,
                                         0.319604973226236,
                                         0.212849658140572,
                                         0.0917320967983715,
                                         0.0198340769432118,
                                         0.000826730723023231,
                                         3.57940884802524e-08,
                                         2.5146382971478e-05,
                                         0.000775203449815614,
                                         0.00719359947517349,
                                         0.0341337526161048,
                                         0.102951196320571,
                                         0.219120336643917,
                                         0.345766792336634,
                                         0.40934672036223,
                                         0.352800457076999,
                                         0.196940589839984,
                                         0.0444217300579788,
                                         6.66162092530243e-11,
                                         2.53251650716091e-07,
                                         2.01561637663631e-05,
                                         0.000374048480890713,
                                         0.00315510839466618,
                                         0.0160070375468406,
                                         0.0563719569711638,
                                         0.149628053000461,
                                         0.314897827762822,
                                         0.542746396770247,
                                         0.782201179063093,
                                         0.954743810235046,

                                         0.961078149449,
                                         0.810285960455949,
                                         0.593083006006198,
                                         0.373402930858594,
                                         0.199265288495983,
                                         0.0881423348296147,
                                         0.03125,
                                         0.00843355669109067,
                                         0.00159443253378056,
                                         0.000182871142914133,
                                         9.61165431070395e-06,
                                         1.18721196463647e-07,
                                         3.09359233218841e-11,
                                         0.0383062451441797,
                                         0.174095004083681,
                                         0.3266043892593,
                                         0.406575512497231,
                                         0.379346914210353,
                                         0.275625756276742,
                                         0.15625,
                                         0.0674241576433343,
                                         0.0209382920309579,
                                         0.00419876619684904,
                                         0.000436346618321083,
                                         1.38140263141593e-05,
                                         1.94040422297892e-08,
                                         0.000610717627026378,
                                         0.0149621599909454,
                                         0.0719430002230247,
                                         0.177078039513285,
                                         0.288869340780982,
                                         0.344758543871026,
                                         0.3125,
                                         0.215615650688193,
                                         0.109985731947944,
                                         0.0385618797911274,
                                         0.00792364623884607,
                                         0.00064294272191476,
                                         4.86834481632029e-06,
                                         4.86834481632039e-06,
                                         0.000642942721914762,
                                         0.00792364623884606,
                                         0.0385618797911274,
                                         0.109985731947944,
                                         0.215615650688193,
                                         0.3125,
                                         0.344758543871026,
                                         0.288869340780982,
                                         0.177078039513285,
                                         0.0719430002230248,
                                         0.0149621599909454,
                                         0.00061071762702637,
                                         1.94040422297897e-08,
                                         1.38140263141593e-05,
                                         0.000436346618321082,
                                         0.00419876619684905,
                                         0.0209382920309579,
                                         0.0674241576433343,
                                         0.15625,
                                         0.275625756276742,
                                         0.379346914210353,
                                         0.406575512497231,
                                         0.3266043892593,
                                         0.174095004083681,
                                         0.0383062451441794,
                                         3.09359233218852e-11,
                                         1.18721196463647e-07,
                                         9.61165431070392e-06,
                                         0.000182871142914133,
                                         0.00159443253378056,
                                         0.00843355669109067,
                                         0.03125,
                                         0.0881423348296147,
                                         0.199265288495983,
                                         0.373402930858594,
                                         0.593083006006198,
                                         0.810285960455949,
                                         0.961078149449,

                                         0.966176641946492,
                                         0.833441105376914,
                                         0.636475978417715,
                                         0.427368415918919,
                                         0.249614339733664,
                                         0.124812759375145,
                                         0.0521983181562325,
                                         0.0176417036768476,
                                         0.0045732742529975,
                                         0.000836460079688217,
                                         9.34412626268675e-05,
                                         4.81451103712612e-06,
                                         5.86620086634389e-08,
                                         1.51711216295204e-11,
                                         0.0333594413738503,
                                         0.15464693719019,
                                         0.300958113244535,
                                         0.396022337129878,
                                         0.3992773485059,
                                         0.322123672176564,
                                         0.210089001540789,
                                         0.109580612810338,
                                         0.0442999869459339,
                                         0.013073145226385,
                                         0.00252093383669489,
                                         0.000254547102080275,
                                         7.9037015269107e-06,
                                         1.0984883699268e-08,
                                         0.000460724170078617,
                                         0.0114780396733569,
                                         0.0569233020563524,
                                         0.146790156374649,
                                         0.255469940068353,
                                         0.332541835293092,
                                         0.338228434382118,
                                         0.272261929433675,
                                         0.171648471956268,
                                         0.0817287663860094,
                                         0.0272047154772325,
                                         0.0053832446682804,
                                         0.000425955396003506,
                                         3.18150952403269e-06,
                                         3.18150952403269e-06,
                                         0.000425955396003508,
                                         0.0053832446682804,
                                         0.0272047154772325,
                                         0.0817287663860093,
                                         0.171648471956268,
                                         0.272261929433675,
                                         0.338228434382118,
                                         0.332541835293092,
                                         0.255469940068353,
                                         0.146790156374649,
                                         0.0569233020563524,
                                         0.0114780396733568,
                                         0.000460724170078617,
                                         1.0984883699268e-08,
                                         7.90370152691075e-06,
                                         0.000254547102080275,
                                         0.00252093383669489,
                                         0.013073145226385,
                                         0.0442999869459338,
                                         0.109580612810338,
                                         0.210089001540789,
                                         0.322123672176564,
                                         0.3992773485059,
                                         0.396022337129878,
                                         0.300958113244535,
                                         0.15464693719019,
                                         0.0333594413738503,
                                         1.51711216295204e-11,
                                         5.86620086634393e-08,
                                         4.81451103712612e-06,
                                         9.34412626268674e-05,
                                         0.000836460079688216,
                                         0.0045732742529975,
                                         0.0176417036768476,
                                         0.0521983181562325,
                                         0.124812759375145,
                                         0.249614339733664,
                                         0.427368415918919,
                                         0.636475978417715,
                                         0.833441105376914,
                                         0.966176641946492,

                                         0.970339586555521,
                                         0.852716349532832,
                                         0.673911063431405,
                                         0.476499468897082,
                                         0.299014661083007,
                                         0.164588556080661,
                                         0.0781476571863817,
                                         0.03125,
                                         0.0101638057815719,
                                         0.00255076679373569,
                                         0.000454231587654232,
                                         4.96713972356689e-05,
                                         2.51834196726985e-06,
                                         3.03465290072794e-08,
                                         7.80027186169198e-12,
                                         0.0293042730140078,
                                         0.138049704446632,
                                         0.276741960866203,
                                         0.380751143578055,
                                         0.408300072526502,
                                         0.357621700100721,
                                         0.259844809480385,
                                         0.15625,
                                         0.0764184602643757,
                                         0.0293485422837327,
                                         0.00831630419480335,
                                         0.00155405931153298,
                                         0.000153314165652248,
                                         4.68617110406112e-06,
                                         6.4571748373324e-09,
                                         0.000353995829409715,
                                         0.00893977037416649,
                                         0.045457697349031,
                                         0.121697036659076,
                                         0.223011070589436,
                                         0.310819375121687,
                                         0.345598716301191,
                                         0.3125,
                                         0.229826550986094,
                                         0.135071059619463,
                                         0.0609036600185984,
                                         0.0194486201570192,
                                         0.00373344584574066,
                                         0.000289459128736202,
                                         2.13813608649453e-06,
                                         2.13813608649447e-06,
                                         0.000289459128736202,
                                         0.00373344584574066,
                                         0.0194486201570193,
                                         0.0609036600185984,
                                         0.135071059619463,
                                         0.229826550986094,
                                         0.3125,
                                         0.345598716301191,
                                         0.310819375121687,
                                         0.223011070589436,
                                         0.121697036659076,
                                         0.045457697349031,
                                         0.00893977037416649,
                                         0.000353995829409722,
                                         6.45717483733216e-09,
                                         4.68617110406112e-06,
                                         0.000153314165652248,
                                         0.00155405931153298,
                                         0.00831630419480335,
                                         0.0293485422837327,
                                         0.0764184602643757,
                                         0.15625,
                                         0.259844809480385,
                                         0.357621700100721,
                                         0.408300072526502,
                                         0.380751143578054,
                                         0.276741960866203,
                                         0.138049704446632,
                                         0.029304273014008,
                                         7.80027186169162e-12,
                                         3.03465290072794e-08,
                                         2.51834196726984e-06,
                                         4.9671397235669e-05,
                                         0.000454231587654232,
                                         0.00255076679373569,
                                         0.0101638057815719,
                                         0.03125,
                                         0.0781476571863817,
                                         0.164588556080661,
                                         0.299014661083007,
                                         0.476499468897082,
                                         0.673911063431405,
                                         0.852716349532832,
                                         0.970339586555521,

                                         0.973781703490346,
                                         0.868907483560764,
                                         0.706283409595617,
                                         0.520877916313063,
                                         0.346398906828627,
                                         0.205902978632174,
                                         0.10804844763362,
                                         0.0491977708598261,
                                         0.0189698065111919,
                                         0.00597958311931442,
                                         0.00146143409524511,
                                         0.000254606923303208,
                                         2.73585545929656e-05,
                                         1.36880687032184e-06,
                                         1.63447253260345e-08,
                                         4.18011087188279e-12,
                                         0.0259404109993526,
                                         0.123829568559764,
                                         0.254344085796055,
                                         0.362891996593532,
                                         0.409077182726811,
                                         0.382697790447774,
                                         0.302830079850391,
                                         0.203300723836565,
                                         0.114764986614499,
                                         0.0533372274195243,
                                         0.0196573929087428,
                                         0.00538990951018953,
                                         0.000981729208930638,
                                         9.50253649915821e-05,
                                         2.86725826426549e-06,
                                         3.92294814228481e-09,
                                         0.000276408940691091,
                                         0.00705886982897649,
                                         0.0366373685693507,
                                         0.101129725079372,
                                         0.193238648423905,
                                         0.28451768845023,
                                         0.339499768004661,
                                         0.336041113978369,
                                         0.27772559819955,
                                         0.19030489397249,
                                         0.105762715465834,
                                         0.0456407455871653,
                                         0.0140912742505101,
                                         0.00263874186711534,
                                         0.000201194447505428,
                                         1.47264248233915e-06,
                                         1.47264248233919e-06,
                                         0.000201194447505428,
                                         0.00263874186711533,
                                         0.0140912742505101,
                                         0.0456407455871653,
                                         0.105762715465834,
                                         0.19030489397249,
                                         0.27772559819955,
                                         0.336041113978368,
                                         0.339499768004661,
                                         0.28451768845023,
                                         0.193238648423905,
                                         0.101129725079371,
                                         0.0366373685693508,
                                         0.00705886982897649,
                                         0.000276408940691085,
                                         3.92294814228497e-09,
                                         2.86725826426549e-06,
                                         9.50253649915818e-05,
                                         0.00098172920893064,
                                         0.00538990951018953,
                                         0.0196573929087428,
                                         0.0533372274195243,
                                         0.114764986614499,
                                         0.203300723836565,
                                         0.302830079850391,
                                         0.382697790447774,
                                         0.409077182726811,
                                         0.362891996593532,
                                         0.254344085796055,
                                         0.123829568559764,
                                         0.0259404109993523,
                                         4.18011087188301e-12,
                                         1.63447253260345e-08,
                                         1.36880687032183e-06,
                                         2.73585545929657e-05,
                                         0.000254606923303208,
                                         0.00146143409524511,
                                         0.00597958311931443,
                                         0.0189698065111919,
                                         0.0491977708598261,
                                         0.10804844763362,
                                         0.205902978632174,
                                         0.346398906828627,
                                         0.520877916313063,
                                         0.706283409595617,
                                         0.868907483560764,
                                         0.973781703490346,

                                         0.97665969853552,
                                         0.882622903215021,
                                         0.734370938736272,
                                         0.560784788110404,
                                         0.391148734311032,
                                         0.247514400905269,
                                         0.140766479732878,
                                         0.0710344151361086,
                                         0.03125,
                                         0.0116931002532677,
                                         0.00359168231124755,
                                         0.000858764822478534,
                                         0.000146915449748258,
                                         1.55585117355168e-05,
                                         7.69882242787479e-07,
                                         9.12352194387934e-09,
                                         2.32352475190747e-12,
                                         0.0231203326686423,
                                         0.111589328133212,
                                         0.233876857970521,
                                         0.343874992736012,
                                         0.403884365261647,
                                         0.398680717606729,
                                         0.337931742322539,
                                         0.247588795033434,
                                         0.15625,
                                         0.0838701664090441,
                                         0.037403150692382,
                                         0.0133287522550794,
                                         0.0035570696195766,
                                         0.000634313114592569,
                                         6.04355589366917e-05,
                                         1.8040769579775e-06,
                                         2.45378496090537e-09,
                                         0.000218929800629732,
                                         0.00564326083443507,
                                         0.0297933274910305,
                                         0.0843460900768311,
                                         0.16681386510441,
                                         0.256867986686964,
                                         0.324503000105854,
                                         0.345185985180005,
                                         0.3125,
                                         0.24062753798814,
                                         0.155803944835099,
                                         0.0827493777234798,
                                         0.034449050253586,
                                         0.0103442574504253,
                                         0.00189767036099757,
                                         0.000142694616851941,
                                         1.03653909938724e-06,
                                         1.03653909938721e-06,
                                         0.000142694616851942,
                                         0.00189767036099757,
                                         0.0103442574504253,
                                         0.034449050253586,
                                         0.0827493777234799,
                                         0.155803944835099,
                                         0.24062753798814,
                                         0.3125,
                                         0.345185985180005,
                                         0.324503000105854,
                                         0.256867986686964,
                                         0.16681386510441,
                                         0.084346090076831,
                                         0.0297933274910305,
                                         0.00564326083443504,
                                         0.000218929800629737,
                                         2.45378496090525e-09,
                                         1.80407695797751e-06,
                                         6.04355589366917e-05,
                                         0.00063431311459257,
                                         0.00355706961957661,
                                         0.0133287522550794,
                                         0.037403150692382,
                                         0.0838701664090441,
                                         0.15625,
                                         0.247588795033434,
                                         0.337931742322539,
                                         0.398680717606729,
                                         0.403884365261647,
                                         0.343874992736011,
                                         0.233876857970521,
                                         0.111589328133212,
                                         0.0231203326686426,
                                         2.32352475190734e-12,
                                         9.12352194387944e-09,
                                         7.69882242787479e-07,
                                         1.55585117355169e-05,
                                         0.000146915449748259,
                                         0.000858764822478534,
                                         0.00359168231124755,
                                         0.0116931002532677,
                                         0.03125,
                                         0.0710344151361086,
                                         0.140766479732878,
                                         0.247514400905269,
                                         0.391148734311032,
                                         0.560784788110404,
                                         0.734370938736272,
                                         0.882622903215021,
                                         0.97665969853552,

                                         0.979090038457521,
                                         0.894332104141364,
                                         0.758834434927316,
                                         0.596592127449347,
                                         0.43296235441263,
                                         0.288505431581841,
                                         0.175243044759442,
                                         0.0960891444563751,
                                         0.0469405729977668,
                                         0.0200673194420643,
                                         0.0073229872337077,
                                         0.00220117926679346,
                                         0.000516706703666593,
                                         8.70580437338779e-05,
                                         9.10744721401243e-06,
                                         4.465000983826e-07,
                                         5.25756253449221e-09,
                                         1.33423429116988e-12,
                                         0.0207335911123645,
                                         0.101001064388041,
                                         0.215303921691312,
                                         0.324632017979952,
                                         0.394540775967116,
                                         0.407138355986811,
                                         0.365101585730731,
                                         0.287109207905955,
                                         0.198018873928661,
                                         0.118924455842412,
                                         0.0612710737565772,
                                         0.0264132896055629,
                                         0.00915368745971148,
                                         0.00238840050772845,
                                         0.000418430022926439,
                                         3.93420202462602e-05,
                                         1.16385084469564e-06,
                                         1.57514380453108e-09,
                                         0.000175625032848649,
                                         0.00456260709429019,
                                         0.0244352530997614,
                                         0.070658624040716,
                                         0.143811509073956,
                                         0.229821171832769,
                                         0.30426124605647,
                                         0.343146763271722,
                                         0.334137160480256,
                                         0.28191161730884,
                                         0.205060823375663,
                                         0.126779654581001,
                                         0.0648646464352009,
                                         0.0262099019948352,
                                         0.00768969305984413,
                                         0.00138660176126623,
                                         0.000103055267897415,
                                         7.43820788109766e-07,
                                         7.43820788109766e-07,
                                         0.000103055267897415,
                                         0.00138660176126623,
                                         0.00768969305984412,
                                         0.0262099019948352,
                                         0.0648646464352009,
                                         0.126779654581001,
                                         0.205060823375663,
                                         0.28191161730884,
                                         0.334137160480256,
                                         0.343146763271722,
                                         0.30426124605647,
                                         0.229821171832769,
                                         0.143811509073956,
                                         0.0706586240407161,
                                         0.0244352530997614,
                                         0.00456260709429019,
                                         0.000175625032848649,
                                         1.57514380453108e-09,
                                         1.16385084469564e-06,
                                         3.93420202462602e-05,
                                         0.000418430022926438,
                                         0.00238840050772845,
                                         0.00915368745971148,
                                         0.0264132896055629,
                                         0.0612710737565772,
                                         0.118924455842412,
                                         0.198018873928661,
                                         0.287109207905955,
                                         0.365101585730731,
                                         0.407138355986811,
                                         0.394540775967116,
                                         0.324632017979952,
                                         0.215303921691312,
                                         0.101001064388041,
                                         0.0207335911123645,
                                         1.33423429116988e-12,
                                         5.25756253449221e-09,
                                         4.465000983826e-07,
                                         9.1074472140124e-06,
                                         8.70580437338779e-05,
                                         0.000516706703666593,
                                         0.00220117926679346,
                                         0.0073229872337077,
                                         0.0200673194420643,
                                         0.0469405729977668,
                                         0.0960891444563751,
                                         0.175243044759442,
                                         0.288505431581841,
                                         0.43296235441263,
                                         0.596592127449347,
                                         0.758834434927316,
                                         0.894332104141364,
                                         0.979090038457521,

                                         0.98116070345907,
                                         0.904400881013132,
                                         0.780228579088967,
                                         0.628699985817667,
                                         0.47174977004354,
                                         0.328238772720487,
                                         0.2105725664303,
                                         0.123611838159504,
                                         0.0657372048597563,
                                         0.03125,
                                         0.013041247108964,
                                         0.00465949619833076,
                                         0.00137518307818972,
                                         0.000317824720394769,
                                         5.2860865028868e-05,
                                         5.47285808961825e-06,
                                         2.66204736245096e-07,
                                         3.11760119467715e-09,
                                         7.88790513321357e-13,
                                         0.0186962478545084,
                                         0.0917958182839067,
                                         0.198513772760937,
                                         0.305750800107497,
                                         0.38244255875005,
                                         0.409599523904138,
                                         0.384913852042446,
                                         0.320838035421231,
                                         0.237838860974822,
                                         0.15625,
                                         0.0901130211979348,
                                         0.0448800349697231,
                                         0.0188078337886107,
                                         0.00636734115119639,
                                         0.001630120677676,
                                         0.000281339067805823,
                                         2.61569436994922e-05,
                                         7.67889354826942e-07,
                                         1.03487376311392e-09,
                                         0.000142504559183781,
                                         0.00372687485442184,
                                         0.0202031656014422,
                                         0.0594773684588477,
                                         0.124016858115086,
                                         0.204450886276453,
                                         0.281439650009101,
                                         0.333097691954486,
                                         0.344202792987512,
                                         0.3125,
                                         0.249066872871011,
                                         0.172912903296725,
                                         0.102890914651352,
                                         0.0510256512273314,
                                         0.0201078315486187,
                                         0.00578503369009302,
                                         0.00102805940021814,
                                         7.56548415831101e-05,
                                         5.43091575009979e-07,
                                         5.43091575009979e-07,
                                         7.56548415831101e-05,
                                         0.00102805940021814,
                                         0.00578503369009303,
                                         0.0201078315486187,
                                         0.0510256512273314,
                                         0.102890914651352,
                                         0.172912903296725,
                                         0.24906687287101,
                                         0.3125,
                                         0.344202792987512,
                                         0.333097691954486,
                                         0.281439650009101,
                                         0.204450886276453,
                                         0.124016858115086,
                                         0.0594773684588477,
                                         0.0202031656014422,
                                         0.00372687485442184,
                                         0.000142504559183781,
                                         1.03487376311392e-09,
                                         7.67889354826942e-07,
                                         2.61569436994922e-05,
                                         0.000281339067805823,
                                         0.001630120677676,
                                         0.0063673411511964,
                                         0.0188078337886107,
                                         0.0448800349697231,
                                         0.0901130211979348,
                                         0.15625,
                                         0.237838860974822,
                                         0.320838035421231,
                                         0.384913852042446,
                                         0.409599523904138,
                                         0.38244255875005,
                                         0.305750800107497,
                                         0.198513772760937,
                                         0.0917958182839066,
                                         0.0186962478545084,
                                         7.88790513321357e-13,
                                         3.11760119467715e-09,
                                         2.66204736245096e-07,
                                         5.47285808961825e-06,
                                         5.28608650288679e-05,
                                         0.000317824720394769,
                                         0.00137518307818972,
                                         0.00465949619833076,
                                         0.013041247108964,
                                         0.03125,
                                         0.0657372048597563,
                                         0.123611838159504,
                                         0.2105725664303,
                                         0.328238772720487,
                                         0.47174977004354,
                                         0.628699985817667,
                                         0.780228579088967,
                                         0.904400881013132,
                                         0.98116070345907,

                                         0.982939133480475,
                                         0.913116941337277,
                                         0.799016388116032,
                                         0.657501552479643,
                                         0.507555999986976,
                                         0.366300716303642,
                                         0.246026111308694,
                                         0.152868898973341,
                                         0.0871892904266643,
                                         0.045182857045992,
                                         0.0209880533359137,
                                         0.00858101764862591,
                                         0.00301120948428896,
                                         0.000874953219047563,
                                         0.000199543083706618,
                                         3.28230735874121e-05,
                                         3.36822567448809e-06,
                                         1.62731247444625e-07,
                                         1.89694690432101e-09,
                                         4.78714334401927e-13,
                                         0.0169436351612265,
                                         0.0837533447126836,
                                         0.183361749750767,
                                         0.287585951343019,
                                         0.368631994883458,
                                         0.407424887754146,
                                         0.398246467979707,
                                         0.348476509779869,
                                         0.274187895363778,
                                         0.193795365754003,
                                         0.122332674192269,
                                         0.0682171653611605,
                                         0.0330237667046852,
                                         0.0135130726426345,
                                         0.00448504599817663,
                                         0.00112982243596163,
                                         0.000192517541254668,
                                         1.77279249548442e-05,
                                         5.17034382655079e-07,
                                         6.94282910019355e-10,
                                         0.000116827894097658,
                                         0.00307282558586135,
                                         0.0168314601661363,
                                         0.0503151234231832,
                                         0.10709324500567,
                                         0.181266409562659,
                                         0.257859214072302,
                                         0.317751690982053,
                                         0.344900166504976,
                                         0.332485781051858,
                                         0.285215268619964,
                                         0.216924464694795,
                                         0.144867924075763,
                                         0.0834801807776153,
                                         0.0403233972976695,
                                         0.0155561146143465,
                                         0.00440148698722521,
                                         0.000772511310863102,
                                         5.63694328478221e-05,
                                         4.02769438477047e-07,
                                         4.02769438477027e-07,
                                         5.63694328478216e-05,
                                         0.000772511310863102,
                                         0.0044014869872252,
                                         0.0155561146143465,
                                         0.0403233972976695,
                                         0.0834801807776153,
                                         0.144867924075763,
                                         0.216924464694795,
                                         0.285215268619964,
                                         0.332485781051858,
                                         0.344900166504976,
                                         0.317751690982053,
                                         0.257859214072302,
                                         0.181266409562659,
                                         0.10709324500567,
                                         0.0503151234231833,
                                         0.0168314601661363,
                                         0.00307282558586137,
                                         0.000116827894097662,
                                         6.9428291001931e-10,
                                         5.17034382655072e-07,
                                         1.77279249548442e-05,
                                         0.000192517541254668,
                                         0.00112982243596163,
                                         0.00448504599817663,
                                         0.0135130726426345,
                                         0.0330237667046852,
                                         0.0682171653611605,
                                         0.122332674192269,
                                         0.193795365754003,
                                         0.274187895363778,
                                         0.348476509779869,
                                         0.398246467979706,
                                         0.407424887754146,
                                         0.368631994883458,
                                         0.28758595134302,
                                         0.183361749750767,
                                         0.0837533447126838,
                                         0.0169436351612268,
                                         4.78714334401888e-13,
                                         1.89694690432098e-09,
                                         1.62731247444625e-07,
                                         3.36822567448808e-06,
                                         3.28230735874121e-05,
                                         0.000199543083706618,
                                         0.000874953219047563,
                                         0.00301120948428896,
                                         0.00858101764862591,
                                         0.0209880533359137,
                                         0.045182857045992,
                                         0.0871892904266643,
                                         0.152868898973341,
                                         0.246026111308694,
                                         0.366300716303642,
                                         0.507555999986976,
                                         0.657501552479643,
                                         0.799016388116032,
                                         0.913116941337277,
                                         0.982939133480475,

                                         0.984477710598813,
                                         0.920708654774105,
                                         0.815583642223294,
                                         0.683365252300584,
                                         0.540507375708598,
                                         0.402447119064048,
                                         0.281044594773174,
                                         0.183198371246392,
                                         0.110780998449751,
                                         0.0616513712004949,
                                         0.03125,
                                         0.0142315815667228,
                                         0.00571722095009891,
                                         0.00197547842390004,
                                         0.000566352500871622,
                                         0.000127692640289202,
                                         2.08050166966591e-05,
                                         2.11866580654319e-06,
                                         1.01765838242085e-07,
                                         1.18152171491229e-09,
                                         2.97506066989199e-13,
                                         0.0154253092598201,
                                         0.0766930706331301,
                                         0.169693502077372,
                                         0.270336576391104,
                                         0.353870954755965,
                                         0.401763275384426,
                                         0.406076220710303,
                                         0.37020454733793,
                                         0.306181692688822,
                                         0.229918983011068,
                                         0.15625,
                                         0.0954027921541729,
                                         0.0517143464431009,
                                         0.024439491106556,
                                         0.0097992877314892,
                                         0.00319774966744404,
                                         0.00079444673440631,
                                         0.000133890742121998,
                                         1.22277152618288e-05,
                                         3.54607417509423e-07,
                                         4.74687552102609e-10,
                                         9.66767101781773e-05,
                                         0.0025553477976511,
                                         0.0141228357983174,
                                         0.042777629848067,
                                         0.092671928819273,
                                         0.160432237480556,
                                         0.234692856711154,
                                         0.299241540057918,
                                         0.338495699622404,
                                         0.342978511066235,
                                         0.3125,
                                         0.255816761001306,
                                         0.187110041845823,
                                         0.120940571827304,
                                         0.0678206875730078,
                                         0.0320319257632366,
                                         0.012134488965062,
                                         0.0033845320523162,
                                         0.000587690419917471,
                                         4.25710061747066e-05,
                                         3.02956204425031e-07,
                                         3.02956204425048e-07,
                                         4.25710061747062e-05,
                                         0.000587690419917474,
                                         0.0033845320523162,
                                         0.012134488965062,
                                         0.0320319257632366,
                                         0.0678206875730078,
                                         0.120940571827304,
                                         0.187110041845823,
                                         0.255816761001306,
                                         0.3125,
                                         0.342978511066235,
                                         0.338495699622404,
                                         0.299241540057918,
                                         0.234692856711154,
                                         0.160432237480556,
                                         0.092671928819273,
                                         0.042777629848067,
                                         0.0141228357983173,
                                         0.00255534779765112,
                                         9.66767101781738e-05,
                                         4.74687552102643e-10,
                                         3.54607417509418e-07,
                                         1.22277152618289e-05,
                                         0.000133890742121998,
                                         0.00079444673440631,
                                         0.00319774966744404,
                                         0.0097992877314892,
                                         0.024439491106556,
                                         0.0517143464431009,
                                         0.0954027921541729,
                                         0.15625,
                                         0.229918983011068,
                                         0.306181692688822,
                                         0.37020454733793,
                                         0.406076220710303,
                                         0.401763275384426,
                                         0.353870954755965,
                                         0.270336576391104,
                                         0.169693502077372,
                                         0.0766930706331304,
                                         0.0154253092598198,
                                         2.97506066989225e-13,
                                         1.18152171491227e-09,
                                         1.01765838242086e-07,
                                         2.11866580654319e-06,
                                         2.08050166966591e-05,
                                         0.000127692640289202,
                                         0.000566352500871622,
                                         0.00197547842390004,
                                         0.00571722095009891,
                                         0.0142315815667228,
                                         0.03125,
                                         0.0616513712004949,
                                         0.110780998449751,
                                         0.183198371246392,
                                         0.281044594773174,
                                         0.402447119064048,
                                         0.540507375708598,
                                         0.683365252300584,
                                         0.815583642223294,
                                         0.920708654774105,
                                         0.984477710598813,

                                         0.985817611272415,
                                         0.927358883169568,
                                         0.830251908189687,
                                         0.706626798199257,
                                         0.570775205306482,
                                         0.436557612320609,
                                         0.31521780089868,
                                         0.214035068411745,
                                         0.135990556499343,
                                         0.0803403621199148,
                                         0.0437763676812723,
                                         0.0217707531821425,
                                         0.00974672184409651,
                                         0.00385648172376317,
                                         0.0013148220379631,
                                         0.000372589448330347,
                                         8.31757307409397e-05,
                                         1.34401753463899e-05,
                                         1.35959347889707e-06,
                                         6.49755261212705e-08,
                                         7.51749061641046e-10,
                                         1.88923523163654e-13,
                                         0.0141014726510423,
                                         0.070466524557229,
                                         0.157357653651719,
                                         0.254099553450246,
                                         0.338706140709618,
                                         0.393552414982249,
                                         0.409359338861938,
                                         0.38648384748794,
                                         0.33343812921574,
                                         0.263444263770927,
                                         0.190342808880085,
                                         0.125174744137578,
                                         0.0743093767945626,
                                         0.0393210201378001,
                                         0.0182037377935623,
                                         0.00717259968144727,
                                         0.00230661768502451,
                                         0.000566222303101648,
                                         9.45225182217549e-05,
                                         8.57061180309869e-06,
                                         2.47330620676855e-07,
                                         3.30185614168098e-10,
                                         8.0684917231873e-05,
                                         0.00214179479952924,
                                         0.0119295991582917,
                                         0.0365491845076658,
                                         0.080397220263135,
                                         0.141913460186889,
                                         0.212646706925472,
                                         0.279150076625265,
                                         0.327025607886028,
                                         0.34554427330171,
                                         0.331049712997181,
                                         0.287885613121742,
                                         0.226615002168789,
                                         0.160368204537326,
                                         0.100812447643524,
                                         0.0552309641841323,
                                         0.0255867190944873,
                                         0.00954177124231793,
                                         0.00262858173113035,
                                         0.000452203412973169,
                                         3.25493913039868e-05,
                                         2.30828936445621e-07,
                                         2.30828936445621e-07,
                                         3.25493913039868e-05,
                                         0.000452203412973167,
                                         0.00262858173113036,
                                         0.00954177124231795,
                                         0.0255867190944873,
                                         0.0552309641841323,
                                         0.100812447643524,
                                         0.160368204537326,
                                         0.226615002168789,
                                         0.287885613121742,
                                         0.331049712997181,
                                         0.34554427330171,
                                         0.327025607886028,
                                         0.279150076625265,
                                         0.212646706925472,
                                         0.141913460186889,
                                         0.080397220263135,
                                         0.0365491845076657,
                                         0.0119295991582917,
                                         0.00214179479952924,
                                         8.0684917231873e-05,
                                         3.30185614168098e-10,
                                         2.47330620676855e-07,
                                         8.57061180309864e-06,
                                         9.45225182217552e-05,
                                         0.000566222303101649,
                                         0.00230661768502451,
                                         0.00717259968144727,
                                         0.0182037377935623,
                                         0.0393210201378001,
                                         0.0743093767945626,
                                         0.125174744137578,
                                         0.190342808880085,
                                         0.263444263770927,
                                         0.33343812921574,
                                         0.38648384748794,
                                         0.409359338861938,
                                         0.393552414982249,
                                         0.338706140709617,
                                         0.254099553450246,
                                         0.157357653651719,
                                         0.070466524557229,
                                         0.0141014726510423,
                                         1.88923523163654e-13,
                                         7.51749061641046e-10,
                                         6.497552612127e-08,
                                         1.35959347889707e-06,
                                         1.344017534639e-05,
                                         8.31757307409397e-05,
                                         0.000372589448330347,
                                         0.0013148220379631,
                                         0.00385648172376317,
                                         0.0097467218440965,
                                         0.0217707531821425,
                                         0.0437763676812723,
                                         0.0803403621199148,
                                         0.135990556499343,
                                         0.214035068411745,
                                         0.31521780089868,
                                         0.436557612320609,
                                         0.570775205306482,
                                         0.706626798199257,
                                         0.830251908189687,
                                         0.927358883169568,
                                         0.985817611272415,

                                         0.986991558480799,
                                         0.933215269062265,
                                         0.843289730210885,
                                         0.727586903133462,
                                         0.598551870509014,
                                         0.4685992516072,
                                         0.348258803031577,
                                         0.244916325136397,
                                         0.162328306085754,
                                         0.100883111897818,
                                         0.058410609315661,
                                         0.03125,
                                         0.0152862928818678,
                                         0.00674277623367906,
                                         0.00263285717070057,
                                         0.000887234738581694,
                                         0.000248883546992533,
                                         5.50803785263624e-05,
                                         8.83619833475794e-06,
                                         8.8867530513844e-07,
                                         4.228252458487e-08,
                                         4.87705057509945e-10,
                                         1.2235861556374e-13,
                                         0.0129403989526022,
                                         0.0649511619745965,
                                         0.146212207963319,
                                         0.238905707429487,
                                         0.3235225293273,
                                         0.383539996629448,
                                         0.408969503501959,
                                         0.397916455511562,
                                         0.355935142863028,
                                         0.293624662114185,
                                         0.223369477806842,
                                         0.15625,
                                         0.0999332686558529,
                                         0.0579168183954917,
                                         0.0300186180864152,
                                         0.0136522546816656,
                                         0.00529843212193558,
                                         0.00168239456005362,
                                         0.000408698201981115,
                                         6.76614761649952e-05,
                                         6.09668974405258e-06,
                                         1.75183088581687e-07,
                                         2.33313750818567e-10,
                                         6.78643798373548e-05,
                                         0.00180822306779843,
                                         0.0101402917605378,
                                         0.0313782102435201,
                                         0.0699467044641086,
                                         0.125568215066485,
                                         0.192105472526388,
                                         0.258598532341532,
                                         0.312181723520226,
                                         0.341842913366886,
                                         0.341677131605087,
                                         0.3125,
                                         0.261323219734689,
                                         0.198989717991939,
                                         0.136903352273876,
                                         0.0840291975902609,
                                         0.0451189052711483,
                                         0.0205550617582871,
                                         0.00756136129926161,
                                         0.00206062904206077,
                                         0.000351631092988581,
                                         2.51702245465384e-05,
                                         1.77953325379598e-07,
                                         1.77953325379609e-07,
                                         2.51702245465384e-05,
                                         0.000351631092988579,
                                         0.00206062904206077,
                                         0.00756136129926161,
                                         0.020555061758287,
                                         0.0451189052711484,
                                         0.0840291975902608,
                                         0.136903352273876,
                                         0.198989717991939,
                                         0.261323219734689,
                                         0.3125,
                                         0.341677131605087,
                                         0.341842913366886,
                                         0.312181723520226,
                                         0.258598532341532,
                                         0.192105472526388,
                                         0.125568215066485,
                                         0.0699467044641086,
                                         0.0313782102435201,
                                         0.0101402917605378,
                                         0.00180822306779843,
                                         6.78643798373519e-05,
                                         2.33313750818587e-10,
                                         1.75183088581687e-07,
                                         6.09668974405254e-06,
                                         6.76614761649952e-05,
                                         0.000408698201981115,
                                         0.00168239456005362,
                                         0.00529843212193559,
                                         0.0136522546816656,
                                         0.0300186180864152,
                                         0.0579168183954917,
                                         0.0999332686558529,
                                         0.15625,
                                         0.223369477806842,
                                         0.293624662114185,
                                         0.355935142863028,
                                         0.397916455511562,
                                         0.408969503501959,
                                         0.383539996629448,
                                         0.3235225293273,
                                         0.238905707429487,
                                         0.14621220796332,
                                         0.0649511619745964,
                                         0.012940398952602,
                                         1.22358615563753e-13,
                                         4.87705057509945e-10,
                                         4.22825245848697e-08,
                                         8.8867530513844e-07,
                                         8.83619833475794e-06,
                                         5.50803785263623e-05,
                                         0.000248883546992534,
                                         0.000887234738581693,
                                         0.00263285717070057,
                                         0.00674277623367906,
                                         0.0152862928818678,
                                         0.03125,
                                         0.058410609315661,
                                         0.100883111897818,
                                         0.162328306085754,
                                         0.244916325136397,
                                         0.348258803031577,
                                         0.4685992516072,
                                         0.598551870509014,
                                         0.727586903133462,
                                         0.843289730210885,
                                         0.933215269062265,
                                         0.986991558480799,

                                         0.988025817941392,
                                         0.938397957393713,
                                         0.854921995854458,
                                         0.746512069629435,
                                         0.624035549809504,
                                         0.498598818739284,
                                         0.379978876760859,
                                         0.27547661060306,
                                         0.189357743346661,
                                         0.122899258342423,
                                         0.0749247912415125,
                                         0.0426259693762454,
                                         0.0224438456232883,
                                         0.0108211532824601,
                                         0.0047115909497125,
                                         0.00181854581178343,
                                         0.000606589117436422,
                                         0.000168649682355491,
                                         3.70407087815065e-05,
                                         5.9045742578186e-06,
                                         5.90805947271715e-07,
                                         2.80008538690956e-08,
                                         3.22107112265813e-10,
                                         8.06919242480726e-14,
                                         0.0119165531218229,
                                         0.0600453955689333,
                                         0.136127369423255,
                                         0.224744174334596,
                                         0.308585266700376,
                                         0.372311849133901,
                                         0.405671664061228,
                                         0.40515081041999,
                                         0.373887812624005,
                                         0.320068496487904,
                                         0.254404709927408,
                                         0.187468745752009,
                                         0.127580023057418,
                                         0.0796735102616688,
                                         0.0452286807110382,
                                         0.0230253380469322,
                                         0.0103110440484412,
                                         0.00394921081164317,
                                         0.00124011992142391,
                                         0.000298512651200756,
                                         4.90606454820233e-05,
                                         4.39635063411921e-06,
                                         1.25848390766791e-07,
                                         1.672583163131e-10,
                                         5.74900921520859e-05,
                                         0.00153685310187306,
                                         0.00867010594929178,
                                         0.0270645022108818,
                                         0.0610381039052094,
                                         0.111204525799719,
                                         0.17324068161376,
                                         0.238346448106257,
                                         0.29529734344762,
                                         0.333423793847795,
                                         0.345529191931276,
                                         0.329794546827754,
                                         0.290086869363285,
                                         0.234646643355675,
                                         0.173668179661128,
                                         0.116613216722999,
                                         0.0701084977048164,
                                         0.0369909170701537,
                                         0.016607645696891,
                                         0.00603666235945183,
                                         0.00162960237365776,
                                         0.000276104421507695,
                                         1.96677649831228e-05,
                                         1.38677294594627e-07,
                                         1.38677294594636e-07,
                                         1.96677649831228e-05,
                                         0.000276104421507697,
                                         0.00162960237365776,
                                         0.00603666235945183,
                                         0.016607645696891,
                                         0.0369909170701537,
                                         0.0701084977048165,
                                         0.116613216722999,
                                         0.173668179661128,
                                         0.234646643355675,
                                         0.290086869363285,
                                         0.329794546827754,
                                         0.345529191931276,
                                         0.333423793847795,
                                         0.29529734344762,
                                         0.238346448106257,
                                         0.17324068161376,
                                         0.111204525799719,
                                         0.0610381039052094,
                                         0.0270645022108818,
                                         0.00867010594929175,
                                         0.00153685310187306,
                                         5.74900921520832e-05,
                                         1.67258316313116e-10,
                                         1.25848390766791e-07,
                                         4.39635063411925e-06,
                                         4.90606454820233e-05,
                                         0.000298512651200756,
                                         0.00124011992142391,
                                         0.00394921081164317,
                                         0.0103110440484412,
                                         0.0230253380469322,
                                         0.0452286807110382,
                                         0.0796735102616688,
                                         0.127580023057418,
                                         0.187468745752009,
                                         0.254404709927408,
                                         0.320068496487904,
                                         0.373887812624005,
                                         0.405150810419989,
                                         0.405671664061228,
                                         0.372311849133901,
                                         0.308585266700376,
                                         0.224744174334596,
                                         0.136127369423255,
                                         0.0600453955689333,
                                         0.0119165531218226,
                                         8.06919242480819e-14,
                                         3.22107112265813e-10,
                                         2.80008538690959e-08,
                                         5.90805947271715e-07,
                                         5.9045742578186e-06,
                                         3.70407087815066e-05,
                                         0.000168649682355491,
                                         0.000606589117436422,
                                         0.00181854581178343,
                                         0.0047115909497125,
                                         0.0108211532824601,
                                         0.0224438456232883,
                                         0.0426259693762454,
                                         0.0749247912415125,
                                         0.122899258342423,
                                         0.189357743346661,
                                         0.27547661060306,
                                         0.379978876760859,
                                         0.498598818739284,
                                         0.624035549809504,
                                         0.746512069629435,
                                         0.854921995854458,
                                         0.938397957393713,
                                         0.988025817941392,

                                         0.015625,
                                         0.09375,
                                         0.234375,
                                         0.3125,
                                         0.234375,
                                         0.09375,
                                         0.015625,

                                         0.240651676451543,
                                         8.90642891983359e-05,
                                         0.38689453417432,
                                         0.00199435471456919,
                                         0.259170194970061,
                                         0.0186075828077168,
                                         0.0925925925925925,
                                         0.0925925925925925,
                                         0.0186075828077168,
                                         0.259170194970061,
                                         0.00199435471456919,
                                         0.38689453417432,
                                         8.90642891983359e-05,
                                         0.240651676451543,

                                         0.487997950811067,
                                         0.015625,
                                         2.04918893273626e-06,
                                         0.371903200617956,
                                         0.09375,
                                         9.67993820439904e-05,
                                         0.118094750193112,
                                         0.234375,
                                         0.00190524980688876,
                                         0.0200000000000001,
                                         0.3125,
                                         0.0200000000000001,
                                         0.00190524980688876,
                                         0.234375,
                                         0.118094750193112,
                                         9.67993820439904e-05,
                                         0.09375,
                                         0.371903200617956,
                                         2.04918893273626e-06,
                                         0.015625,
                                         0.487997950811067,

                                         0.649365364759566,
                                         0.0904507043809332,
                                         0.00129169054500841,
                                         1.12034609596495e-07,
                                         0.290703918176805,
                                         0.267313540583252,
                                         0.0157344648452828,
                                         9.00933926509632e-06,
                                         0.0542252306569591,
                                         0.329168843350549,
                                         0.0798609055796943,
                                         0.000301871724750737,
                                         0.00539449330804379,
                                         0.21617985071528,
                                         0.21617985071528,
                                         0.0053944933080438,
                                         0.000301871724750736,
                                         0.0798609055796944,
                                         0.329168843350549,
                                         0.0542252306569591,
                                         9.00933926509629e-06,
                                         0.0157344648452828,
                                         0.267313540583252,
                                         0.290703918176806,
                                         1.12034609596494e-07,
                                         0.00129169054500841,
                                         0.0904507043809332,
                                         0.649365364759566,

                                         0.749554587679141,
                                         0.207182490501477,
                                         0.015625,
                                         0.000151016199569706,
                                         1.06560653839098e-08,
                                         0.221353699788412,
                                         0.372920319490549,
                                         0.09375,
                                         0.00302039010779528,
                                         1.29902006290891e-06,
                                         0.0272369869249785,
                                         0.279684117192853,
                                         0.234375,
                                         0.0251704685470313,
                                         6.59817149140504e-05,
                                         0.00178743421642514,
                                         0.111871197960726,
                                         0.3125,
                                         0.111871197960726,
                                         0.00178743421642515,
                                         6.598171491405e-05,
                                         0.0251704685470313,
                                         0.234375,
                                         0.279684117192853,
                                         0.0272369869249786,
                                         1.29902006290891e-06,
                                         0.00302039010779528,
                                         0.09375,
                                         0.372920319490549,
                                         0.221353699788413,
                                         1.06560653839097e-08,
                                         0.000151016199569706,
                                         0.015625,
                                         0.207182490501477,
                                         0.749554587679141,

                                         0.81375924289991,
                                         0.328372125630103,
                                         0.0564217878246265,
                                         0.00304390853814397,
                                         2.36269815467975e-05,
                                         1.48190126791976e-09,
                                         0.170621756019885,
                                         0.401813503400374,
                                         0.208095275218851,
                                         0.029711099469125,
                                         0.000695108340399703,
                                         2.54438775867441e-07,
                                         0.0149060179046153,
                                         0.204866774249226,
                                         0.319791086313206,
                                         0.120835517422513,
                                         0.00852090091604614,
                                         1.82027114048226e-05,
                                         0.000694524543507226,
                                         0.055707960482305,
                                         0.262101325213535,
                                         0.262101325213535,
                                         0.0557079604823049,
                                         0.000694524543507226,
                                         1.82027114048226e-05,
                                         0.00852090091604616,
                                         0.120835517422513,
                                         0.319791086313206,
                                         0.204866774249226,
                                         0.0149060179046153,
                                         2.54438775867441e-07,
                                         0.000695108340399704,
                                         0.029711099469125,
                                         0.208095275218851,
                                         0.401813503400373,
                                         0.170621756019885,
                                         1.48190126791976e-09,
                                         2.36269815467976e-05,
                                         0.00304390853814397,
                                         0.0564217878246265,
                                         0.328372125630103,
                                         0.81375924289991,

                                         0.85671295250191,
                                         0.435920768638663,
                                         0.120627117586845,
                                         0.015625,
                                         0.000687413250542091,
                                         4.65874489972301e-06,
                                         2.71469863944772e-10,
                                         0.134214972089717,
                                         0.388182279505458,
                                         0.30588512562442,
                                         0.09375,
                                         0.00975903760618147,
                                         0.000188340312097645,
                                         6.23818849807477e-08,
                                         0.0087610338058376,
                                         0.144029883565605,
                                         0.323191943175992,
                                         0.234375,
                                         0.0577277780891864,
                                         0.00317253483543277,
                                         5.9728845484652e-06,
                                         0.00030500606463178,
                                         0.0285015343978439,
                                         0.182121584666833,
                                         0.3125,
                                         0.182121584666833,
                                         0.0285015343978439,
                                         0.000305006064631782,
                                         5.97288454846515e-06,
                                         0.00317253483543277,
                                         0.0577277780891864,
                                         0.234375,
                                         0.323191943175992,
                                         0.144029883565605,
                                         0.00876103380583764,
                                         6.2381884980747e-08,
                                         0.000188340312097645,
                                         0.00975903760618147,
                                         0.09375,
                                         0.30588512562442,
                                         0.388182279505458,
                                         0.134214972089718,
                                         2.71469863944768e-10,
                                         4.65874489972301e-06,
                                         0.000687413250542091,
                                         0.015625,
                                         0.120627117586845,
                                         0.435920768638663,
                                         0.85671295250191,

                                         0.886628693473981,
                                         0.525563037930433,
                                         0.196946677191932,
                                         0.0429225677678332,
                                         0.00463196994906852,
                                         0.000178262231206392,
                                         1.10426659117843e-06,
                                         6.12673032803027e-11,
                                         0.107764122334931,
                                         0.356876198850528,
                                         0.367523422097736,
                                         0.177698441311976,
                                         0.0402782237846574,
                                         0.00343894693993399,
                                         5.85441714065222e-05,
                                         1.8146749806817e-08,
                                         0.00545752041229134,
                                         0.100971570894968,
                                         0.285765728817883,
                                         0.306528104821836,
                                         0.145936405845817,
                                         0.0276426942666765,
                                         0.00129324900385492,
                                         2.23953418680636e-06,
                                         0.000147406036592928,
                                         0.0152362948822188,
                                         0.118504268454632,
                                         0.282004286518812,
                                         0.282004286518812,
                                         0.118504268454632,
                                         0.0152362948822188,
                                         0.000147406036592928,
                                         2.23953418680636e-06,
                                         0.00129324900385492,
                                         0.0276426942666765,
                                         0.145936405845817,
                                         0.306528104821836,
                                         0.285765728817883,
                                         0.100971570894968,
                                         0.00545752041229134,
                                         1.8146749806817e-08,
                                         5.85441714065222e-05,
                                         0.00343894693993399,
                                         0.0402782237846574,
                                         0.177698441311976,
                                         0.367523422097736,
                                         0.356876198850528,
                                         0.107764122334931,
                                         6.12673032803027e-11,
                                         1.10426659117843e-06,
                                         0.000178262231206392,
                                         0.00463196994906852,
                                         0.0429225677678332,
                                         0.196946677191932,
                                         0.525563037930433,
                                         0.886628693473981,

                                         0.908202619193918,
                                         0.598549725974222,
                                         0.275566362050813,
                                         0.0842648887968301,
                                         0.015625,
                                         0.00148772667905727,
                                         5.21895637687888e-05,
                                         3.03660853684063e-07,
                                         1.62794144261341e-11,
                                         0.0881542669947908,
                                         0.320725075037017,
                                         0.396220581062149,
                                         0.257994621537119,
                                         0.09375,
                                         0.0174928934846064,
                                         0.00130669834137419,
                                         2.04013370225755e-05,
                                         6.03782736437188e-09,
                                         0.00356527213988063,
                                         0.0716068142807417,
                                         0.237375895726281,
                                         0.329126923900684,
                                         0.234375,
                                         0.0857015961476009,
                                         0.0136318805271944,
                                         0.000571106640927325,
                                         9.33063845943033e-07,
                                         7.69025534576269e-05,
                                         0.00852657306921589,
                                         0.0758463927284193,
                                         0.223931349454102,
                                         0.3125,
                                         0.223931349454102,
                                         0.0758463927284194,
                                         0.00852657306921589,
                                         7.69025534576277e-05,
                                         9.3306384594302e-07,
                                         0.000571106640927325,
                                         0.0136318805271944,
                                         0.0857015961476009,
                                         0.234375,
                                         0.329126923900684,
                                         0.237375895726281,
                                         0.0716068142807417,
                                         0.00356527213988066,
                                         6.03782736437178e-09,
                                         2.04013370225755e-05,
                                         0.00130669834137419,
                                         0.0174928934846064,
                                         0.09375,
                                         0.257994621537119,
                                         0.396220581062149,
                                         0.320725075037017,
                                         0.0881542669947911,
                                         1.62794144261337e-11,
                                         3.03660853684063e-07,
                                         5.21895637687887e-05,
                                         0.00148772667905727,
                                         0.015625,
                                         0.0842648887968301,
                                         0.275566362050813,
                                         0.598549725974222,
                                         0.908202619193918,

                                         0.924228861993799,
                                         0.657629939666541,
                                         0.350557905405777,
                                         0.135523950826256,
                                         0.0359298332314448,
                                         0.00593994102213164,
                                         0.000517012007032715,
                                         1.69638086069414e-05,
                                         9.43190130066706e-08,
                                         4.93186517608961e-12,
                                         0.0733054147366087,
                                         0.285475673185297,
                                         0.401517934701504,
                                         0.321426293366619,
                                         0.159708344185841,
                                         0.0481074379115265,
                                         0.00784761671802496,
                                         0.000533188386280913,
                                         7.82193530213016e-06,
                                         2.23850035636455e-09,
                                         0.00242259793122461,
                                         0.0516351440383035,
                                         0.19161914170826,
                                         0.317640232094028,
                                         0.295793598575398,
                                         0.162342070807074,
                                         0.049632219461143,
                                         0.00698275423314323,
                                         0.000270282513922471,
                                         4.23342527500015e-07,
                                         4.26997524077325e-05,
                                         0.00498104434162094,
                                         0.0487721117564285,
                                         0.167412675526897,
                                         0.292178774266583,
                                         0.292178774266583,
                                         0.167412675526897,
                                         0.0487721117564285,
                                         0.00498104434162092,
                                         4.26997524077325e-05,
                                         4.23342527500015e-07,
                                         0.000270282513922472,
                                         0.00698275423314323,
                                         0.049632219461143,
                                         0.162342070807074,
                                         0.295793598575398,
                                         0.317640232094028,
                                         0.19161914170826,
                                         0.0516351440383034,
                                         0.00242259793122461,
                                         2.23850035636455e-09,
                                         7.82193530213019e-06,
                                         0.000533188386280913,
                                         0.00784761671802496,
                                         0.0481074379115265,
                                         0.159708344185841,
                                         0.321426293366619,
                                         0.401517934701504,
                                         0.285475673185297,
                                         0.0733054147366087,
                                         4.93186517608961e-12,
                                         9.43190130066711e-08,
                                         1.69638086069414e-05,
                                         0.000517012007032715,
                                         0.00593994102213164,
                                         0.0359298332314448,
                                         0.135523950826256,
                                         0.350557905405777,
                                         0.657629939666541,
                                         0.924228861993799,

                                         0.936437853053716,
                                         0.705566365777096,
                                         0.419107650971861,
                                         0.192013413677796,
                                         0.0654191410221913,
                                         0.015625,
                                         0.00237348997369225,
                                         0.000193272321106365,
                                         6.03302595636996e-06,
                                         3.24225182611974e-08,
                                         1.6639152760913e-12,
                                         0.061835648391359,
                                         0.253361486953526,
                                         0.392203778739559,
                                         0.364716855397745,
                                         0.225841204691613,
                                         0.09375,
                                         0.0247509320478836,
                                         0.00366309259758599,
                                         0.000232087371565582,
                                         3.25047264105798e-06,
                                         9.07138817434349e-10,
                                         0.00170132637896137,
                                         0.0379081060412853,
                                         0.152927897026068,
                                         0.288648203579908,
                                         0.324855545204382,
                                         0.234375,
                                         0.107543575780304,
                                         0.0289277656298593,
                                         0.00372011687762228,
                                         0.000135779762503713,
                                         2.06065388344487e-07,
                                         2.49652017721161e-05,
                                         0.00302497857042952,
                                         0.0318024359873673,
                                         0.121837396795999,
                                         0.249216111279933,
                                         0.3125,
                                         0.249216111279934,
                                         0.121837396795999,
                                         0.0318024359873673,
                                         0.00302497857042952,
                                         2.49652017721165e-05,
                                         2.06065388344483e-07,
                                         0.000135779762503713,
                                         0.00372011687762229,
                                         0.0289277656298594,
                                         0.107543575780304,
                                         0.234375,
                                         0.324855545204382,
                                         0.288648203579908,
                                         0.152927897026068,
                                         0.0379081060412853,
                                         0.00170132637896139,
                                         9.07138817434326e-10,
                                         3.25047264105798e-06,
                                         0.000232087371565582,
                                         0.00366309259758599,
                                         0.0247509320478836,
                                         0.09375,
                                         0.225841204691613,
                                         0.364716855397745,
                                         0.392203778739559,
                                         0.253361486953526,
                                         0.0618356483913593,
                                         1.66391527609125e-12,
                                         3.24225182611974e-08,
                                         6.03302595636998e-06,
                                         0.000193272321106366,
                                         0.00237348997369225,
                                         0.015625,
                                         0.0654191410221913,
                                         0.192013413677796,
                                         0.419107650971861,
                                         0.705566365777096,
                                         0.936437853053716,

                                         0.945941375076244,
                                         0.744701381503684,
                                         0.480304149526492,
                                         0.249921487886891,
                                         0.1023329820139,
                                         0.0317158046435623,
                                         0.00700121083733933,
                                         0.000997280072177191,
                                         7.71815461449814e-05,
                                         2.3189396905709e-06,
                                         1.21412315496825e-08,
                                         6.14180323756786e-13,
                                         0.0528146109528153,
                                         0.224998785356456,
                                         0.374653483462532,
                                         0.389858039255586,
                                         0.283770425919367,
                                         0.147936913965609,
                                         0.0540349602570074,
                                         0.012946969934934,
                                         0.00178120160847439,
                                         0.000107023344454753,
                                         1.44666251499846e-06,
                                         3.96012173575593e-10,
                                         0.00122866279189889,
                                         0.0283248061288119,
                                         0.121767662574666,
                                         0.253395062947723,
                                         0.327874312211486,
                                         0.287518725017728,
                                         0.173766188319194,
                                         0.0700338330109796,
                                         0.0171277944043345,
                                         0.00205805198830996,
                                         7.18224926269383e-05,
                                         1.06392235006816e-07,
                                         1.52443901813e-05,
                                         0.00190174571467425,
                                         0.0211073101638544,
                                         0.0878392323508453,
                                         0.202044196837156,
                                         0.298026196959559,
                                         0.298026196959559,
                                         0.202044196837156,
                                         0.0878392323508454,
                                         0.0211073101638545,
                                         0.00190174571467425,
                                         1.52443901812997e-05,
                                         1.06392235006818e-07,
                                         7.1822492626938e-05,
                                         0.00205805198830996,
                                         0.0171277944043345,
                                         0.0700338330109795,
                                         0.173766188319194,
                                         0.287518725017728,
                                         0.327874312211487,
                                         0.253395062947724,
                                         0.121767662574666,
                                         0.028324806128812,
                                         0.00122866279189887,
                                         3.96012173575605e-10,
                                         1.44666251499845e-06,
                                         0.000107023344454753,
                                         0.00178120160847439,
                                         0.012946969934934,
                                         0.0540349602570074,
                                         0.147936913965609,
                                         0.283770425919367,
                                         0.389858039255586,
                                         0.374653483462532,
                                         0.224998785356456,
                                         0.052814610952815,
                                         6.14180323756808e-13,
                                         1.21412315496825e-08,
                                         2.3189396905709e-06,
                                         7.71815461449813e-05,
                                         0.000997280072177189,
                                         0.00700121083733933,
                                         0.0317158046435623,
                                         0.1023329820139,
                                         0.249921487886891,
                                         0.480304149526492,
                                         0.744701381503684,
                                         0.945941375076244,

                                         0.953477489198502,
                                         0.77690153034159,
                                         0.534242674803509,
                                         0.306629028420349,
                                         0.144317162959809,
                                         0.0542277344394006,
                                         0.015625,
                                         0.00324498670927488,
                                         0.000439670550181651,
                                         3.27019925302698e-05,
                                         9.53581399770645e-07,
                                         4.89140831738389e-09,
                                         2.44655903206097e-13,
                                         0.0456039615029865,
                                         0.200306580686151,
                                         0.353041987216133,
                                         0.400643414629467,
                                         0.329688753217045,
                                         0.203487602341284,
                                         0.09375,
                                         0.0311314198908948,
                                         0.00692857190159343,
                                         0.000901014902303179,
                                         5.19484374655998e-05,
                                         6.82978728877576e-07,
                                         1.84147604512068e-10,
                                         0.000908831675072765,
                                         0.0215185605356662,
                                         0.0972081997375672,
                                         0.218118000918025,
                                         0.313818859588447,
                                         0.318158262977015,
                                         0.234375,
                                         0.124443923202766,
                                         0.04549344633889,
                                         0.0103437613347892,
                                         0.00117916876129925,
                                         3.97346321202839e-05,
                                         5.77517576780873e-08,
                                         9.65968728906999e-06,
                                         0.00123290593433581,
                                         0.0142750674626265,
                                         0.0633320778025359,
                                         0.159313535444034,
                                         0.265306070439365,
                                         0.3125,
                                         0.265306070439365,
                                         0.159313535444034,
                                         0.0633320778025359,
                                         0.0142750674626265,
                                         0.00123290593433581,
                                         9.65968728906979e-06,
                                         5.77517576780889e-08,
                                         3.97346321202841e-05,
                                         0.00117916876129925,
                                         0.0103437613347892,
                                         0.04549344633889,
                                         0.124443923202766,
                                         0.234375,
                                         0.318158262977015,
                                         0.313818859588447,
                                         0.218118000918025,
                                         0.0972081997375673,
                                         0.0215185605356662,
                                         0.000908831675072752,
                                         1.84147604512075e-10,
                                         6.82978728877581e-07,
                                         5.19484374655997e-05,
                                         0.00090101490230318,
                                         0.00692857190159343,
                                         0.0311314198908948,
                                         0.09375,
                                         0.203487602341284,
                                         0.329688753217045,
                                         0.400643414629467,
                                         0.353041987216133,
                                         0.20030658068615,
                                         0.0456039615029862,
                                         2.44655903206107e-13,
                                         4.89140831738393e-09,
                                         9.53581399770642e-07,
                                         3.27019925302699e-05,
                                         0.000439670550181651,
                                         0.00324498670927488,
                                         0.015625,
                                         0.0542277344394006,
                                         0.144317162959809,
                                         0.306629028420349,
                                         0.534242674803509,
                                         0.77690153034159,
                                         0.953477489198502,

                                         0.959550510119687,
                                         0.803618450543985,
                                         0.581484872387582,
                                         0.3605478479603,
                                         0.189113893948438,
                                         0.082321027345887,
                                         0.0289193023736069,
                                         0.00786771514546783,
                                         0.00155694293618327,
                                         0.000202737582130415,
                                         1.46098729033881e-05,
                                         4.15970587898748e-07,
                                         2.09907673726371e-09,
                                         1.04045003277217e-13,
                                         0.0397567909608296,
                                         0.178935928997575,
                                         0.329946636180797,
                                         0.40092340775171,
                                         0.363002674711358,
                                         0.254950392175547,
                                         0.139674094695753,
                                         0.0586439311882786,
                                         0.0180979879008854,
                                         0.00380233498534681,
                                         0.000472988338340877,
                                         2.63912426953643e-05,
                                         3.39377591557051e-07,
                                         9.04024597574588e-11,
                                         0.000686346719476824,
                                         0.0166009890766319,
                                         0.0780077492816105,
                                         0.185758492010357,
                                         0.290325358739303,
                                         0.328995036090824,
                                         0.281081767882982,
                                         0.182132010460318,
                                         0.0876549910855881,
                                         0.0297135982157879,
                                         0.00638033066423249,
                                         0.000697663199502414,
                                         2.28626606018395e-05,
                                         3.27286449484103e-08,
                                         6.31938085480084e-06,
                                         0.000821427244537897,
                                         0.00983627173722424,
                                         0.045902323402155,
                                         0.123839401817635,
                                         0.226423622465085,
                                         0.301681178253593,
                                         0.301681178253593,
                                         0.226423622465085,
                                         0.123839401817635,
                                         0.0459023234021551,
                                         0.00983627173722424,
                                         0.000821427244537893,
                                         6.31938085480084e-06,
                                         3.27286449484103e-08,
                                         2.28626606018396e-05,
                                         0.000697663199502414,
                                         0.00638033066423248,
                                         0.0297135982157879,
                                         0.0876549910855881,
                                         0.182132010460317,
                                         0.281081767882983,
                                         0.328995036090824,
                                         0.290325358739303,
                                         0.185758492010357,
                                         0.0780077492816105,
                                         0.0166009890766318,
                                         0.000686346719476824,
                                         9.04024597574588e-11,
                                         3.39377591557054e-07,
                                         2.63912426953643e-05,
                                         0.000472988338340876,
                                         0.00380233498534681,
                                         0.0180979879008854,
                                         0.0586439311882785,
                                         0.139674094695753,
                                         0.254950392175547,
                                         0.363002674711359,
                                         0.40092340775171,
                                         0.329946636180797,
                                         0.178935928997575,
                                         0.0397567909608296,
                                         1.04045003277217e-13,
                                         2.09907673726373e-09,
                                         4.15970587898748e-07,
                                         1.46098729033881e-05,
                                         0.000202737582130415,
                                         0.00155694293618327,
                                         0.00786771514546783,
                                         0.0289193023736069,
                                         0.082321027345887,
                                         0.189113893948438,
                                         0.3605478479603,
                                         0.581484872387582,
                                         0.803618450543985,
                                         0.959550510119687,

                                         0.964513919005733,
                                         0.825972347607508,
                                         0.622763432033523,
                                         0.410842066574916,
                                         0.234871855881689,
                                         0.114730678586702,
                                         0.046935252136009,
                                         0.015625,
                                         0.00405945404289132,
                                         0.000772689312952027,
                                         9.74389955919345e-05,
                                         6.8442781683579e-06,
                                         1.91133865676399e-07,
                                         9.51767408520104e-10,
                                         4.68308119072925e-14,
                                         0.0349540052987262,
                                         0.160464011551945,
                                         0.306885788387296,
                                         0.393944413932996,
                                         0.384856831207909,
                                         0.299147264963753,
                                         0.187274430302237,
                                         0.09375,
                                         0.0366261104320834,
                                         0.010668464884702,
                                         0.00214075555237378,
                                         0.000256962714403866,
                                         1.39632486095607e-05,
                                         1.76368569592556e-07,
                                         4.65206462987081e-11,
                                         0.000527805795207727,
                                         0.0129890844600336,
                                         0.0630114116303683,
                                         0.157392395901675,
                                         0.262758139559731,
                                         0.32499693789278,
                                         0.311348352685565,
                                         0.234375,
                                         0.137690104712919,
                                         0.0613744646394433,
                                         0.0195970237034756,
                                         0.00401977114858926,
                                         0.000425034375432843,
                                         1.3617591888202e-05,
                                         1.92552228962504e-08,
                                         4.2505985424606e-06,
                                         0.000560761468288135,
                                         0.00690017919090419,
                                         0.0335375454492528,
                                         0.0956779550992293,
                                         0.188309499719668,
                                         0.276066295688297,
                                         0.3125,
                                         0.276066295688297,
                                         0.188309499719668,
                                         0.0956779550992293,
                                         0.0335375454492528,
                                         0.0069001791909042,
                                         0.000560761468288135,
                                         4.25059854246072e-06,
                                         1.92552228962497e-08,
                                         1.3617591888202e-05,
                                         0.000425034375432842,
                                         0.00401977114858927,
                                         0.0195970237034756,
                                         0.0613744646394432,
                                         0.137690104712919,
                                         0.234375,
                                         0.311348352685565,
                                         0.32499693789278,
                                         0.262758139559731,
                                         0.157392395901675,
                                         0.0630114116303684,
                                         0.0129890844600336,
                                         0.000527805795207737,
                                         4.6520646298706e-11,
                                         1.76368569592556e-07,
                                         1.39632486095607e-05,
                                         0.000256962714403866,
                                         0.00214075555237378,
                                         0.010668464884702,
                                         0.0366261104320834,
                                         0.09375,
                                         0.187274430302237,
                                         0.299147264963753,
                                         0.384856831207909,
                                         0.393944413932995,
                                         0.306885788387297,
                                         0.160464011551945,
                                         0.0349540052987265,
                                         4.68308119072899e-14,
                                         9.51767408520104e-10,
                                         1.91133865676398e-07,
                                         6.84427816835792e-06,
                                         9.74389955919345e-05,
                                         0.000772689312952027,
                                         0.00405945404289132,
                                         0.015625,
                                         0.046935252136009,
                                         0.114730678586702,
                                         0.234871855881689,
                                         0.410842066574916,
                                         0.622763432033523,
                                         0.825972347607508,
                                         0.964513919005733,

                                         0.968621115700728,
                                         0.844827894946839,
                                         0.658832183335224,
                                         0.45717569525536,
                                         0.28021528122254,
                                         0.150104998707654,
                                         0.0692376370717168,
                                         0.0269360872738176,
                                         0.00858371879171459,
                                         0.00214785564036788,
                                         0.000396036380091269,
                                         4.86456768668548e-05,
                                         3.34589092360918e-06,
                                         9.19624666642103e-08,
                                         4.52953012034904e-10,
                                         2.21526334365978e-14,
                                         0.0309635267377078,
                                         0.144477531683551,
                                         0.284707357562356,
                                         0.382213326346221,
                                         0.39710175363652,
                                         0.334787879547122,
                                         0.232864863371416,
                                         0.133570101516051,
                                         0.0623165263168637,
                                         0.0229903648736792,
                                         0.00639238629092303,
                                         0.00123576747861812,
                                         0.000144075982016138,
                                         7.66106642194578e-06,
                                         9.53506338839978e-08,
                                         2.49477494306772e-11,
                                         0.000412416153788181,
                                         0.0102948764704147,
                                         0.0512638634822729,
                                         0.133142673915044,
                                         0.234477164089132,
                                         0.311123672475516,
                                         0.326328081122631,
                                         0.275976917719567,
                                         0.188503644051338,
                                         0.102535770074375,
                                         0.0429912129989208,
                                         0.0130803098340233,
                                         0.00258499767175157,
                                         0.000265923428919882,
                                         8.36339820808646e-06,
                                         1.17064750532777e-08,
                                         2.92967633127402e-06,
                                         0.000391237697400073,
                                         0.00492291916233749,
                                         0.0247358849386848,
                                         0.0738410780622995,
                                         0.154203813599773,
                                         0.243895427845814,
                                         0.304113004330648,
                                         0.304113004330648,
                                         0.243895427845814,
                                         0.154203813599773,
                                         0.0738410780622995,
                                         0.0247358849386847,
                                         0.0049229191623375,
                                         0.000391237697400073,
                                         2.92967633127393e-06,
                                         1.17064750532782e-08,
                                         8.36339820808646e-06,
                                         0.000265923428919881,
                                         0.00258499767175157,
                                         0.0130803098340233,
                                         0.0429912129989208,
                                         0.102535770074375,
                                         0.188503644051338,
                                         0.275976917719567,
                                         0.326328081122631,
                                         0.311123672475516,
                                         0.234477164089132,
                                         0.133142673915044,
                                         0.051263863482273,
                                         0.0102948764704147,
                                         0.000412416153788172,
                                         2.49477494306785e-11,
                                         9.53506338839979e-08,
                                         7.66106642194575e-06,
                                         0.000144075982016139,
                                         0.00123576747861812,
                                         0.00639238629092303,
                                         0.0229903648736793,
                                         0.0623165263168636,
                                         0.133570101516051,
                                         0.232864863371416,
                                         0.334787879547123,
                                         0.39710175363652,
                                         0.382213326346221,
                                         0.284707357562357,
                                         0.144477531683551,
                                         0.0309635267377075,
                                         2.21526334365992e-14,
                                         4.52953012034904e-10,
                                         9.19624666642099e-08,
                                         3.34589092360919e-06,
                                         4.86456768668548e-05,
                                         0.000396036380091269,
                                         0.00214785564036788,
                                         0.00858371879171458,
                                         0.0269360872738176,
                                         0.0692376370717168,
                                         0.150104998707654,
                                         0.28021528122254,
                                         0.45717569525536,
                                         0.658832183335224,
                                         0.844827894946839,
                                         0.968621115700728,

                                         0.972057421816389,
                                         0.860855446127013,
                                         0.69039649618559,
                                         0.499522976595493,
                                         0.324197987915755,
                                         0.187206346021014,
                                         0.0951040693223257,
                                         0.0418564672898566,
                                         0.015625,
                                         0.00480303341270715,
                                         0.00116508469965099,
                                         0.00020924211220552,
                                         2.51466978027399e-05,
                                         1.69965846720885e-06,
                                         4.61008744633972e-08,
                                         2.25006479756521e-10,
                                         1.09490581909576e-14,
                                         0.0276136603147861,
                                         0.130604742528048,
                                         0.263846655304091,
                                         0.367570869089469,
                                         0.401704478371663,
                                         0.361848329305527,
                                         0.273974462463315,
                                         0.175067687077512,
                                         0.09375,
                                         0.0413404010433632,
                                         0.0145595856695794,
                                         0.00389713626163808,
                                         0.000730612511673111,
                                         8.3153119609848e-05,
                                         4.34268820994449e-06,
                                         5.33910927847369e-08,
                                         1.38754541622991e-11,
                                         0.000326847218961765,
                                         0.00825612807951666,
                                         0.0420139356513346,
                                         0.112697805484362,
                                         0.207391899855783,
                                         0.29142132955637,
                                         0.32885907080933,
                                         0.305097167406522,
                                         0.234375,
                                         0.148259496618724,
                                         0.0758104879031977,
                                         0.0302434161111429,
                                         0.00884467757954704,
                                         0.00169505654475309,
                                         0.000170449956285214,
                                         5.27875314197065e-06,
                                         7.32666624731036e-09,
                                         2.06330931044467e-06,
                                         0.000278350896181256,
                                         0.00356807411361486,
                                         0.0184284395078466,
                                         0.057105197067776,
                                         0.125174200632103,
                                         0.210527239132601,
                                         0.283575747151314,
                                         0.3125,
                                         0.283575747151314,
                                         0.210527239132601,
                                         0.125174200632102,
                                         0.0571051970677759,
                                         0.0184284395078466,
                                         0.00356807411361486,
                                         0.000278350896181254,
                                         2.06330931044474e-06,
                                         7.32666624731001e-09,
                                         5.2787531419707e-06,
                                         0.000170449956285214,
                                         0.00169505654475309,
                                         0.00884467757954705,
                                         0.0302434161111429,
                                         0.0758104879031977,
                                         0.148259496618724,
                                         0.234375,
                                         0.305097167406523,
                                         0.32885907080933,
                                         0.29142132955637,
                                         0.207391899855783,
                                         0.112697805484362,
                                         0.0420139356513346,
                                         0.00825612807951662,
                                         0.000326847218961773,
                                         1.38754541622983e-11,
                                         5.33910927847375e-08,
                                         4.34268820994449e-06,
                                         8.31531196098482e-05,
                                         0.000730612511673112,
                                         0.00389713626163808,
                                         0.0145595856695794,
                                         0.0413404010433632,
                                         0.09375,
                                         0.175067687077512,
                                         0.273974462463315,
                                         0.361848329305527,
                                         0.401704478371663,
                                         0.367570869089469,
                                         0.263846655304091,
                                         0.130604742528048,
                                         0.0276136603147864,
                                         1.09490581909569e-14,
                                         2.25006479756524e-10,
                                         4.61008744633972e-08,
                                         1.69965846720886e-06,
                                         2.51466978027399e-05,
                                         0.000209242112205521,
                                         0.00116508469965099,
                                         0.00480303341270715,
                                         0.015625,
                                         0.0418564672898566,
                                         0.0951040693223257,
                                         0.187206346021014,
                                         0.324197987915755,
                                         0.499522976595493,
                                         0.69039649618559,
                                         0.860855446127013,
                                         0.972057421816389,

                                         0.974960808669954,
                                         0.874578074075131,
                                         0.718085961603359,
                                         0.538038089382177,
                                         0.366218402546375,
                                         0.225001178393878,
                                         0.123699785988714,
                                         0.0601463381917086,
                                         0.0254599803429195,
                                         0.00918305608732532,
                                         0.00273921380931099,
                                         0.000647420573551661,
                                         0.000113734681366832,
                                         1.34205614444865e-05,
                                         8.93873362265076e-07,
                                         2.39765046374449e-08,
                                         1.16129173827628e-10,
                                         5.62702076651821e-15,
                                         0.0247753787254001,
                                         0.1185241803974,
                                         0.244490839943744,
                                         0.351324228403018,
                                         0.400463711197528,
                                         0.381025519127778,
                                         0.309259552624371,
                                         0.215656837587999,
                                         0.128883555929084,
                                         0.0653055801284339,
                                         0.0275026405463803,
                                         0.00932255215945078,
                                         0.00241783213379856,
                                         0.000441824893736348,
                                         4.92814431104841e-05,
                                         2.53514156247093e-06,
                                         3.08486001639875e-08,
                                         7.97164362242016e-12,
                                         0.000262326523593114,
                                         0.00669274217062284,
                                         0.0346846652145753,
                                         0.095585482932311,
                                         0.182463049907526,
                                         0.26885127014099,
                                         0.322155875631265,
                                         0.322185529747869,
                                         0.271847731963274,
                                         0.19350941720615,
                                         0.115056619903781,
                                         0.0559334884180619,
                                         0.021416482044638,
                                         0.00606063928884449,
                                         0.00113208646100311,
                                         0.000111688206832603,
                                         3.41443103367697e-06,
                                         4.70550230453718e-09,
                                         1.48136757314682e-06,
                                         0.000201557961083261,
                                         0.00262428591342232,
                                         0.0138699375050174,
                                         0.0443389516045444,
                                         0.101173983477551,
                                         0.178981324604586,
                                         0.256712820212951,
                                         0.305810678342814,
                                         0.305810678342814,
                                         0.256712820212951,
                                         0.178981324604586,
                                         0.101173983477551,
                                         0.0443389516045444,
                                         0.0138699375050175,
                                         0.00262428591342232,
                                         0.000201557961083261,
                                         1.48136757314682e-06,
                                         4.70550230453718e-09,
                                         3.41443103367696e-06,
                                         0.000111688206832603,
                                         0.0011320864610031,
                                         0.00606063928884449,
                                         0.021416482044638,
                                         0.0559334884180619,
                                         0.115056619903781,
                                         0.19350941720615,
                                         0.271847731963274,
                                         0.322185529747869,
                                         0.322155875631265,
                                         0.26885127014099,
                                         0.182463049907526,
                                         0.0955854829323111,
                                         0.0346846652145753,
                                         0.00669274217062284,
                                         0.000262326523593114,
                                         7.97164362242016e-12,
                                         3.08486001639875e-08,
                                         2.53514156247093e-06,
                                         4.9281443110484e-05,
                                         0.000441824893736348,
                                         0.00241783213379857,
                                         0.00932255215945078,
                                         0.0275026405463803,
                                         0.0653055801284339,
                                         0.128883555929084,
                                         0.215656837587999,
                                         0.309259552624371,
                                         0.381025519127778,
                                         0.400463711197528,
                                         0.351324228403018,
                                         0.244490839943744,
                                         0.1185241803974,
                                         0.0247753787254001,
                                         5.62702076651821e-15,
                                         1.16129173827628e-10,
                                         2.39765046374449e-08,
                                         8.93873362265073e-07,
                                         1.34205614444865e-05,
                                         0.000113734681366832,
                                         0.000647420573551661,
                                         0.00273921380931099,
                                         0.00918305608732532,
                                         0.0254599803429195,
                                         0.0601463381917086,
                                         0.123699785988714,
                                         0.225001178393878,
                                         0.366218402546375,
                                         0.538038089382177,
                                         0.718085961603359,
                                         0.874578074075131,
                                         0.974960808669954,

                                         0.977435650241118,
                                         0.886406989879932,
                                         0.742448313231084,
                                         0.572970339357278,
                                         0.405932699205302,
                                         0.262680513242844,
                                         0.154199209865131,
                                         0.0813714542256584,
                                         0.0381393669996204,
                                         0.015625,
                                         0.00547498519255554,
                                         0.00159223348901111,
                                         0.000368156628013724,
                                         6.34782884281394e-05,
                                         7.37498461918577e-06,
                                         4.85128763070724e-07,
                                         1.2890178567556e-08,
                                         6.20275562214327e-11,
                                         2.99470477117429e-15,
                                         0.022350319307711,
                                         0.107963346799201,
                                         0.226681595147296,
                                         0.334377878762335,
                                         0.394902425029427,
                                         0.393349556865857,
                                         0.33824013939101,
                                         0.253442303603072,
                                         0.165587027160815,
                                         0.09375,
                                         0.0453975714984511,
                                         0.0184035762559179,
                                         0.006042158701056,
                                         0.00152607859179978,
                                         0.000272915282458093,
                                         2.99263759592852e-05,
                                         1.51988734606524e-06,
                                         1.83334418307343e-08,
                                         4.71477485130109e-12,
                                         0.000212945294247509,
                                         0.005479087853718,
                                         0.0288373304145694,
                                         0.0813077034166513,
                                         0.160071613676584,
                                         0.245424679547772,
                                         0.309141207649815,
                                         0.328908347256015,
                                         0.299549015022429,
                                         0.234375,
                                         0.156845134847677,
                                         0.0886311642693745,
                                         0.0413181046131922,
                                         0.0152868269740897,
                                         0.00420807382688278,
                                         0.000769201263519256,
                                         7.46711127333135e-05,
                                         2.25783445990399e-06,
                                         3.0928343522135e-09,
                                         1.08205937088367e-06,
                                         0.000148299237219682,
                                         0.00195655731679186,
                                         0.0105444656954937,
                                         0.034604897994727,
                                         0.0816688664892098,
                                         0.150691023151782,
                                         0.227650920900951,
                                         0.289006899278452,
                                         0.3125,
                                         0.289006899278452,
                                         0.227650920900952,
                                         0.150691023151782,
                                         0.0816688664892097,
                                         0.0346048979947271,
                                         0.0105444656954937,
                                         0.00195655731679186,
                                         0.000148299237219682,
                                         1.08205937088367e-06,
                                         3.0928343522135e-09,
                                         2.25783445990399e-06,
                                         7.46711127333135e-05,
                                         0.000769201263519256,
                                         0.00420807382688277,
                                         0.0152868269740897,
                                         0.0413181046131922,
                                         0.0886311642693745,
                                         0.156845134847677,
                                         0.234375,
                                         0.299549015022429,
                                         0.328908347256015,
                                         0.309141207649815,
                                         0.245424679547772,
                                         0.160071613676584,
                                         0.0813077034166513,
                                         0.0288373304145694,
                                         0.005479087853718,
                                         0.000212945294247509,
                                         4.71477485130109e-12,
                                         1.83334418307343e-08,
                                         1.51988734606524e-06,
                                         2.99263759592852e-05,
                                         0.000272915282458093,
                                         0.00152607859179978,
                                         0.006042158701056,
                                         0.0184035762559179,
                                         0.0453975714984511,
                                         0.09375,
                                         0.165587027160815,
                                         0.253442303603072,
                                         0.33824013939101,
                                         0.393349556865857,
                                         0.394902425029427,
                                         0.334377878762335,
                                         0.226681595147296,
                                         0.107963346799201,
                                         0.022350319307711,
                                         2.99470477117429e-15,
                                         6.20275562214327e-11,
                                         1.2890178567556e-08,
                                         4.85128763070724e-07,
                                         7.37498461918576e-06,
                                         6.34782884281395e-05,
                                         0.000368156628013724,
                                         0.00159223348901111,
                                         0.00547498519255554,
                                         0.015625,
                                         0.0381393669996204,
                                         0.0813714542256584,
                                         0.154199209865131,
                                         0.262680513242844,
                                         0.405932699205302,
                                         0.572970339357278,
                                         0.742448313231084,
                                         0.886406989879932,
                                         0.977435650241118,

                                         0.979562049099076,
                                         0.896668019554143,
                                         0.76395332304625,
                                         0.604611132082384,
                                         0.443180618546272,
                                         0.299643817580666,
                                         0.185856366597293,
                                         0.10499846864745,
                                         0.0535248885784691,
                                         0.0243202719552969,
                                         0.00969095531437596,
                                         0.00331319161993609,
                                         0.000942951082806277,
                                         0.000213984245592755,
                                         3.63114854257522e-05,
                                         4.1630832505185e-06,
                                         2.70945173048897e-07,
                                         7.14110048667623e-09,
                                         3.41716705094067e-11,
                                         1.64471903375808e-15,
                                         0.0202625062883993,
                                         0.0986935306988044,
                                         0.210378390418692,
                                         0.317342522383551,
                                         0.386252288644223,
                                         0.399941392337855,
                                         0.361018468268403,
                                         0.287222581955343,
                                         0.201986411089171,
                                         0.12517551054417,
                                         0.0677825881292264,
                                         0.0316069561721389,
                                         0.0124095504088961,
                                         0.00396581384072885,
                                         0.000979389589685194,
                                         0.000171959942021362,
                                         1.85836830086352e-05,
                                         9.33540881747693e-07,
                                         1.11766514028696e-08,
                                         2.86241769220901e-12,
                                         0.000174639762681458,
                                         0.00452620739103975,
                                         0.02413927320557,
                                         0.0694015480701794,
                                         0.140265263039817,
                                         0.222421182417801,
                                         0.292193233268112,
                                         0.32737307445125,
                                         0.317597658368405,
                                         0.268447320901583,
                                         0.197541552253742,
                                         0.125634105653134,
                                         0.0680474240918155,
                                         0.0306246833260814,
                                         0.0110066640203169,
                                         0.0029595674528315,
                                         0.000531093416242418,
                                         5.08499226601634e-05,
                                         1.52316151945806e-06,
                                         2.07569268582754e-09,
                                         8.02771286706285e-07,
                                         0.000110707983669699,
                                         0.00147722272484599,
                                         0.00809484941946051,
                                         0.0271661392915844,
                                         0.0659712425682498,
                                         0.126127450453789,
                                         0.199005949362439,
                                         0.266336788518745,
                                         0.307041800901606,
                                         0.307041800901606,
                                         0.266336788518745,
                                         0.199005949362439,
                                         0.126127450453789,
                                         0.0659712425682498,
                                         0.0271661392915844,
                                         0.00809484941946053,
                                         0.00147722272484599,
                                         0.0001107079836697,
                                         8.02771286706324e-07,
                                         2.07569268582741e-09,
                                         1.52316151945804e-06,
                                         5.08499226601634e-05,
                                         0.000531093416242416,
                                         0.0029595674528315,
                                         0.0110066640203169,
                                         0.0306246833260814,
                                         0.0680474240918155,
                                         0.125634105653134,
                                         0.197541552253742,
                                         0.268447320901583,
                                         0.317597658368405,
                                         0.32737307445125,
                                         0.292193233268112,
                                         0.222421182417801,
                                         0.140265263039817,
                                         0.0694015480701795,
                                         0.02413927320557,
                                         0.00452620739103978,
                                         0.000174639762681463,
                                         2.86241769220878e-12,
                                         1.11766514028695e-08,
                                         9.33540881747693e-07,
                                         1.85836830086351e-05,
                                         0.000171959942021362,
                                         0.000979389589685195,
                                         0.00396581384072885,
                                         0.0124095504088961,
                                         0.0316069561721389,
                                         0.0677825881292264,
                                         0.12517551054417,
                                         0.201986411089172,
                                         0.287222581955343,
                                         0.361018468268403,
                                         0.399941392337855,
                                         0.386252288644223,
                                         0.317342522383552,
                                         0.210378390418692,
                                         0.0986935306988047,
                                         0.0202625062883996,
                                         1.64471903375792e-15,
                                         3.41716705094061e-11,
                                         7.14110048667623e-09,
                                         2.70945173048896e-07,
                                         4.1630832505185e-06,
                                         3.63114854257523e-05,
                                         0.000213984245592755,
                                         0.000942951082806277,
                                         0.00331319161993609,
                                         0.00969095531437596,
                                         0.0243202719552969,
                                         0.0535248885784691,
                                         0.10499846864745,
                                         0.185856366597293,
                                         0.299643817580666,
                                         0.443180618546272,
                                         0.604611132082384,
                                         0.76395332304625,
                                         0.896668019554143,
                                         0.979562049099076,

                                         0.981402286216887,
                                         0.905621388085949,
                                         0.783000804188452,
                                         0.633262061621569,
                                         0.477927421878223,
                                         0.335467604414565,
                                         0.218037043487174,
                                         0.130468578259818,
                                         0.0713441437499665,
                                         0.0353127295520003,
                                         0.015625,
                                         0.00608000308311431,
                                         0.00203526972180058,
                                         0.000568599860539125,
                                         0.000126970896819501,
                                         2.12519624709268e-05,
                                         2.40880521308376e-06,
                                         1.55337012721933e-07,
                                         4.06557911814258e-09,
                                         1.93611009501178e-11,
                                         9.293835729738e-16,
                                         0.0184525462915543,
                                         0.090523600128933,
                                         0.195497028209047,
                                         0.300619144074091,
                                         0.375479722982245,
                                         0.401877087896897,
                                         0.378045307716001,
                                         0.316378757919445,
                                         0.236621128198707,
                                         0.158031849890968,
                                         0.09375,
                                         0.048909470901651,
                                         0.02209170736979,
                                         0.00844127138016552,
                                         0.00263628962431273,
                                         0.000638644066909652,
                                         0.000110377268901452,
                                         1.17799727629276e-05,
                                         5.86201554743653e-07,
                                         6.97296368377302e-09,
                                         1.77946010049735e-12,
                                         0.000144562050574634,
                                         0.00377021157705791,
                                         0.0203379357094985,
                                         0.0594618689880849,
                                         0.122913556812282,
                                         0.200597106411037,
                                         0.273115392840906,
                                         0.319666747215176,
                                         0.326992257569699,
                                         0.294677324305785,
                                         0.234375,
                                         0.163934699208391,
                                         0.0999137709048275,
                                         0.0522152948692543,
                                         0.0228071391336858,
                                         0.00799663883505801,
                                         0.0021073970309653,
                                         0.000372222294458676,
                                         3.52176418986272e-05,
                                         1.04638984331884e-06,
                                         1.41961400605658e-09,
                                         6.04019590175353e-07,
                                         8.37468258916539e-05,
                                         0.00112842398397011,
                                         0.00627276771202083,
                                         0.0214591152221702,
                                         0.0534016664130626,
                                         0.105231856301101,
                                         0.172260750495602,
                                         0.241001722485209,
                                         0.293053923058091,
                                         0.3125,
                                         0.293053923058091,
                                         0.241001722485209,
                                         0.172260750495602,
                                         0.105231856301101,
                                         0.0534016664130626,
                                         0.0214591152221702,
                                         0.00627276771202082,
                                         0.00112842398397011,
                                         8.37468258916548e-05,
                                         6.04019590175321e-07,
                                         1.41961400605668e-09,
                                         1.04638984331882e-06,
                                         3.52176418986274e-05,
                                         0.000372222294458676,
                                         0.0021073970309653,
                                         0.007996638835058,
                                         0.0228071391336858,
                                         0.0522152948692542,
                                         0.0999137709048275,
                                         0.163934699208391,
                                         0.234375,
                                         0.294677324305785,
                                         0.326992257569699,
                                         0.319666747215176,
                                         0.273115392840906,
                                         0.200597106411037,
                                         0.122913556812282,
                                         0.059461868988085,
                                         0.0203379357094984,
                                         0.00377021157705793,
                                         0.000144562050574629,
                                         1.77946010049751e-12,
                                         6.9729636837729e-09,
                                         5.86201554743658e-07,
                                         1.17799727629276e-05,
                                         0.000110377268901452,
                                         0.000638644066909652,
                                         0.00263628962431273,
                                         0.00844127138016551,
                                         0.02209170736979,
                                         0.048909470901651,
                                         0.09375,
                                         0.158031849890968,
                                         0.236621128198707,
                                         0.316378757919445,
                                         0.378045307716001,
                                         0.401877087896897,
                                         0.375479722982245,
                                         0.300619144074091,
                                         0.195497028209047,
                                         0.0905236001289333,
                                         0.018452546291554,
                                         9.29383572973899e-16,
                                         1.93611009501174e-11,
                                         4.06557911814261e-09,
                                         1.55337012721933e-07,
                                         2.40880521308376e-06,
                                         2.12519624709268e-05,
                                         0.000126970896819501,
                                         0.000568599860539124,
                                         0.00203526972180058,
                                         0.00608000308311431,
                                         0.015625,
                                         0.0353127295520003,
                                         0.0713441437499665,
                                         0.130468578259818,
                                         0.218037043487174,
                                         0.335467604414565,
                                         0.477927421878223,
                                         0.633262061621569,
                                         0.783000804188452,
                                         0.905621388085949,
                                         0.981402286216887,

                                         0.983005362216885,
                                         0.913476551524573,
                                         0.79992976855372,
                                         0.659216583917199,
                                         0.51022075224158,
                                         0.369870656862231,
                                         0.250226258305671,
                                         0.157246838652346,
                                         0.0912452995347586,
                                         0.0485199720352232,
                                         0.0234146498759706,
                                         0.0101262383377984,
                                         0.0038603820413856,
                                         0.00126890623989645,
                                         0.000348851319265737,
                                         7.6820417285542e-05,
                                         1.2705622567556e-05,
                                         1.42588966659826e-06,
                                         9.12201721407436e-08,
                                         2.3730110783671e-09,
                                         1.12534963291082e-11,
                                         5.38943505887117e-16,
                                         0.0168734943331811,
                                         0.0832939898699682,
                                         0.181932837815798,
                                         0.284461285692348,
                                         0.363326718389408,
                                         0.400121732750269,
                                         0.389949255558054,
                                         0.340729378556393,
                                         0.268471541787507,
                                         0.190922340508149,
                                         0.12217030683181,
                                         0.0698670890660645,
                                         0.0353180388162654,
                                         0.0155254529032003,
                                         0.00579582431218419,
                                         0.00177461418626883,
                                         0.000422820649040302,
                                         7.20857140787499e-05,
                                         7.61023984053795e-06,
                                         3.7561509025742e-07,
                                         4.44297339187163e-09,
                                         1.1303074779466e-12,
                                         0.000120682120174215,
                                         0.00316459899676643,
                                         0.0172408664156614,
                                         0.0511454461198671,
                                         0.107801626155334,
                                         0.180352913071076,
                                         0.253204877690679,
                                         0.307628096072838,
                                         0.329135533178452,
                                         0.313026940042406,
                                         0.26560265956073,
                                         0.200856509747572,
                                         0.134633033343024,
                                         0.0791494281553994,
                                         0.0401216526002263,
                                         0.0170812635786697,
                                         0.00586280143247278,
                                         0.00151845262410807,
                                         0.00026454195506392,
                                         2.47727976836525e-05,
                                         7.30884428550886e-07,
                                         9.87731073809429e-10,
                                         4.60340898126162e-07,
                                         6.41242700365725e-05,
                                         0.000871376429034798,
                                         0.00490444085550882,
                                         0.0170589389858251,
                                         0.0433563696123443,
                                         0.0876869102633715,
                                         0.148129358486746,
                                         0.215203838200786,
                                         0.273719293213546,
                                         0.307962546580055,
                                         0.307962546580055,
                                         0.273719293213546,
                                         0.215203838200786,
                                         0.148129358486746,
                                         0.0876869102633716,
                                         0.0433563696123443,
                                         0.0170589389858251,
                                         0.00490444085550881,
                                         0.000871376429034801,
                                         6.41242700365724e-05,
                                         4.60340898126162e-07,
                                         9.87731073809429e-10,
                                         7.30884428550886e-07,
                                         2.47727976836524e-05,
                                         0.000264541955063921,
                                         0.00151845262410807,
                                         0.00586280143247278,
                                         0.0170812635786697,
                                         0.0401216526002263,
                                         0.0791494281553994,
                                         0.134633033343024,
                                         0.200856509747572,
                                         0.26560265956073,
                                         0.313026940042406,
                                         0.329135533178452,
                                         0.307628096072838,
                                         0.253204877690679,
                                         0.180352913071076,
                                         0.107801626155334,
                                         0.051145446119867,
                                         0.0172408664156615,
                                         0.00316459899676643,
                                         0.000120682120174215,
                                         1.1303074779466e-12,
                                         4.44297339187163e-09,
                                         3.75615090257418e-07,
                                         7.61023984053798e-06,
                                         7.20857140787501e-05,
                                         0.000422820649040302,
                                         0.00177461418626883,
                                         0.00579582431218419,
                                         0.0155254529032003,
                                         0.0353180388162654,
                                         0.0698670890660645,
                                         0.12217030683181,
                                         0.190922340508149,
                                         0.268471541787507,
                                         0.340729378556393,
                                         0.389949255558054,
                                         0.400121732750269,
                                         0.363326718389408,
                                         0.284461285692348,
                                         0.181932837815799,
                                         0.0832939898699682,
                                         0.0168734943331811,
                                         5.38943505887117e-16,
                                         1.12534963291082e-11,
                                         2.37301107836708e-09,
                                         9.12201721407441e-08,
                                         1.42588966659826e-06,
                                         1.2705622567556e-05,
                                         7.6820417285542e-05,
                                         0.000348851319265737,
                                         0.00126890623989645,
                                         0.0038603820413856,
                                         0.0101262383377984,
                                         0.0234146498759706,
                                         0.0485199720352232,
                                         0.0912452995347586,
                                         0.157246838652346,
                                         0.250226258305671,
                                         0.369870656862231,
                                         0.51022075224158,
                                         0.659216583917199,
                                         0.79992976855372,
                                         0.913476551524573,
                                         0.983005362216885,

                                         0.984410247379471,
                                         0.920403376507279,
                                         0.815027333157476,
                                         0.682750218151206,
                                         0.540159664424491,
                                         0.402681714264921,
                                         0.282021698355784,
                                         0.184850777371003,
                                         0.112842606226361,
                                         0.0637649706786781,
                                         0.0330971108092022,
                                         0.015625,
                                         0.00662464501856691,
                                         0.00248088422078279,
                                         0.00080262514199532,
                                         0.000217593664039002,
                                         4.73364216804371e-05,
                                         7.74811930639151e-06,
                                         8.62022390353783e-07,
                                         5.47635678108041e-08,
                                         1.41707583458805e-09,
                                         6.69558782682509e-12,
                                         3.20008464088613e-16,
                                         0.0154878666079712,
                                         0.0768713553299151,
                                         0.169574382320453,
                                         0.269020109893535,
                                         0.350353236507141,
                                         0.395505224053674,
                                         0.397422628054756,
                                         0.360393286592369,
                                         0.296914199156356,
                                         0.222708847314842,
                                         0.151880991038753,
                                         0.09375,
                                         0.0519698871798051,
                                         0.0255713520773776,
                                         0.0109813921722315,
                                         0.00401784644725615,
                                         0.00120928275187258,
                                         0.000283993555319825,
                                         4.78450556664249e-05,
                                         5.00347042396582e-06,
                                         2.45192692501692e-07,
                                         2.88605681809872e-09,
                                         7.3223164259791e-13,
                                         0.000101530337878636,
                                         0.00267509759900154,
                                         0.0147006680888247,
                                         0.044166847554624,
                                         0.0946844967140477,
                                         0.161856929754158,
                                         0.233351940368985,
                                         0.292766150053764,
                                         0.325519930698192,
                                         0.324101868055451,
                                         0.290405955823643,
                                         0.234375,
                                         0.169875088018046,
                                         0.109822074993031,
                                         0.0626023738286668,
                                         0.0309121479268566,
                                         0.0128720894861253,
                                         0.0043371997918613,
                                         0.00110648196677728,
                                         0.000190475752435071,
                                         1.76770875009035e-05,
                                         5.18334123699816e-07,
                                         6.98110673349207e-10,
                                         3.54975836528086e-07,
                                         4.96493369281438e-05,
                                         0.000679692735975953,
                                         0.00386729041420811,
                                         0.0136474133094868,
                                         0.035327190460759,
                                         0.0730750245607963,
                                         0.126842197944713,
                                         0.190336872776197,
                                         0.251550002659837,
                                         0.296146322111984,
                                         0.3125,
                                         0.296146322111984,
                                         0.251550002659837,
                                         0.190336872776197,
                                         0.126842197944713,
                                         0.0730750245607962,
                                         0.035327190460759,
                                         0.0136474133094868,
                                         0.00386729041420811,
                                         0.000679692735975956,
                                         4.96493369281438e-05,
                                         3.54975836528063e-07,
                                         6.98110673349266e-10,
                                         5.18334123699816e-07,
                                         1.76770875009034e-05,
                                         0.000190475752435071,
                                         0.00110648196677728,
                                         0.00433719979186129,
                                         0.0128720894861253,
                                         0.0309121479268565,
                                         0.0626023738286668,
                                         0.109822074993031,
                                         0.169875088018046,
                                         0.234375,
                                         0.290405955823643,
                                         0.324101868055451,
                                         0.325519930698192,
                                         0.292766150053764,
                                         0.233351940368985,
                                         0.161856929754158,
                                         0.0946844967140477,
                                         0.044166847554624,
                                         0.0147006680888248,
                                         0.00267509759900154,
                                         0.000101530337878632,
                                         7.32231642597988e-13,
                                         2.88605681809872e-09,
                                         2.4519269250169e-07,
                                         5.00347042396582e-06,
                                         4.78450556664249e-05,
                                         0.000283993555319825,
                                         0.00120928275187258,
                                         0.00401784644725615,
                                         0.0109813921722315,
                                         0.0255713520773776,
                                         0.0519698871798051,
                                         0.09375,
                                         0.151880991038753,
                                         0.222708847314842,
                                         0.296914199156356,
                                         0.360393286592369,
                                         0.397422628054756,
                                         0.395505224053674,
                                         0.350353236507141,
                                         0.269020109893535,
                                         0.169574382320454,
                                         0.0768713553299151,
                                         0.0154878666079709,
                                         3.20008464088654e-16,
                                         6.69558782682509e-12,
                                         1.41707583458804e-09,
                                         5.47635678108041e-08,
                                         8.62022390353783e-07,
                                         7.74811930639149e-06,
                                         4.73364216804372e-05,
                                         0.000217593664039002,
                                         0.00080262514199532,
                                         0.00248088422078279,
                                         0.00662464501856691,
                                         0.015625,
                                         0.0330971108092022,
                                         0.0637649706786781,
                                         0.112842606226361,
                                         0.184850777371003,
                                         0.282021698355784,
                                         0.402681714264921,
                                         0.540159664424491,
                                         0.682750218151206,
                                         0.815027333157476,
                                         0.920403376507279,
                                         0.984410247379471,

                                         0.985648242491884,
                                         0.926540621665256,
                                         0.828536774256041,
                                         0.704115979622578,
                                         0.567872969985807,
                                         0.433811933190359,
                                         0.313120387329857,
                                         0.212863734445695,
                                         0.13574995151458,
                                         0.0808088850116454,
                                         0.0446221662446437,
                                         0.0226782282648721,
                                         0.0105030813043862,
                                         0.00437651336117894,
                                         0.00161361935564144,
                                         0.000514836222655621,
                                         0.000137871194237895,
                                         2.96744469098549e-05,
                                         4.81299206954868e-06,
                                         5.31405820038482e-07,
                                         3.35531910817617e-08,
                                         8.64182624687966e-10,
                                         4.07005592943438e-12,
                                         1.94176239711507e-16,
                                         0.014265452697046,
                                         0.0711440143707394,
                                         0.158311329590502,
                                         0.25437654004114,
                                         0.336975478942183,
                                         0.388721313293548,
                                         0.401150936586012,
                                         0.375677256944185,
                                         0.321646750992481,
                                         0.252542239984665,
                                         0.181815749981213,
                                         0.11968644666824,
                                         0.0716445859134123,
                                         0.0386678395276867,
                                         0.0185878295644263,
                                         0.00782225753476684,
                                         0.00281230753919116,
                                         0.000833851412673816,
                                         0.000193366300271747,
                                         3.22390106266807e-05,
                                         3.34351653713972e-06,
                                         1.62820027466446e-07,
                                         1.90822233801827e-09,
                                         4.82986488050167e-13,
                                         8.60276228537196e-05,
                                         0.00227615077995136,
                                         0.0126037842935098,
                                         0.0382911729009392,
                                         0.0833171027456719,
                                         0.145132264167834,
                                         0.214137650718655,
                                         0.276259288899507,
                                         0.317546560390812,
                                         0.328849889502049,
                                         0.308674754829191,
                                         0.263190120585428,
                                         0.203628604388724,
                                         0.14235093196579,
                                         0.0892164682220487,
                                         0.0495203703038796,
                                         0.0239023632973457,
                                         0.00976300390324498,
                                         0.00323694401359236,
                                         0.000814940427035567,
                                         0.000138823145103221,
                                         1.27820018336915e-05,
                                         3.72774616455327e-07,
                                         5.00567482719176e-10,
                                         2.7668716587898e-07,
                                         3.88384971443051e-05,
                                         0.000535166173903805,
                                         0.00307410722051123,
                                         0.0109867374828562,
                                         0.0288993660423255,
                                         0.0609644956026475,
                                         0.108347177679839,
                                         0.167199273040824,
                                         0.228381068359525,
                                         0.279492044090297,
                                         0.308668932874937,
                                         0.308668932874937,
                                         0.279492044090297,
                                         0.228381068359525,
                                         0.167199273040824,
                                         0.108347177679839,
                                         0.0609644956026475,
                                         0.0288993660423254,
                                         0.0109867374828562,
                                         0.00307410722051123,
                                         0.000535166173903802,
                                         3.88384971443051e-05,
                                         2.76687165878961e-07,
                                         5.00567482719222e-10,
                                         3.72774616455327e-07,
                                         1.27820018336916e-05,
                                         0.000138823145103221,
                                         0.000814940427035567,
                                         0.00323694401359237,
                                         0.00976300390324498,
                                         0.0239023632973458,
                                         0.0495203703038796,
                                         0.0892164682220487,
                                         0.14235093196579,
                                         0.203628604388724,
                                         0.263190120585428,
                                         0.308674754829191,
                                         0.328849889502049,
                                         0.317546560390812,
                                         0.276259288899507,
                                         0.214137650718655,
                                         0.145132264167834,
                                         0.0833171027456719,
                                         0.0382911729009392,
                                         0.0126037842935098,
                                         0.00227615077995136,
                                         8.60276228537156e-05,
                                         4.82986488050222e-13,
                                         1.90822233801827e-09,
                                         1.62820027466448e-07,
                                         3.34351653713972e-06,
                                         3.22390106266807e-05,
                                         0.000193366300271748,
                                         0.000833851412673816,
                                         0.00281230753919116,
                                         0.00782225753476684,
                                         0.0185878295644263,
                                         0.0386678395276867,
                                         0.0716445859134123,
                                         0.11968644666824,
                                         0.181815749981213,
                                         0.252542239984665,
                                         0.321646750992481,
                                         0.375677256944185,
                                         0.401150936586012,
                                         0.388721313293548,
                                         0.336975478942183,
                                         0.25437654004114,
                                         0.158311329590502,
                                         0.0711440143707394,
                                         0.0142654526970456,
                                         1.94176239711533e-16,
                                         4.07005592943438e-12,
                                         8.64182624687975e-10,
                                         3.35531910817617e-08,
                                         5.31405820038482e-07,
                                         4.81299206954869e-06,
                                         2.96744469098549e-05,
                                         0.000137871194237896,
                                         0.000514836222655621,
                                         0.00161361935564144,
                                         0.00437651336117894,
                                         0.0105030813043862,
                                         0.0226782282648721,
                                         0.0446221662446437,
                                         0.0808088850116454,
                                         0.13574995151458,
                                         0.212863734445695,
                                         0.313120387329857,
                                         0.433811933190359,
                                         0.567872969985807,
                                         0.704115979622578,
                                         0.828536774256041,
                                         0.926540621665256,
                                         0.985648242491884,

                                         0.0078125,
                                         0.0546875,
                                         0.1640625,
                                         0.2734375,
                                         0.2734375,
                                         0.1640625,
                                         0.0546875,
                                         0.0078125,

                                         0.189795993315888,
                                         1.8821498927247e-05,
                                         0.355989781949584,
                                         0.000491699531897622,
                                         0.286161523761367,
                                         0.00550514290529928,
                                         0.12779458199453,
                                         0.0342424550425071,
                                         0.0342424550425071,
                                         0.12779458199453,
                                         0.00550514290529928,
                                         0.286161523761367,
                                         0.000491699531897622,
                                         0.355989781949584,
                                         1.8821498927247e-05,
                                         0.189795993315888,

                                         0.432999769052994,
                                         0.0078125,
                                         2.30947005396121e-07,
                                         0.384987272306509,
                                         0.0546875,
                                         1.27276934913809e-05,
                                         0.146699385243321,
                                         0.1640625,
                                         0.000300614756679824,
                                         0.0310554417117261,
                                         0.2734375,
                                         0.00394455828827407,
                                         0.00394455828827407,
                                         0.2734375,
                                         0.0310554417117261,
                                         0.000300614756679824,
                                         0.1640625,
                                         0.146699385243321,
                                         1.27276934913809e-05,
                                         0.0546875,
                                         0.384987272306509,
                                         2.30947005396121e-07,
                                         0.0078125,
                                         0.432999769052994,

                                         0.604278729922773,
                                         0.0606011146246741,
                                         0.000426270122763878,
                                         7.77876955884479e-09,
                                         0.315606443857553,
                                         0.208947128293814,
                                         0.00605794295571169,
                                         7.2979088026355e-07,
                                         0.0706443820461607,
                                         0.308756007159942,
                                         0.0368967980913548,
                                         2.93433147870465e-05,
                                         0.00878490145596999,
                                         0.253467289218044,
                                         0.124847449533696,
                                         0.000655461833106641,
                                         0.000655461833106639,
                                         0.124847449533696,
                                         0.253467289218044,
                                         0.00878490145597001,
                                         2.93433147870464e-05,
                                         0.0368967980913548,
                                         0.308756007159942,
                                         0.0706443820461608,
                                         7.29790880263547e-07,
                                         0.00605794295571169,
                                         0.208947128293814,
                                         0.315606443857553,
                                         7.77876955884475e-09,
                                         0.000426270122763878,
                                         0.0606011146246741,
                                         0.604278729922773,

                                         0.714392924232422,
                                         0.159371951613892,
                                         0.0078125,
                                         3.48493053863121e-05,
                                         4.99876848003043e-10,
                                         0.246131644127034,
                                         0.334673772213092,
                                         0.0546875,
                                         0.000813168259283756,
                                         7.10933197513471e-08,
                                         0.0363430168783423,
                                         0.301199801577644,
                                         0.1640625,
                                         0.0081318605994322,
                                         4.33329026092715e-06,
                                         0.00298127469437943,
                                         0.150596604153917,
                                         0.2734375,
                                         0.0451779922773527,
                                         0.000146735184364572,
                                         0.000146735184364572,
                                         0.0451779922773527,
                                         0.2734375,
                                         0.150596604153917,
                                         0.00298127469437944,
                                         4.33329026092713e-06,
                                         0.0081318605994322,
                                         0.1640625,
                                         0.301199801577644,
                                         0.0363430168783424,
                                         7.10933197513466e-08,
                                         0.000813168259283756,
                                         0.0546875,
                                         0.334673772213092,
                                         0.246131644127034,
                                         4.99876848003039e-10,
                                         3.48493053863121e-05,
                                         0.0078125,
                                         0.159371951613892,
                                         0.714392924232422,

                                         0.786282464402557,
                                         0.272747428675303,
                                         0.0349425544563488,
                                         0.00115878678013018,
                                         4.00229978709488e-06,
                                         5.00367562627932e-11,
                                         0.192337449481471,
                                         0.389372878683597,
                                         0.150354633577943,
                                         0.0131958523060965,
                                         0.000137372772317918,
                                         1.00230515815988e-08,
                                         0.0201637976251847,
                                         0.238228625850516,
                                         0.277269562532147,
                                         0.0644012912236479,
                                         0.00202076087444521,
                                         8.60466560791248e-07,
                                         0.00117437906879438,
                                         0.0809747634973347,
                                         0.284063263843902,
                                         0.174614055279785,
                                         0.016514167346699,
                                         4.10388823432674e-05,
                                         4.10388823432674e-05,
                                         0.016514167346699,
                                         0.174614055279785,
                                         0.284063263843902,
                                         0.0809747634973346,
                                         0.00117437906879438,
                                         8.60466560791248e-07,
                                         0.00202076087444521,
                                         0.0644012912236479,
                                         0.277269562532147,
                                         0.238228625850516,
                                         0.0201637976251847,
                                         1.00230515815988e-08,
                                         0.000137372772317919,
                                         0.0131958523060965,
                                         0.150354633577943,
                                         0.389372878683597,
                                         0.192337449481471,
                                         5.00367562627932e-11,
                                         4.00229978709489e-06,
                                         0.00115878678013018,
                                         0.0349425544563488,
                                         0.272747428675303,
                                         0.786282464402557,

                                         0.834912997163999,
                                         0.379584806517345,
                                         0.0847915241920486,
                                         0.0078125,
                                         0.000204214957908504,
                                         6.02070135413138e-07,
                                         6.90783405608846e-12,
                                         0.152599687365376,
                                         0.394351734849226,
                                         0.250849153763575,
                                         0.0546875,
                                         0.00338238804843511,
                                         2.83967233501691e-05,
                                         1.85193420922078e-09,
                                         0.0119533402178823,
                                         0.175582773721426,
                                         0.318050478394745,
                                         0.1640625,
                                         0.0240094674763298,
                                         0.000574000922291251,
                                         2.12780794804954e-07,
                                         0.000520178517150538,
                                         0.0434317721173692,
                                         0.224030403419406,
                                         0.2734375,
                                         0.0946823697475519,
                                         0.00644591307885771,
                                         1.35820959550772e-05,
                                         1.35820959550771e-05,
                                         0.00644591307885771,
                                         0.0946823697475519,
                                         0.2734375,
                                         0.224030403419406,
                                         0.0434317721173692,
                                         0.000520178517150542,
                                         2.12780794804952e-07,
                                         0.000574000922291251,
                                         0.0240094674763298,
                                         0.1640625,
                                         0.318050478394745,
                                         0.175582773721426,
                                         0.0119533402178824,
                                         1.85193420922076e-09,
                                         2.83967233501691e-05,
                                         0.00338238804843511,
                                         0.0546875,
                                         0.250849153763575,
                                         0.394351734849226,
                                         0.152599687365376,
                                         6.90783405608835e-12,
                                         6.02070135413138e-07,
                                         0.000204214957908504,
                                         0.0078125,
                                         0.0847915241920486,
                                         0.379584806517345,
                                         0.834912997163999,

                                         0.869024617148354,
                                         0.472130746008638,
                                         0.150224269540811,
                                         0.0253980268206605,
                                         0.00189115309870527,
                                         4.22898256217175e-05,
                                         1.12267207929378e-07,
                                         1.2164667026349e-12,
                                         0.123228534279389,
                                         0.374026043452567,
                                         0.327056853557849,
                                         0.122671786630209,
                                         0.0191857179525427,
                                         0.000951806839092721,
                                         6.94399568274334e-06,
                                         4.20355856043675e-10,
                                         0.00748882533409007,
                                         0.126988565619147,
                                         0.305161416668529,
                                         0.253929184701289,
                                         0.0834166293886726,
                                         0.00918089377249079,
                                         0.000184072612874598,
                                         6.22525567557284e-08,
                                         0.000252838738529668,
                                         0.0239527227230124,
                                         0.158184339460846,
                                         0.292016936748802,
                                         0.201490564659119,
                                         0.0491981303347605,
                                         0.00271079332087049,
                                         5.1218255079553e-06,
                                         5.1218255079553e-06,
                                         0.00271079332087049,
                                         0.0491981303347605,
                                         0.201490564659119,
                                         0.292016936748802,
                                         0.158184339460846,
                                         0.0239527227230124,
                                         0.000252838738529668,
                                         6.22525567557284e-08,
                                         0.000184072612874598,
                                         0.00918089377249079,
                                         0.0834166293886727,
                                         0.253929184701289,
                                         0.305161416668529,
                                         0.126988565619147,
                                         0.00748882533409007,
                                         4.20355856043675e-10,
                                         6.94399568274333e-06,
                                         0.000951806839092721,
                                         0.0191857179525427,
                                         0.122671786630209,
                                         0.327056853557849,
                                         0.374026043452567,
                                         0.123228534279389,
                                         1.2164667026349e-12,
                                         1.12267207929378e-07,
                                         4.22898256217175e-05,
                                         0.00189115309870527,
                                         0.0253980268206605,
                                         0.150224269540811,
                                         0.472130746008638,
                                         0.869024617148354,

                                         0.893744142257077,
                                         0.549477958085253,
                                         0.222295448173005,
                                         0.0557940337309718,
                                         0.0078125,
                                         0.000502663105141885,
                                         1.0088988133954e-05,
                                         2.48954669634121e-08,
                                         2.59166328142104e-13,
                                         0.101209338557884,
                                         0.343502375222785,
                                         0.372896397144658,
                                         0.199295985461008,
                                         0.0546875,
                                         0.00689544501740769,
                                         0.000294704029443844,
                                         1.95135770704456e-06,
                                         1.12141736685944e-10,
                                         0.00491191880811613,
                                         0.0920306369612021,
                                         0.268082842283547,
                                         0.305093218996892,
                                         0.1640625,
                                         0.0405387921438994,
                                         0.00368933210647813,
                                         6.55506064578806e-05,
                                         2.07959705652438e-08,
                                         0.000132436979527922,
                                         0.0136981717197272,
                                         0.107072352888744,
                                         0.259474124106776,
                                         0.2734375,
                                         0.132405737437903,
                                         0.02565883438599,
                                         0.00122333115140062,
                                         2.14248902292501e-06,
                                         2.14248902292498e-06,
                                         0.00122333115140062,
                                         0.02565883438599,
                                         0.132405737437903,
                                         0.2734375,
                                         0.259474124106776,
                                         0.107072352888744,
                                         0.0136981717197272,
                                         0.000132436979527923,
                                         2.07959705652434e-08,
                                         6.55506064578806e-05,
                                         0.00368933210647812,
                                         0.0405387921438994,
                                         0.1640625,
                                         0.305093218996892,
                                         0.268082842283547,
                                         0.0920306369612021,
                                         0.00491191880811617,
                                         1.12141736685941e-10,
                                         1.95135770704456e-06,
                                         0.000294704029443843,
                                         0.00689544501740769,
                                         0.0546875,
                                         0.199295985461008,
                                         0.372896397144658,
                                         0.343502375222785,
                                         0.101209338557884,
                                         2.59166328142098e-13,
                                         2.48954669634121e-08,
                                         1.0088988133954e-05,
                                         0.000502663105141885,
                                         0.0078125,
                                         0.0557940337309718,
                                         0.222295448173005,
                                         0.549477958085253,
                                         0.893744142257077,

                                         0.912170692266778,
                                         0.613260754654977,
                                         0.294365150290663,
                                         0.0971297034542767,
                                         0.0206394317017482,
                                         0.00252781811443596,
                                         0.000146470692237609,
                                         2.71921736229605e-06,
                                         6.36354503616898e-09,
                                         6.43447416647235e-14,
                                         0.0844071880891463,
                                         0.310584295080952,
                                         0.393349285805798,
                                         0.268759731603853,
                                         0.107032810707876,
                                         0.0238848603538697,
                                         0.00259378920356574,
                                         9.97121387125178e-05,
                                         6.15688275793512e-07,
                                         3.40726430409742e-11,
                                         0.00334738731069152,
                                         0.0674119709056842,
                                         0.225264914037869,
                                         0.318712831971607,
                                         0.237880772526816,
                                         0.0967214516287335,
                                         0.0196852909023901,
                                         0.00156702293584564,
                                         2.5529708730075e-05,
                                         7.73253331815299e-09,
                                         7.37496550382288e-05,
                                         0.00812871791323433,
                                         0.0716698072561585,
                                         0.20997248826672,
                                         0.293717109131236,
                                         0.217595745835285,
                                         0.0829996939053501,
                                         0.0136813883175915,
                                         0.000588109684602307,
                                         9.74911675303113e-07,
                                         9.74911675303113e-07,
                                         0.000588109684602309,
                                         0.0136813883175915,
                                         0.0829996939053501,
                                         0.217595745835285,
                                         0.293717109131236,
                                         0.20997248826672,
                                         0.0716698072561585,
                                         0.00812871791323431,
                                         7.37496550382288e-05,
                                         7.73253331815299e-09,
                                         2.55297087300751e-05,
                                         0.00156702293584564,
                                         0.0196852909023901,
                                         0.0967214516287335,
                                         0.237880772526816,
                                         0.318712831971607,
                                         0.225264914037869,
                                         0.0674119709056841,
                                         0.00334738731069152,
                                         3.40726430409742e-11,
                                         6.15688275793515e-07,
                                         9.97121387125178e-05,
                                         0.00259378920356574,
                                         0.0238848603538697,
                                         0.107032810707876,
                                         0.268759731603853,
                                         0.393349285805798,
                                         0.310584295080951,
                                         0.0844071880891463,
                                         6.43447416647235e-14,
                                         6.36354503616902e-09,
                                         2.71921736229605e-06,
                                         0.000146470692237609,
                                         0.00252781811443596,
                                         0.0206394317017482,
                                         0.0971297034542767,
                                         0.294365150290663,
                                         0.613260754654977,
                                         0.912170692266778,

                                         0.926244098741814,
                                         0.665723950256127,
                                         0.362559971440197,
                                         0.145843416736863,
                                         0.0415262113765022,
                                         0.0078125,
                                         0.000866865997780997,
                                         4.64727036686175e-05,
                                         8.13999977323069e-07,
                                         1.83085746069555e-09,
                                         1.8112834145891e-14,
                                         0.0713562801833172,
                                         0.278896908646785,
                                         0.395833756721649,
                                         0.323189978586531,
                                         0.167250507519824,
                                         0.0546875,
                                         0.0105463678313788,
                                         0.00102759732206423,
                                         3.65331818533283e-05,
                                         2.14141625603513e-07,
                                         1.15206170936179e-11,
                                         0.00235592881980487,
                                         0.0500744783969867,
                                         0.185211955423512,
                                         0.306939058132516,
                                         0.288692693861173,
                                         0.1640625,
                                         0.0549891586734564,
                                         0.00973803212535825,
                                         0.000702706254919552,
                                         1.07342293668924e-05,
                                         3.14042400973937e-09,
                                         4.32135179017489e-05,
                                         0.00499478343468782,
                                         0.0481451673549734,
                                         0.161947378132257,
                                         0.276841782374935,
                                         0.2734375,
                                         0.159286412364948,
                                         0.0512680662607414,
                                         0.0075090956229194,
                                         0.000298929063563843,
                                         4.75585199454238e-07,
                                         4.75585199454228e-07,
                                         0.000298929063563843,
                                         0.00750909562291941,
                                         0.0512680662607414,
                                         0.159286412364948,
                                         0.2734375,
                                         0.276841782374935,
                                         0.161947378132257,
                                         0.0481451673549733,
                                         0.00499478343468782,
                                         4.32135179017496e-05,
                                         3.14042400973929e-09,
                                         1.07342293668924e-05,
                                         0.000702706254919553,
                                         0.00973803212535826,
                                         0.0549891586734564,
                                         0.1640625,
                                         0.288692693861174,
                                         0.306939058132516,
                                         0.185211955423511,
                                         0.0500744783969867,
                                         0.0023559288198049,
                                         1.15206170936175e-11,
                                         2.14141625603513e-07,
                                         3.65331818533283e-05,
                                         0.00102759732206424,
                                         0.0105463678313788,
                                         0.0546875,
                                         0.167250507519824,
                                         0.323189978586531,
                                         0.395833756721648,
                                         0.278896908646785,
                                         0.0713562801833176,
                                         1.81128341458903e-14,
                                         1.83085746069555e-09,
                                         8.13999977323072e-07,
                                         4.64727036686176e-05,
                                         0.000866865997780996,
                                         0.0078125,
                                         0.0415262113765022,
                                         0.145843416736863,
                                         0.362559971440197,
                                         0.665723950256127,
                                         0.926244098741814,

                                         0.937220095578147,
                                         0.708999375682048,
                                         0.42504579933678,
                                         0.198352432442444,
                                         0.0699871380925131,
                                         0.0178438414813797,
                                         0.00306221267023594,
                                         0.000315224524153621,
                                         1.59257191772164e-05,
                                         2.66790910752525e-07,
                                         5.82067296012457e-10,
                                         5.66254781410992e-15,
                                         0.0610489564866734,
                                         0.249914040751448,
                                         0.386808451327986,
                                         0.360983388111131,
                                         0.226420907449706,
                                         0.0971037421352778,
                                         0.0275729871697237,
                                         0.00477438883616499,
                                         0.000428790788774355,
                                         1.43650414587286e-05,
                                         8.09141497756906e-08,
                                         4.25962443159873e-12,
                                         0.00170426887483335,
                                         0.0377536264932533,
                                         0.150861838134904,
                                         0.281552973061156,
                                         0.313933768368664,
                                         0.226467972473799,
                                         0.106403399390355,
                                         0.0309912282637739,
                                         0.0049478332633373,
                                         0.000331486581215451,
                                         4.82057635316753e-06,
                                         1.37326373421978e-09,
                                         2.64317230418161e-05,
                                         0.00316850347847235,
                                         0.0326881491160478,
                                         0.122000191776094,
                                         0.241817114545694,
                                         0.293430404251701,
                                         0.228115440427528,
                                         0.111760229919329,
                                         0.031718464837885,
                                         0.00424964367069749,
                                         0.000159551522207577,
                                         2.4595977545887e-07,
                                         2.45959775458876e-07,
                                         0.000159551522207576,
                                         0.00424964367069749,
                                         0.031718464837885,
                                         0.111760229919329,
                                         0.228115440427528,
                                         0.293430404251701,
                                         0.241817114545695,
                                         0.122000191776094,
                                         0.0326881491160478,
                                         0.00316850347847236,
                                         2.64317230418156e-05,
                                         1.37326373421982e-09,
                                         4.8205763531675e-06,
                                         0.00033148658121545,
                                         0.0049478332633373,
                                         0.0309912282637739,
                                         0.106403399390355,
                                         0.226467972473799,
                                         0.313933768368664,
                                         0.281552973061156,
                                         0.150861838134904,
                                         0.0377536264932534,
                                         0.00170426887483333,
                                         4.25962443159889e-12,
                                         8.09141497756901e-08,
                                         1.43650414587286e-05,
                                         0.000428790788774354,
                                         0.00477438883616498,
                                         0.0275729871697237,
                                         0.0971037421352778,
                                         0.226420907449706,
                                         0.360983388111132,
                                         0.386808451327986,
                                         0.249914040751448,
                                         0.061048956486673,
                                         5.66254781411016e-15,
                                         5.82067296012452e-10,
                                         2.66790910752525e-07,
                                         1.59257191772164e-05,
                                         0.00031522452415362,
                                         0.00306221267023594,
                                         0.0178438414813797,
                                         0.0699871380925131,
                                         0.198352432442444,
                                         0.42504579933678,
                                         0.708999375682048,
                                         0.937220095578147,

                                         0.945936938561647,
                                         0.744892565468458,
                                         0.481239949030381,
                                         0.251795991139697,
                                         0.104521182198714,
                                         0.0333624833981836,
                                         0.0078125,
                                         0.0012485762684793,
                                         0.000121240747790487,
                                         5.84794461503403e-06,
                                         9.46057209918471e-08,
                                         2.01529937703236e-10,
                                         1.93485451689262e-15,
                                         0.0527838544579877,
                                         0.224062754111928,
                                         0.371019080411895,
                                         0.383831260964566,
                                         0.278571865327661,
                                         0.146056757288519,
                                         0.0546875,
                                         0.0139748730855691,
                                         0.00222900861673815,
                                         0.00018797833540665,
                                         6.01282975145158e-06,
                                         3.28291486577646e-08,
                                         1.69904734082443e-12,
                                         0.00126230188648962,
                                         0.0288847700657434,
                                         0.12258971402078,
                                         0.250758168309437,
                                         0.318195040276673,
                                         0.274036336328936,
                                         0.1640625,
                                         0.0670353503614245,
                                         0.0175629758053626,
                                         0.00258961715184117,
                                         0.000163781041875245,
                                         2.29193810509822e-06,
                                         6.39419473769765e-10,
                                         1.67707643537466e-05,
                                         0.00206869114031551,
                                         0.0225029426863568,
                                         0.0910117216263317,
                                         0.201918938578588,
                                         0.285642053064808,
                                         0.2734375,
                                         0.17864357020408,
                                         0.0768797484484723,
                                         0.0198194145281061,
                                         0.00247842537323951,
                                         8.88942447721653e-05,
                                         1.33688402125921e-07,
                                         1.33688402125925e-07,
                                         8.88942447721658e-05,
                                         0.0024784253732395,
                                         0.0198194145281062,
                                         0.0768797484484723,
                                         0.17864357020408,
                                         0.2734375,
                                         0.285642053064808,
                                         0.201918938578588,
                                         0.0910117216263317,
                                         0.0225029426863568,
                                         0.0020686911403155,
                                         1.67707643537462e-05,
                                         6.39419473769788e-10,
                                         2.29193810509824e-06,
                                         0.000163781041875244,
                                         0.00258961715184118,
                                         0.0175629758053626,
                                         0.0670353503614245,
                                         0.1640625,
                                         0.274036336328936,
                                         0.318195040276673,
                                         0.250758168309436,
                                         0.12258971402078,
                                         0.0288847700657433,
                                         0.00126230188648961,
                                         1.6990473408245e-12,
                                         3.28291486577648e-08,
                                         6.01282975145156e-06,
                                         0.000187978335406651,
                                         0.00222900861673815,
                                         0.0139748730855691,
                                         0.0546875,
                                         0.146056757288519,
                                         0.278571865327661,
                                         0.383831260964566,
                                         0.371019080411895,
                                         0.224062754111928,
                                         0.0527838544579874,
                                         1.93485451689271e-15,
                                         2.01529937703238e-10,
                                         9.46057209918468e-08,
                                         5.84794461503404e-06,
                                         0.000121240747790487,
                                         0.0012485762684793,
                                         0.0078125,
                                         0.0333624833981836,
                                         0.104521182198714,
                                         0.251795991139697,
                                         0.481239949030381,
                                         0.744892565468458,
                                         0.945936938561647,

                                         0.952969820938751,
                                         0.774862926592346,
                                         0.531244961759882,
                                         0.304174912854268,
                                         0.143277284960876,
                                         0.0542953426974053,
                                         0.0160220880541196,
                                         0.00350878479449016,
                                         0.000530051593766141,
                                         4.91386596995848e-05,
                                         2.28430545834448e-06,
                                         3.59395852792802e-08,
                                         7.51103354506816e-11,
                                         7.13550584545569e-16,
                                         0.0460648242665565,
                                         0.201288667661476,
                                         0.351679374393899,
                                         0.394610545742223,
                                         0.320856262912937,
                                         0.196179792539372,
                                         0.0902805002364112,
                                         0.0305125124568437,
                                         0.00718823939691991,
                                         0.00107519245701581,
                                         8.62789721153054e-05,
                                         2.66021701833628e-06,
                                         1.41677648126912e-08,
                                         7.23320168848703e-13,
                                         0.000954295563234292,
                                         0.0224097485070864,
                                         0.0997751034510938,
                                         0.219400289904316,
                                         0.307940572750945,
                                         0.303786994996299,
                                         0.218017830725903,
                                         0.113716221788444,
                                         0.0417782394623391,
                                         0.0100825950776664,
                                         0.00139662226784715,
                                         8.43886983787661e-05,
                                         1.1453182760116e-06,
                                         3.1423864864456e-10,
                                         1.09830733887696e-05,
                                         0.00138606033366371,
                                         0.0157262425719347,
                                         0.0677693315169741,
                                         0.164191549140133,
                                         0.261343425884759,
                                         0.292494407183787,
                                         0.235447654760001,
                                         0.13489791342914,
                                         0.0525274040407279,
                                         0.0125597344367972,
                                         0.00148723296820769,
                                         5.14373442776061e-05,
                                         7.58431071318831e-08,
                                         7.58431071318831e-08,
                                         5.14373442776064e-05,
                                         0.00148723296820769,
                                         0.0125597344367972,
                                         0.0525274040407278,
                                         0.13489791342914,
                                         0.235447654760001,
                                         0.292494407183787,
                                         0.261343425884759,
                                         0.164191549140133,
                                         0.0677693315169742,
                                         0.0157262425719347,
                                         0.00138606033366371,
                                         1.09830733887696e-05,
                                         3.1423864864456e-10,
                                         1.14531827601161e-06,
                                         8.43886983787661e-05,
                                         0.00139662226784715,
                                         0.0100825950776664,
                                         0.0417782394623391,
                                         0.113716221788444,
                                         0.218017830725903,
                                         0.303786994996299,
                                         0.307940572750945,
                                         0.219400289904316,
                                         0.0997751034510938,
                                         0.0224097485070863,
                                         0.000954295563234292,
                                         7.23320168848703e-13,
                                         1.41677648126914e-08,
                                         2.66021701833628e-06,
                                         8.62789721153052e-05,
                                         0.00107519245701581,
                                         0.00718823939691991,
                                         0.0305125124568437,
                                         0.0902805002364112,
                                         0.196179792539372,
                                         0.320856262912937,
                                         0.394610545742223,
                                         0.351679374393899,
                                         0.201288667661475,
                                         0.0460648242665565,
                                         7.13550584545569e-16,
                                         7.51103354506824e-11,
                                         3.59395852792802e-08,
                                         2.28430545834448e-06,
                                         4.91386596995847e-05,
                                         0.000530051593766141,
                                         0.00350878479449015,
                                         0.0160220880541196,
                                         0.0542953426974053,
                                         0.143277284960876,
                                         0.304174912854268,
                                         0.531244961759882,
                                         0.774862926592346,
                                         0.952969820938751,

                                         0.958723227255006,
                                         0.800067125939386,
                                         0.575497737495814,
                                         0.35423167219522,
                                         0.184488574859528,
                                         0.079975965051387,
                                         0.0281891738330272,
                                         0.0078125,
                                         0.00162135793230379,
                                         0.000234066389689774,
                                         2.09020202910069e-05,
                                         9.43080852419066e-07,
                                         1.45064312484966e-08,
                                         2.98505703800188e-11,
                                         2.81160065031437e-16,
                                         0.0405348422550844,
                                         0.181336551676853,
                                         0.330859861763959,
                                         0.39627276065787,
                                         0.352682967155124,
                                         0.243282994747208,
                                         0.131222548120872,
                                         0.0546875,
                                         0.0170666727741127,
                                         0.00377036046283577,
                                         0.000535758827106493,
                                         4.13083812115719e-05,
                                         1.23639204099532e-06,
                                         6.45341786698059e-09,
                                         3.25847562895827e-13,
                                         0.00073449178028857,
                                         0.0176143854012481,
                                         0.0815206740636618,
                                         0.189987166791876,
                                         0.28895000776231,
                                         0.317166443131511,
                                         0.261792861695211,
                                         0.1640625,
                                         0.0769913681899537,
                                         0.0260285457079497,
                                         0.00588536795198876,
                                         0.000775444356778815,
                                         4.51621940104766e-05,
                                         5.97929739973003e-07,
                                         1.61844719356791e-10,
                                         7.3938883370804e-06,
                                         0.000950554737998388,
                                         0.0111588370314232,
                                         0.0506036457841155,
                                         0.131518979368856,
                                         0.229715449863967,
                                         0.290158053440965,
                                         0.2734375,
                                         0.192957964013554,
                                         0.0998261746454514,
                                         0.0359174420547951,
                                         0.00808705875207693,
                                         0.000916476552659172,
                                         3.07778315058496e-05,
                                         4.46591122256563e-08,
                                         4.46591122256547e-08,
                                         3.07778315058496e-05,
                                         0.00091647655265917,
                                         0.00808705875207694,
                                         0.0359174420547951,
                                         0.0998261746454514,
                                         0.192957964013554,
                                         0.2734375,
                                         0.290158053440965,
                                         0.229715449863967,
                                         0.131518979368856,
                                         0.0506036457841154,
                                         0.0111588370314232,
                                         0.000950554737998388,
                                         7.3938883370806e-06,
                                         1.61844719356784e-10,
                                         5.97929739973003e-07,
                                         4.51621940104764e-05,
                                         0.000775444356778817,
                                         0.00588536795198876,
                                         0.0260285457079497,
                                         0.0769913681899537,
                                         0.1640625,
                                         0.261792861695211,
                                         0.317166443131511,
                                         0.28895000776231,
                                         0.189987166791875,
                                         0.0815206740636619,
                                         0.017614385401248,
                                         0.000734491780288583,
                                         3.25847562895809e-13,
                                         6.45341786698059e-09,
                                         1.23639204099531e-06,
                                         4.1308381211572e-05,
                                         0.000535758827106493,
                                         0.00377036046283577,
                                         0.0170666727741127,
                                         0.0546875,
                                         0.131222548120872,
                                         0.243282994747208,
                                         0.352682967155124,
                                         0.396272760657869,
                                         0.330859861763959,
                                         0.181336551676853,
                                         0.0405348422550848,
                                         2.81160065031419e-16,
                                         2.98505703800188e-11,
                                         1.45064312484965e-08,
                                         9.43080852419068e-07,
                                         2.09020202910069e-05,
                                         0.000234066389689774,
                                         0.00162135793230379,
                                         0.0078125,
                                         0.0281891738330272,
                                         0.079975965051387,
                                         0.184488574859528,
                                         0.35423167219522,
                                         0.575497737495814,
                                         0.800067125939386,
                                         0.958723227255006,

                                         0.963487876613842,
                                         0.82141561165458,
                                         0.614568939183748,
                                         0.401264115422011,
                                         0.226676823404277,
                                         0.109427803262988,
                                         0.044367600759339,
                                         0.0147476762654543,
                                         0.00388407906278665,
                                         0.000771505932739513,
                                         0.000107322536723417,
                                         9.29433436896899e-06,
                                         4.09195085019907e-07,
                                         6.17844303555952e-09,
                                         1.25524551204721e-11,
                                         1.17398600950322e-16,
                                         0.0359326736082037,
                                         0.163885983045812,
                                         0.309842709060337,
                                         0.391381058833441,
                                         0.374769204727842,
                                         0.284740368112662,
                                         0.174090254186645,
                                         0.0853188770585429,
                                         0.0328974781024956,
                                         0.00963444795339857,
                                         0.00202099690357497,
                                         0.000275459397485201,
                                         2.05568708701249e-05,
                                         6.00488165400556e-07,
                                         3.08280389840102e-09,
                                         1.54246643849532e-13,
                                         0.000574322757366307,
                                         0.0140134117549949,
                                         0.066947624287235,
                                         0.163603465711448,
                                         0.265548523544295,
                                         0.317536474076944,
                                         0.292756259240022,
                                         0.211538724130551,
                                         0.119415407801536,
                                         0.0515629331976816,
                                         0.0163103613075057,
                                         0.00349880798270781,
                                         0.00044259532444611,
                                         2.50122679806086e-05,
                                         3.24478806898789e-07,
                                         8.68543830758214e-11,
                                         5.09976322857701e-06,
                                         0.000665692172642758,
                                         0.00803630764657857,
                                         0.0379937962826882,
                                         0.104532510300816,
                                         0.196727778981297,
                                         0.273505090552769,
                                         0.291381601128071,
                                         0.240816156450563,
                                         0.153311908177405,
                                         0.0731288948183056,
                                         0.024689376308208,
                                         0.00529400236001014,
                                         0.000578800887512043,
                                         1.89737978073704e-05,
                                         2.71703511525217e-08,
                                         2.71703511525228e-08,
                                         1.89737978073704e-05,
                                         0.000578800887512041,
                                         0.00529400236001015,
                                         0.024689376308208,
                                         0.0731288948183056,
                                         0.153311908177405,
                                         0.240816156450563,
                                         0.291381601128071,
                                         0.273505090552769,
                                         0.196727778981297,
                                         0.104532510300816,
                                         0.0379937962826881,
                                         0.00803630764657859,
                                         0.000665692172642758,
                                         5.09976322857685e-06,
                                         8.6854383075826e-11,
                                         3.24478806898789e-07,
                                         2.50122679806085e-05,
                                         0.000442595324446111,
                                         0.0034988079827078,
                                         0.0163103613075057,
                                         0.0515629331976817,
                                         0.119415407801536,
                                         0.21153872413055,
                                         0.292756259240022,
                                         0.317536474076944,
                                         0.265548523544295,
                                         0.163603465711448,
                                         0.0669476242872351,
                                         0.0140134117549949,
                                         0.000574322757366295,
                                         1.54246643849542e-13,
                                         3.08280389840102e-09,
                                         6.00488165400553e-07,
                                         2.0556870870125e-05,
                                         0.000275459397485201,
                                         0.00202099690357497,
                                         0.00963444795339858,
                                         0.0328974781024956,
                                         0.0853188770585428,
                                         0.174090254186645,
                                         0.284740368112662,
                                         0.374769204727842,
                                         0.391381058833441,
                                         0.309842709060338,
                                         0.163885983045812,
                                         0.0359326736082033,
                                         1.17398600950331e-16,
                                         1.25524551204721e-11,
                                         6.17844303555948e-09,
                                         4.09195085019908e-07,
                                         9.29433436896899e-06,
                                         0.000107322536723417,
                                         0.000771505932739514,
                                         0.00388407906278664,
                                         0.0147476762654543,
                                         0.044367600759339,
                                         0.109427803262988,
                                         0.226676823404277,
                                         0.401264115422011,
                                         0.614568939183748,
                                         0.82141561165458,
                                         0.963487876613842,

                                         0.967476832232532,
                                         0.839624823270648,
                                         0.649055261862035,
                                         0.444953589036542,
                                         0.268706827222014,
                                         0.141592634054263,
                                         0.0642538196510229,
                                         0.0246635922971972,
                                         0.0078125,
                                         0.00197288396267145,
                                         0.000377934973009722,
                                         5.09828306588816e-05,
                                         4.30421995417006e-06,
                                         1.85675786621681e-07,
                                         2.76053986983122e-09,
                                         5.54916360631833e-12,
                                         5.1594834602283e-17,
                                         0.0320641270869944,
                                         0.148614359994553,
                                         0.289388640264885,
                                         0.381985712912654,
                                         0.388438124856186,
                                         0.319295983767263,
                                         0.215951747699119,
                                         0.120350124948616,
                                         0.0546875,
                                         0.0198110461502499,
                                         0.00551004808648888,
                                         0.00110781497082647,
                                         0.000145897344939989,
                                         1.05978787641102e-05,
                                         3.03382342154962e-07,
                                         1.53620121305142e-09,
                                         7.62822434944875e-14,
                                         0.000455429840768007,
                                         0.0112735188645107,
                                         0.0552973727696637,
                                         0.14054090307518,
                                         0.240651299732262,
                                         0.308581201267556,
                                         0.311055375524245,
                                         0.251686529925444,
                                         0.1640625,
                                         0.0852582652010214,
                                         0.0344284055840612,
                                         0.0103165320032539,
                                         0.00211945175603592,
                                         0.000259242282342137,
                                         1.42892617083408e-05,
                                         1.82260221107425e-07,
                                         4.83352428375634e-11,
                                         3.59377629743918e-06,
                                         0.000475100744687779,
                                         0.00587022857034107,
                                         0.0287267076715445,
                                         0.0828289334430581,
                                         0.165681100185602,
                                         0.248912206014693,
                                         0.292415840739479,
                                         0.2734375,
                                         0.203841716775321,
                                         0.119510462467359,
                                         0.053373750920577,
                                         0.0171051614255499,
                                         0.00352306146718697,
                                         0.000373901128484931,
                                         1.20133236294192e-05,
                                         1.70149958389949e-08,
                                         1.70149958389941e-08,
                                         1.20133236294193e-05,
                                         0.000373901128484931,
                                         0.00352306146718698,
                                         0.0171051614255499,
                                         0.053373750920577,
                                         0.119510462467359,
                                         0.203841716775321,
                                         0.2734375,
                                         0.292415840739479,
                                         0.248912206014693,
                                         0.165681100185602,
                                         0.082828933443058,
                                         0.0287267076715445,
                                         0.00587022857034108,
                                         0.000475100744687776,
                                         3.5937762974393e-06,
                                         4.83352428375605e-11,
                                         1.82260221107427e-07,
                                         1.42892617083408e-05,
                                         0.000259242282342138,
                                         0.00211945175603593,
                                         0.0103165320032539,
                                         0.0344284055840612,
                                         0.0852582652010214,
                                         0.1640625,
                                         0.251686529925444,
                                         0.311055375524245,
                                         0.308581201267556,
                                         0.240651299732261,
                                         0.140540903075179,
                                         0.0552973727696637,
                                         0.0112735188645106,
                                         0.000455429840768018,
                                         7.62822434944821e-14,
                                         1.53620121305144e-09,
                                         3.03382342154962e-07,
                                         1.05978787641102e-05,
                                         0.000145897344939989,
                                         0.00110781497082647,
                                         0.00551004808648888,
                                         0.0198110461502499,
                                         0.0546875,
                                         0.120350124948616,
                                         0.215951747699119,
                                         0.319295983767263,
                                         0.388438124856186,
                                         0.381985712912654,
                                         0.289388640264885,
                                         0.148614359994552,
                                         0.0320641270869948,
                                         5.15948346022787e-17,
                                         5.54916360631841e-12,
                                         2.76053986983122e-09,
                                         1.85675786621682e-07,
                                         4.30421995417007e-06,
                                         5.09828306588817e-05,
                                         0.000377934973009722,
                                         0.00197288396267145,
                                         0.0078125,
                                         0.0246635922971972,
                                         0.0642538196510229,
                                         0.141592634054263,
                                         0.268706827222014,
                                         0.444953589036542,
                                         0.649055261862035,
                                         0.839624823270648,
                                         0.967476832232532,

                                         0.970848993561292,
                                         0.855260371523085,
                                         0.679525631043893,
                                         0.485230984967367,
                                         0.309763463258982,
                                         0.175475137508019,
                                         0.0873166582711359,
                                         0.0376481861539915,
                                         0.0138091752542664,
                                         0.00420228119387966,
                                         0.0010246217907608,
                                         0.000190422200218412,
                                         2.50346621280949e-05,
                                         2.06886649136993e-06,
                                         8.7731454159596e-08,
                                         1.28750873003575e-09,
                                         2.56506411962059e-12,
                                         2.37314862287524e-17,
                                         0.0287827057606339,
                                         0.135223917864324,
                                         0.26992231391626,
                                         0.369649730903669,
                                         0.395184575011754,
                                         0.346682286201018,
                                         0.254681894023045,
                                         0.15748706426402,
                                         0.0815556356205716,
                                         0.0348654242541196,
                                         0.0120021441298514,
                                         0.00319898861333274,
                                         0.00062090013467116,
                                         7.9461864671816e-05,
                                         5.64299335673836e-06,
                                         1.58822971351864e-07,
                                         7.94948767956052e-10,
                                         3.92230249620262e-14,
                                         0.000365708256998698,
                                         0.00916287779792744,
                                         0.045950998054323,
                                         0.120685606699555,
                                         0.216069264156086,
                                         0.293542458344168,
                                         0.318362752116162,
                                         0.282337738765935,
                                         0.206425538890078,
                                         0.12397325768716,
                                         0.0602528095227768,
                                         0.0230319667180795,
                                         0.0065997120642815,
                                         0.00130800153406177,
                                         0.000155556070816479,
                                         8.39652655459267e-06,
                                         1.05585254270088e-07,
                                         2.77830836035845e-11,
                                         2.58146005276901e-06,
                                         0.000344935401574243,
                                         0.00434588874347064,
                                         0.021890115676134,
                                         0.0656316761907518,
                                         0.138082199755362,
                                         0.221092456279348,
                                         0.281203338135137,
                                         0.290268809764174,
                                         0.24489987733575,
                                         0.168044097237528,
                                         0.0921248617786786,
                                         0.0389722713303529,
                                         0.0119614891172009,
                                         0.00238227495764645,
                                         0.00024661160501842,
                                         7.79103032146277e-06,
                                         1.09332002379141e-08,
                                         1.09332002379141e-08,
                                         7.79103032146277e-06,
                                         0.00024661160501842,
                                         0.00238227495764644,
                                         0.0119614891172009,
                                         0.0389722713303529,
                                         0.0921248617786786,
                                         0.168044097237528,
                                         0.24489987733575,
                                         0.290268809764174,
                                         0.281203338135137,
                                         0.221092456279348,
                                         0.138082199755362,
                                         0.0656316761907518,
                                         0.0218901156761341,
                                         0.00434588874347064,
                                         0.000344935401574243,
                                         2.58146005276901e-06,
                                         2.77830836035845e-11,
                                         1.05585254270088e-07,
                                         8.39652655459267e-06,
                                         0.000155556070816479,
                                         0.00130800153406177,
                                         0.0065997120642815,
                                         0.0230319667180795,
                                         0.0602528095227768,
                                         0.12397325768716,
                                         0.206425538890078,
                                         0.282337738765935,
                                         0.318362752116162,
                                         0.293542458344168,
                                         0.216069264156086,
                                         0.120685606699555,
                                         0.045950998054323,
                                         0.00916287779792744,
                                         0.000365708256998698,
                                         3.92230249620262e-14,
                                         7.94948767956052e-10,
                                         1.58822971351864e-07,
                                         5.64299335673834e-06,
                                         7.9461864671816e-05,
                                         0.00062090013467116,
                                         0.00319898861333274,
                                         0.0120021441298514,
                                         0.0348654242541196,
                                         0.0815556356205716,
                                         0.15748706426402,
                                         0.254681894023045,
                                         0.346682286201018,
                                         0.395184575011754,
                                         0.36964973090367,
                                         0.26992231391626,
                                         0.135223917864324,
                                         0.0287827057606339,
                                         2.37314862287524e-17,
                                         2.56506411962059e-12,
                                         1.28750873003575e-09,
                                         8.77314541595956e-08,
                                         2.06886649136993e-06,
                                         2.50346621280949e-05,
                                         0.000190422200218412,
                                         0.0010246217907608,
                                         0.00420228119387966,
                                         0.0138091752542664,
                                         0.0376481861539915,
                                         0.0873166582711359,
                                         0.175475137508019,
                                         0.309763463258982,
                                         0.485230984967367,
                                         0.679525631043893,
                                         0.855260371523085,
                                         0.970848993561292,

                                         0.973724739478554,
                                         0.868771103835969,
                                         0.706497445227301,
                                         0.522180717653786,
                                         0.34929822280336,
                                         0.210216031048477,
                                         0.112917825555881,
                                         0.0535653676976678,
                                         0.0221276721186275,
                                         0.0078125,
                                         0.00229851199108852,
                                         0.00054409476381518,
                                         9.85609151974571e-05,
                                         1.26783501823302e-05,
                                         1.02893507519265e-06,
                                         4.30031096923521e-08,
                                         6.24168847809301e-10,
                                         1.23409554030576e-12,
                                         1.13696304849452e-17,
                                         0.0259763753379508,
                                         0.123451202307739,
                                         0.251656076026484,
                                         0.355527351924447,
                                         0.396441334813594,
                                         0.367251375360567,
                                         0.28896969016475,
                                         0.194642605695934,
                                         0.11208186416695,
                                         0.0546875,
                                         0.0222353124102691,
                                         0.00733697107637154,
                                         0.00188716998971387,
                                         0.000355599567720664,
                                         4.44223468079519e-05,
                                         3.0948795736486e-06,
                                         8.5862068038227e-08,
                                         4.25554224767889e-10,
                                         2.08833459848254e-14,
                                         0.000296991563136116,
                                         0.00751810687398467,
                                         0.0384173549360853,
                                         0.103740519894834,
                                         0.192834483162211,
                                         0.274969322948799,
                                         0.316931417374285,
                                         0.303120245522948,
                                         0.243309002562003,
                                         0.1640625,
                                         0.0921855630137715,
                                         0.042401603666598,
                                         0.0154860454845544,
                                         0.00427447636813722,
                                         0.000821936448179471,
                                         9.54576771365523e-05,
                                         5.06201950711366e-06,
                                         6.28903837332664e-08,
                                         1.64390619415994e-11,
                                         1.8864146839945e-06,
                                         0.000254360202034222,
                                         0.00325817940718655,
                                         0.0168171081474633,
                                         0.0521096266416783,
                                         0.114375380696803,
                                         0.193110455559094,
                                         0.262252401059121,
                                         0.293432697448997,
                                         0.2734375,
                                         0.212329376288294,
                                         0.136136710517544,
                                         0.0705988349565245,
                                         0.028545135659314,
                                         0.00844894484909402,
                                         0.00163570681965068,
                                         0.000165795897199209,
                                         5.16346310022053e-06,
                                         7.18921505192884e-09,
                                         7.18921505192884e-09,
                                         5.16346310022053e-06,
                                         0.000165795897199209,
                                         0.00163570681965068,
                                         0.00844894484909401,
                                         0.028545135659314,
                                         0.0705988349565245,
                                         0.136136710517544,
                                         0.212329376288294,
                                         0.2734375,
                                         0.293432697448997,
                                         0.262252401059121,
                                         0.193110455559094,
                                         0.114375380696803,
                                         0.0521096266416784,
                                         0.0168171081474633,
                                         0.00325817940718655,
                                         0.000254360202034222,
                                         1.8864146839945e-06,
                                         1.64390619415994e-11,
                                         6.28903837332664e-08,
                                         5.06201950711366e-06,
                                         9.54576771365523e-05,
                                         0.000821936448179469,
                                         0.00427447636813723,
                                         0.0154860454845544,
                                         0.0424016036665979,
                                         0.0921855630137715,
                                         0.1640625,
                                         0.243309002562002,
                                         0.303120245522948,
                                         0.316931417374285,
                                         0.274969322948799,
                                         0.192834483162211,
                                         0.103740519894834,
                                         0.0384173549360853,
                                         0.00751810687398467,
                                         0.000296991563136116,
                                         2.08833459848254e-14,
                                         4.25554224767889e-10,
                                         8.5862068038227e-08,
                                         3.0948795736486e-06,
                                         4.44223468079518e-05,
                                         0.000355599567720665,
                                         0.00188716998971387,
                                         0.00733697107637153,
                                         0.0222353124102691,
                                         0.0546875,
                                         0.11208186416695,
                                         0.194642605695934,
                                         0.28896969016475,
                                         0.367251375360567,
                                         0.396441334813594,
                                         0.355527351924447,
                                         0.251656076026484,
                                         0.123451202307739,
                                         0.0259763753379508,
                                         1.13696304849452e-17,
                                         1.23409554030576e-12,
                                         6.24168847809301e-10,
                                         4.30031096923521e-08,
                                         1.02893507519265e-06,
                                         1.26783501823302e-05,
                                         9.85609151974571e-05,
                                         0.00054409476381518,
                                         0.00229851199108852,
                                         0.0078125,
                                         0.0221276721186275,
                                         0.0535653676976678,
                                         0.112917825555881,
                                         0.210216031048477,
                                         0.34929822280336,
                                         0.522180717653786,
                                         0.706497445227301,
                                         0.868771103835969,
                                         0.973724739478554,

                                         0.976196567367861,
                                         0.88051540924611,
                                         0.730428922953023,
                                         0.555975297182679,
                                         0.38697022724605,
                                         0.245116685329897,
                                         0.140402125697163,
                                         0.0721185178433988,
                                         0.0328585504402887,
                                         0.0130907088805282,
                                         0.00447467010885329,
                                         0.00127924672339679,
                                         0.000295282260900386,
                                         5.23333777910373e-05,
                                         6.60771573402766e-06,
                                         5.28020695703352e-07,
                                         2.17952399551297e-08,
                                         3.13371383563937e-10,
                                         6.15569715074035e-13,
                                         5.65076185442762e-18,
                                         0.0235583721185029,
                                         0.113068272156229,
                                         0.234670800652588,
                                         0.340450844297936,
                                         0.393472739101553,
                                         0.381689925755387,
                                         0.318179686300911,
                                         0.230159655628361,
                                         0.144664366967263,
                                         0.0786069415233813,
                                         0.0365139964386586,
                                         0.0142376142757751,
                                         0.00453368175334123,
                                         0.00113155607461202,
                                         0.000207926387842072,
                                         2.5445437883706e-05,
                                         1.74404953165637e-06,
                                         4.77941037217861e-08,
                                         2.34892705560329e-10,
                                         1.14734779033256e-14,
                                         0.000243655653888718,
                                         0.00622254097712791,
                                         0.032311964507659,
                                         0.0893462954486217,
                                         0.171464792950121,
                                         0.254725095916331,
                                         0.309025580036677,
                                         0.314800069958618,
                                         0.272959337910312,
                                         0.202293462334452,
                                         0.127697069136316,
                                         0.067911503775161,
                                         0.0298323811711126,
                                         0.0104856802187149,
                                         0.00280408440037196,
                                         0.000525523483423647,
                                         5.9810741935254e-05,
                                         3.12401077495157e-06,
                                         3.84136017933627e-08,
                                         9.98404148902157e-12,
                                         1.40002310887155e-06,
                                         0.000190248950546227,
                                         0.00247169663356501,
                                         0.0130264530827157,
                                         0.0415109588427052,
                                         0.0944409324476511,
                                         0.166741577564465,
                                         0.239203723788553,
                                         0.286128973009092,
                                         0.289221311546274,
                                         0.248101840031537,
                                         0.179960406898712,
                                         0.109056687595715,
                                         0.0539814607296651,
                                         0.0210087420467862,
                                         0.00602978491756742,
                                         0.00113953340134022,
                                         0.000113443134915462,
                                         3.49002087574654e-06,
                                         4.82664286444923e-09,
                                         4.82664286444892e-09,
                                         3.4900208757465e-06,
                                         0.000113443134915462,
                                         0.00113953340134021,
                                         0.00602978491756742,
                                         0.0210087420467862,
                                         0.0539814607296651,
                                         0.109056687595715,
                                         0.179960406898712,
                                         0.248101840031537,
                                         0.289221311546273,
                                         0.286128973009092,
                                         0.239203723788553,
                                         0.166741577564465,
                                         0.094440932447651,
                                         0.0415109588427052,
                                         0.0130264530827157,
                                         0.00247169663356501,
                                         0.000190248950546229,
                                         1.40002310887162e-06,
                                         9.98404148902077e-12,
                                         3.84136017933621e-08,
                                         3.12401077495157e-06,
                                         5.98107419352538e-05,
                                         0.000525523483423647,
                                         0.00280408440037197,
                                         0.0104856802187149,
                                         0.0298323811711126,
                                         0.067911503775161,
                                         0.127697069136316,
                                         0.202293462334452,
                                         0.272959337910312,
                                         0.314800069958618,
                                         0.309025580036677,
                                         0.254725095916331,
                                         0.171464792950121,
                                         0.0893462954486219,
                                         0.032311964507659,
                                         0.00622254097712795,
                                         0.000243655653888726,
                                         1.14734779033245e-14,
                                         2.34892705560325e-10,
                                         4.77941037217861e-08,
                                         1.74404953165636e-06,
                                         2.5445437883706e-05,
                                         0.000207926387842072,
                                         0.00113155607461202,
                                         0.00453368175334123,
                                         0.0142376142757751,
                                         0.0365139964386586,
                                         0.0786069415233813,
                                         0.144664366967263,
                                         0.230159655628361,
                                         0.318179686300911,
                                         0.381689925755387,
                                         0.393472739101553,
                                         0.340450844297936,
                                         0.234670800652588,
                                         0.11306827215623,
                                         0.0235583721185033,
                                         5.65076185442698e-18,
                                         6.15569715074022e-13,
                                         3.13371383563937e-10,
                                         2.17952399551296e-08,
                                         5.28020695703352e-07,
                                         6.60771573402767e-06,
                                         5.23333777910373e-05,
                                         0.000295282260900386,
                                         0.00127924672339679,
                                         0.00447467010885329,
                                         0.0130907088805282,
                                         0.0328585504402887,
                                         0.0721185178433988,
                                         0.140402125697163,
                                         0.245116685329897,
                                         0.38697022724605,
                                         0.555975297182679,
                                         0.730428922953023,
                                         0.88051540924611,
                                         0.976196567367861,

                                         0.978336469198365,
                                         0.890781350111176,
                                         0.751719661380738,
                                         0.586832352594959,
                                         0.422592976245175,
                                         0.279635530435334,
                                         0.16915519179793,
                                         0.0929159456895194,
                                         0.0459463889894858,
                                         0.0202264579705358,
                                         0.0078125,
                                         0.00259749328051612,
                                         0.000724534328239758,
                                         0.000163659495084149,
                                         2.84656792621858e-05,
                                         3.5369768206122e-06,
                                         2.78891511560826e-07,
                                         1.13890484506114e-08,
                                         1.62421239301908e-10,
                                         3.17262243486129e-13,
                                         2.90331499607672e-18,
                                         0.0214607191296514,
                                         0.103880265823414,
                                         0.218967999654001,
                                         0.325007963186267,
                                         0.387341119431338,
                                         0.390824517854616,
                                         0.342172961824708,
                                         0.262868427992087,
                                         0.177784283323365,
                                         0.105603901070251,
                                         0.0546875,
                                         0.0243775686181874,
                                         0.00917514775492572,
                                         0.00283458255818483,
                                         0.000689536522901207,
                                         0.000124004899552202,
                                         1.49093959106605e-05,
                                         1.00763574989925e-06,
                                         2.73221051518847e-08,
                                         1.33306870946422e-10,
                                         6.48536180584406e-15,
                                         0.000201754631485758,
                                         0.0051918029810232,
                                         0.0273355997696612,
                                         0.0771431147005187,
                                         0.152155672143844,
                                         0.23409625407529,
                                         0.296639691531881,
                                         0.318720368741796,
                                         0.29482109872538,
                                         0.236299771407634,
                                         0.1640625,
                                         0.0980504423012164,
                                         0.049795532529488,
                                         0.0210407021560248,
                                         0.00715840411639092,
                                         0.00186323953552717,
                                         0.000341592253423101,
                                         3.82069974205487e-05,
                                         1.96973912614713e-06,
                                         2.40054522803663e-08,
                                         6.20865426632319e-12,
                                         1.05373219788318e-06,
                                         0.000144155378096451,
                                         0.00189585037272781,
                                         0.0101725031380004,
                                         0.0332055123222507,
                                         0.0778994915002695,
                                         0.142869764075645,
                                         0.214688462265752,
                                         0.271613436453665,
                                         0.293747471034107,
                                         0.2734375,
                                         0.219096894317552,
                                         0.150139577895451,
                                         0.086767851101552,
                                         0.041285984451282,
                                         0.0155534247225901,
                                         0.0043479393165472,
                                         0.000804840358035996,
                                         7.8891599219885e-05,
                                         2.40156721394334e-06,
                                         3.30208492368816e-09,
                                         3.30208492368839e-09,
                                         2.40156721394331e-06,
                                         7.88915992198854e-05,
                                         0.000804840358035996,
                                         0.0043479393165472,
                                         0.0155534247225901,
                                         0.041285984451282,
                                         0.0867678511015519,
                                         0.150139577895451,
                                         0.219096894317552,
                                         0.2734375,
                                         0.293747471034107,
                                         0.271613436453665,
                                         0.214688462265752,
                                         0.142869764075645,
                                         0.0778994915002695,
                                         0.0332055123222507,
                                         0.0101725031380004,
                                         0.0018958503727278,
                                         0.000144155378096453,
                                         1.05373219788312e-06,
                                         6.20865426632375e-12,
                                         2.40054522803659e-08,
                                         1.96973912614715e-06,
                                         3.82069974205487e-05,
                                         0.000341592253423101,
                                         0.00186323953552717,
                                         0.00715840411639092,
                                         0.0210407021560248,
                                         0.049795532529488,
                                         0.0980504423012164,
                                         0.1640625,
                                         0.236299771407634,
                                         0.29482109872538,
                                         0.318720368741796,
                                         0.296639691531881,
                                         0.23409625407529,
                                         0.152155672143844,
                                         0.0771431147005187,
                                         0.0273355997696611,
                                         0.00519180298102323,
                                         0.000201754631485751,
                                         6.48536180584475e-15,
                                         1.33306870946419e-10,
                                         2.73221051518849e-08,
                                         1.00763574989925e-06,
                                         1.49093959106605e-05,
                                         0.000124004899552202,
                                         0.000689536522901207,
                                         0.00283458255818483,
                                         0.00917514775492572,
                                         0.0243775686181874,
                                         0.0546875,
                                         0.105603901070251,
                                         0.177784283323365,
                                         0.262868427992088,
                                         0.342172961824708,
                                         0.390824517854616,
                                         0.387341119431338,
                                         0.325007963186267,
                                         0.218967999654001,
                                         0.103880265823414,
                                         0.021460719129651,
                                         2.90331499607708e-18,
                                         3.17262243486122e-13,
                                         1.6242123930191e-10,
                                         1.13890484506114e-08,
                                         2.78891511560826e-07,
                                         3.5369768206122e-06,
                                         2.84656792621858e-05,
                                         0.000163659495084149,
                                         0.000724534328239758,
                                         0.00259749328051612,
                                         0.0078125,
                                         0.0202264579705358,
                                         0.0459463889894858,
                                         0.0929159456895194,
                                         0.16915519179793,
                                         0.279635530435334,
                                         0.422592976245175,
                                         0.586832352594959,
                                         0.751719661380738,
                                         0.890781350111176,
                                         0.978336469198365,

                                         0.980201135684649,
                                         0.899802034928746,
                                         0.770715042394355,
                                         0.61498729685726,
                                         0.456090617808426,
                                         0.313370558539771,
                                         0.19863465885222,
                                         0.115525780189393,
                                         0.0612226679668602,
                                         0.0293026770626826,
                                         0.0125237852716783,
                                         0.00471002091732903,
                                         0.00152898069154182,
                                         0.000417510871561184,
                                         9.25579579894907e-05,
                                         1.58388181371484e-05,
                                         1.94086476176554e-06,
                                         1.5127491189003e-07,
                                         6.12029987973844e-09,
                                         8.66661943997641e-11,
                                         1.68462038852163e-13,
                                         1.53744805132756e-18,
                                         0.0196295857256514,
                                         0.0957216161707918,
                                         0.204503083115557,
                                         0.309605009419575,
                                         0.378910941032084,
                                         0.395500688257218,
                                         0.361141196174155,
                                         0.292047409240671,
                                         0.210158420975289,
                                         0.134521064807784,
                                         0.0762360522300465,
                                         0.0379135219432858,
                                         0.0163198094489065,
                                         0.00595976757834684,
                                         0.00179405352893373,
                                         0.000426871194038755,
                                         7.53533046405333e-05,
                                         8.92230328295759e-06,
                                         5.95699105827036e-07,
                                         1.60044141877713e-08,
                                         7.75952400317919e-11,
                                         3.76184240485053e-15,
                                         0.000168472989179581,
                                         0.00436411603251342,
                                         0.0232556830086233,
                                         0.0667994716644947,
                                         0.134910691266675,
                                         0.213923999854287,
                                         0.281398805930724,
                                         0.316410597225363,
                                         0.309175133330406,
                                         0.26466499735517,
                                         0.198887917221197,
                                         0.130794245901368,
                                         0.0746537075102097,
                                         0.0364597824261607,
                                         0.0149032245058435,
                                         0.00493053606982463,
                                         0.00125381235771946,
                                         0.000225533089426752,
                                         2.48487421244017e-05,
                                         1.26663957333766e-06,
                                         1.53176211514553e-08,
                                         3.94479064559854e-12,
                                         8.03298440532971e-07,
                                         0.000110537604932635,
                                         0.00146921662217127,
                                         0.00800692150553196,
                                         0.0266859755846531,
                                         0.0642834640753651,
                                         0.121813371393712,
                                         0.190447895461017,
                                         0.252691021865712,
                                         0.289287864506997,
                                         0.288259676939709,
                                         0.250674779575387,
                                         0.189720898616707,
                                         0.123915694985664,
                                         0.0687784818907889,
                                         0.0316387215671883,
                                         0.0115901827462374,
                                         0.00316716764054091,
                                         0.000575849991608476,
                                         5.56921286396264e-05,
                                         1.67986763136631e-06,
                                         2.29813118781267e-09,
                                         2.29813118781267e-09,
                                         1.67986763136631e-06,
                                         5.56921286396261e-05,
                                         0.000575849991608478,
                                         0.00316716764054091,
                                         0.0115901827462374,
                                         0.0316387215671883,
                                         0.068778481890789,
                                         0.123915694985664,
                                         0.189720898616707,
                                         0.250674779575387,
                                         0.288259676939709,
                                         0.289287864506998,
                                         0.252691021865712,
                                         0.190447895461017,
                                         0.121813371393712,
                                         0.0642834640753651,
                                         0.026685975584653,
                                         0.00800692150553194,
                                         0.00146921662217128,
                                         0.000110537604932635,
                                         8.03298440532971e-07,
                                         3.94479064559854e-12,
                                         1.53176211514553e-08,
                                         1.26663957333765e-06,
                                         2.48487421244018e-05,
                                         0.000225533089426753,
                                         0.00125381235771946,
                                         0.00493053606982463,
                                         0.0149032245058435,
                                         0.0364597824261607,
                                         0.0746537075102096,
                                         0.130794245901368,
                                         0.198887917221197,
                                         0.26466499735517,
                                         0.309175133330406,
                                         0.316410597225363,
                                         0.281398805930724,
                                         0.213923999854287,
                                         0.134910691266675,
                                         0.0667994716644946,
                                         0.0232556830086233,
                                         0.00436411603251342,
                                         0.000168472989179581,
                                         3.76184240485053e-15,
                                         7.75952400317919e-11,
                                         1.60044141877712e-08,
                                         5.95699105827039e-07,
                                         8.92230328295762e-06,
                                         7.53533046405333e-05,
                                         0.000426871194038755,
                                         0.00179405352893373,
                                         0.00595976757834684,
                                         0.0163198094489064,
                                         0.0379135219432858,
                                         0.0762360522300465,
                                         0.134521064807784,
                                         0.210158420975289,
                                         0.292047409240671,
                                         0.361141196174155,
                                         0.395500688257218,
                                         0.378910941032084,
                                         0.309605009419575,
                                         0.204503083115557,
                                         0.0957216161707918,
                                         0.0196295857256514,
                                         1.53744805132756e-18,
                                         1.68462038852163e-13,
                                         8.66661943997631e-11,
                                         6.12029987973848e-09,
                                         1.51274911890031e-07,
                                         1.94086476176554e-06,
                                         1.58388181371484e-05,
                                         9.25579579894907e-05,
                                         0.000417510871561184,
                                         0.00152898069154182,
                                         0.00471002091732903,
                                         0.0125237852716783,
                                         0.0293026770626826,
                                         0.0612226679668602,
                                         0.115525780189393,
                                         0.19863465885222,
                                         0.313370558539771,
                                         0.456090617808426,
                                         0.61498729685726,
                                         0.770715042394355,
                                         0.899802034928746,
                                         0.980201135684649,

                                         0.981835687264961,
                                         0.907767375406583,
                                         0.787712134983158,
                                         0.640676541012468,
                                         0.487463956671044,
                                         0.34603675197343,
                                         0.228382563918332,
                                         0.139516260811256,
                                         0.0784425962852767,
                                         0.0403037873154724,
                                         0.0187537633445454,
                                         0.0078125,
                                         0.00287093293064401,
                                         0.000912797088858873,
                                         0.000244679857962669,
                                         5.33646853206015e-05,
                                         9.00315366196295e-06,
                                         1.0899226619756e-06,
                                         8.40952832111374e-08,
                                         3.37474029268917e-09,
                                         4.74925265387767e-11,
                                         9.19221477333445e-14,
                                         8.36928536797698e-19,
                                         0.0180219208015663,
                                         0.0884520077048747,
                                         0.191206387220227,
                                         0.294515739971171,
                                         0.368869954274127,
                                         0.396514736040439,
                                         0.375473941062165,
                                         0.317341615918227,
                                         0.240800069587592,
                                         0.16422828354244,
                                         0.100403432252597,
                                         0.0546875,
                                         0.0262759846154603,
                                         0.0109766099234674,
                                         0.00390561698822856,
                                         0.00114960285102881,
                                         0.000268332876129319,
                                         4.66073765109113e-05,
                                         5.44548974999852e-06,
                                         3.59721792626804e-07,
                                         9.58708315634491e-09,
                                         4.62256597536422e-11,
                                         2.23420074886271e-15,
                                         0.000141770723200571,
                                         0.00369372054007889,
                                         0.0198911764609069,
                                         0.0580231647138582,
                                         0.119626464952611,
                                         0.194724076066543,
                                         0.264557375005152,
                                         0.30935165531861,
                                         0.316799488284471,
                                         0.286796114974627,
                                         0.230373171877843,
                                         0.1640625,
                                         0.103066651282937,
                                         0.0565699025004194,
                                         0.0267180216381245,
                                         0.0106136540123101,
                                         0.00342749100316607,
                                         0.000854155314086654,
                                         0.000151121225582492,
                                         1.64329811059999e-05,
                                         8.29413174286887e-07,
                                         9.96252188408458e-09,
                                         2.5561081468461e-12,
                                         6.19583049199914e-07,
                                         8.56934975387588e-05,
                                         0.00114959810574629,
                                         0.00635070310435903,
                                         0.0215530507450925,
                                         0.0531260426487963,
                                         0.103558902519045,
                                         0.167534924594432,
                                         0.231547357821663,
                                         0.278244167171674,
                                         0.293658610458761,
                                         0.2734375,
                                         0.224597453237212,
                                         0.16196833748304,
                                         0.101542169536682,
                                         0.0544389218088151,
                                         0.0243223904623489,
                                         0.00869654065753194,
                                         0.00232992254650951,
                                         0.000417055120505166,
                                         3.98641822116301e-05,
                                         1.19284208549276e-06,
                                         1.62466472423674e-09,
                                         1.62466472423688e-09,
                                         1.19284208549276e-06,
                                         3.98641822116298e-05,
                                         0.000417055120505166,
                                         0.00232992254650951,
                                         0.00869654065753193,
                                         0.0243223904623489,
                                         0.0544389218088151,
                                         0.101542169536682,
                                         0.16196833748304,
                                         0.224597453237212,
                                         0.2734375,
                                         0.293658610458761,
                                         0.278244167171674,
                                         0.231547357821663,
                                         0.167534924594433,
                                         0.103558902519045,
                                         0.0531260426487964,
                                         0.0215530507450925,
                                         0.00635070310435903,
                                         0.00114959810574629,
                                         8.56934975387588e-05,
                                         6.19583049199874e-07,
                                         2.55610814684637e-12,
                                         9.96252188408458e-09,
                                         8.2941317428688e-07,
                                         1.64329811059999e-05,
                                         0.000151121225582492,
                                         0.000854155314086653,
                                         0.00342749100316607,
                                         0.0106136540123101,
                                         0.0267180216381245,
                                         0.0565699025004194,
                                         0.103066651282937,
                                         0.1640625,
                                         0.230373171877843,
                                         0.286796114974627,
                                         0.316799488284471,
                                         0.30935165531861,
                                         0.264557375005152,
                                         0.194724076066544,
                                         0.119626464952611,
                                         0.0580231647138582,
                                         0.0198911764609069,
                                         0.00369372054007889,
                                         0.000141770723200565,
                                         2.23420074886299e-15,
                                         4.62256597536422e-11,
                                         9.58708315634482e-09,
                                         3.59721792626804e-07,
                                         5.44548974999852e-06,
                                         4.66073765109112e-05,
                                         0.000268332876129319,
                                         0.0011496028510288,
                                         0.00390561698822856,
                                         0.0109766099234674,
                                         0.0262759846154603,
                                         0.0546875,
                                         0.100403432252597,
                                         0.16422828354244,
                                         0.240800069587592,
                                         0.317341615918227,
                                         0.375473941062165,
                                         0.396514736040439,
                                         0.368869954274127,
                                         0.294515739971171,
                                         0.191206387220227,
                                         0.0884520077048747,
                                         0.0180219208015659,
                                         8.36928536797822e-19,
                                         9.19221477333445e-14,
                                         4.74925265387761e-11,
                                         3.37474029268917e-09,
                                         8.40952832111374e-08,
                                         1.0899226619756e-06,
                                         9.00315366196297e-06,
                                         5.33646853206014e-05,
                                         0.000244679857962669,
                                         0.000912797088858873,
                                         0.00287093293064401,
                                         0.0078125,
                                         0.0187537633445454,
                                         0.0403037873154724,
                                         0.0784425962852767,
                                         0.139516260811256,
                                         0.228382563918332,
                                         0.34603675197343,
                                         0.487463956671044,
                                         0.640676541012468,
                                         0.787712134983158,
                                         0.907767375406583,
                                         0.981835687264961,

                                         0.983276388416166,
                                         0.914833111934895,
                                         0.802965872469459,
                                         0.664127658385973,
                                         0.516764966577533,
                                         0.377443319770002,
                                         0.258025861325193,
                                         0.164482092846195,
                                         0.0973186995710779,
                                         0.0531335663444866,
                                         0.0265751520607697,
                                         0.0120654625515744,
                                         0.00491514327527196,
                                         0.00177003954205364,
                                         0.000552630194915283,
                                         0.000145751805888448,
                                         3.13366423072629e-05,
                                         5.22131312141857e-06,
                                         6.25390102499986e-07,
                                         4.78259961244181e-08,
                                         1.90556076317127e-09,
                                         2.66710298301593e-11,
                                         5.14280953071714e-14,
                                         4.67263761768589e-19,
                                         0.0166029785300273,
                                         0.0819525681125272,
                                         0.178996312506076,
                                         0.279918248656237,
                                         0.357756023857913,
                                         0.394580293942502,
                                         0.385661682032654,
                                         0.338671491196503,
                                         0.269018763604518,
                                         0.193727230670111,
                                         0.126329099287118,
                                         0.0742893599930842,
                                         0.0391155662037998,
                                         0.0182453167338771,
                                         0.00742692412508311,
                                         0.00258359091737021,
                                         0.000745741863514427,
                                         0.000171171936519054,
                                         2.93132137693409e-05,
                                         3.38505876739845e-06,
                                         2.21533412230133e-07,
                                         5.86258116400465e-09,
                                         2.81303948388905e-11,
                                         1.35596283164817e-15,
                                         0.000120148849579125,
                                         0.00314634596000642,
                                         0.0171007160485293,
                                         0.0505631441752794,
                                         0.1061461047239,
                                         0.176783714699912,
                                         0.247043231953079,
                                         0.298855925715137,
                                         0.31870733766013,
                                         0.302716147935993,
                                         0.25736782707289,
                                         0.196034483359586,
                                         0.133409352085544,
                                         0.0806014881452719,
                                         0.0427766311002428,
                                         0.0196271286195733,
                                         0.00760585079662577,
                                         0.00240496413480119,
                                         0.000588842409643092,
                                         0.000102681360891187,
                                         1.10377076432986e-05,
                                         5.52282352640547e-07,
                                         6.59438699854727e-09,
                                         1.68638481968064e-12,
                                         4.8303736013657e-07,
                                         6.71085532091358e-05,
                                         0.000907636603974112,
                                         0.00507416314339264,
                                         0.0174963985334008,
                                         0.0440024252250925,
                                         0.0879157984217301,
                                         0.146511797906954,
                                         0.209763078145012,
                                         0.262789495611459,
                                         0.29129471614663,
                                         0.287386142433357,
                                         0.252784490097784,
                                         0.197816361011389,
                                         0.136877374017709,
                                         0.0828356496764302,
                                         0.0430957630327638,
                                         0.018772068882903,
                                         0.00657146534897703,
                                         0.00173039206159768,
                                         0.000305524492502017,
                                         2.8904200357546e-05,
                                         8.58816793398183e-07,
                                         1.16518015164528e-09,
                                         1.16518015164538e-09,
                                         8.58816793398183e-07,
                                         2.89042003575462e-05,
                                         0.000305524492502017,
                                         0.00173039206159768,
                                         0.00657146534897704,
                                         0.018772068882903,
                                         0.0430957630327638,
                                         0.0828356496764302,
                                         0.136877374017709,
                                         0.197816361011389,
                                         0.252784490097783,
                                         0.287386142433357,
                                         0.29129471614663,
                                         0.262789495611459,
                                         0.209763078145012,
                                         0.146511797906954,
                                         0.0879157984217301,
                                         0.0440024252250925,
                                         0.0174963985334007,
                                         0.00507416314339264,
                                         0.000907636603974107,
                                         6.71085532091358e-05,
                                         4.83037360136536e-07,
                                         1.68638481968083e-12,
                                         6.59438699854727e-09,
                                         5.52282352640552e-07,
                                         1.10377076432986e-05,
                                         0.000102681360891187,
                                         0.000588842409643094,
                                         0.00240496413480119,
                                         0.00760585079662578,
                                         0.0196271286195733,
                                         0.0427766311002428,
                                         0.0806014881452719,
                                         0.133409352085543,
                                         0.196034483359586,
                                         0.25736782707289,
                                         0.302716147935993,
                                         0.31870733766013,
                                         0.298855925715137,
                                         0.247043231953079,
                                         0.176783714699912,
                                         0.1061461047239,
                                         0.0505631441752794,
                                         0.0171007160485292,
                                         0.00314634596000642,
                                         0.00012014884957912,
                                         1.35596283164835e-15,
                                         2.81303948388905e-11,
                                         5.86258116400471e-09,
                                         2.21533412230133e-07,
                                         3.38505876739845e-06,
                                         2.93132137693409e-05,
                                         0.000171171936519054,
                                         0.000745741863514428,
                                         0.00258359091737021,
                                         0.00742692412508311,
                                         0.0182453167338771,
                                         0.0391155662037998,
                                         0.0742893599930842,
                                         0.126329099287118,
                                         0.193727230670111,
                                         0.269018763604518,
                                         0.338671491196503,
                                         0.385661682032654,
                                         0.394580293942502,
                                         0.357756023857913,
                                         0.279918248656237,
                                         0.178996312506076,
                                         0.0819525681125272,
                                         0.0166029785300269,
                                         4.67263761768665e-19,
                                         5.14280953071714e-14,
                                         2.66710298301596e-11,
                                         1.90556076317127e-09,
                                         4.78259961244181e-08,
                                         6.25390102499987e-07,
                                         5.22131312141857e-06,
                                         3.1336642307263e-05,
                                         0.000145751805888448,
                                         0.000552630194915283,
                                         0.00177003954205364,
                                         0.00491514327527195,
                                         0.0120654625515744,
                                         0.0265751520607697,
                                         0.0531335663444866,
                                         0.0973186995710779,
                                         0.164482092846195,
                                         0.258025861325193,
                                         0.377443319770002,
                                         0.516764966577533,
                                         0.664127658385973,
                                         0.802965872469459,
                                         0.914833111934895,
                                         0.983276388416166,

                                         0.00390625,
                                         0.03125,
                                         0.109375,
                                         0.21875,
                                         0.2734375,
                                         0.21875,
                                         0.109375,
                                         0.03125,
                                         0.00390625,

                                         0.149687380573964,
                                         3.97745072752434e-06,
                                         0.32086890193539,
                                         0.000118752385597781,
                                         0.300917971024471,
                                         0.00155116477799825,
                                         0.161261454648038,
                                         0.0115780515248016,
                                         0.0540123456790123,
                                         0.0540123456790123,
                                         0.0115780515248016,
                                         0.161261454648038,
                                         0.00155116477799825,
                                         0.300917971024471,
                                         0.000118752385597781,
                                         0.32086890193539,
                                         3.97745072752434e-06,
                                         0.149687380573964,

                                         0.384199973971887,
                                         0.00390625,
                                         2.60281121224955e-08,
                                         0.390398360648854,
                                         0.03125,
                                         1.63935114618901e-06,
                                         0.173554826955047,
                                         0.109375,
                                         4.51730449538622e-05,
                                         0.0440887067387617,
                                         0.21875,
                                         0.000711293261238472,
                                         0.00700000000000005,
                                         0.2734375,
                                         0.00700000000000005,
                                         0.000711293261238471,
                                         0.21875,
                                         0.0440887067387617,
                                         4.51730449538622e-05,
                                         0.109375,
                                         0.173554826955047,
                                         1.63935114618901e-06,
                                         0.03125,
                                         0.390398360648854,
                                         2.60281121224955e-08,
                                         0.00390625,
                                         0.384199973971887,

                                         0.562322543291604,
                                         0.0406021724085881,
                                         0.000140673180788785,
                                         5.40094316100545e-10,
                                         0.335649493049349,
                                         0.159991537728688,
                                         0.00228477553580074,
                                         5.7909401941954e-08,
                                         0.0876525497574884,
                                         0.275818131124848,
                                         0.0162350574475442,
                                         2.71648061425736e-06,
                                         0.013079919274785,
                                         0.271713090176816,
                                         0.0659213466818577,
                                         7.28158782036092e-05,
                                         0.00121990381845877,
                                         0.167293215715069,
                                         0.167293215715069,
                                         0.00121990381845877,
                                         7.28158782036089e-05,
                                         0.0659213466818577,
                                         0.271713090176816,
                                         0.013079919274785,
                                         2.71648061425735e-06,
                                         0.0162350574475442,
                                         0.275818131124848,
                                         0.0876525497574885,
                                         5.79094019419536e-08,
                                         0.00228477553580074,
                                         0.159991537728688,
                                         0.335649493049349,
                                         5.40094316100541e-10,
                                         0.000140673180788785,
                                         0.0406021724085881,
                                         0.562322543291604,

                                         0.680880697126515,
                                         0.12259442822481,
                                         0.00390625,
                                         8.04201197864117e-06,
                                         2.34492614456703e-11,
                                         0.268097816847257,
                                         0.294220187112653,
                                         0.03125,
                                         0.000214458347261367,
                                         3.81142069245898e-09,
                                         0.0461842175427365,
                                         0.308924433958084,
                                         0.109375,
                                         0.00250206882172024,
                                         2.71033306581782e-07,
                                         0.00454627659010641,
                                         0.185350602957548,
                                         0.21875,
                                         0.0166808239550454,
                                         1.10133740826422e-05,
                                         0.00027970365112584,
                                         0.0695049546108987,
                                         0.2734375,
                                         0.0695049546108987,
                                         0.000279703651125842,
                                         1.10133740826421e-05,
                                         0.0166808239550454,
                                         0.21875,
                                         0.185350602957548,
                                         0.00454627659010643,
                                         2.7103330658178e-07,
                                         0.00250206882172024,
                                         0.109375,
                                         0.308924433958084,
                                         0.0461842175427366,
                                         3.81142069245895e-09,
                                         0.000214458347261367,
                                         0.03125,
                                         0.294220187112653,
                                         0.268097816847257,
                                         2.34492614456701e-11,
                                         8.04201197864117e-06,
                                         0.00390625,
                                         0.12259442822481,
                                         0.680880697126515,

                                         0.759733446005233,
                                         0.226545294324976,
                                         0.0216402591801953,
                                         0.000441139010905775,
                                         6.77970800207906e-07,
                                         1.68950322906245e-12,
                                         0.21239214717859,
                                         0.369617074802618,
                                         0.106418362209228,
                                         0.00574118215379526,
                                         2.65946318950958e-05,
                                         3.86778024269846e-10,
                                         0.0259772828008209,
                                         0.263831752925225,
                                         0.228954266579475,
                                         0.0326892716861027,
                                         0.000456409877638838,
                                         3.87384832414507e-08,
                                         0.00181556139885074,
                                         0.107612829750927,
                                         0.281476966926776,
                                         0.106358233224189,
                                         0.00447587590990954,
                                         2.21710052896043e-06,
                                         7.93063890253343e-05,
                                         0.0274334898060111,
                                         0.216280319029333,
                                         0.216280319029333,
                                         0.0274334898060111,
                                         7.93063890253343e-05,
                                         2.21710052896043e-06,
                                         0.00447587590990955,
                                         0.106358233224189,
                                         0.281476966926776,
                                         0.107612829750926,
                                         0.00181556139885074,
                                         3.87384832414507e-08,
                                         0.000456409877638839,
                                         0.0326892716861027,
                                         0.228954266579475,
                                         0.263831752925225,
                                         0.0259772828008209,
                                         3.86778024269846e-10,
                                         2.65946318950959e-05,
                                         0.00574118215379526,
                                         0.106418362209228,
                                         0.369617074802618,
                                         0.21239214717859,
                                         1.68950322906245e-12,
                                         6.77970800207907e-07,
                                         0.000441139010905775,
                                         0.0216402591801953,
                                         0.226545294324976,
                                         0.759733446005233,

                                         0.813667764445078,
                                         0.330529389064834,
                                         0.0596018765816454,
                                         0.00390625,
                                         6.06676537012991e-05,
                                         7.7808177043123e-08,
                                         1.75777048152068e-13,
                                         0.169961861751363,
                                         0.392443339620086,
                                         0.201517180883226,
                                         0.03125,
                                         0.00114837843365764,
                                         4.19409566696012e-06,
                                         5.38564560634911e-11,
                                         0.0155322333317329,
                                         0.203855250726603,
                                         0.29808648196301,
                                         0.109375,
                                         0.00951022767593871,
                                         9.89075585663159e-05,
                                         7.21923924066092e-09,
                                         0.00081110725088707,
                                         0.0605102284705957,
                                         0.251961645126635,
                                         0.21875,
                                         0.0450047912516688,
                                         0.00133285400897737,
                                         5.5297697433189e-07,
                                         2.64729706922393e-05,
                                         0.0112257586464937,
                                         0.133108750430518,
                                         0.2734375,
                                         0.133108750430518,
                                         0.0112257586464937,
                                         2.64729706922396e-05,
                                         5.52976974331884e-07,
                                         0.00133285400897737,
                                         0.0450047912516688,
                                         0.21875,
                                         0.251961645126635,
                                         0.0605102284705957,
                                         0.000811107250887075,
                                         7.21923924066082e-09,
                                         9.89075585663159e-05,
                                         0.00951022767593871,
                                         0.109375,
                                         0.29808648196301,
                                         0.203855250726603,
                                         0.0155322333317329,
                                         5.38564560634903e-11,
                                         4.19409566696012e-06,
                                         0.00114837843365764,
                                         0.03125,
                                         0.201517180883226,
                                         0.392443339620086,
                                         0.169961861751364,
                                         1.75777048152065e-13,
                                         7.7808177043123e-08,
                                         6.06676537012991e-05,
                                         0.00390625,
                                         0.0596018765816454,
                                         0.330529389064834,
                                         0.813667764445078,

                                         0.851770071021287,
                                         0.424130742155003,
                                         0.114585995970256,
                                         0.0150284523953017,
                                         0.000772125053069863,
                                         1.00325758238975e-05,
                                         1.14138434296086e-08,
                                         2.41530336638006e-14,
                                         0.13803636901654,
                                         0.384000030829074,
                                         0.285106188564433,
                                         0.0829565954028709,
                                         0.00895222436508324,
                                         0.00025805799838256,
                                         8.06826915998154e-07,
                                         9.53850935176882e-12,
                                         0.00978684555966569,
                                         0.152104065908508,
                                         0.310355754255881,
                                         0.200339062610788,
                                         0.0454100865323796,
                                         0.00290402436203193,
                                         2.49520885249798e-05,
                                         1.64803864144351e-09,
                                         0.000396509771575473,
                                         0.034428043167376,
                                         0.193052269270981,
                                         0.276466367315195,
                                         0.131624171971701,
                                         0.0186743346692449,
                                         0.000440956123948967,
                                         1.62710740732389e-07,
                                         1.00402625899951e-05,
                                         0.00487039148680477,
                                         0.0750533423329648,
                                         0.238450914353611,
                                         0.238450914353611,
                                         0.0750533423329648,
                                         0.00487039148680477,
                                         1.00402625899951e-05,
                                         1.62710740732389e-07,
                                         0.000440956123948967,
                                         0.0186743346692449,
                                         0.131624171971701,
                                         0.276466367315195,
                                         0.193052269270981,
                                         0.034428043167376,
                                         0.000396509771575473,
                                         1.64803864144351e-09,
                                         2.49520885249798e-05,
                                         0.00290402436203193,
                                         0.0454100865323796,
                                         0.200339062610788,
                                         0.310355754255881,
                                         0.152104065908508,
                                         0.00978684555966569,
                                         9.53850935176882e-12,
                                         8.06826915998154e-07,
                                         0.00025805799838256,
                                         0.00895222436508325,
                                         0.0829565954028709,
                                         0.285106188564433,
                                         0.384000030829074,
                                         0.13803636901654,
                                         2.41530336638006e-14,
                                         1.14138434296086e-08,
                                         1.00325758238975e-05,
                                         0.000772125053069864,
                                         0.0150284523953017,
                                         0.114585995970256,
                                         0.424130742155003,
                                         0.851770071021287,

                                         0.879515842541613,
                                         0.504429311917423,
                                         0.179322562850851,
                                         0.0369427200868735,
                                         0.00390625,
                                         0.00016983643624042,
                                         1.95034551386569e-06,
                                         2.0410410752885e-09,
                                         4.12589690786632e-15,
                                         0.11382639772371,
                                         0.36038916934264,
                                         0.343783082577237,
                                         0.150810509152786,
                                         0.03125,
                                         0.00266261335121172,
                                         6.51091409607065e-05,
                                         1.82835407104989e-07,
                                         2.0403234498739e-12,
                                         0.00644496219854924,
                                         0.112647408191901,
                                         0.288344799558302,
                                         0.269347159809281,
                                         0.109375,
                                         0.0182626333403897,
                                         0.000950934124412902,
                                         7.16550690331077e-06,
                                         4.41425814669216e-10,
                                         0.000208525757877873,
                                         0.0201202155127369,
                                         0.138197980306189,
                                         0.274887597706482,
                                         0.21875,
                                         0.0715781790362857,
                                         0.00793635070178253,
                                         0.000160470603414393,
                                         5.45730698779783e-08,
                                         4.21676170850248e-06,
                                         0.00224607404853326,
                                         0.0413972303947519,
                                         0.175338751080449,
                                         0.2734375,
                                         0.175338751080449,
                                         0.0413972303947519,
                                         0.00224607404853326,
                                         4.21676170850254e-06,
                                         5.45730698779773e-08,
                                         0.000160470603414393,
                                         0.00793635070178252,
                                         0.0715781790362857,
                                         0.21875,
                                         0.274887597706482,
                                         0.138197980306189,
                                         0.0201202155127369,
                                         0.000208525757877875,
                                         4.41425814669207e-10,
                                         7.16550690331077e-06,
                                         0.0009509341244129,
                                         0.0182626333403897,
                                         0.109375,
                                         0.269347159809281,
                                         0.288344799558302,
                                         0.112647408191901,
                                         0.00644496219854928,
                                         2.04032344987385e-12,
                                         1.82835407104989e-07,
                                         6.51091409607064e-05,
                                         0.00266261335121172,
                                         0.03125,
                                         0.150810509152786,
                                         0.343783082577237,
                                         0.36038916934264,
                                         0.113826397723711,
                                         4.12589690786621e-15,
                                         2.0410410752885e-09,
                                         1.95034551386569e-06,
                                         0.00016983643624042,
                                         0.00390625,
                                         0.0369427200868735,
                                         0.179322562850851,
                                         0.504429311917423,
                                         0.879515842541613,

                                         0.900269842293711,
                                         0.57188508386752,
                                         0.24717982498596,
                                         0.0696126347822499,
                                         0.0118560567266512,
                                         0.00107574543179176,
                                         4.14954844234534e-05,
                                         4.35877534033639e-07,
                                         4.29337671551831e-10,
                                         8.394888408492e-16,
                                         0.0952067997845387,
                                         0.33100536629966,
                                         0.377482602437625,
                                         0.220136549376214,
                                         0.0702669998007756,
                                         0.0116165814611536,
                                         0.000839801662513245,
                                         1.82667186260992e-05,
                                         4.74736589169372e-08,
                                         5.08042022590994e-13,
                                         0.00440495311069968,
                                         0.0838183982749969,
                                         0.252208034691503,
                                         0.30456100359866,
                                         0.18219674352879,
                                         0.0548814063014413,
                                         0.00743585099546659,
                                         0.000334915039658724,
                                         2.29659529696477e-06,
                                         1.34512425084828e-10,
                                         0.000116459940444679,
                                         0.0121284591984975,
                                         0.0962903680513115,
                                         0.240778878060299,
                                         0.269955239680595,
                                         0.148161058407073,
                                         0.0376224070821072,
                                         0.00350889774960427,
                                         6.34860326862705e-05,
                                         2.03510639982383e-08,
                                         1.92438452060843e-06,
                                         0.00109686182834678,
                                         0.0229766544481776,
                                         0.118971378958066,
                                         0.249990168661728,
                                         0.249990168661728,
                                         0.118971378958066,
                                         0.0229766544481776,
                                         0.00109686182834678,
                                         1.92438452060843e-06,
                                         2.03510639982383e-08,
                                         6.34860326862708e-05,
                                         0.00350889774960427,
                                         0.0376224070821072,
                                         0.148161058407073,
                                         0.269955239680595,
                                         0.240778878060299,
                                         0.0962903680513115,
                                         0.0121284591984975,
                                         0.000116459940444679,
                                         1.34512425084828e-10,
                                         2.29659529696478e-06,
                                         0.000334915039658724,
                                         0.00743585099546659,
                                         0.0548814063014413,
                                         0.18219674352879,
                                         0.304561003598661,
                                         0.252208034691503,
                                         0.0838183982749968,
                                         0.00440495311069968,
                                         5.08042022590994e-13,
                                         4.74736589169375e-08,
                                         1.82667186260992e-05,
                                         0.000839801662513245,
                                         0.0116165814611536,
                                         0.0702669998007756,
                                         0.220136549376214,
                                         0.377482602437625,
                                         0.33100536629966,
                                         0.0952067997845387,
                                         8.394888408492e-16,
                                         4.29337671551834e-10,
                                         4.35877534033639e-07,
                                         4.14954844234534e-05,
                                         0.00107574543179176,
                                         0.0118560567266512,
                                         0.0696126347822499,
                                         0.24717982498596,
                                         0.57188508386752,
                                         0.900269842293711,

                                         0.916161310284861,
                                         0.628131384149106,
                                         0.313641930864063,
                                         0.110775084917633,
                                         0.0263596587228344,
                                         0.00390625,
                                         0.000316604100475664,
                                         1.11744515402315e-05,
                                         1.098281306717e-07,
                                         1.03386140903071e-10,
                                         1.97170352066983e-16,
                                         0.0806623076556215,
                                         0.300740528856164,
                                         0.391344324609069,
                                         0.280546654553846,
                                         0.121332421229342,
                                         0.03125,
                                         0.00440209517844266,
                                         0.000282386017027088,
                                         5.63337477321096e-06,
                                         1.38197705583398e-08,
                                         1.43325310350592e-13,
                                         0.00310704393859348,
                                         0.062995783590566,
                                         0.213629890754853,
                                         0.31084662340766,
                                         0.244338555776599,
                                         0.109375,
                                         0.0267781382009658,
                                         0.00312203822866213,
                                         0.000126415915707075,
                                         8.08197305459863e-07,
                                         4.55808297882444e-11,
                                         6.83889756260379e-05,
                                         0.00754037521083249,
                                         0.0666387662863243,
                                         0.196810908204723,
                                         0.281170072076598,
                                         0.21875,
                                         0.0930814800606188,
                                         0.0197240092102977,
                                         0.00162105151503799,
                                         2.70082170341266e-05,
                                         8.28330236639516e-09,
                                         9.40816270950463e-07,
                                         0.000564097855835028,
                                         0.0129918768520413,
                                         0.0778811210086107,
                                         0.202220974654123,
                                         0.2734375,
                                         0.202220974654123,
                                         0.0778811210086106,
                                         0.0129918768520413,
                                         0.000564097855835028,
                                         9.40816270950482e-07,
                                         8.28330236639495e-09,
                                         2.70082170341266e-05,
                                         0.00162105151503799,
                                         0.0197240092102978,
                                         0.0930814800606187,
                                         0.21875,
                                         0.281170072076598,
                                         0.196810908204723,
                                         0.0666387662863242,
                                         0.00754037521083249,
                                         6.8388975626039e-05,
                                         4.5580829788243e-11,
                                         8.08197305459863e-07,
                                         0.000126415915707075,
                                         0.00312203822866214,
                                         0.0267781382009658,
                                         0.109375,
                                         0.244338555776599,
                                         0.31084662340766,
                                         0.213629890754853,
                                         0.062995783590566,
                                         0.00310704393859351,
                                         1.43325310350587e-13,
                                         1.38197705583398e-08,
                                         5.63337477321097e-06,
                                         0.000282386017027089,
                                         0.00440209517844266,
                                         0.03125,
                                         0.121332421229342,
                                         0.280546654553846,
                                         0.391344324609069,
                                         0.300740528856164,
                                         0.0806623076556219,
                                         1.97170352066975e-16,
                                         1.03386140903071e-10,
                                         1.098281306717e-07,
                                         1.11744515402315e-05,
                                         0.000316604100475664,
                                         0.00390625,
                                         0.0263596587228344,
                                         0.110775084917633,
                                         0.313641930864063,
                                         0.628131384149106,
                                         0.916161310284861,

                                         0.928579223511302,
                                         0.675008972996041,
                                         0.376144848450611,
                                         0.157424188646157,
                                         0.0478653060038374,
                                         0.0100392432855156,
                                         0.00133936066997764,
                                         9.96375074566032e-05,
                                         3.28612918475526e-06,
                                         3.0693937556711e-08,
                                         2.79051046593466e-11,
                                         5.22068951199069e-17,
                                         0.0691269765347617,
                                         0.27192322148806,
                                         0.391207607089348,
                                         0.327425950370293,
                                         0.176974656709406,
                                         0.0624367855669128,
                                         0.0137828160020664,
                                         0.00172469613357614,
                                         0.000101116719939689,
                                         1.88877578556652e-06,
                                         4.43329753082488e-09,
                                         4.48827273519201e-14,
                                         0.00225140807502781,
                                         0.0479248877975795,
                                         0.178007180499224,
                                         0.2979427261485,
                                         0.286272331315905,
                                         0.169886219056916,
                                         0.0620520926716624,
                                         0.0130611188771435,
                                         0.00136125463530851,
                                         5.08494505854318e-05,
                                         3.08140057744875e-07,
                                         1.68814081806632e-11,
                                         4.19008494999797e-05,
                                         0.00482656172018327,
                                         0.0462838740279641,
                                         0.154922475866084,
                                         0.264612053017961,
                                         0.264142155149632,
                                         0.159638213030955,
                                         0.0565210376157768,
                                         0.0104717127649491,
                                         0.000782265315403673,
                                         1.22385901596237e-05,
                                         3.62827380822475e-09,
                                         4.87384208657471e-07,
                                         0.000303804806715623,
                                         0.00752145569714038,
                                         0.0503472887195836,
                                         0.152869162818937,
                                         0.256683114566362,
                                         0.256683114566362,
                                         0.152869162818937,
                                         0.0503472887195837,
                                         0.0075214556971404,
                                         0.000303804806715624,
                                         4.87384208657459e-07,
                                         3.62827380822486e-09,
                                         1.22385901596236e-05,
                                         0.000782265315403671,
                                         0.0104717127649491,
                                         0.0565210376157768,
                                         0.159638213030955,
                                         0.264142155149632,
                                         0.264612053017962,
                                         0.154922475866084,
                                         0.0462838740279642,
                                         0.00482656172018328,
                                         4.1900849499979e-05,
                                         1.68814081806638e-11,
                                         3.08140057744873e-07,
                                         5.08494505854316e-05,
                                         0.00136125463530851,
                                         0.0130611188771435,
                                         0.0620520926716624,
                                         0.169886219056916,
                                         0.286272331315905,
                                         0.2979427261485,
                                         0.178007180499224,
                                         0.0479248877975796,
                                         0.00225140807502779,
                                         4.4882727351922e-14,
                                         4.43329753082484e-09,
                                         1.88877578556651e-06,
                                         0.000101116719939689,
                                         0.00172469613357614,
                                         0.0137828160020664,
                                         0.0624367855669128,
                                         0.176974656709406,
                                         0.327425950370293,
                                         0.391207607089348,
                                         0.271923221488061,
                                         0.0691269765347612,
                                         5.22068951199094e-17,
                                         2.79051046593464e-11,
                                         3.06939375567109e-08,
                                         3.28612918475525e-06,
                                         9.96375074566031e-05,
                                         0.00133936066997764,
                                         0.0100392432855156,
                                         0.0478653060038374,
                                         0.157424188646157,
                                         0.376144848450611,
                                         0.675008972996041,
                                         0.928579223511302,

                                         0.938456022163199,
                                         0.714202395567706,
                                         0.433495674279375,
                                         0.206768489861003,
                                         0.0756990873722987,
                                         0.0205255725691051,
                                         0.00390625,
                                         0.000480415742152006,
                                         3.34325756381077e-05,
                                         1.04576062724161e-06,
                                         9.38592389337705e-09,
                                         8.30319473562006e-12,
                                         1.53017440105916e-17,
                                         0.0598473311875837,
                                         0.245521359206014,
                                         0.381954198008051,
                                         0.360220010229547,
                                         0.230576758611325,
                                         0.102695286632628,
                                         0.03125,
                                         0.00614528421061833,
                                         0.000702465377219034,
                                         3.84174719023393e-05,
                                         6.81758376787761e-07,
                                         1.54581394374093e-09,
                                         1.53564221830562e-14,
                                         0.00166975867540801,
                                         0.0369262592266623,
                                         0.147236628619399,
                                         0.274555008054849,
                                         0.307268806171007,
                                         0.224793525939879,
                                         0.109375,
                                         0.0343909976051121,
                                         0.00645740564668597,
                                         0.000617452189968414,
                                         2.16651646870492e-05,
                                         1.25906245827965e-07,
                                         6.74244188565703e-12,
                                         2.6621013156306e-05,
                                         0.00317353505532462,
                                         0.0324326468166142,
                                         0.119578432715467,
                                         0.233982495062447,
                                         0.281176511664073,
                                         0.21875,
                                         0.109978939086908,
                                         0.0339197908542616,
                                         0.0056707413583063,
                                         0.000393419115626554,
                                         5.86002245527266e-06,
                                         1.69163371294806e-09,
                                         2.65262262110664e-07,
                                         0.000170463461475241,
                                         0.00446507685194582,
                                         0.0325504023583294,
                                         0.111359758329118,
                                         0.219813466549525,
                                         0.2734375,
                                         0.219813466549525,
                                         0.111359758329118,
                                         0.0325504023583294,
                                         0.00446507685194582,
                                         0.00017046346147524,
                                         2.65262262110657e-07,
                                         1.69163371294812e-09,
                                         5.8600224552727e-06,
                                         0.000393419115626553,
                                         0.00567074135830631,
                                         0.0339197908542616,
                                         0.109978939086908,
                                         0.21875,
                                         0.281176511664073,
                                         0.233982495062447,
                                         0.119578432715467,
                                         0.0324326468166143,
                                         0.00317353505532461,
                                         2.66210131563054e-05,
                                         6.74244188565731e-12,
                                         1.25906245827966e-07,
                                         2.16651646870491e-05,
                                         0.000617452189968415,
                                         0.00645740564668597,
                                         0.0343909976051121,
                                         0.109375,
                                         0.224793525939879,
                                         0.307268806171007,
                                         0.274555008054848,
                                         0.1472366286194,
                                         0.0369262592266621,
                                         0.00166975867540799,
                                         1.5356422183057e-14,
                                         1.54581394374094e-09,
                                         6.81758376787758e-07,
                                         3.84174719023394e-05,
                                         0.000702465377219034,
                                         0.00614528421061833,
                                         0.03125,
                                         0.102695286632628,
                                         0.230576758611325,
                                         0.360220010229547,
                                         0.381954198008051,
                                         0.245521359206014,
                                         0.0598473311875833,
                                         1.53017440105924e-17,
                                         8.30319473562015e-12,
                                         9.385923893377e-09,
                                         1.04576062724162e-06,
                                         3.34325756381077e-05,
                                         0.000480415742152006,
                                         0.00390625,
                                         0.0205255725691051,
                                         0.0756990873722987,
                                         0.206768489861003,
                                         0.433495674279375,
                                         0.714202395567706,
                                         0.938456022163199,

                                         0.94643426275367,
                                         0.747136348849164,
                                         0.485345746375922,
                                         0.25661608614036,
                                         0.108550355329033,
                                         0.035810829063663,
                                         0.008876676978496,
                                         0.00156482161674821,
                                         0.000180452787012712,
                                         1.19100161484532e-05,
                                         3.57159262200858e-07,
                                         3.10515653659882e-09,
                                         2.687639947298e-12,
                                         4.89359816106433e-18,
                                         0.0522844654806429,
                                         0.221812621945459,
                                         0.367193723071683,
                                         0.380470613711269,
                                         0.277815437054743,
                                         0.147876109069939,
                                         0.0571632886049885,
                                         0.0155517054219356,
                                         0.00279679045402743,
                                         0.000297829148409053,
                                         1.5417169569149e-05,
                                         2.62675429941451e-07,
                                         5.79381564027068e-10,
                                         5.66925589107604e-15,
                                         0.00126366788397565,
                                         0.0288104938367954,
                                         0.121539466824707,
                                         0.246795034979453,
                                         0.311071021960145,
                                         0.267152788412702,
                                         0.161050490828185,
                                         0.0676190808506004,
                                         0.0189641909985836,
                                         0.00325836780863157,
                                         0.0002911557949692,
                                         9.72150406855002e-06,
                                         5.46432237766702e-08,
                                         2.87343827977604e-12,
                                         1.74524006734735e-05,
                                         0.00213834167863958,
                                         0.0229880088868362,
                                         0.0914773697859371,
                                         0.199032816748895,
                                         0.27579307649806,
                                         0.259279900279373,
                                         0.168005096401316,
                                         0.0734802565690704,
                                         0.0203701845898472,
                                         0.00314201445765401,
                                         0.000205593520872943,
                                         2.94489562181094e-06,
                                         8.32222853159274e-10,
                                         1.50645935697317e-07,
                                         9.91935690279492e-05,
                                         0.0027174740353242,
                                         0.0211919508015269,
                                         0.0795920773441467,
                                         0.177945506146943,
                                         0.260888939018358,
                                         0.260888939018358,
                                         0.177945506146943,
                                         0.0795920773441467,
                                         0.0211919508015269,
                                         0.0027174740353242,
                                         9.91935690279486e-05,
                                         1.50645935697317e-07,
                                         8.32222853159274e-10,
                                         2.94489562181096e-06,
                                         0.000205593520872943,
                                         0.003142014457654,
                                         0.0203701845898472,
                                         0.0734802565690704,
                                         0.168005096401316,
                                         0.259279900279373,
                                         0.27579307649806,
                                         0.199032816748896,
                                         0.0914773697859372,
                                         0.0229880088868362,
                                         0.00213834167863957,
                                         1.74524006734735e-05,
                                         2.87343827977604e-12,
                                         5.46432237766707e-08,
                                         9.72150406855002e-06,
                                         0.000291155794969199,
                                         0.00325836780863156,
                                         0.0189641909985836,
                                         0.0676190808506003,
                                         0.161050490828185,
                                         0.267152788412702,
                                         0.311071021960146,
                                         0.246795034979453,
                                         0.121539466824707,
                                         0.0288104938367953,
                                         0.00126366788397565,
                                         5.66925589107604e-15,
                                         5.79381564027075e-10,
                                         2.62675429941451e-07,
                                         1.5417169569149e-05,
                                         0.000297829148409052,
                                         0.00279679045402743,
                                         0.0155517054219356,
                                         0.0571632886049885,
                                         0.147876109069939,
                                         0.277815437054743,
                                         0.380470613711269,
                                         0.367193723071683,
                                         0.221812621945459,
                                         0.0522844654806429,
                                         4.89359816106433e-18,
                                         2.68763994729803e-12,
                                         3.10515653659882e-09,
                                         3.57159262200857e-07,
                                         1.19100161484531e-05,
                                         0.000180452787012712,
                                         0.00156482161674821,
                                         0.008876676978496,
                                         0.035810829063663,
                                         0.108550355329033,
                                         0.25661608614036,
                                         0.485345746375922,
                                         0.747136348849164,
                                         0.94643426275367,

                                         0.952967301317703,
                                         0.774974377608438,
                                         0.531819353588785,
                                         0.3054216882714,
                                         0.144913208634263,
                                         0.0557492997051097,
                                         0.0169303345614497,
                                         0.00390625,
                                         0.000647575146034186,
                                         7.0904403443984e-05,
                                         4.48377417677146e-06,
                                         1.29948180410215e-07,
                                         1.10099038086552e-09,
                                         9.36212507421273e-13,
                                         1.68801220711213e-18,
                                         0.0460474074984276,
                                         0.200741986647579,
                                         0.349427071256235,
                                         0.390479871390557,
                                         0.316602929802121,
                                         0.193813322770219,
                                         0.0900707141726205,
                                         0.03125,
                                         0.00779026229015681,
                                         0.00130529588996632,
                                         0.000131345968913884,
                                         6.5050613760708e-06,
                                         1.07243526941048e-07,
                                         2.3131486298078e-10,
                                         2.2357764225946e-15,
                                         0.000973442775840815,
                                         0.0227492534408862,
                                         0.10044469765901,
                                         0.218411492764528,
                                         0.302621614313074,
                                         0.294785349293064,
                                         0.209642692879317,
                                         0.109375,
                                         0.041000773080902,
                                         0.0105129062364609,
                                         0.00168332441722738,
                                         0.00014246581003004,
                                         4.5702158196876e-06,
                                         2.50040694474896e-08,
                                         1.29556503410423e-12,
                                         1.17591957545558e-05,
                                         0.00147318752155576,
                                         0.0164990688517443,
                                         0.0698094592492785,
                                         0.16529012540668,
                                         0.256206483097903,
                                         0.278828912095263,
                                         0.21875,
                                         0.123308769011406,
                                         0.0483836427482773,
                                         0.0123276657041819,
                                         0.00178291999801676,
                                         0.000111292085721896,
                                         1.54447116769969e-06,
                                         4.28994788216568e-10,
                                         8.87819809660387e-08,
                                         5.96250740520746e-05,
                                         0.00169383799816597,
                                         0.0139454675066329,
                                         0.0564253019793627,
                                         0.139172795855556,
                                         0.231779966762851,
                                         0.2734375,
                                         0.231779966762851,
                                         0.139172795855556,
                                         0.0564253019793627,
                                         0.0139454675066329,
                                         0.00169383799816598,
                                         5.96250740520746e-05,
                                         8.8781980966042e-08,
                                         4.28994788216548e-10,
                                         1.54447116769969e-06,
                                         0.000111292085721895,
                                         0.00178291999801676,
                                         0.0123276657041819,
                                         0.0483836427482773,
                                         0.123308769011406,
                                         0.21875,
                                         0.278828912095263,
                                         0.256206483097903,
                                         0.16529012540668,
                                         0.0698094592492784,
                                         0.0164990688517443,
                                         0.00147318752155576,
                                         1.17591957545561e-05,
                                         1.29556503410416e-12,
                                         2.50040694474896e-08,
                                         4.57021581968758e-06,
                                         0.00014246581003004,
                                         0.00168332441722738,
                                         0.0105129062364609,
                                         0.041000773080902,
                                         0.109375,
                                         0.209642692879317,
                                         0.294785349293064,
                                         0.302621614313074,
                                         0.218411492764528,
                                         0.10044469765901,
                                         0.0227492534408862,
                                         0.000973442775840833,
                                         2.23577642259445e-15,
                                         2.3131486298078e-10,
                                         1.07243526941048e-07,
                                         6.50506137607082e-06,
                                         0.000131345968913884,
                                         0.00130529588996632,
                                         0.00779026229015681,
                                         0.03125,
                                         0.0900707141726205,
                                         0.193813322770219,
                                         0.316602929802121,
                                         0.390479871390557,
                                         0.349427071256236,
                                         0.200741986647579,
                                         0.0460474074984281,
                                         1.68801220711201e-18,
                                         9.36212507421273e-13,
                                         1.10099038086551e-09,
                                         1.29948180410216e-07,
                                         4.48377417677146e-06,
                                         7.0904403443984e-05,
                                         0.000647575146034186,
                                         0.00390625,
                                         0.0169303345614497,
                                         0.0557492997051097,
                                         0.144913208634263,
                                         0.3054216882714,
                                         0.531819353588785,
                                         0.774974377608438,
                                         0.952967301317703,

                                         0.958381841294348,
                                         0.798652140992959,
                                         0.573279494479795,
                                         0.352190398563234,
                                         0.183367523871216,
                                         0.0797737865498052,
                                         0.0284308373363627,
                                         0.00807444500085405,
                                         0.00175752148131173,
                                         0.000277123561316401,
                                         2.9083507141679e-05,
                                         1.77579297742401e-06,
                                         5.00436569593344e-08,
                                         4.15094980901703e-10,
                                         3.47859767713221e-13,
                                         6.22157701680893e-19,
                                         0.0408482825559487,
                                         0.182107765292965,
                                         0.330315557631623,
                                         0.392589734870213,
                                         0.346474396264484,
                                         0.23723213370546,
                                         0.12749410738381,
                                         0.0533858501168022,
                                         0.0170124606517993,
                                         0.0039550589713849,
                                         0.000625912236653902,
                                         6.01483311323599e-05,
                                         2.87321142448458e-06,
                                         4.61067844372625e-08,
                                         9.76367628220708e-11,
                                         9.34211545989131e-16,
                                         0.000761705486994343,
                                         0.0181667536578693,
                                         0.0832663845306687,
                                         0.191460163288022,
                                         0.286416431985675,
                                         0.308649004481535,
                                         0.250131640903244,
                                         0.154425032825364,
                                         0.0720463001286848,
                                         0.0246950854137472,
                                         0.00589329478601122,
                                         0.000891318430977544,
                                         7.21712434948037e-05,
                                         2.2405789160718e-06,
                                         1.19894869237268e-08,
                                         6.13716834987168e-13,
                                         8.11637898813371e-06,
                                         0.00103559069758117,
                                         0.0119942290379559,
                                         0.0533555819878182,
                                         0.135296532146772,
                                         0.229465921908779,
                                         0.280420076166905,
                                         0.255253198697407,
                                         0.174348487213393,
                                         0.0881109843663233,
                                         0.0317077072479928,
                                         0.00754751775859906,
                                         0.00103591171153335,
                                         6.22182234494792e-05,
                                         8.41297844549318e-07,
                                         2.30384254532216e-10,
                                         5.40527219868804e-08,
                                         3.68959733090542e-05,
                                         0.00107982899571223,
                                         0.00929311508060361,
                                         0.0399443554181672,
                                         0.10662315557662,
                                         0.196485085896906,
                                         0.263696703884384,
                                         0.263696703884384,
                                         0.196485085896906,
                                         0.10662315557662,
                                         0.0399443554181672,
                                         0.00929311508060359,
                                         0.00107982899571224,
                                         3.68959733090542e-05,
                                         5.40527219868781e-08,
                                         2.30384254532228e-10,
                                         8.41297844549318e-07,
                                         6.2218223449479e-05,
                                         0.00103591171153335,
                                         0.00754751775859906,
                                         0.0317077072479928,
                                         0.0881109843663234,
                                         0.174348487213393,
                                         0.255253198697407,
                                         0.280420076166905,
                                         0.229465921908779,
                                         0.135296532146772,
                                         0.0533555819878182,
                                         0.011994229037956,
                                         0.00103559069758117,
                                         8.11637898813346e-06,
                                         6.13716834987206e-13,
                                         1.19894869237268e-08,
                                         2.24057891607179e-06,
                                         7.21712434948039e-05,
                                         0.000891318430977544,
                                         0.00589329478601122,
                                         0.0246950854137472,
                                         0.0720463001286848,
                                         0.154425032825364,
                                         0.250131640903244,
                                         0.308649004481535,
                                         0.286416431985674,
                                         0.191460163288022,
                                         0.0832663845306688,
                                         0.0181667536578693,
                                         0.000761705486994326,
                                         9.34211545989199e-16,
                                         9.76367628220708e-11,
                                         4.61067844372622e-08,
                                         2.87321142448459e-06,
                                         6.01483311323599e-05,
                                         0.000625912236653902,
                                         0.0039550589713849,
                                         0.0170124606517993,
                                         0.0533858501168022,
                                         0.12749410738381,
                                         0.23723213370546,
                                         0.346474396264484,
                                         0.392589734870212,
                                         0.330315557631623,
                                         0.182107765292965,
                                         0.0408482825559482,
                                         6.22157701680946e-19,
                                         3.47859767713221e-13,
                                         4.15094980901701e-10,
                                         5.00436569593346e-08,
                                         1.77579297742401e-06,
                                         2.9083507141679e-05,
                                         0.000277123561316401,
                                         0.00175752148131173,
                                         0.00807444500085404,
                                         0.0284308373363627,
                                         0.0797737865498052,
                                         0.183367523871216,
                                         0.352190398563234,
                                         0.573279494479795,
                                         0.798652140992959,
                                         0.958381841294348,

                                         0.96291782758848,
                                         0.818917795111741,
                                         0.61018955814276,
                                         0.396345524976371,
                                         0.222713778885278,
                                         0.107092918827516,
                                         0.0434109010178495,
                                         0.0145328266905549,
                                         0.00390625,
                                         0.000810377691703877,
                                         0.000122596102984312,
                                         1.24222079130953e-05,
                                         7.36729313693712e-07,
                                         2.02837795961415e-08,
                                         1.65302295490691e-10,
                                         1.36854799750696e-13,
                                         2.43128396178896e-19,
                                         0.0364720371524205,
                                         0.16565622527126,
                                         0.3109256297542,
                                         0.388864512481369,
                                         0.367944386693893,
                                         0.275997721813975,
                                         0.166743349065387,
                                         0.0810461248531386,
                                         0.03125,
                                         0.00930005016774062,
                                         0.00204271096020328,
                                         0.00030848498196629,
                                         2.85399251238108e-05,
                                         1.32313605620432e-06,
                                         2.07619005947242e-08,
                                         4.3298470452541e-11,
                                         4.10813649648833e-16,
                                         0.000604378314506097,
                                         0.0146606515287996,
                                         0.0693148569198388,
                                         0.166917057965824,
                                         0.265947145996121,
                                         0.31119190872014,
                                         0.280205269067622,
                                         0.197739062808478,
                                         0.109375,
                                         0.0466940090139075,
                                         0.0148907039852441,
                                         0.00335156244642387,
                                         0.000483699641826617,
                                         3.77605388597257e-05,
                                         1.14086271653831e-06,
                                         5.99326020562179e-09,
                                         3.03691126204179e-13,
                                         5.72294636915894e-06,
                                         0.000741413914429252,
                                         0.00882994687942566,
                                         0.040941625602165,
                                         0.109842507293789,
                                         0.20049938593987,
                                         0.269070463262743,
                                         0.275685954184228,
                                         0.21875,
                                         0.133967355841576,
                                         0.0620276735870083,
                                         0.0208076271158292,
                                         0.00468447206577589,
                                         0.000615791675192914,
                                         3.58229724558322e-05,
                                         4.74040735875223e-07,
                                         1.28286598647761e-10,
                                         3.38696334296785e-08,
                                         2.34340963389945e-05,
                                         0.000703023541400072,
                                         0.00627638334038282,
                                         0.0283547327688799,
                                         0.0807379679463675,
                                         0.161486332950958,
                                         0.240224238748673,
                                         0.2734375,
                                         0.240224238748673,
                                         0.161486332950958,
                                         0.0807379679463675,
                                         0.0283547327688799,
                                         0.0062763833403828,
                                         0.000703023541400072,
                                         2.34340963389943e-05,
                                         3.38696334296801e-08,
                                         1.28286598647753e-10,
                                         4.74040735875228e-07,
                                         3.58229724558322e-05,
                                         0.000615791675192916,
                                         0.0046844720657759,
                                         0.0208076271158292,
                                         0.0620276735870083,
                                         0.133967355841576,
                                         0.21875,
                                         0.275685954184228,
                                         0.269070463262743,
                                         0.20049938593987,
                                         0.109842507293789,
                                         0.040941625602165,
                                         0.00882994687942566,
                                         0.000741413914429247,
                                         5.72294636915914e-06,
                                         3.03691126204158e-13,
                                         5.99326020562187e-09,
                                         1.14086271653831e-06,
                                         3.77605388597258e-05,
                                         0.000483699641826618,
                                         0.00335156244642388,
                                         0.0148907039852441,
                                         0.0466940090139074,
                                         0.109375,
                                         0.197739062808478,
                                         0.280205269067622,
                                         0.31119190872014,
                                         0.265947145996121,
                                         0.166917057965823,
                                         0.0693148569198388,
                                         0.0146606515287995,
                                         0.000604378314506111,
                                         4.10813649648799e-16,
                                         4.32984704525417e-11,
                                         2.07619005947242e-08,
                                         1.32313605620432e-06,
                                         2.85399251238109e-05,
                                         0.000308484981966291,
                                         0.00204271096020328,
                                         0.00930005016774062,
                                         0.03125,
                                         0.0810461248531386,
                                         0.166743349065387,
                                         0.275997721813975,
                                         0.367944386693892,
                                         0.388864512481369,
                                         0.3109256297542,
                                         0.16565622527126,
                                         0.0364720371524209,
                                         2.43128396178873e-19,
                                         1.36854799750699e-13,
                                         1.65302295490691e-10,
                                         2.02837795961416e-08,
                                         7.36729313693714e-07,
                                         1.24222079130954e-05,
                                         0.000122596102984312,
                                         0.000810377691703877,
                                         0.00390625,
                                         0.0145328266905549,
                                         0.0434109010178495,
                                         0.107092918827516,
                                         0.222713778885278,
                                         0.396345524976371,
                                         0.61018955814276,
                                         0.818917795111741,
                                         0.96291782758848,

                                         0.966754519686593,
                                         0.83636935887209,
                                         0.64303594268099,
                                         0.437606766916381,
                                         0.262011418604361,
                                         0.136850500531849,
                                         0.0616346968646651,
                                         0.0235656228342258,
                                         0.00748992413327123,
                                         0.00192301637543174,
                                         0.000383266837562394,
                                         5.60078190550855e-05,
                                         5.51049425149786e-06,
                                         3.18929172733807e-07,
                                         8.61062469682906e-09,
                                         6.91376309843516e-11,
                                         5.66572009504783e-14,
                                         1.00085544730261e-19,
                                         0.0327557909975925,
                                         0.151128101207955,
                                         0.291917506903224,
                                         0.38099374440789,
                                         0.38201635723697,
                                         0.308997095809359,
                                         0.205455691251766,
                                         0.112660506558125,
                                         0.0505540089679615,
                                         0.0182341185475834,
                                         0.00513083962558723,
                                         0.00107531504930661,
                                         0.000156193343012776,
                                         1.3999498549089e-05,
                                         6.32966635702135e-07,
                                         9.74696879241116e-09,
                                         2.00672553493609e-11,
                                         1.89051205472177e-16,
                                         0.000485554550961691,
                                         0.011947317229455,
                                         0.0579779815037575,
                                         0.145120818187063,
                                         0.243681049717623,
                                         0.305239309471316,
                                         0.299632656710999,
                                         0.235636484102641,
                                         0.149283511094421,
                                         0.0756422820999364,
                                         0.0300506378298502,
                                         0.00903235178075781,
                                         0.00193692383813992,
                                         0.000268849213765453,
                                         2.0356590201996e-05,
                                         6.01177494634018e-07,
                                         3.10955967810144e-09,
                                         1.56230420628952e-13,
                                         4.11291673981186e-06,
                                         0.000539706335563146,
                                         0.0065800318040132,
                                         0.0315866481580201,
                                         0.088822604980982,
                                         0.172301269975151,
                                         0.249702025554433,
                                         0.281627668503879,
                                         0.251901081518033,
                                         0.179310789632554,
                                         0.100572883067704,
                                         0.043353874353363,
                                         0.0137253844951375,
                                         0.00295030566330049,
                                         0.000374103008439953,
                                         2.11883824896458e-05,
                                         2.75341558697365e-07,
                                         7.37757621016341e-11,
                                         2.17741807732012e-08,
                                         1.52378836945538e-05,
                                         0.000466737731924782,
                                         0.00429692115474295,
                                         0.0202350961552761,
                                         0.0607878120417839,
                                         0.130057380615653,
                                         0.210372090640425,
                                         0.265661267630807,
                                         0.265661267630807,
                                         0.210372090640425,
                                         0.130057380615653,
                                         0.0607878120417839,
                                         0.0202350961552761,
                                         0.00429692115474296,
                                         0.000466737731924782,
                                         1.52378836945538e-05,
                                         2.17741807732012e-08,
                                         7.37757621016341e-11,
                                         2.75341558697365e-07,
                                         2.11883824896458e-05,
                                         0.000374103008439952,
                                         0.00295030566330049,
                                         0.0137253844951375,
                                         0.043353874353363,
                                         0.100572883067704,
                                         0.179310789632554,
                                         0.251901081518033,
                                         0.281627668503879,
                                         0.249702025554433,
                                         0.172301269975151,
                                         0.088822604980982,
                                         0.0315866481580202,
                                         0.0065800318040132,
                                         0.000539706335563146,
                                         4.11291673981186e-06,
                                         1.56230420628952e-13,
                                         3.10955967810144e-09,
                                         6.01177494634018e-07,
                                         2.03565902019959e-05,
                                         0.000268849213765453,
                                         0.00193692383813992,
                                         0.00903235178075781,
                                         0.0300506378298502,
                                         0.0756422820999364,
                                         0.149283511094421,
                                         0.235636484102641,
                                         0.299632656710999,
                                         0.305239309471316,
                                         0.243681049717623,
                                         0.145120818187063,
                                         0.0579779815037575,
                                         0.011947317229455,
                                         0.000485554550961691,
                                         1.89051205472177e-16,
                                         2.00672553493609e-11,
                                         9.74696879241116e-09,
                                         6.32966635702133e-07,
                                         1.3999498549089e-05,
                                         0.000156193343012776,
                                         0.00107531504930661,
                                         0.00513083962558723,
                                         0.0182341185475834,
                                         0.0505540089679615,
                                         0.112660506558125,
                                         0.205455691251766,
                                         0.308997095809359,
                                         0.38201635723697,
                                         0.38099374440789,
                                         0.291917506903224,
                                         0.151128101207955,
                                         0.0327557909975925,
                                         1.00085544730261e-19,
                                         5.66572009504783e-14,
                                         6.91376309843516e-11,
                                         8.61062469682902e-09,
                                         3.18929172733807e-07,
                                         5.51049425149786e-06,
                                         5.60078190550855e-05,
                                         0.000383266837562394,
                                         0.00192301637543174,
                                         0.00748992413327123,
                                         0.0235656228342258,
                                         0.0616346968646651,
                                         0.136850500531849,
                                         0.262011418604361,
                                         0.437606766916381,
                                         0.64303594268099,
                                         0.83636935887209,
                                         0.966754519686593,

                                         0.970027917478441,
                                         0.851486100039221,
                                         0.672287391886562,
                                         0.475893223714319,
                                         0.300565213623944,
                                         0.168230140729627,
                                         0.0826880717444693,
                                         0.0352611200560505,
                                         0.0128380178253708,
                                         0.00390625,
                                         0.000964962860604875,
                                         0.000185926947306552,
                                         2.63861988767406e-05,
                                         2.53221325473761e-06,
                                         1.43553843652434e-07,
                                         3.81191053588978e-09,
                                         3.0223534028936e-11,
                                         2.45534709954659e-14,
                                         4.31656898564682e-20,
                                         0.0295745760009045,
                                         0.138280030373987,
                                         0.27368042672591,
                                         0.37029995151573,
                                         0.389864073435329,
                                         0.3358871225508,
                                         0.241838030491297,
                                         0.146433981132939,
                                         0.0743172343460537,
                                         0.03125,
                                         0.0106683930438692,
                                         0.00286534253206903,
                                         0.000577397730565732,
                                         8.11690954207405e-05,
                                         7.08304985232172e-06,
                                         3.13529593251699e-07,
                                         4.75156251024292e-09,
                                         9.67633655448239e-12,
                                         9.06117183607098e-17,
                                         0.000394485348637467,
                                         0.00982470292200377,
                                         0.048742810565251,
                                         0.126059577392731,
                                         0.221241082230723,
                                         0.293400572514468,
                                         0.30944565393946,
                                         0.26605148881845,
                                         0.188217136456613,
                                         0.109375,
                                         0.0516018739875343,
                                         0.0193191854432446,
                                         0.0055277879018754,
                                         0.00113830643691007,
                                         0.000152898712748682,
                                         1.12821647182135e-05,
                                         3.26817803367058e-07,
                                         1.66834972113087e-09,
                                         8.32162429250392e-14,
                                         3.00680442137414e-06,
                                         0.000398879153284916,
                                         0.00496065869905865,
                                         0.0245222316007613,
                                         0.0717431239711161,
                                         0.146450382834528,
                                         0.226259138452506,
                                         0.276217677090962,
                                         0.272389733918781,
                                         0.21875,
                                         0.142624420061655,
                                         0.0744325722244388,
                                         0.0302405454883942,
                                         0.0091219907745458,
                                         0.00188603310298123,
                                         0.000231989476261046,
                                         1.28450830789023e-05,
                                         1.64370990513115e-07,
                                         4.36710660250815e-11,
                                         1.43238412713263e-08,
                                         1.01214624622997e-05,
                                         0.00031553544054979,
                                         0.00298142679397504,
                                         0.0145403483194615,
                                         0.0456877828504458,
                                         0.103396988052556,
                                         0.179232705754539,
                                         0.246378227499518,
                                         0.2734375,
                                         0.246378227499518,
                                         0.17923270575454,
                                         0.103396988052556,
                                         0.0456877828504457,
                                         0.0145403483194615,
                                         0.00298142679397504,
                                         0.00031553544054979,
                                         1.01214624622997e-05,
                                         1.43238412713263e-08,
                                         4.36710660250815e-11,
                                         1.64370990513115e-07,
                                         1.28450830789023e-05,
                                         0.000231989476261046,
                                         0.00188603310298122,
                                         0.00912199077454581,
                                         0.0302405454883942,
                                         0.0744325722244387,
                                         0.142624420061655,
                                         0.21875,
                                         0.272389733918781,
                                         0.276217677090962,
                                         0.226259138452506,
                                         0.146450382834528,
                                         0.0717431239711162,
                                         0.0245222316007613,
                                         0.00496065869905865,
                                         0.000398879153284916,
                                         3.00680442137414e-06,
                                         8.32162429250392e-14,
                                         1.66834972113087e-09,
                                         3.26817803367058e-07,
                                         1.12821647182135e-05,
                                         0.000152898712748681,
                                         0.00113830643691007,
                                         0.0055277879018754,
                                         0.0193191854432445,
                                         0.0516018739875343,
                                         0.109375,
                                         0.188217136456613,
                                         0.26605148881845,
                                         0.30944565393946,
                                         0.293400572514468,
                                         0.221241082230723,
                                         0.126059577392731,
                                         0.048742810565251,
                                         0.00982470292200377,
                                         0.000394485348637467,
                                         9.06117183607098e-17,
                                         9.67633655448239e-12,
                                         4.75156251024292e-09,
                                         3.13529593251699e-07,
                                         7.0830498523217e-06,
                                         8.11690954207407e-05,
                                         0.000577397730565732,
                                         0.00286534253206902,
                                         0.0106683930438692,
                                         0.03125,
                                         0.0743172343460537,
                                         0.146433981132939,
                                         0.241838030491297,
                                         0.3358871225508,
                                         0.38986407343533,
                                         0.37029995151573,
                                         0.27368042672591,
                                         0.138280030373987,
                                         0.0295745760009045,
                                         4.31656898564682e-20,
                                         2.45534709954659e-14,
                                         3.0223534028936e-11,
                                         3.81191053588978e-09,
                                         1.43553843652434e-07,
                                         2.53221325473762e-06,
                                         2.63861988767406e-05,
                                         0.000185926947306552,
                                         0.000964962860604875,
                                         0.00390625,
                                         0.0128380178253708,
                                         0.0352611200560505,
                                         0.0826880717444693,
                                         0.168230140729627,
                                         0.300565213623944,
                                         0.475893223714319,
                                         0.672287391886562,
                                         0.851486100039221,
                                         0.970027917478441,

                                         0.972842648423601,
                                         0.864653772647492,
                                         0.698375666930653,
                                         0.511251802481283,
                                         0.337889227344956,
                                         0.20051202762073,
                                         0.106064469359798,
                                         0.0495348235353043,
                                         0.0201716316598053,
                                         0.00704624764516319,
                                         0.00206611958610135,
                                         0.000493926209843846,
                                         9.24667410561284e-05,
                                         1.2798990988485e-05,
                                         1.20242691010243e-06,
                                         6.69710016143271e-08,
                                         1.75324210192132e-09,
                                         1.3751609324081e-11,
                                         1.10888952301006e-14,
                                         1.94143248056743e-20,
                                         0.0268313515540759,
                                         0.126893092788945,
                                         0.256426048178961,
                                         0.357787957611164,
                                         0.39264799920875,
                                         0.356837261673332,
                                         0.274701250698921,
                                         0.180669554464756,
                                         0.101495350243867,
                                         0.0483556898829199,
                                         0.0192684041820155,
                                         0.00628256410842356,
                                         0.00162252415875406,
                                         0.000316275094420418,
                                         4.32423105914018e-05,
                                         3.6883975527122e-06,
                                         1.60335982825667e-07,
                                         2.39695819391885e-09,
                                         4.83584655875148e-12,
                                         4.50507802369755e-17,
                                         0.000323758034745832,
                                         0.00814726386361046,
                                         0.0411920339839869,
                                         0.109545525552668,
                                         0.199622959175587,
                                         0.277829287164886,
                                         0.31126436775742,
                                         0.288295181886796,
                                         0.223423742015515,
                                         0.145182851503305,
                                         0.0786165711175802,
                                         0.0349614827236179,
                                         0.0124558924577257,
                                         0.00341926146797662,
                                         0.000680357464298382,
                                         8.88723601003313e-05,
                                         6.41502218673564e-06,
                                         1.82787061208428e-07,
                                         9.22645359285686e-10,
                                         4.57362338824729e-14,
                                         2.23234087824953e-06,
                                         0.000298914878453499,
                                         0.00378117071911674,
                                         0.0191657367576546,
                                         0.0579935295158162,
                                         0.123608348113779,
                                         0.2015394779163,
                                         0.26287648944939,
                                         0.281044083729802,
                                         0.249083529885262,
                                         0.183292375461683,
                                         0.111174377953193,
                                         0.0546412315408488,
                                         0.0211232909806198,
                                         0.00611684347239514,
                                         0.00122365123559573,
                                         0.000146665267453873,
                                         7.96512127745399e-06,
                                         1.00590980730396e-07,
                                         2.65326381696259e-11,
                                         9.62011993118581e-09,
                                         6.85430302558e-06,
                                         0.000216929868234106,
                                         0.00209573521836309,
                                         0.0105300057906402,
                                         0.0343714297530784,
                                         0.0815588077335555,
                                         0.149811835765369,
                                         0.220952841355931,
                                         0.26708821073597,
                                         0.26708821073597,
                                         0.220952841355931,
                                         0.149811835765369,
                                         0.0815588077335555,
                                         0.0343714297530784,
                                         0.0105300057906402,
                                         0.00209573521836309,
                                         0.000216929868234106,
                                         6.85430302558008e-06,
                                         9.62011993118643e-09,
                                         2.65326381696238e-11,
                                         1.00590980730394e-07,
                                         7.96512127745399e-06,
                                         0.000146665267453872,
                                         0.00122365123559573,
                                         0.00611684347239515,
                                         0.0211232909806198,
                                         0.0546412315408488,
                                         0.111174377953193,
                                         0.183292375461683,
                                         0.249083529885262,
                                         0.281044083729802,
                                         0.26287648944939,
                                         0.2015394779163,
                                         0.123608348113779,
                                         0.0579935295158162,
                                         0.0191657367576547,
                                         0.00378117071911674,
                                         0.000298914878453502,
                                         2.23234087824964e-06,
                                         4.57362338824684e-14,
                                         9.22645359285669e-10,
                                         1.82787061208428e-07,
                                         6.41502218673562e-06,
                                         8.88723601003313e-05,
                                         0.000680357464298383,
                                         0.00341926146797662,
                                         0.0124558924577257,
                                         0.0349614827236179,
                                         0.0786165711175802,
                                         0.145182851503305,
                                         0.223423742015515,
                                         0.288295181886796,
                                         0.31126436775742,
                                         0.277829287164885,
                                         0.199622959175587,
                                         0.109545525552668,
                                         0.0411920339839869,
                                         0.00814726386361051,
                                         0.000323758034745843,
                                         4.50507802369704e-17,
                                         4.83584655875137e-12,
                                         2.39695819391885e-09,
                                         1.60335982825666e-07,
                                         3.6883975527122e-06,
                                         4.32423105914019e-05,
                                         0.000316275094420418,
                                         0.00162252415875406,
                                         0.00628256410842356,
                                         0.0192684041820155,
                                         0.0483556898829199,
                                         0.101495350243867,
                                         0.180669554464756,
                                         0.274701250698921,
                                         0.356837261673332,
                                         0.39264799920875,
                                         0.357787957611165,
                                         0.256426048178961,
                                         0.126893092788945,
                                         0.0268313515540764,
                                         1.94143248056718e-20,
                                         1.10888952301003e-14,
                                         1.3751609324081e-11,
                                         1.75324210192131e-09,
                                         6.69710016143271e-08,
                                         1.20242691010243e-06,
                                         1.2798990988485e-05,
                                         9.24667410561284e-05,
                                         0.000493926209843846,
                                         0.00206611958610135,
                                         0.00704624764516319,
                                         0.0201716316598053,
                                         0.0495348235353043,
                                         0.106064469359798,
                                         0.20051202762073,
                                         0.337889227344956,
                                         0.511251802481283,
                                         0.698375666930653,
                                         0.864653772647492,
                                         0.972842648423601,

                                         0.975280229530664,
                                         0.876184489616517,
                                         0.72168821064246,
                                         0.543806791725869,
                                         0.373665153738048,
                                         0.233095621910536,
                                         0.131232190890892,
                                         0.0661720475422446,
                                         0.0295899642242764,
                                         0.0115853293479172,
                                         0.00390625,
                                         0.00110969867121686,
                                         0.0002579264984758,
                                         4.71059389740312e-05,
                                         6.38173720241994e-06,
                                         5.88661167017507e-07,
                                         3.22900643016741e-08,
                                         8.35025872697622e-10,
                                         6.48878258416976e-12,
                                         5.19884336129344e-15,
                                         9.06970836537649e-21,
                                         0.0244499173416097,
                                         0.11677488395727,
                                         0.240251605906224,
                                         0.344204486952726,
                                         0.391422580057019,
                                         0.372319268198386,
                                         0.303384007256306,
                                         0.213951185178198,
                                         0.130851398121675,
                                         0.0691290289809489,
                                         0.03125,
                                         0.011902356874394,
                                         0.00373286263811167,
                                         0.000932428448880945,
                                         0.000176671536478127,
                                         2.35865252287576e-05,
                                         1.97281157807321e-06,
                                         8.44321806233103e-08,
                                         1.24745965374191e-09,
                                         2.49650720099869e-12,
                                         2.31539623016907e-17,
                                         0.000268165822971631,
                                         0.00680896944321159,
                                         0.0349913779442189,
                                         0.0953161484105267,
                                         0.179385447525785,
                                         0.260180632724115,
                                         0.306847821901761,
                                         0.302644563844657,
                                         0.253157239867596,
                                         0.180464002847683,
                                         0.109375,
                                         0.0558520254123703,
                                         0.023635571786312,
                                         0.00807483066165601,
                                         0.00213979571393139,
                                         0.000413466759908156,
                                         5.27327431193858e-05,
                                         3.73503036741543e-06,
                                         1.04922311819442e-07,
                                         5.24489708582191e-10,
                                         2.58604083553203e-14,
                                         1.68070468542575e-06,
                                         0.00022686906297201,
                                         0.00291217683065876,
                                         0.0150826757136631,
                                         0.0469775639986817,
                                         0.103895412085877,
                                         0.177343533614827,
                                         0.24463185562214,
                                         0.27987511686582,
                                         0.269204718058324,
                                         0.21875,
                                         0.149763795311836,
                                         0.0855169431726772,
                                         0.0399588777594208,
                                         0.0148094862158464,
                                         0.00414170524158949,
                                         0.000805447189556164,
                                         9.44152657199656e-05,
                                         5.0427930460868e-06,
                                         6.29655599971458e-08,
                                         1.65046905601512e-11,
                                         6.58353898417659e-09,
                                         4.72442747789019e-06,
                                         0.000151479707132162,
                                         0.00149166163392204,
                                         0.00768906964614919,
                                         0.0259297178931932,
                                         0.064060111132756,
                                         0.123587105003828,
                                         0.193382976825055,
                                         0.250989044495309,
                                         0.2734375,
                                         0.250989044495309,
                                         0.193382976825055,
                                         0.123587105003828,
                                         0.064060111132756,
                                         0.0259297178931932,
                                         0.00768906964614919,
                                         0.00149166163392204,
                                         0.000151479707132161,
                                         4.72442747789025e-06,
                                         6.58353898417612e-09,
                                         1.65046905601527e-11,
                                         6.29655599971447e-08,
                                         5.04279304608684e-06,
                                         9.44152657199656e-05,
                                         0.000805447189556164,
                                         0.00414170524158949,
                                         0.0148094862158464,
                                         0.0399588777594208,
                                         0.0855169431726772,
                                         0.149763795311836,
                                         0.21875,
                                         0.269204718058324,
                                         0.27987511686582,
                                         0.24463185562214,
                                         0.177343533614827,
                                         0.103895412085877,
                                         0.0469775639986817,
                                         0.0150826757136631,
                                         0.00291217683065875,
                                         0.000226869062972012,
                                         1.68070468542566e-06,
                                         2.58604083553231e-14,
                                         5.2448970858218e-10,
                                         1.04922311819443e-07,
                                         3.73503036741543e-06,
                                         5.27327431193858e-05,
                                         0.000413466759908156,
                                         0.00213979571393139,
                                         0.008074830661656,
                                         0.023635571786312,
                                         0.0558520254123703,
                                         0.109375,
                                         0.180464002847683,
                                         0.253157239867596,
                                         0.302644563844657,
                                         0.306847821901761,
                                         0.260180632724115,
                                         0.179385447525785,
                                         0.0953161484105267,
                                         0.0349913779442188,
                                         0.00680896944321164,
                                         0.000268165822971622,
                                         2.31539623016936e-17,
                                         2.49650720099863e-12,
                                         1.24745965374192e-09,
                                         8.44321806233103e-08,
                                         1.97281157807321e-06,
                                         2.35865252287576e-05,
                                         0.000176671536478127,
                                         0.000932428448880943,
                                         0.00373286263811167,
                                         0.011902356874394,
                                         0.03125,
                                         0.0691290289809489,
                                         0.130851398121675,
                                         0.213951185178198,
                                         0.303384007256306,
                                         0.372319268198386,
                                         0.391422580057019,
                                         0.344204486952726,
                                         0.240251605906224,
                                         0.11677488395727,
                                         0.0244499173416093,
                                         9.06970836537778e-21,
                                         5.1988433612933e-15,
                                         6.48878258416983e-12,
                                         8.35025872697622e-10,
                                         3.22900643016741e-08,
                                         5.88661167017507e-07,
                                         6.38173720241994e-06,
                                         4.71059389740312e-05,
                                         0.0002579264984758,
                                         0.00110969867121686,
                                         0.00390625,
                                         0.0115853293479172,
                                         0.0295899642242764,
                                         0.0661720475422446,
                                         0.131232190890892,
                                         0.233095621910536,
                                         0.373665153738048,
                                         0.543806791725869,
                                         0.72168821064246,
                                         0.876184489616517,
                                         0.975280229530664,

                                         0.977404908789797,
                                         0.886332222442529,
                                         0.742567285184163,
                                         0.573725516807242,
                                         0.407703235783672,
                                         0.265501210051669,
                                         0.157680204965298,
                                         0.08487423977963,
                                         0.041078445597656,
                                         0.0176967720100195,
                                         0.00669859247786867,
                                         0.00219077374061691,
                                         0.000605583056299944,
                                         0.00013737447448127,
                                         2.45576700274951e-05,
                                         3.26564432798095e-06,
                                         2.96479452575759e-07,
                                         1.60489969900202e-08,
                                         4.1063363222043e-10,
                                         3.16518929060632e-12,
                                         2.52183478843118e-15,
                                         4.38588921605081e-21,
                                         0.0223698151588167,
                                         0.107758499889738,
                                         0.225182057681531,
                                         0.330094240400146,
                                         0.387099056198032,
                                         0.382954787904813,
                                         0.327635631095374,
                                         0.245212323278107,
                                         0.161153778953633,
                                         0.0928472404213051,
                                         0.0466015423504767,
                                         0.020153977413697,
                                         0.00738718108193503,
                                         0.00224109117663931,
                                         0.000544002303695965,
                                         0.000100585390473339,
                                         1.31550824735183e-05,
                                         1.08180731920008e-06,
                                         4.56773299801441e-08,
                                         6.68008040873262e-10,
                                         1.32752163250985e-12,
                                         1.22644972968921e-17,
                                         0.000223989846747249,
                                         0.00573171506908331,
                                         0.0298751305768698,
                                         0.08309019627779,
                                         0.160797067435223,
                                         0.241660995362026,
                                         0.297840075862812,
                                         0.309946505489309,
                                         0.276595457563439,
                                         0.213118917756569,
                                         0.141838810693517,
                                         0.0811151668252038,
                                         0.0394241040088532,
                                         0.0159952511951498,
                                         0.00527220605279903,
                                         0.00135543590949833,
                                         0.000255370429904819,
                                         3.19028875146301e-05,
                                         2.22292576837764e-06,
                                         6.16796286080289e-08,
                                         3.05734634413383e-10,
                                         1.5004443878863e-14,
                                         1.28161098438509e-06,
                                         0.000174212615202499,
                                         0.00226489353592231,
                                         0.0119515318830725,
                                         0.0381677085073549,
                                         0.0871420088873798,
                                         0.15471666408964,
                                         0.22386858162235,
                                         0.271276107087539,
                                         0.279535490767317,
                                         0.24669015786949,
                                         0.186554322086574,
                                         0.120228345342853,
                                         0.0652355840794623,
                                         0.0291975199099846,
                                         0.0104372243672023,
                                         0.00283275876077558,
                                         0.000537615796775412,
                                         6.18174607949826e-05,
                                         3.25434627168436e-06,
                                         4.02355204683874e-08,
                                         1.04894328338384e-11,
                                         4.58315058458304e-09,
                                         3.30944086214713e-06,
                                         0.000107316324439647,
                                         0.00107442815722323,
                                         0.00566231553511256,
                                         0.0196394170415053,
                                         0.0502309126753737,
                                         0.101060063894097,
                                         0.166286909872,
                                         0.229156365554849,
                                         0.268156656542556,
                                         0.268156656542556,
                                         0.229156365554849,
                                         0.166286909872,
                                         0.101060063894097,
                                         0.0502309126753737,
                                         0.0196394170415053,
                                         0.00566231553511255,
                                         0.00107442815722322,
                                         0.000107316324439647,
                                         3.30944086214713e-06,
                                         4.58315058458304e-09,
                                         1.04894328338384e-11,
                                         4.02355204683874e-08,
                                         3.25434627168434e-06,
                                         6.18174607949829e-05,
                                         0.000537615796775413,
                                         0.00283275876077558,
                                         0.0104372243672023,
                                         0.0291975199099846,
                                         0.0652355840794623,
                                         0.120228345342853,
                                         0.186554322086574,
                                         0.24669015786949,
                                         0.279535490767317,
                                         0.271276107087539,
                                         0.22386858162235,
                                         0.15471666408964,
                                         0.0871420088873798,
                                         0.0381677085073548,
                                         0.0119515318830725,
                                         0.00226489353592232,
                                         0.000174212615202499,
                                         1.28161098438509e-06,
                                         1.5004443878863e-14,
                                         3.05734634413383e-10,
                                         6.16796286080284e-08,
                                         2.22292576837765e-06,
                                         3.19028875146302e-05,
                                         0.000255370429904819,
                                         0.00135543590949833,
                                         0.00527220605279903,
                                         0.0159952511951498,
                                         0.0394241040088532,
                                         0.0811151668252038,
                                         0.141838810693517,
                                         0.213118917756569,
                                         0.276595457563439,
                                         0.309946505489309,
                                         0.297840075862812,
                                         0.241660995362026,
                                         0.160797067435223,
                                         0.0830901962777899,
                                         0.0298751305768699,
                                         0.00573171506908331,
                                         0.000223989846747249,
                                         1.22644972968921e-17,
                                         1.32752163250985e-12,
                                         6.68008040873255e-10,
                                         4.56773299801444e-08,
                                         1.08180731920008e-06,
                                         1.31550824735183e-05,
                                         0.000100585390473339,
                                         0.000544002303695965,
                                         0.00224109117663931,
                                         0.00738718108193502,
                                         0.020153977413697,
                                         0.0466015423504767,
                                         0.0928472404213051,
                                         0.161153778953633,
                                         0.245212323278107,
                                         0.327635631095374,
                                         0.382954787904813,
                                         0.387099056198032,
                                         0.330094240400145,
                                         0.225182057681531,
                                         0.107758499889738,
                                         0.0223698151588167,
                                         4.38588921605081e-21,
                                         2.52183478843118e-15,
                                         3.16518929060628e-12,
                                         4.10633632220432e-10,
                                         1.60489969900203e-08,
                                         2.96479452575759e-07,
                                         3.26564432798095e-06,
                                         2.45576700274951e-05,
                                         0.00013737447448127,
                                         0.000605583056299944,
                                         0.00219077374061691,
                                         0.00669859247786867,
                                         0.0176967720100195,
                                         0.041078445597656,
                                         0.08487423977963,
                                         0.157680204965298,
                                         0.265501210051669,
                                         0.407703235783672,
                                         0.573725516807242,
                                         0.742567285184163,
                                         0.886332222442529,
                                         0.977404908789797,

                                         0.979267860481196,
                                         0.895304850987842,
                                         0.761312390832218,
                                         0.601195604616849,
                                         0.439909020801398,
                                         0.297359997920204,
                                         0.184945327987176,
                                         0.10530000093907,
                                         0.0545294115206056,
                                         0.0254747278118643,
                                         0.0106264151457423,
                                         0.00390625,
                                         0.00124418076276625,
                                         0.000335847404102693,
                                         7.45905277073675e-05,
                                         1.30876496424839e-05,
                                         1.71235536999654e-06,
                                         1.53318678005907e-07,
                                         8.20398256182067e-09,
                                         2.07964391261829e-10,
                                         1.5916862188904e-12,
                                         1.2619775085405e-15,
                                         2.1888464034888e-21,
                                         0.0205426142701251,
                                         0.0997001953499298,
                                         0.211197953207519,
                                         0.315847491164948,
                                         0.380439486957168,
                                         0.389414032425809,
                                         0.347497887449246,
                                         0.273730078977488,
                                         0.191305478117369,
                                         0.118632476028865,
                                         0.0650187855904253,
                                         0.03125,
                                         0.0130140173430221,
                                         0.00461559747804944,
                                         0.00136071464204241,
                                         0.00032221628542494,
                                         5.83263863357313e-05,
                                         7.49283187175758e-06,
                                         6.07130405194534e-07,
                                         2.53342072114187e-08,
                                         3.6720672255909e-10,
                                         7.25281361798432e-13,
                                         6.67791752315367e-18,
                                         0.000188533260827283,
                                         0.00485734709474422,
                                         0.0256327126545915,
                                         0.0725967408073652,
                                         0.143941612746421,
                                         0.223109830671423,
                                         0.285653158176301,
                                         0.3113111872517,
                                         0.293631104939577,
                                         0.241699468068733,
                                         0.1740479794439,
                                         0.109375,
                                         0.0595548777612637,
                                         0.0277518485206967,
                                         0.0108599667057658,
                                         0.00347065440512793,
                                         0.000869189152342216,
                                         0.000160204594492494,
                                         1.96570025818132e-05,
                                         1.35021744526725e-06,
                                         3.70631090964228e-08,
                                         1.82364154248274e-10,
                                         8.91343028411979e-15,
                                         9.88740213622614e-07,
                                         0.000135227250721941,
                                         0.00177771191990203,
                                         0.00953495762222498,
                                         0.0311206810474558,
                                         0.0730445415012691,
                                         0.134180016994472,
                                         0.202315373012892,
                                         0.257536425546103,
                                         0.281390703794873,
                                         0.266232499453116,
                                         0.21875,
                                         0.155734647898638,
                                         0.0953493762930582,
                                         0.0495281242901337,
                                         0.0213617685559044,
                                         0.00740159770375841,
                                         0.00195733831524609,
                                         0.000363675929723018,
                                         4.11208480587987e-05,
                                         2.13764224657219e-06,
                                         2.6201996715729e-08,
                                         6.79846153102135e-12,
                                         3.24083137155998e-09,
                                         2.35293167509086e-06,
                                         7.70563116150444e-05,
                                         0.000782709180936833,
                                         0.00420525018086524,
                                         0.0149464084210062,
                                         0.0393927837949999,
                                         0.0821756329227496,
                                         0.141174183710696,
                                         0.204749954599758,
                                         0.254526596601126,
                                         0.2734375,
                                         0.254526596601126,
                                         0.204749954599758,
                                         0.141174183710696,
                                         0.0821756329227497,
                                         0.0393927837949998,
                                         0.0149464084210063,
                                         0.00420525018086524,
                                         0.000782709180936833,
                                         7.70563116150449e-05,
                                         2.35293167509086e-06,
                                         3.2408313715597e-09,
                                         6.79846153102207e-12,
                                         2.6201996715729e-08,
                                         2.13764224657217e-06,
                                         4.11208480587987e-05,
                                         0.000363675929723018,
                                         0.00195733831524609,
                                         0.00740159770375842,
                                         0.0213617685559044,
                                         0.0495281242901337,
                                         0.0953493762930582,
                                         0.155734647898638,
                                         0.21875,
                                         0.266232499453116,
                                         0.281390703794873,
                                         0.257536425546103,
                                         0.202315373012892,
                                         0.134180016994471,
                                         0.0730445415012692,
                                         0.0311206810474558,
                                         0.00953495762222498,
                                         0.00177771191990203,
                                         0.000135227250721941,
                                         9.88740213622551e-07,
                                         8.91343028412093e-15,
                                         1.82364154248274e-10,
                                         3.70631090964225e-08,
                                         1.35021744526725e-06,
                                         1.96570025818132e-05,
                                         0.000160204594492493,
                                         0.000869189152342218,
                                         0.00347065440512793,
                                         0.0108599667057658,
                                         0.0277518485206967,
                                         0.0595548777612637,
                                         0.109375,
                                         0.1740479794439,
                                         0.241699468068733,
                                         0.293631104939577,
                                         0.3113111872517,
                                         0.285653158176301,
                                         0.223109830671424,
                                         0.143941612746421,
                                         0.0725967408073652,
                                         0.0256327126545915,
                                         0.00485734709474422,
                                         0.000188533260827275,
                                         6.67791752315466e-18,
                                         7.25281361798432e-13,
                                         3.67206722559086e-10,
                                         2.53342072114187e-08,
                                         6.07130405194534e-07,
                                         7.49283187175756e-06,
                                         5.83263863357314e-05,
                                         0.00032221628542494,
                                         0.00136071464204241,
                                         0.00461559747804944,
                                         0.0130140173430221,
                                         0.03125,
                                         0.0650187855904253,
                                         0.118632476028865,
                                         0.191305478117369,
                                         0.273730078977488,
                                         0.347497887449245,
                                         0.389414032425809,
                                         0.380439486957168,
                                         0.315847491164948,
                                         0.211197953207519,
                                         0.0997001953499298,
                                         0.0205426142701246,
                                         2.18884640348917e-21,
                                         1.2619775085405e-15,
                                         1.59168621889038e-12,
                                         2.07964391261829e-10,
                                         8.20398256182067e-09,
                                         1.53318678005906e-07,
                                         1.71235536999654e-06,
                                         1.30876496424839e-05,
                                         7.45905277073675e-05,
                                         0.000335847404102693,
                                         0.00124418076276625,
                                         0.00390625,
                                         0.0106264151457423,
                                         0.0254747278118643,
                                         0.0545294115206056,
                                         0.10530000093907,
                                         0.184945327987176,
                                         0.297359997920204,
                                         0.439909020801398,
                                         0.601195604616849,
                                         0.761312390832218,
                                         0.895304850987842,
                                         0.979267860481196,

                                         0.980910241946381,
                                         0.903273535042967,
                                         0.778184158367112,
                                         0.626410363346187,
                                         0.470256632726424,
                                         0.32839912584075,
                                         0.21262539204281,
                                         0.127097078971741,
                                         0.0697674598078105,
                                         0.0349364537337338,
                                         0.0158270825127816,
                                         0.00641916929678917,
                                         0.00230014723454175,
                                         0.000715875794696415,
                                         0.00018926404871408,
                                         4.12628093846338e-05,
                                         7.1224823758249e-06,
                                         9.18706616325978e-07,
                                         8.12618792329773e-08,
                                         4.30429216060754e-09,
                                         1.0822105752295e-10,
                                         8.23140632407526e-13,
                                         6.49831116028683e-16,
                                         1.12441884437828e-21,
                                         0.018929171758283,
                                         0.0924766151354235,
                                         0.198253712818775,
                                         0.301738360318288,
                                         0.372066670808874,
                                         0.392353551434014,
                                         0.363203754259059,
                                         0.29908011099563,
                                         0.220409918106139,
                                         0.145576900886023,
                                         0.0859845563839051,
                                         0.0451703460382816,
                                         0.0209199683258416,
                                         0.00843330997885779,
                                         0.00290692916960963,
                                         0.000835911972030511,
                                         0.000193713279451504,
                                         3.44208520407407e-05,
                                         4.35302578613607e-06,
                                         3.48173631710485e-07,
                                         1.43787176451866e-08,
                                         2.06783113582014e-10,
                                         4.06226113529142e-13,
                                         3.72911474339369e-18,
                                         0.00015981296611841,
                                         0.00414211947612643,
                                         0.0220972551585927,
                                         0.0635887335109394,
                                         0.128790747600595,
                                         0.205083745750959,
                                         0.271433588223909,
                                         0.307905576301308,
                                         0.304640341046584,
                                         0.265389769579365,
                                         0.204370449804804,
                                         0.139061228838351,
                                         0.0832423756747535,
                                         0.0434646820095063,
                                         0.0195334444066987,
                                         0.00740867176737405,
                                         0.00230497097597744,
                                         0.000564214763933625,
                                         0.000102017264825887,
                                         1.23216273586071e-05,
                                         8.3580813716238e-07,
                                         2.27265837584815e-08,
                                         1.1109978795821e-10,
                                         5.41079942499078e-15,
                                         7.70999974180466e-07,
                                         0.0001060169410976,
                                         0.00140739914555936,
                                         0.00765758411219946,
                                         0.0254747840625442,
                                         0.0612557476978479,
                                         0.115914775427059,
                                         0.181137982637751,
                                         0.240605551667179,
                                         0.276463522003917,
                                         0.277573305918098,
                                         0.244636164615526,
                                         0.189273520878609,
                                         0.128007937701713,
                                         0.0750041274539168,
                                         0.0375216661174474,
                                         0.0156723268390472,
                                         0.00528480816493593,
                                         0.00136621189606314,
                                         0.000249173707659285,
                                         2.77622707744716e-05,
                                         1.42729977285783e-06,
                                         1.73628324202096e-08,
                                         4.48620458696506e-12,
                                         2.32475254755706e-09,
                                         1.6959300462711e-06,
                                         5.60242759990201e-05,
                                         0.000576346146535945,
                                         0.00314931698862125,
                                         0.0114351658278751,
                                         0.030938127559636,
                                         0.0666011175167186,
                                         0.118769216706051,
                                         0.179999588718022,
                                         0.235622799895638,
                                         0.268977079097306,
                                         0.268977079097306,
                                         0.235622799895638,
                                         0.179999588718022,
                                         0.118769216706051,
                                         0.0666011175167186,
                                         0.030938127559636,
                                         0.0114351658278751,
                                         0.00314931698862125,
                                         0.000576346146535945,
                                         5.60242759990197e-05,
                                         1.6959300462711e-06,
                                         2.32475254755685e-09,
                                         4.48620458696557e-12,
                                         1.73628324202096e-08,
                                         1.42729977285784e-06,
                                         2.77622707744716e-05,
                                         0.000249173707659285,
                                         0.00136621189606314,
                                         0.00528480816493593,
                                         0.0156723268390472,
                                         0.0375216661174474,
                                         0.0750041274539168,
                                         0.128007937701713,
                                         0.189273520878609,
                                         0.244636164615526,
                                         0.277573305918098,
                                         0.276463522003917,
                                         0.240605551667179,
                                         0.181137982637751,
                                         0.115914775427059,
                                         0.0612557476978478,
                                         0.0254747840625442,
                                         0.00765758411219946,
                                         0.00140739914555936,
                                         0.0001060169410976,
                                         7.70999974180413e-07,
                                         5.41079942499153e-15,
                                         1.1109978795821e-10,
                                         2.27265837584818e-08,
                                         8.3580813716238e-07,
                                         1.23216273586071e-05,
                                         0.000102017264825887,
                                         0.000564214763933625,
                                         0.00230497097597744,
                                         0.00740867176737405,
                                         0.0195334444066987,
                                         0.0434646820095063,
                                         0.0832423756747535,
                                         0.139061228838351,
                                         0.204370449804804,
                                         0.265389769579365,
                                         0.304640341046584,
                                         0.307905576301307,
                                         0.271433588223909,
                                         0.205083745750959,
                                         0.128790747600595,
                                         0.0635887335109394,
                                         0.0220972551585926,
                                         0.00414211947612643,
                                         0.000159812966118403,
                                         3.72911474339429e-18,
                                         4.06226113529142e-13,
                                         2.06783113582017e-10,
                                         1.43787176451866e-08,
                                         3.48173631710485e-07,
                                         4.35302578613608e-06,
                                         3.44208520407407e-05,
                                         0.000193713279451505,
                                         0.000835911972030511,
                                         0.00290692916960963,
                                         0.00843330997885779,
                                         0.0209199683258416,
                                         0.0451703460382816,
                                         0.0859845563839051,
                                         0.145576900886023,
                                         0.220409918106139,
                                         0.29908011099563,
                                         0.363203754259059,
                                         0.392353551434014,
                                         0.372066670808874,
                                         0.301738360318288,
                                         0.198253712818774,
                                         0.0924766151354235,
                                         0.0189291717582826,
                                         1.12441884437849e-21,
                                         6.49831116028683e-16,
                                         8.23140632407538e-13,
                                         1.0822105752295e-10,
                                         4.30429216060754e-09,
                                         8.12618792329776e-08,
                                         9.18706616325978e-07,
                                         7.12248237582492e-06,
                                         4.12628093846338e-05,
                                         0.00018926404871408,
                                         0.000715875794696415,
                                         0.00230014723454175,
                                         0.00641916929678917,
                                         0.0158270825127816,
                                         0.0349364537337338,
                                         0.0697674598078105,
                                         0.127097078971741,
                                         0.21262539204281,
                                         0.32839912584075,
                                         0.470256632726424,
                                         0.626410363346187,
                                         0.778184158367112,
                                         0.903273535042967,
                                         0.980910241946381,

                                         0.001953125,
                                         0.017578125,
                                         0.0703125,
                                         0.1640625,
                                         0.24609375,
                                         0.24609375,
                                         0.1640625,
                                         0.0703125,
                                         0.017578125,
                                         0.001953125,

                                         0.118054715021316,
                                         8.40534239649844e-07,
                                         0.284693989973831,
                                         2.82322483908705e-05,
                                         0.305134098813929,
                                         0.000421456741626533,
                                         0.190774349174245,
                                         0.00367009527019952,
                                         0.0766767491967178,
                                         0.0205454730255043,
                                         0.0205454730255043,
                                         0.0766767491967178,
                                         0.00367009527019952,
                                         0.190774349174245,
                                         0.000421456741626533,
                                         0.305134098813929,
                                         2.82322483908705e-05,
                                         0.284693989973831,
                                         8.40534239649844e-07,
                                         0.118054715021316,

                                         0.340899997066588,
                                         0.001953125,
                                         2.93341158288331e-09,
                                         0.389699792147695,
                                         0.017578125,
                                         2.0785230485651e-07,
                                         0.197993454329062,
                                         0.0703125,
                                         6.5456709384245e-06,
                                         0.0586797540973283,
                                         0.1640625,
                                         0.00012024590267193,
                                         0.0111799590162214,
                                         0.24609375,
                                         0.00142004098377867,
                                         0.00142004098377867,
                                         0.24609375,
                                         0.0111799590162214,
                                         0.00012024590267193,
                                         0.1640625,
                                         0.0586797540973283,
                                         6.5456709384245e-06,
                                         0.0703125,
                                         0.197993454329062,
                                         2.0785230485651e-07,
                                         0.017578125,
                                         0.389699792147695,
                                         2.93341158288331e-09,
                                         0.001953125,
                                         0.340899997066588,

                                         0.523279452073962,
                                         0.0272030706779361,
                                         4.64234829899064e-05,
                                         3.74997444104046e-11,
                                         0.351387820958782,
                                         0.120591915575868,
                                         0.000848247280189908,
                                         4.52335114521126e-09,
                                         0.104871434886943,
                                         0.237594257475621,
                                         0.00688850079034372,
                                         2.42498904157948e-07,
                                         0.018257634536266,
                                         0.273067792598097,
                                         0.0326320038318305,
                                         7.58361106640354e-06,
                                         0.00204336656386727,
                                         0.20175276400069,
                                         0.0993750242864341,
                                         0.000152460309358515,
                                         0.000152460309358515,
                                         0.0993750242864341,
                                         0.20175276400069,
                                         0.00204336656386727,
                                         7.5836110664035e-06,
                                         0.0326320038318305,
                                         0.273067792598097,
                                         0.018257634536266,
                                         2.42498904157946e-07,
                                         0.00688850079034372,
                                         0.237594257475621,
                                         0.104871434886943,
                                         4.52335114521123e-09,
                                         0.000848247280189908,
                                         0.120591915575868,
                                         0.351387820958782,
                                         3.74997444104043e-11,
                                         4.64234829899064e-05,
                                         0.0272030706779361,
                                         0.523279452073962,

                                         0.648940531175615,
                                         0.0943038827069123,
                                         0.001953125,
                                         1.85581766832031e-06,
                                         1.10000666072867e-12,
                                         0.287461493558098,
                                         0.254614909661082,
                                         0.017578125,
                                         5.56757487928878e-05,
                                         2.01143293064475e-10,
                                         0.0565942015802643,
                                         0.30553120336261,
                                         0.0703125,
                                         0.000742359567504601,
                                         1.63468199438075e-08,
                                         0.00649951560759269,
                                         0.213867160694829,
                                         0.1640625,
                                         0.00577403414098331,
                                         7.74957339876462e-07,
                                         0.000479848916350383,
                                         0.0962381156122405,
                                         0.24609375,
                                         0.0288708026873771,
                                         2.36176556761302e-05,
                                         2.36176556761301e-05,
                                         0.0288708026873771,
                                         0.24609375,
                                         0.0962381156122405,
                                         0.000479848916350385,
                                         7.74957339876457e-07,
                                         0.00577403414098331,
                                         0.1640625,
                                         0.213867160694829,
                                         0.00649951560759272,
                                         1.63468199438074e-08,
                                         0.000742359567504601,
                                         0.0703125,
                                         0.30553120336261,
                                         0.0565942015802645,
                                         2.01143293064473e-10,
                                         5.56757487928878e-05,
                                         0.017578125,
                                         0.254614909661082,
                                         0.287461493558098,
                                         1.10000666072866e-12,
                                         1.85581766832031e-06,
                                         0.001953125,
                                         0.0943038827069123,
                                         0.648940531175615,

                                         0.73408086166281,
                                         0.188169584696206,
                                         0.0134020201062015,
                                         0.000167937389586946,
                                         1.14845071680197e-07,
                                         5.70464869069653e-14,
                                         0.23087325908181,
                                         0.345381386658926,
                                         0.0741441516659445,
                                         0.00245881459186946,
                                         5.06813155674938e-06,
                                         1.46921106793994e-11,
                                         0.0322716259764131,
                                         0.281751289976078,
                                         0.18230602327775,
                                         0.0160000613246008,
                                         9.94033173009336e-05,
                                         1.68173266649671e-09,
                                         0.00263138779083231,
                                         0.134075582164827,
                                         0.261482078757008,
                                         0.0607343386342396,
                                         0.00113728855921434,
                                         1.1229140683586e-07,
                                         0.000137931461165695,
                                         0.041015493692345,
                                         0.241100057449734,
                                         0.148204516803066,
                                         0.00836478795847495,
                                         4.82003907990717e-06,
                                         4.82003907990717e-06,
                                         0.00836478795847497,
                                         0.148204516803066,
                                         0.241100057449734,
                                         0.041015493692345,
                                         0.000137931461165695,
                                         1.1229140683586e-07,
                                         0.00113728855921434,
                                         0.0607343386342396,
                                         0.261482078757008,
                                         0.134075582164826,
                                         0.00263138779083231,
                                         1.68173266649671e-09,
                                         9.94033173009338e-05,
                                         0.0160000613246008,
                                         0.18230602327775,
                                         0.281751289976078,
                                         0.0322716259764131,
                                         1.46921106793994e-11,
                                         5.06813155674939e-06,
                                         0.00245881459186946,
                                         0.0741441516659445,
                                         0.345381386658926,
                                         0.23087325908181,
                                         5.70464869069653e-14,
                                         1.14845071680197e-07,
                                         0.000167937389586946,
                                         0.0134020201062015,
                                         0.188169584696206,
                                         0.73408086166281,

                                         0.792963138849073,
                                         0.287813619406762,
                                         0.0418955046026501,
                                         0.001953125,
                                         1.80229903005919e-05,
                                         1.00554936355042e-08,
                                         4.47283047134315e-15,
                                         0.18634163036405,
                                         0.384441926922649,
                                         0.159357347810958,
                                         0.017578125,
                                         0.000383801970606365,
                                         6.09774150668569e-07,
                                         1.54173795912652e-12,
                                         0.0194618564249364,
                                         0.22822732059979,
                                         0.269397922730685,
                                         0.0703125,
                                         0.0036324950690339,
                                         1.64343338986463e-05,
                                         2.36187100449204e-10,
                                         0.00118570167034693,
                                         0.0790353374469651,
                                         0.265664292850764,
                                         0.1640625,
                                         0.0200548612000703,
                                         0.000258375896602107,
                                         2.11066144876013e-08,
                                         4.64388089755155e-05,
                                         0.0175950078883927,
                                         0.168417262258783,
                                         0.24609375,
                                         0.0711784885161493,
                                         0.00261135767529592,
                                         1.21253827051535e-06,
                                         1.21253827051534e-06,
                                         0.00261135767529592,
                                         0.0711784885161493,
                                         0.24609375,
                                         0.168417262258783,
                                         0.0175950078883928,
                                         4.64388089755159e-05,
                                         2.1106614487601e-08,
                                         0.000258375896602107,
                                         0.0200548612000703,
                                         0.1640625,
                                         0.265664292850764,
                                         0.0790353374469651,
                                         0.00118570167034694,
                                         2.361871004492e-10,
                                         1.64343338986463e-05,
                                         0.0036324950690339,
                                         0.0703125,
                                         0.269397922730685,
                                         0.22822732059979,
                                         0.0194618564249365,
                                         1.5417379591265e-12,
                                         6.09774150668569e-07,
                                         0.000383801970606365,
                                         0.017578125,
                                         0.159357347810958,
                                         0.384441926922649,
                                         0.18634163036405,
                                         4.47283047134306e-15,
                                         1.00554936355042e-08,
                                         1.80229903005919e-05,
                                         0.001953125,
                                         0.0418955046026501,
                                         0.287813619406762,
                                         0.792963138849073,

                                         0.834858115145607,
                                         0.381010743235229,
                                         0.087402325287584,
                                         0.00889259559384836,
                                         0.000315245284999029,
                                         2.38006603674817e-06,
                                         1.16040849539582e-09,
                                         4.79560216404684e-16,
                                         0.152207602881117,
                                         0.388079990277973,
                                         0.244653036144052,
                                         0.0552227112130797,
                                         0.00411191791263751,
                                         6.88725880843439e-05,
                                         9.22809144079149e-08,
                                         2.13061261026564e-13,
                                         0.0123332490499632,
                                         0.175680177618941,
                                         0.304365703963741,
                                         0.1524138344606,
                                         0.0238373379923246,
                                         0.000885770640384145,
                                         3.26159746436003e-06,
                                         4.20710470388535e-11,
                                         0.000582955562416167,
                                         0.0463917832813303,
                                         0.220880620185582,
                                         0.245384907424297,
                                         0.0806098042817147,
                                         0.00664527492519944,
                                         6.72458714914327e-05,
                                         4.84595014790653e-09,
                                         1.77136424205652e-05,
                                         0.00787542220460056,
                                         0.103046675581335,
                                         0.253971965322744,
                                         0.175239680513756,
                                         0.0320493406180019,
                                         0.000891282471648028,
                                         3.58830241426015e-07,
                                         3.58830241426015e-07,
                                         0.000891282471648028,
                                         0.0320493406180019,
                                         0.175239680513756,
                                         0.253971965322744,
                                         0.103046675581335,
                                         0.00787542220460056,
                                         1.77136424205652e-05,
                                         4.84595014790653e-09,
                                         6.72458714914327e-05,
                                         0.00664527492519944,
                                         0.0806098042817148,
                                         0.245384907424297,
                                         0.220880620185582,
                                         0.0463917832813303,
                                         0.000582955562416167,
                                         4.20710470388534e-11,
                                         3.26159746436003e-06,
                                         0.000885770640384145,
                                         0.0238373379923246,
                                         0.1524138344606,
                                         0.304365703963741,
                                         0.175680177618941,
                                         0.0123332490499632,
                                         2.13061261026564e-13,
                                         9.22809144079149e-08,
                                         6.88725880843439e-05,
                                         0.00411191791263751,
                                         0.0552227112130797,
                                         0.244653036144052,
                                         0.388079990277973,
                                         0.152207602881117,
                                         4.79560216404684e-16,
                                         1.16040849539582e-09,
                                         2.38006603674817e-06,
                                         0.000315245284999029,
                                         0.00889259559384836,
                                         0.087402325287584,
                                         0.381010743235229,
                                         0.834858115145607,

                                         0.865514055653727,
                                         0.463073954063879,
                                         0.144656950071109,
                                         0.0244607617724454,
                                         0.001953125,
                                         5.73831951853805e-05,
                                         3.77029645882362e-07,
                                         1.67333622507954e-10,
                                         6.56837846813454e-17,
                                         0.126016081990981,
                                         0.37219822068189,
                                         0.311990515017672,
                                         0.112337624829852,
                                         0.017578125,
                                         0.00101207916949535,
                                         1.415984281185e-05,
                                         1.68633670750249e-08,
                                         3.65419181086648e-14,
                                         0.00815446179277346,
                                         0.132958379314319,
                                         0.299061811526877,
                                         0.229296791868129,
                                         0.0703125,
                                         0.00793344340247131,
                                         0.00023635176307578,
                                         7.55305863672351e-07,
                                         9.03528785199791e-12,
                                         0.000307809079176318,
                                         0.0277060061756257,
                                         0.167223505112193,
                                         0.273015631735544,
                                         0.1640625,
                                         0.0362765320820695,
                                         0.00230131492606189,
                                         1.97341403613635e-05,
                                         1.30319510568632e-09,
                                         7.46933646073754e-06,
                                         0.00371147564021952,
                                         0.0601101980206355,
                                         0.20897364723627,
                                         0.24609375,
                                         0.106636104708539,
                                         0.0144048166899179,
                                         0.00033145764714034,
                                         1.20834614566922e-07,
                                         1.2083461456692e-07,
                                         0.00033145764714034,
                                         0.0144048166899178,
                                         0.106636104708539,
                                         0.24609375,
                                         0.20897364723627,
                                         0.0601101980206356,
                                         0.00371147564021952,
                                         7.46933646073765e-06,
                                         1.30319510568629e-09,
                                         1.97341403613635e-05,
                                         0.00230131492606188,
                                         0.0362765320820695,
                                         0.1640625,
                                         0.273015631735544,
                                         0.167223505112193,
                                         0.0277060061756257,
                                         0.000307809079176321,
                                         9.03528785199769e-12,
                                         7.55305863672351e-07,
                                         0.000236351763075779,
                                         0.00793344340247132,
                                         0.0703125,
                                         0.229296791868129,
                                         0.299061811526877,
                                         0.132958379314319,
                                         0.00815446179277351,
                                         3.65419181086638e-14,
                                         1.68633670750249e-08,
                                         1.415984281185e-05,
                                         0.00101207916949535,
                                         0.017578125,
                                         0.112337624829852,
                                         0.311990515017672,
                                         0.37219822068189,
                                         0.126016081990981,
                                         6.56837846813433e-17,
                                         1.67333622507954e-10,
                                         3.77029645882362e-07,
                                         5.73831951853805e-05,
                                         0.001953125,
                                         0.0244607617724454,
                                         0.144656950071109,
                                         0.463073954063879,
                                         0.865514055653727,

                                         0.88852425956534,
                                         0.533300959938584,
                                         0.20755808158595,
                                         0.0498912150350392,
                                         0.00681055966738008,
                                         0.000457797270860624,
                                         1.17557662985834e-05,
                                         6.98690834023006e-08,
                                         2.89666899763972e-11,
                                         1.09525890644255e-17,
                                         0.105710244555335,
                                         0.347257115360417,
                                         0.356595690600092,
                                         0.177492777724896,
                                         0.0454094735334404,
                                         0.00556153344838018,
                                         0.00026765746312383,
                                         3.29407605568205e-06,
                                         3.60333883417891e-09,
                                         7.45682626606297e-15,
                                         0.00558962080908566,
                                         0.1004956869068,
                                         0.272288948568944,
                                         0.280643361293379,
                                         0.134563604969729,
                                         0.0300284827816705,
                                         0.00270847762881428,
                                         6.90239295947184e-05,
                                         1.99218109789502e-07,
                                         2.25636179659522e-12,
                                         0.000172410777565855,
                                         0.0169652587091248,
                                         0.121283224080305,
                                         0.25884850111143,
                                         0.232608485657004,
                                         0.0945777590804261,
                                         0.0159877718524998,
                                         0.000843689283255162,
                                         6.42494363471879e-06,
                                         3.9827243106243e-10,
                                         3.41869965174573e-06,
                                         0.00184114513293217,
                                         0.0347284919949928,
                                         0.153479723968527,
                                         0.258486560795834,
                                         0.191495742795276,
                                         0.0606687581559915,
                                         0.00662948601172686,
                                         0.000133206158092031,
                                         4.51924853494426e-08,
                                         4.51924853494426e-08,
                                         0.000133206158092031,
                                         0.00662948601172686,
                                         0.0606687581559915,
                                         0.191495742795276,
                                         0.258486560795834,
                                         0.153479723968527,
                                         0.0347284919949928,
                                         0.00184114513293217,
                                         3.41869965174573e-06,
                                         3.9827243106243e-10,
                                         6.42494363471883e-06,
                                         0.000843689283255162,
                                         0.0159877718524998,
                                         0.0945777590804261,
                                         0.232608485657004,
                                         0.25884850111143,
                                         0.121283224080305,
                                         0.0169652587091248,
                                         0.000172410777565855,
                                         2.25636179659522e-12,
                                         1.99218109789503e-07,
                                         6.90239295947184e-05,
                                         0.00270847762881428,
                                         0.0300284827816705,
                                         0.134563604969729,
                                         0.280643361293379,
                                         0.272288948568944,
                                         0.1004956869068,
                                         0.00558962080908566,
                                         7.45682626606297e-15,
                                         3.60333883417893e-09,
                                         3.29407605568205e-06,
                                         0.00026765746312383,
                                         0.00556153344838018,
                                         0.0454094735334404,
                                         0.177492777724896,
                                         0.356595690600092,
                                         0.347257115360417,
                                         0.105710244555335,
                                         1.09525890644255e-17,
                                         2.89666899763974e-11,
                                         6.98690834023006e-08,
                                         1.17557662985834e-05,
                                         0.000457797270860624,
                                         0.00681055966738008,
                                         0.0498912150350392,
                                         0.20755808158595,
                                         0.533300959938584,
                                         0.88852425956534,

                                         0.906188279745077,
                                         0.592661621384172,
                                         0.271324107858288,
                                         0.0841390013554658,
                                         0.0167323621624069,
                                         0.001953125,
                                         0.000115632816023,
                                         2.68691849984411e-06,
                                         1.48184503966547e-08,
                                         5.83808098680115e-12,
                                         2.14633156915631e-18,
                                         0.0897572748580563,
                                         0.319227864884406,
                                         0.380860407051976,
                                         0.239724752059501,
                                         0.0866456690438467,
                                         0.017578125,
                                         0.00180874156007398,
                                         7.63877973634863e-05,
                                         8.55087122475406e-07,
                                         8.77932539246432e-10,
                                         1.75521618448044e-15,
                                         0.00395128501807154,
                                         0.0764209203151126,
                                         0.237607832532905,
                                         0.303560937254304,
                                         0.199413219356654,
                                         0.0703125,
                                         0.0125744620626961,
                                         0.000965185887167953,
                                         2.19298379895477e-05,
                                         5.86772373555435e-08,
                                         6.37943031839741e-13,
                                         0.00010146677361351,
                                         0.0106718700364353,
                                         0.0864713963544483,
                                         0.224231016629604,
                                         0.267718155497604,
                                         0.1640625,
                                         0.0509940031232733,
                                         0.0071140142825945,
                                         0.000328078125145613,
                                         2.28767836254999e-06,
                                         1.35253955623774e-10,
                                         1.67503473831988e-06,
                                         0.00095803916972009,
                                         0.0202301296125573,
                                         0.106478018516221,
                                         0.231055428925939,
                                         0.24609375,
                                         0.132942325451482,
                                         0.0337079992992782,
                                         0.00315524872111706,
                                         5.733697078296e-05,
                                         1.84345493909534e-08,
                                         1.8434549390953e-08,
                                         5.733697078296e-05,
                                         0.00315524872111706,
                                         0.0337079992992782,
                                         0.132942325451482,
                                         0.24609375,
                                         0.231055428925939,
                                         0.106478018516221,
                                         0.0202301296125573,
                                         0.00095803916972009,
                                         1.67503473831991e-06,
                                         1.3525395562377e-10,
                                         2.28767836254999e-06,
                                         0.000328078125145614,
                                         0.00711401428259451,
                                         0.0509940031232732,
                                         0.1640625,
                                         0.267718155497605,
                                         0.224231016629604,
                                         0.0864713963544482,
                                         0.0106718700364353,
                                         0.000101466773613512,
                                         6.37943031839718e-13,
                                         5.86772373555435e-08,
                                         2.19298379895477e-05,
                                         0.000965185887167954,
                                         0.0125744620626961,
                                         0.0703125,
                                         0.199413219356654,
                                         0.303560937254304,
                                         0.237607832532905,
                                         0.0764209203151126,
                                         0.00395128501807158,
                                         1.75521618448037e-15,
                                         8.77932539246432e-10,
                                         8.55087122475409e-07,
                                         7.63877973634864e-05,
                                         0.00180874156007397,
                                         0.017578125,
                                         0.0866456690438467,
                                         0.239724752059501,
                                         0.380860407051976,
                                         0.319227864884406,
                                         0.0897572748580568,
                                         2.14633156915621e-18,
                                         5.83808098680115e-12,
                                         1.48184503966548e-08,
                                         2.68691849984411e-06,
                                         0.000115632816023,
                                         0.001953125,
                                         0.0167323621624069,
                                         0.0841390013554658,
                                         0.271324107858288,
                                         0.592661621384172,
                                         0.906188279745077,

                                         0.920018017544691,
                                         0.642648116843337,
                                         0.332869886578574,
                                         0.124941120538524,
                                         0.0327358366306177,
                                         0.00564824597051831,
                                         0.00058581398402507,
                                         3.14938468661993e-05,
                                         6.78063257221626e-07,
                                         3.53129647512309e-09,
                                         1.3378089980036e-12,
                                         4.81331016979569e-19,
                                         0.0770508536995015,
                                         0.291247705374337,
                                         0.389474656848333,
                                         0.292347612968695,
                                         0.136165224358977,
                                         0.0395189758349758,
                                         0.00678192017357317,
                                         0.000613292945313636,
                                         2.34725933478027e-05,
                                         2.44463769734291e-07,
                                         2.39105660952087e-10,
                                         4.65530076926346e-16,
                                         0.00286797960842162,
                                         0.058663675198922,
                                         0.202535604508734,
                                         0.304026324791538,
                                         0.251725057756417,
                                         0.122889631711204,
                                         0.0348949913150061,
                                         0.00530796081983809,
                                         0.00036113486633739,
                                         7.52163595611216e-06,
                                         1.89934162449036e-08,
                                         2.00110152775935e-13,
                                         6.22718054329922e-05,
                                         0.00689275459525359,
                                         0.0614384643106245,
                                         0.184433420598578,
                                         0.271458525849408,
                                         0.222916183177939,
                                         0.104734631613306,
                                         0.0267981147184749,
                                         0.00324111588447162,
                                         0.0001349978678587,
                                         8.80102201996518e-07,
                                         5.01773008521791e-11,
                                         8.6920322546622e-07,
                                         0.000520631977531963,
                                         0.0119810200969825,
                                         0.0719254398008224,
                                         0.188189330516301,
                                         0.259945574319763,
                                         0.202084031899689,
                                         0.0869751625577856,
                                         0.0186996798944281,
                                         0.00155760015787021,
                                         2.62166745561584e-05,
                                         8.08835011722743e-09,
                                         8.08835011722767e-09,
                                         2.62166745561583e-05,
                                         0.00155760015787021,
                                         0.0186996798944281,
                                         0.0869751625577855,
                                         0.202084031899689,
                                         0.259945574319763,
                                         0.188189330516301,
                                         0.0719254398008225,
                                         0.0119810200969825,
                                         0.000520631977531965,
                                         8.69203225466199e-07,
                                         5.01773008521809e-11,
                                         8.80102201996511e-07,
                                         0.0001349978678587,
                                         0.00324111588447161,
                                         0.0267981147184748,
                                         0.104734631613306,
                                         0.222916183177939,
                                         0.271458525849408,
                                         0.184433420598578,
                                         0.0614384643106246,
                                         0.00689275459525361,
                                         6.2271805432991e-05,
                                         2.00110152775943e-13,
                                         1.89934162449035e-08,
                                         7.52163595611213e-06,
                                         0.00036113486633739,
                                         0.00530796081983808,
                                         0.0348949913150061,
                                         0.122889631711204,
                                         0.251725057756417,
                                         0.304026324791538,
                                         0.202535604508734,
                                         0.0586636751989222,
                                         0.00286797960842158,
                                         4.65530076926369e-16,
                                         2.39105660952085e-10,
                                         2.4446376973429e-07,
                                         2.34725933478027e-05,
                                         0.000613292945313635,
                                         0.00678192017357317,
                                         0.0395189758349758,
                                         0.136165224358977,
                                         0.292347612968695,
                                         0.389474656848333,
                                         0.291247705374338,
                                         0.077050853699501,
                                         4.81331016979595e-19,
                                         1.33780899800359e-12,
                                         3.53129647512308e-09,
                                         6.78063257221625e-07,
                                         3.14938468661992e-05,
                                         0.00058581398402507,
                                         0.00564824597051831,
                                         0.0327358366306177,
                                         0.124941120538524,
                                         0.332869886578574,
                                         0.642648116843337,
                                         0.920018017544691,

                                         0.931034268387415,
                                         0.684776685230924,
                                         0.390488154604692,
                                         0.169793046370148,
                                         0.0548247896594246,
                                         0.012627930728698,
                                         0.001953125,
                                         0.000184849969628659,
                                         9.21915390796935e-06,
                                         1.87008489560124e-07,
                                         9.31186469577859e-10,
                                         3.42098268889217e-13,
                                         1.21013423862849e-19,
                                         0.0667957839820509,
                                         0.264831393031033,
                                         0.387067677072141,
                                         0.332778991417701,
                                         0.187868679415866,
                                         0.0710787765636639,
                                         0.017578125,
                                         0.00266009195271012,
                                         0.000217920795571245,
                                         7.72876923913341e-06,
                                         7.60926368141927e-08,
                                         7.16498682005776e-11,
                                         1.36626575280558e-16,
                                         0.00212985441592324,
                                         0.045520544302933,
                                         0.170523182747666,
                                         0.289874080362162,
                                         0.286120696087496,
                                         0.177813683592171,
                                         0.0703125,
                                         0.017013411136942,
                                         0.00228941101520067,
                                         0.000141963546603993,
                                         2.76354214828815e-06,
                                         6.66956327403186e-09,
                                         6.85573935226307e-14,
                                         3.96157224031372e-05,
                                         0.00456417430647637,
                                         0.0438224594469777,
                                         0.147292169986169,
                                         0.254191460975531,
                                         0.259481982771236,
                                         0.1640625,
                                         0.063475033495805,
                                         0.0140302579045897,
                                         0.00152110829449592,
                                         5.85472290484752e-05,
                                         3.62156423177821e-07,
                                         2.00673584054183e-11,
                                         4.7369599698267e-07,
                                         0.000294192414765836,
                                         0.00723976616691544,
                                         0.0481132186305477,
                                         0.145173422427208,
                                         0.24342417708731,
                                         0.24609375,
                                         0.152240062701835,
                                         0.055274142565204,
                                         0.0104775056144453,
                                         0.000797372166587034,
                                         1.26418158895968e-05,
                                         3.77607481652501e-09,
                                         3.77607481652514e-09,
                                         1.26418158895968e-05,
                                         0.000797372166587031,
                                         0.0104775056144453,
                                         0.055274142565204,
                                         0.152240062701835,
                                         0.24609375,
                                         0.24342417708731,
                                         0.145173422427208,
                                         0.0481132186305476,
                                         0.00723976616691545,
                                         0.000294192414765835,
                                         4.73695996982657e-07,
                                         2.00673584054191e-11,
                                         3.62156423177824e-07,
                                         5.8547229048475e-05,
                                         0.00152110829449593,
                                         0.0140302579045897,
                                         0.063475033495805,
                                         0.1640625,
                                         0.259481982771236,
                                         0.254191460975531,
                                         0.147292169986169,
                                         0.0438224594469778,
                                         0.00456417430647635,
                                         3.96157224031364e-05,
                                         6.85573935226341e-14,
                                         6.66956327403192e-09,
                                         2.76354214828814e-06,
                                         0.000141963546603994,
                                         0.00228941101520067,
                                         0.017013411136942,
                                         0.0703125,
                                         0.177813683592171,
                                         0.286120696087496,
                                         0.289874080362161,
                                         0.170523182747666,
                                         0.0455205443029329,
                                         0.00212985441592321,
                                         1.36626575280566e-16,
                                         7.16498682005784e-11,
                                         7.60926368141923e-08,
                                         7.72876923913343e-06,
                                         0.000217920795571246,
                                         0.00266009195271012,
                                         0.017578125,
                                         0.0710787765636639,
                                         0.187868679415866,
                                         0.3327789914177,
                                         0.387067677072141,
                                         0.264831393031032,
                                         0.0667957839820504,
                                         1.21013423862857e-19,
                                         3.42098268889221e-13,
                                         9.31186469577855e-10,
                                         1.87008489560124e-07,
                                         9.21915390796935e-06,
                                         0.000184849969628659,
                                         0.001953125,
                                         0.012627930728698,
                                         0.0548247896594246,
                                         0.169793046370148,
                                         0.390488154604692,
                                         0.684776685230924,
                                         0.931034268387415,

                                         0.93994352605176,
                                         0.720401898986882,
                                         0.443412193020801,
                                         0.216493250702587,
                                         0.0822403889442549,
                                         0.0236192537797201,
                                         0.00491792292704952,
                                         0.000697867448607169,
                                         6.14340353347228e-05,
                                         2.88669828447954e-06,
                                         5.58431177012161e-08,
                                         2.682834830134e-10,
                                         9.61706327494035e-14,
                                         3.35607642690437e-20,
                                         0.0584166303171948,
                                         0.240610048760533,
                                         0.377401980196092,
                                         0.361105518939959,
                                         0.236789697463,
                                         0.109724177555486,
                                         0.0356287864630183,
                                         0.00780258751326935,
                                         0.0010711687651019,
                                         8.12098607757627e-05,
                                         2.71184530049678e-06,
                                         2.55318574822688e-08,
                                         2.33232238309374e-11,
                                         4.37403365711576e-17,
                                         0.00161357339411421,
                                         0.0357166037124326,
                                         0.142763833038203,
                                         0.267695685940874,
                                         0.303010676894345,
                                         0.226545780592781,
                                         0.114719652870375,
                                         0.0387723243456328,
                                         0.00830088198271583,
                                         0.00101539172473769,
                                         5.85298818591834e-05,
                                         1.07991200480745e-06,
                                         2.51392414279806e-09,
                                         2.53366901635575e-14,
                                         2.59990656604573e-05,
                                         0.00309273951471022,
                                         0.0315027900516469,
                                         0.115761837742985,
                                         0.226188153126965,
                                         0.27285154385495,
                                         0.215472282453679,
                                         0.112388485745325,
                                         0.0375238483694139,
                                         0.00740585606817343,
                                         0.000736897660569505,
                                         2.6644717527766e-05,
                                         1.58063848330148e-07,
                                         8.56119589561316e-12,
                                         2.69303024629406e-07,
                                         0.000172159504873729,
                                         0.00446883491791109,
                                         0.0321813254038812,
                                         0.108541607994568,
                                         0.21125710633821,
                                         0.26017135194807,
                                         0.209428738284974,
                                         0.109044804726288,
                                         0.0347241312248962,
                                         0.00596418603886725,
                                         0.000422618345672472,
                                         6.38891937657939e-06,
                                         1.85965962576495e-09,
                                         1.85965962576495e-09,
                                         6.38891937657944e-06,
                                         0.000422618345672472,
                                         0.00596418603886724,
                                         0.0347241312248961,
                                         0.109044804726288,
                                         0.209428738284974,
                                         0.26017135194807,
                                         0.21125710633821,
                                         0.108541607994568,
                                         0.0321813254038812,
                                         0.00446883491791109,
                                         0.000172159504873728,
                                         2.69303024629406e-07,
                                         8.56119589561317e-12,
                                         1.5806384833015e-07,
                                         2.6644717527766e-05,
                                         0.000736897660569503,
                                         0.00740585606817342,
                                         0.0375238483694139,
                                         0.112388485745325,
                                         0.215472282453679,
                                         0.27285154385495,
                                         0.226188153126965,
                                         0.115761837742985,
                                         0.0315027900516469,
                                         0.00309273951471021,
                                         2.59990656604573e-05,
                                         2.53366901635575e-14,
                                         2.51392414279809e-09,
                                         1.07991200480745e-06,
                                         5.85298818591833e-05,
                                         0.00101539172473768,
                                         0.00830088198271583,
                                         0.0387723243456328,
                                         0.114719652870375,
                                         0.226545780592781,
                                         0.303010676894345,
                                         0.267695685940874,
                                         0.142763833038203,
                                         0.0357166037124324,
                                         0.00161357339411421,
                                         4.37403365711576e-17,
                                         2.33232238309377e-11,
                                         2.55318574822688e-08,
                                         2.71184530049677e-06,
                                         8.12098607757625e-05,
                                         0.0010711687651019,
                                         0.00780258751326935,
                                         0.0356287864630183,
                                         0.109724177555486,
                                         0.236789697463,
                                         0.361105518939959,
                                         0.377401980196092,
                                         0.240610048760533,
                                         0.0584166303171948,
                                         3.35607642690437e-20,
                                         9.61706327494049e-14,
                                         2.682834830134e-10,
                                         5.58431177012159e-08,
                                         2.88669828447953e-06,
                                         6.14340353347228e-05,
                                         0.000697867448607168,
                                         0.00491792292704952,
                                         0.0236192537797201,
                                         0.0822403889442549,
                                         0.216493250702587,
                                         0.443412193020801,
                                         0.720401898986882,
                                         0.93994352605176,

                                         0.947245932468883,
                                         0.750668620766563,
                                         0.491456015243935,
                                         0.263337287398581,
                                         0.113827309103921,
                                         0.0388614806412547,
                                         0.010168308942307,
                                         0.001953125,
                                         0.000258643425616291,
                                         2.14786686564033e-05,
                                         9.61831946787098e-07,
                                         1.79057071815325e-08,
                                         8.35615457719164e-11,
                                         2.93627172912827e-14,
                                         1.01343880790502e-20,
                                         0.0514923196393769,
                                         0.218751811576882,
                                         0.363270045103649,
                                         0.378759607855378,
                                         0.279773095773075,
                                         0.151990371574695,
                                         0.0608582305722841,
                                         0.017578125,
                                         0.00350038548376106,
                                         0.000444831613088226,
                                         3.16974800698593e-05,
                                         1.00838225905815e-06,
                                         9.15685951584244e-09,
                                         8.16164811116992e-12,
                                         1.51009003712977e-17,
                                         0.00124405518541669,
                                         0.0283316936065772,
                                         0.119341640238462,
                                         0.242120989835997,
                                         0.305620801017244,
                                         0.264198466167207,
                                         0.161885291487656,
                                         0.0703125,
                                         0.0210546383706614,
                                         0.00409450505249555,
                                         0.000464266939833039,
                                         2.5239247156086e-05,
                                         4.45968433171348e-07,
                                         1.00827029096883e-09,
                                         1.00005903001905e-14,
                                         1.75328948834964e-05,
                                         0.00214047524064504,
                                         0.0228702657539518,
                                         0.0902855020095908,
                                         0.194749640565652,
                                         0.267892960155709,
                                         0.25119573183342,
                                         0.1640625,
                                         0.0738748297111628,
                                         0.0219848735868932,
                                         0.00396668372540505,
                                         0.000368505853392585,
                                         1.26700544483296e-05,
                                         7.26595776635417e-08,
                                         3.86336039161224e-12,
                                         1.5884812250597e-07,
                                         0.000103959062532905,
                                         0.00281750628549698,
                                         0.0216430302964904,
                                         0.0797783213165511,
                                         0.174625146736717,
                                         0.250571454464212,
                                         0.24609375,
                                         0.166632485708919,
                                         0.0758858858032842,
                                         0.0217872222463018,
                                         0.00345881121544883,
                                         0.000231402111201771,
                                         3.366070760829e-06,
                                         9.59443232899859e-10,
                                         9.59443232899814e-10,
                                         3.366070760829e-06,
                                         0.00023140211120177,
                                         0.00345881121544884,
                                         0.0217872222463018,
                                         0.0758858858032842,
                                         0.166632485708919,
                                         0.24609375,
                                         0.250571454464212,
                                         0.174625146736717,
                                         0.0797783213165511,
                                         0.0216430302964904,
                                         0.00281750628549698,
                                         0.000103959062532905,
                                         1.58848122505976e-07,
                                         3.86336039161202e-12,
                                         7.26595776635416e-08,
                                         1.26700544483296e-05,
                                         0.000368505853392586,
                                         0.00396668372540505,
                                         0.0219848735868932,
                                         0.0738748297111628,
                                         0.1640625,
                                         0.25119573183342,
                                         0.267892960155709,
                                         0.194749640565652,
                                         0.0902855020095907,
                                         0.0228702657539518,
                                         0.00214047524064504,
                                         1.75328948834969e-05,
                                         1.00005903001899e-14,
                                         1.00827029096883e-09,
                                         4.45968433171346e-07,
                                         2.52392471560861e-05,
                                         0.000464266939833039,
                                         0.00409450505249555,
                                         0.0210546383706614,
                                         0.0703125,
                                         0.161885291487656,
                                         0.264198466167207,
                                         0.305620801017244,
                                         0.242120989835997,
                                         0.119341640238463,
                                         0.0283316936065772,
                                         0.00124405518541671,
                                         1.51009003712966e-17,
                                         8.16164811116991e-12,
                                         9.15685951584239e-09,
                                         1.00838225905815e-06,
                                         3.16974800698593e-05,
                                         0.000444831613088226,
                                         0.00350038548376106,
                                         0.017578125,
                                         0.0608582305722841,
                                         0.151990371574695,
                                         0.279773095773075,
                                         0.378759607855377,
                                         0.36327004510365,
                                         0.218751811576882,
                                         0.0514923196393774,
                                         1.01343880790493e-20,
                                         2.93627172912827e-14,
                                         8.35615457719158e-11,
                                         1.79057071815326e-08,
                                         9.61831946787098e-07,
                                         2.14786686564033e-05,
                                         0.000258643425616291,
                                         0.001953125,
                                         0.010168308942307,
                                         0.0388614806412547,
                                         0.113827309103921,
                                         0.263337287398581,
                                         0.491456015243935,
                                         0.750668620766563,
                                         0.947245932468883,

                                         0.953302865574998,
                                         0.776519502749435,
                                         0.534764056295314,
                                         0.309118289109104,
                                         0.148332980433088,
                                         0.0581557596034312,
                                         0.018218531040955,
                                         0.00442080914296558,
                                         0.000795267477139372,
                                         9.95422912225544e-05,
                                         7.88138645883811e-06,
                                         3.39286340848336e-07,
                                         6.12022894102384e-09,
                                         2.78879067393039e-11,
                                         9.6400597996279e-15,
                                         3.29714496278066e-21,
                                         0.0457107814741542,
                                         0.199193744191715,
                                         0.346638943660327,
                                         0.387648985087177,
                                         0.315310890943157,
                                         0.194562242517366,
                                         0.0919107566586694,
                                         0.0328827227209963,
                                         0.00866028603755126,
                                         0.00159823143084462,
                                         0.000190819086145568,
                                         1.2928559729181e-05,
                                         3.95310852164795e-07,
                                         3.48486366746159e-09,
                                         3.04397737122234e-12,
                                         5.56974501046301e-18,
                                         0.000974145605152381,
                                         0.0227099670514823,
                                         0.0998642347009965,
                                         0.216057866567247,
                                         0.29789121941755,
                                         0.289295631605108,
                                         0.206080456592469,
                                         0.108705434641625,
                                         0.0419149287828918,
                                         0.0114048396478536,
                                         0.00205332872036029,
                                         0.000218953251178895,
                                         1.13482080015214e-05,
                                         1.93541075297835e-07,
                                         4.27189523214429e-10,
                                         4.18167297690924e-15,
                                         1.21100489608048e-05,
                                         0.0015103378534825,
                                         0.0167826059563476,
                                         0.0702454678738222,
                                         0.164169783982741,
                                         0.250923873032687,
                                         0.269540523993972,
                                         0.2096290843123,
                                         0.11833739989264,
                                         0.0474739637295832,
                                         0.0128887840105263,
                                         0.00216306437351521,
                                         0.000190034578480861,
                                         6.2701409058538e-06,
                                         3.49716852170135e-08,
                                         1.83139326801538e-12,
                                         9.67792820935891e-08,
                                         6.45722893338871e-05,
                                         0.00181310640087947,
                                         0.0146818576618577,
                                         0.0581625213561258,
                                         0.139912514745722,
                                         0.226634385384579,
                                         0.259876070600716,
                                         0.214777996391175,
                                         0.127038769229853,
                                         0.0520091652921943,
                                         0.0137373183965751,
                                         0.00204574948322875,
                                         0.000130585791402548,
                                         1.84046262241045e-06,
                                         5.15617482795463e-10,
                                         5.1561748279549e-10,
                                         1.84046262241045e-06,
                                         0.000130585791402547,
                                         0.00204574948322876,
                                         0.0137373183965751,
                                         0.0520091652921943,
                                         0.127038769229853,
                                         0.214777996391175,
                                         0.259876070600716,
                                         0.226634385384579,
                                         0.139912514745722,
                                         0.0581625213561258,
                                         0.0146818576618577,
                                         0.00181310640087948,
                                         6.45722893338871e-05,
                                         9.67792820935851e-08,
                                         1.8313932680155e-12,
                                         3.49716852170135e-08,
                                         6.27014090585377e-06,
                                         0.000190034578480862,
                                         0.00216306437351521,
                                         0.0128887840105263,
                                         0.0474739637295832,
                                         0.11833739989264,
                                         0.2096290843123,
                                         0.269540523993972,
                                         0.250923873032687,
                                         0.164169783982741,
                                         0.0702454678738221,
                                         0.0167826059563476,
                                         0.0015103378534825,
                                         1.21100489608045e-05,
                                         4.18167297690954e-15,
                                         4.27189523214429e-10,
                                         1.93541075297834e-07,
                                         1.13482080015215e-05,
                                         0.000218953251178895,
                                         0.00205332872036029,
                                         0.0114048396478536,
                                         0.0419149287828918,
                                         0.108705434641625,
                                         0.206080456592469,
                                         0.289295631605108,
                                         0.29789121941755,
                                         0.216057866567247,
                                         0.0998642347009966,
                                         0.0227099670514823,
                                         0.000974145605152361,
                                         5.56974501046348e-18,
                                         3.04397737122234e-12,
                                         3.48486366746157e-09,
                                         3.95310852164797e-07,
                                         1.2928559729181e-05,
                                         0.000190819086145568,
                                         0.00159823143084462,
                                         0.00866028603755125,
                                         0.0328827227209962,
                                         0.0919107566586694,
                                         0.194562242517366,
                                         0.315310890943157,
                                         0.387648985087177,
                                         0.346638943660327,
                                         0.199193744191715,
                                         0.0457107814741537,
                                         3.29714496278097e-21,
                                         9.6400597996279e-15,
                                         2.78879067393037e-11,
                                         6.12022894102386e-09,
                                         3.39286340848336e-07,
                                         7.88138645883811e-06,
                                         9.95422912225545e-05,
                                         0.000795267477139371,
                                         0.00442080914296557,
                                         0.018218531040955,
                                         0.0581557596034312,
                                         0.148332980433088,
                                         0.309118289109104,
                                         0.534764056295314,
                                         0.776519502749435,
                                         0.953302865574998,

                                         0.958380306170332,
                                         0.798721448632662,
                                         0.573651149207693,
                                         0.353047551563617,
                                         0.184593104009144,
                                         0.0809992224496767,
                                         0.0293290941677352,
                                         0.00856335318361979,
                                         0.001953125,
                                         0.000332869046348808,
                                         3.97682287702796e-05,
                                         3.0267297331653e-06,
                                         1.26101845963926e-07,
                                         2.21586089490036e-09,
                                         9.89837139941849e-12,
                                         3.37514579557141e-15,
                                         1.14568478577711e-21,
                                         0.04083769276333,
                                         0.181767118311709,
                                         0.3288456804156,
                                         0.389681760714785,
                                         0.343086073885203,
                                         0.234843267400552,
                                         0.126736261651028,
                                         0.0537252615624158,
                                         0.017578125,
                                         0.00429757780819562,
                                         0.000745450867926293,
                                         8.45593036193704e-05,
                                         5.49564720956808e-06,
                                         1.6261126831117e-07,
                                         1.39863531682145e-09,
                                         1.20131688559612e-12,
                                         2.17784440253807e-18,
                                         0.000773396132572093,
                                         0.0183845404738358,
                                         0.0837826122314988,
                                         0.191163263307023,
                                         0.283405444581703,
                                         0.302616678560679,
                                         0.243400024190129,
                                         0.149806515589461,
                                         0.0703125,
                                         0.0246599145220503,
                                         0.00621039584920958,
                                         0.00104994520437082,
                                         0.000106447074218876,
                                         5.30366717967475e-06,
                                         8.78340114089731e-08,
                                         1.9003784949405e-10,
                                         1.83995004580959e-15,
                                         8.54396751674061e-06,
                                         0.00108469348078193,
                                         0.0124518088860192,
                                         0.0547035595144176,
                                         0.136562067297722,
                                         0.227470142852168,
                                         0.2726824174259,
                                         0.243668652050026,
                                         0.1640625,
                                         0.0825422264902717,
                                         0.0301811883075765,
                                         0.00760481519573969,
                                         0.00120272241896914,
                                         0.000100906393159936,
                                         3.217642122994e-06,
                                         1.75363589680459e-08,
                                         9.06780161838982e-13,
                                         6.06780554967066e-08,
                                         4.11410862929229e-05,
                                         0.001189667149679,
                                         0.0100633183332449,
                                         0.0423025404644418,
                                         0.109918404086455,
                                         0.196384916202321,
                                         0.254790418839474,
                                         0.24609375,
                                         0.177613210908137,
                                         0.094290483109404,
                                         0.0354099382170062,
                                         0.00873597851954204,
                                         0.00123417167944415,
                                         7.57752248411315e-05,
                                         1.04028711726718e-06,
                                         2.87284676714703e-10,
                                         2.87284676714686e-10,
                                         1.04028711726719e-06,
                                         7.57752248411315e-05,
                                         0.00123417167944416,
                                         0.00873597851954206,
                                         0.0354099382170062,
                                         0.094290483109404,
                                         0.177613210908137,
                                         0.24609375,
                                         0.254790418839474,
                                         0.196384916202321,
                                         0.109918404086455,
                                         0.0423025404644418,
                                         0.0100633183332449,
                                         0.001189667149679,
                                         4.11410862929225e-05,
                                         6.06780554967095e-08,
                                         9.06780161838918e-13,
                                         1.75363589680462e-08,
                                         3.217642122994e-06,
                                         0.000100906393159936,
                                         0.00120272241896914,
                                         0.0076048151957397,
                                         0.0301811883075765,
                                         0.0825422264902717,
                                         0.1640625,
                                         0.243668652050026,
                                         0.2726824174259,
                                         0.227470142852168,
                                         0.136562067297722,
                                         0.0547035595144175,
                                         0.0124518088860192,
                                         0.00108469348078192,
                                         8.54396751674091e-06,
                                         1.83995004580944e-15,
                                         1.90037849494053e-10,
                                         8.78340114089731e-08,
                                         5.30366717967477e-06,
                                         0.000106447074218877,
                                         0.00104994520437083,
                                         0.00621039584920958,
                                         0.0246599145220503,
                                         0.0703125,
                                         0.149806515589461,
                                         0.243400024190129,
                                         0.302616678560679,
                                         0.283405444581703,
                                         0.191163263307023,
                                         0.0837826122314988,
                                         0.0183845404738357,
                                         0.000773396132572111,
                                         2.17784440253786e-18,
                                         1.20131688559614e-12,
                                         1.39863531682145e-09,
                                         1.62611268311171e-07,
                                         5.49564720956809e-06,
                                         8.45593036193705e-05,
                                         0.000745450867926293,
                                         0.00429757780819562,
                                         0.017578125,
                                         0.0537252615624158,
                                         0.126736261651028,
                                         0.234843267400552,
                                         0.343086073885203,
                                         0.389681760714785,
                                         0.3288456804156,
                                         0.181767118311709,
                                         0.0408376927633305,
                                         1.14568478577699e-21,
                                         3.37514579557147e-15,
                                         9.89837139941849e-12,
                                         2.21586089490037e-09,
                                         1.26101845963926e-07,
                                         3.02672973316531e-06,
                                         3.97682287702796e-05,
                                         0.000332869046348808,
                                         0.001953125,
                                         0.00856335318361979,
                                         0.0293290941677352,
                                         0.0809992224496767,
                                         0.184593104009144,
                                         0.353047551563617,
                                         0.573651149207693,
                                         0.798721448632662,
                                         0.958380306170332,

                                         0.962677313910663,
                                         0.817895611384855,
                                         0.608505705582312,
                                         0.394656747783505,
                                         0.22162066099343,
                                         0.106727709473724,
                                         0.0435064274425506,
                                         0.0147507393130043,
                                         0.00406244127467545,
                                         0.000879996318562521,
                                         0.000143363600208042,
                                         1.64732672540766e-05,
                                         1.21294015235435e-06,
                                         4.91649981499378e-08,
                                         8.45111464068134e-10,
                                         3.71260551996076e-12,
                                         1.25144568316588e-15,
                                         4.22102356649563e-22,
                                         0.0366948519833707,
                                         0.166263727385119,
                                         0.310772133888108,
                                         0.386550172195887,
                                         0.363516818498379,
                                         0.271105119523125,
                                         0.163154424799031,
                                         0.079333951690994,
                                         0.030847345727362,
                                         0.00938718051182295,
                                         0.00215912913618917,
                                         0.00035581096620908,
                                         3.86779868922917e-05,
                                         2.42787757125483e-06,
                                         6.98896190948483e-08,
                                         5.88825229179518e-10,
                                         4.98651797405812e-13,
                                         8.96970981362501e-19,
                                         0.000621651555683724,
                                         0.0150215458953183,
                                         0.070540245512075,
                                         0.168271161051957,
                                         0.265006333572846,
                                         0.306066453049615,
                                         0.271932911436825,
                                         0.189636472747589,
                                         0.104103657446379,
                                         0.0445048114168335,
                                         0.0144522617703858,
                                         0.00341567385704345,
                                         0.000548158095988327,
                                         5.3286233185881e-05,
                                         2.56879138428022e-06,
                                         4.15060586491322e-08,
                                         8.83080418825007e-11,
                                         8.47142540699347e-16,
                                         6.14335628971851e-06,
                                         0.000791677932622364,
                                         0.0093400383164308,
                                         0.0427297454399559,
                                         0.112695037482896,
                                         0.201562871298179,
                                         0.264387843447072,
                                         0.264424349230215,
                                         0.204941999241714,
                                         0.123082286327198,
                                         0.0564299693586503,
                                         0.0191271496758387,
                                         0.00453173595711367,
                                         0.000682213097195969,
                                         5.50759240426674e-05,
                                         1.70668501372075e-06,
                                         9.1226269365785e-09,
                                         4.66714595958558e-13,
                                         3.90282299989274e-08,
                                         2.68223560835327e-05,
                                         0.000795014084383486,
                                         0.00697534019561142,
                                         0.0308083049828649,
                                         0.0853335504968222,
                                         0.165247792326867,
                                         0.237025730288406,
                                         0.259364434553004,
                                         0.21882584718245,
                                         0.141644032864359,
                                         0.0688554927813087,
                                         0.0240845111783888,
                                         0.00561486809663214,
                                         0.000759117882925893,
                                         4.51138330811218e-05,
                                         6.05834566664204e-07,
                                         1.65295392834739e-10,
                                         1.65295392834739e-10,
                                         6.05834566664204e-07,
                                         4.51138330811218e-05,
                                         0.000759117882925891,
                                         0.00561486809663214,
                                         0.0240845111783888,
                                         0.0688554927813087,
                                         0.141644032864359,
                                         0.21882584718245,
                                         0.259364434553004,
                                         0.237025730288406,
                                         0.165247792326867,
                                         0.0853335504968222,
                                         0.0308083049828649,
                                         0.00697534019561144,
                                         0.000795014084383486,
                                         2.68223560835327e-05,
                                         3.90282299989274e-08,
                                         4.66714595958558e-13,
                                         9.1226269365785e-09,
                                         1.70668501372075e-06,
                                         5.50759240426672e-05,
                                         0.000682213097195969,
                                         0.00453173595711367,
                                         0.0191271496758387,
                                         0.0564299693586503,
                                         0.123082286327198,
                                         0.204941999241714,
                                         0.264424349230215,
                                         0.264387843447072,
                                         0.201562871298179,
                                         0.112695037482896,
                                         0.042729745439956,
                                         0.0093400383164308,
                                         0.000791677932622364,
                                         6.14335628971851e-06,
                                         8.47142540699347e-16,
                                         8.83080418825007e-11,
                                         4.15060586491322e-08,
                                         2.56879138428021e-06,
                                         5.3286233185881e-05,
                                         0.000548158095988326,
                                         0.00341567385704345,
                                         0.0144522617703858,
                                         0.0445048114168335,
                                         0.104103657446379,
                                         0.189636472747589,
                                         0.271932911436825,
                                         0.306066453049615,
                                         0.265006333572846,
                                         0.168271161051957,
                                         0.070540245512075,
                                         0.0150215458953183,
                                         0.000621651555683724,
                                         8.96970981362501e-19,
                                         4.98651797405812e-13,
                                         5.88825229179518e-10,
                                         6.9889619094848e-08,
                                         2.42787757125483e-06,
                                         3.86779868922916e-05,
                                         0.00035581096620908,
                                         0.00215912913618917,
                                         0.00938718051182295,
                                         0.030847345727362,
                                         0.079333951690994,
                                         0.163154424799031,
                                         0.271105119523125,
                                         0.363516818498379,
                                         0.386550172195887,
                                         0.310772133888108,
                                         0.166263727385119,
                                         0.0366948519833707,
                                         4.22102356649563e-22,
                                         1.25144568316588e-15,
                                         3.71260551996076e-12,
                                         8.45111464068129e-10,
                                         4.91649981499378e-08,
                                         1.21294015235435e-06,
                                         1.64732672540766e-05,
                                         0.000143363600208042,
                                         0.000879996318562521,
                                         0.00406244127467545,
                                         0.0147507393130043,
                                         0.0435064274425506,
                                         0.106727709473724,
                                         0.22162066099343,
                                         0.394656747783505,
                                         0.608505705582312,
                                         0.817895611384855,
                                         0.962677313910663,

                                         0.966345130751693,
                                         0.834544997363187,
                                         0.63973385939736,
                                         0.4337087769054,
                                         0.258631283365172,
                                         0.134629980923689,
                                         0.0605512652688731,
                                         0.0232117623951518,
                                         0.00744835248827616,
                                         0.001953125,
                                         0.00040511136159258,
                                         6.3534575286734e-05,
                                         7.06397145123984e-06,
                                         5.05752237101432e-07,
                                         2.00281888762798e-08,
                                         3.37897934302451e-10,
                                         1.46348542129955e-12,
                                         4.88513991206721e-16,
                                         1.63881911839792e-22,
                                         0.0331450805407356,
                                         0.152469924084304,
                                         0.292981792402822,
                                         0.379660021280277,
                                         0.377405372328941,
                                         0.302401438253441,
                                         0.199231258280367,
                                         0.108444218948088,
                                         0.0485069880338517,
                                         0.017578125,
                                         0.00503866349111065,
                                         0.00110153134817836,
                                         0.000173900046829507,
                                         1.82381491587256e-05,
                                         1.11173089298539e-06,
                                         3.12661134142859e-08,
                                         2.58840437468728e-10,
                                         2.16584613038332e-13,
                                         3.87016271501656e-19,
                                         0.000505269841127986,
                                         0.0123804403457237,
                                         0.059634750655309,
                                         0.147709696699677,
                                         0.244766841143218,
                                         0.301886298464837,
                                         0.291346104089369,
                                         0.225176039305873,
                                         0.140399602421835,
                                         0.0703125,
                                         0.0278531147329687,
                                         0.00848791600159717,
                                         0.00190268960022777,
                                         0.00029230833275843,
                                         2.74268007635062e-05,
                                         1.2858187159755e-06,
                                         2.03466695462182e-08,
                                         4.26771760430174e-11,
                                         4.06204667537187e-16,
                                         4.49308328043373e-06,
                                         0.000586414625989298,
                                         0.00708068016669876,
                                         0.0335227732122794,
                                         0.0926006173579943,
                                         0.175800354458783,
                                         0.248529385609854,
                                         0.27274370807498,
                                         0.237052337052224,
                                         0.1640625,
                                         0.0898150209190093,
                                         0.0381524189926736,
                                         0.0121437546384281,
                                         0.00273286653429386,
                                         0.000394700269797864,
                                         3.08462504840309e-05,
                                         9.32977847826665e-07,
                                         4.90546908595889e-09,
                                         2.48700917884197e-13,
                                         2.56850274412078e-08,
                                         1.78561559071138e-05,
                                         0.000540461822833831,
                                         0.00489086128329377,
                                         0.0225211028980197,
                                         0.0658128296895151,
                                         0.136288983103356,
                                         0.212374211342194,
                                         0.257298395738922,
                                         0.24609375,
                                         0.18618241376021,
                                         0.110244659015977,
                                         0.0498255953912449,
                                         0.0164251794412873,
                                         0.00365152407701096,
                                         0.000475706945861307,
                                         2.75019701557902e-05,
                                         3.62476525025571e-07,
                                         9.78868471796072e-11,
                                         9.78868471796072e-11,
                                         3.62476525025571e-07,
                                         2.75019701557902e-05,
                                         0.000475706945861307,
                                         0.00365152407701096,
                                         0.0164251794412873,
                                         0.0498255953912449,
                                         0.110244659015977,
                                         0.18618241376021,
                                         0.24609375,
                                         0.257298395738922,
                                         0.212374211342194,
                                         0.136288983103356,
                                         0.065812829689515,
                                         0.0225211028980198,
                                         0.00489086128329377,
                                         0.000540461822833831,
                                         1.78561559071138e-05,
                                         2.56850274412078e-08,
                                         2.48700917884197e-13,
                                         4.90546908595889e-09,
                                         9.32977847826665e-07,
                                         3.08462504840309e-05,
                                         0.000394700269797863,
                                         0.00273286653429387,
                                         0.0121437546384281,
                                         0.0381524189926735,
                                         0.0898150209190093,
                                         0.1640625,
                                         0.237052337052224,
                                         0.27274370807498,
                                         0.248529385609854,
                                         0.175800354458783,
                                         0.0926006173579944,
                                         0.0335227732122794,
                                         0.00708068016669876,
                                         0.000586414625989298,
                                         4.49308328043373e-06,
                                         4.06204667537187e-16,
                                         4.26771760430174e-11,
                                         2.03466695462182e-08,
                                         1.2858187159755e-06,
                                         2.74268007635061e-05,
                                         0.00029230833275843,
                                         0.00190268960022777,
                                         0.00848791600159716,
                                         0.0278531147329687,
                                         0.0703125,
                                         0.140399602421835,
                                         0.225176039305873,
                                         0.291346104089369,
                                         0.301886298464837,
                                         0.244766841143218,
                                         0.147709696699677,
                                         0.059634750655309,
                                         0.0123804403457237,
                                         0.000505269841127986,
                                         3.87016271501656e-19,
                                         2.16584613038332e-13,
                                         2.58840437468728e-10,
                                         3.12661134142859e-08,
                                         1.11173089298539e-06,
                                         1.82381491587256e-05,
                                         0.000173900046829507,
                                         0.00110153134817836,
                                         0.00503866349111065,
                                         0.017578125,
                                         0.0485069880338517,
                                         0.108444218948088,
                                         0.199231258280367,
                                         0.302401438253441,
                                         0.377405372328941,
                                         0.379660021280277,
                                         0.292981792402822,
                                         0.152469924084304,
                                         0.0331450805407356,
                                         1.63881911839792e-22,
                                         4.88513991206721e-16,
                                         1.46348542129955e-12,
                                         3.37897934302451e-10,
                                         2.00281888762797e-08,
                                         5.05752237101434e-07,
                                         7.06397145123984e-06,
                                         6.35345752867339e-05,
                                         0.00040511136159258,
                                         0.001953125,
                                         0.00744835248827616,
                                         0.0232117623951518,
                                         0.0605512652688731,
                                         0.134629980923689,
                                         0.258631283365172,
                                         0.4337087769054,
                                         0.63973385939736,
                                         0.834544997363187,
                                         0.966345130751693,

                                         0.969500252540025,
                                         0.849077868147307,
                                         0.667728997078888,
                                         0.470125933409015,
                                         0.295033369280832,
                                         0.164024220409416,
                                         0.0801246534175718,
                                         0.0340231443469457,
                                         0.0123832219731749,
                                         0.00379273623224631,
                                         0.000954003320965617,
                                         0.000190708403866699,
                                         2.89556784598906e-05,
                                         3.13020441710102e-06,
                                         2.18809424063584e-07,
                                         8.49420315098025e-09,
                                         1.4103344924294e-10,
                                         6.03458927396183e-13,
                                         1.99755761878828e-16,
                                         6.67018036452716e-23,
                                         0.0300815629521852,
                                         0.140183140501664,
                                         0.275820028665886,
                                         0.370132821650419,
                                         0.385702722577114,
                                         0.328390264901827,
                                         0.233458343480037,
                                         0.139605112695227,
                                         0.0700956871796734,
                                         0.0292816027162519,
                                         0.0100090463862216,
                                         0.00272896025379432,
                                         0.000571599563366141,
                                         8.70190791424562e-05,
                                         8.85255737434961e-06,
                                         5.26291186170121e-07,
                                         1.45098778741054e-08,
                                         1.18333353570163e-10,
                                         9.80022552139957e-14,
                                         1.74128607018262e-19,
                                         0.00041483018460078,
                                         0.0102863555435936,
                                         0.050637102141779,
                                         0.129514522648562,
                                         0.22410510613092,
                                         0.292206617922687,
                                         0.302322254224997,
                                         0.254592544310493,
                                         0.17634632737871,
                                         0.100474193608132,
                                         0.0466716332741835,
                                         0.0173556974727287,
                                         0.00501496046092873,
                                         0.00107516160832206,
                                         0.00015918016816391,
                                         1.44926242425244e-05,
                                         6.63472411219081e-07,
                                         1.03129784583542e-08,
                                         2.13693004935257e-11,
                                         2.02031996638317e-16,
                                         3.33700683567683e-06,
                                         0.000440295322446271,
                                         0.00542286362114314,
                                         0.0264360238113597,
                                         0.0759569632212813,
                                         0.151672419675054,
                                         0.228374510080601,
                                         0.270836275602571,
                                         0.258796462162889,
                                         0.201108769424274,
                                         0.126949235712979,
                                         0.0643878207344867,
                                         0.0256661029643434,
                                         0.00774907398451173,
                                         0.00166965200051269,
                                         0.000232800957068437,
                                         1.76969642673624e-05,
                                         5.24297567222459e-07,
                                         2.7180743767055e-09,
                                         1.36737293655263e-13,
                                         1.72567225461933e-08,
                                         1.21154928509657e-05,
                                         0.000373338686297954,
                                         0.00346887198768339,
                                         0.0165499965786646,
                                         0.0506101537434212,
                                         0.110902060190773,
                                         0.18521768785727,
                                         0.244154495147721,
                                         0.258774788105428,
                                         0.221983991219318,
                                         0.153560619292955,
                                         0.0844436165203947,
                                         0.0359037937296271,
                                         0.01125841981212,
                                         0.00240401384448774,
                                         0.00030345140537017,
                                         1.71350765234378e-05,
                                         2.22252595078333e-07,
                                         5.94933299411754e-11,
                                         5.94933299411706e-11,
                                         2.22252595078329e-07,
                                         1.71350765234378e-05,
                                         0.000303451405370169,
                                         0.00240401384448774,
                                         0.01125841981212,
                                         0.0359037937296271,
                                         0.0844436165203947,
                                         0.153560619292955,
                                         0.221983991219318,
                                         0.258774788105428,
                                         0.244154495147721,
                                         0.18521768785727,
                                         0.110902060190773,
                                         0.0506101537434211,
                                         0.0165499965786646,
                                         0.0034688719876834,
                                         0.000373338686297954,
                                         1.21154928509658e-05,
                                         1.72567225461944e-08,
                                         1.36737293655249e-13,
                                         2.71807437670545e-09,
                                         5.24297567222459e-07,
                                         1.76969642673623e-05,
                                         0.000232800957068437,
                                         0.00166965200051269,
                                         0.00774907398451173,
                                         0.0256661029643434,
                                         0.0643878207344867,
                                         0.126949235712979,
                                         0.201108769424274,
                                         0.258796462162889,
                                         0.270836275602571,
                                         0.228374510080601,
                                         0.151672419675054,
                                         0.0759569632212813,
                                         0.0264360238113597,
                                         0.00542286362114314,
                                         0.000440295322446275,
                                         3.337006835677e-06,
                                         2.02031996638294e-16,
                                         2.13693004935252e-11,
                                         1.03129784583542e-08,
                                         6.63472411219078e-07,
                                         1.44926242425244e-05,
                                         0.00015918016816391,
                                         0.00107516160832206,
                                         0.00501496046092873,
                                         0.0173556974727287,
                                         0.0466716332741835,
                                         0.100474193608132,
                                         0.17634632737871,
                                         0.254592544310493,
                                         0.302322254224997,
                                         0.292206617922687,
                                         0.22410510613092,
                                         0.129514522648563,
                                         0.050637102141779,
                                         0.0102863555435937,
                                         0.000414830184600794,
                                         1.74128607018239e-19,
                                         9.80022552139933e-14,
                                         1.18333353570163e-10,
                                         1.45098778741053e-08,
                                         5.26291186170121e-07,
                                         8.85255737434963e-06,
                                         8.70190791424562e-05,
                                         0.000571599563366141,
                                         0.00272896025379432,
                                         0.0100090463862216,
                                         0.0292816027162519,
                                         0.0700956871796734,
                                         0.139605112695227,
                                         0.233458343480037,
                                         0.328390264901827,
                                         0.385702722577114,
                                         0.37013282165042,
                                         0.275820028665886,
                                         0.140183140501665,
                                         0.0300815629521857,
                                         6.67018036452619e-23,
                                         1.99755761878823e-16,
                                         6.03458927396183e-13,
                                         1.41033449242939e-10,
                                         8.49420315098025e-09,
                                         2.18809424063585e-07,
                                         3.13020441710102e-06,
                                         2.89556784598906e-05,
                                         0.000190708403866699,
                                         0.000954003320965617,
                                         0.00379273623224631,
                                         0.0123832219731749,
                                         0.0340231443469457,
                                         0.0801246534175718,
                                         0.164024220409416,
                                         0.295033369280832,
                                         0.470125933409015,
                                         0.667728997078888,
                                         0.849077868147307,
                                         0.969500252540025,

                                         0.972233537294956,
                                         0.861826821754566,
                                         0.692856526359391,
                                         0.503935792598157,
                                         0.330402195414323,
                                         0.194301378187792,
                                         0.101811169630528,
                                         0.0471258172473941,
                                         0.0190562523421442,
                                         0.00663585568443234,
                                         0.001953125,
                                         0.000474084437537328,
                                         9.18190843732838e-05,
                                         1.35584524777143e-05,
                                         1.43072537794144e-06,
                                         9.79712299879971e-08,
                                         3.73854423453418e-09,
                                         6.12226922291294e-11,
                                         2.59229024514222e-13,
                                         8.51912663740795e-17,
                                         2.83329951948509e-23,
                                         0.0274202301213695,
                                         0.129219010757554,
                                         0.259485158547622,
                                         0.3588389921494,
                                         0.389366624913519,
                                         0.349148193504701,
                                         0.264789191343279,
                                         0.171416072653655,
                                         0.0948034069391898,
                                         0.0445452629713639,
                                         0.017578125,
                                         0.00572052810311582,
                                         0.00149496672692265,
                                         0.000301927378466852,
                                         4.45591064203065e-05,
                                         4.41620943326559e-06,
                                         2.56963680604259e-07,
                                         6.96422862421643e-09,
                                         5.60659820368998e-11,
                                         4.60228688542743e-14,
                                         8.13723783316347e-20,
                                         0.000343707551765931,
                                         0.00861093477749811,
                                         0.0431915923875212,
                                         0.113564222689665,
                                         0.203935110602507,
                                         0.278843932873933,
                                         0.306071267280261,
                                         0.277116042687271,
                                         0.209617663790779,
                                         0.132899578528814,
                                         0.0703125,
                                         0.0306784935223099,
                                         0.0108180149638119,
                                         0.00298821850609684,
                                         0.000616785488470345,
                                         8.84745257963467e-05,
                                         7.84979737891243e-06,
                                         3.5208789830803e-07,
                                         5.38930451369099e-09,
                                         1.1050190929077e-11,
                                         1.03867340844282e-16,
                                         2.51318146105458e-06,
                                         0.000334727182139195,
                                         0.00419375159510709,
                                         0.0209652589556953,
                                         0.0623077511715038,
                                         0.129906054799834,
                                         0.206377175384674,
                                         0.26132959193034,
                                         0.270363837424305,
                                         0.231292991975816,
                                         0.1640625,
                                         0.0959729246850546,
                                         0.0456646804433749,
                                         0.0172519821374087,
                                         0.00498022100203002,
                                         0.00103395971953299,
                                         0.000139882035474028,
                                         1.03835526728609e-05,
                                         3.02191891593047e-07,
                                         1.54768534691206e-09,
                                         7.73388679373243e-14,
                                         1.18133506260594e-08,
                                         8.36461847822913e-06,
                                         0.000261770476321586,
                                         0.00248813192219903,
                                         0.0122378922397782,
                                         0.038905594993471,
                                         0.0894571875563516,
                                         0.158427287254306,
                                         0.224173256811638,
                                         0.258771127667505,
                                         0.24609375,
                                         0.19300915242405,
                                         0.123916101473461,
                                         0.0640295017525838,
                                         0.0258510124826093,
                                         0.00776789721427686,
                                         0.00160243312329033,
                                         0.000196859018860631,
                                         1.08929965163057e-05,
                                         1.3935098197321e-07,
                                         3.70195454584342e-11,
                                         3.70195454584375e-11,
                                         1.39350981973208e-07,
                                         1.08929965163058e-05,
                                         0.000196859018860631,
                                         0.00160243312329033,
                                         0.00776789721427686,
                                         0.0258510124826093,
                                         0.0640295017525837,
                                         0.123916101473461,
                                         0.19300915242405,
                                         0.24609375,
                                         0.258771127667505,
                                         0.224173256811638,
                                         0.158427287254306,
                                         0.0894571875563516,
                                         0.038905594993471,
                                         0.0122378922397782,
                                         0.00248813192219903,
                                         0.000261770476321585,
                                         8.36461847822925e-06,
                                         1.18133506260586e-08,
                                         7.73388679373326e-14,
                                         1.54768534691203e-09,
                                         3.0219189159305e-07,
                                         1.03835526728609e-05,
                                         0.000139882035474028,
                                         0.00103395971953299,
                                         0.00498022100203002,
                                         0.0172519821374087,
                                         0.0456646804433749,
                                         0.0959729246850546,
                                         0.1640625,
                                         0.231292991975816,
                                         0.270363837424305,
                                         0.26132959193034,
                                         0.206377175384674,
                                         0.129906054799834,
                                         0.0623077511715038,
                                         0.0209652589556953,
                                         0.00419375159510707,
                                         0.000334727182139198,
                                         2.51318146105445e-06,
                                         1.03867340844295e-16,
                                         1.10501909290767e-11,
                                         5.38930451369104e-09,
                                         3.5208789830803e-07,
                                         7.84979737891243e-06,
                                         8.84745257963467e-05,
                                         0.000616785488470345,
                                         0.00298821850609684,
                                         0.0108180149638119,
                                         0.0306784935223099,
                                         0.0703125,
                                         0.132899578528814,
                                         0.209617663790779,
                                         0.277116042687271,
                                         0.306071267280261,
                                         0.278843932873933,
                                         0.203935110602507,
                                         0.113564222689665,
                                         0.0431915923875211,
                                         0.00861093477749817,
                                         0.000343707551765919,
                                         8.13723783316463e-20,
                                         4.6022868854273e-14,
                                         5.60659820369004e-11,
                                         6.96422862421643e-09,
                                         2.56963680604259e-07,
                                         4.41620943326559e-06,
                                         4.45591064203065e-05,
                                         0.000301927378466852,
                                         0.00149496672692265,
                                         0.00572052810311582,
                                         0.017578125,
                                         0.0445452629713639,
                                         0.0948034069391898,
                                         0.171416072653655,
                                         0.264789191343279,
                                         0.349148193504701,
                                         0.389366624913519,
                                         0.3588389921494,
                                         0.259485158547622,
                                         0.129219010757555,
                                         0.027420230121369,
                                         2.83329951948554e-23,
                                         8.5191266374077e-17,
                                         2.59229024514226e-13,
                                         6.12226922291294e-11,
                                         3.73854423453418e-09,
                                         9.79712299879971e-08,
                                         1.43072537794144e-06,
                                         1.35584524777143e-05,
                                         9.18190843732838e-05,
                                         0.000474084437537328,
                                         0.001953125,
                                         0.00663585568443234,
                                         0.0190562523421442,
                                         0.0471258172473941,
                                         0.101811169630528,
                                         0.194301378187792,
                                         0.330402195414323,
                                         0.503935792598157,
                                         0.692856526359391,
                                         0.861826821754566,
                                         0.972233537294956,

                                         0.974616658711705,
                                         0.873064049696355,
                                         0.715447529495134,
                                         0.535232142709016,
                                         0.364449348393076,
                                         0.224944209396603,
                                         0.125169732118079,
                                         0.0623552298574436,
                                         0.0275623188070307,
                                         0.0106876152955132,
                                         0.0035828737247701,
                                         0.00101899538596918,
                                         0.000239853151911141,
                                         4.52006103899493e-05,
                                         6.51569211636894e-06,
                                         6.73309888688083e-07,
                                         4.5289124482667e-08,
                                         1.70266372108628e-09,
                                         2.75509343045049e-11,
                                         1.15597821212238e-13,
                                         3.77512390534628e-17,
                                         1.25116580029229e-23,
                                         0.025094250702827,
                                         0.119413554715562,
                                         0.244077801201264,
                                         0.346440366884036,
                                         0.389284986515362,
                                         0.365013005895598,
                                         0.29259425562497,
                                         0.202671089299678,
                                         0.121645141115628,
                                         0.0630824104305571,
                                         0.0280414687778872,
                                         0.0105460051918296,
                                         0.00329156913949924,
                                         0.00082956477682189,
                                         0.000162377801200136,
                                         2.33310099536358e-05,
                                         2.26071295283782e-06,
                                         1.29116999420406e-07,
                                         3.44774428124332e-09,
                                         2.74463232245468e-11,
                                         2.23567519443995e-14,
                                         3.9360398022431e-20,
                                         0.000287165403367117,
                                         0.00725903064157441,
                                         0.0370080547618342,
                                         0.0996626142645101,
                                         0.184805806829698,
                                         0.263244521989266,
                                         0.303983317429305,
                                         0.292771097552771,
                                         0.238611440828838,
                                         0.165482940173645,
                                         0.0975410654655965,
                                         0.0485088775943182,
                                         0.0200760383107107,
                                         0.00676665118758931,
                                         0.0017984991618313,
                                         0.000359310217315484,
                                         5.01550193194809e-05,
                                         4.35166493871874e-06,
                                         1.91757007785675e-07,
                                         2.89625089103149e-09,
                                         5.88442033851673e-12,
                                         5.50327962439248e-17,
                                         1.91693238514046e-06,
                                         0.000257407043576286,
                                         0.00327326395299634,
                                         0.0167244888828465,
                                         0.0511776530363735,
                                         0.110745768111124,
                                         0.18422582025339,
                                         0.246706955511461,
                                         0.273026344089694,
                                         0.253229892864535,
                                         0.197920612660827,
                                         0.130158119422202,
                                         0.0714282226349014,
                                         0.0321969008144076,
                                         0.0116201201141241,
                                         0.00322791722142554,
                                         0.000649082911302336,
                                         8.55547776868799e-05,
                                         6.22134428696635e-06,
                                         1.78280967078347e-07,
                                         9.03473589116944e-10,
                                         4.48849217786865e-14,
                                         8.226137155756e-09,
                                         5.86781884119464e-06,
                                         0.000186114526330692,
                                         0.00180421341264355,
                                         0.00911086458698825,
                                         0.029950867829918,
                                         0.0717737638216057,
                                         0.133643875383096,
                                         0.200831724812422,
                                         0.249110014929661,
                                         0.258171936215112,
                                         0.224510045561488,
                                         0.163371443069066,
                                         0.0984847129571788,
                                         0.0482642396262792,
                                         0.018641878994067,
                                         0.00540008284479155,
                                         0.00108130337621436,
                                         0.000129757270358261,
                                         7.05485766067229e-06,
                                         8.91747106701963e-08,
                                         2.35338964934684e-11,
                                         2.35338964934684e-11,
                                         8.91747106701963e-08,
                                         7.05485766067224e-06,
                                         0.000129757270358262,
                                         0.00108130337621436,
                                         0.00540008284479155,
                                         0.018641878994067,
                                         0.0482642396262792,
                                         0.0984847129571788,
                                         0.163371443069066,
                                         0.224510045561488,
                                         0.258171936215112,
                                         0.249110014929662,
                                         0.200831724812422,
                                         0.133643875383096,
                                         0.0717737638216057,
                                         0.029950867829918,
                                         0.00911086458698823,
                                         0.00180421341264354,
                                         0.000186114526330693,
                                         5.86781884119464e-06,
                                         8.226137155756e-09,
                                         4.48849217786865e-14,
                                         9.03473589116944e-10,
                                         1.78280967078345e-07,
                                         6.22134428696638e-06,
                                         8.55547776868801e-05,
                                         0.000649082911302336,
                                         0.00322791722142554,
                                         0.0116201201141241,
                                         0.0321969008144076,
                                         0.0714282226349013,
                                         0.130158119422202,
                                         0.197920612660827,
                                         0.253229892864535,
                                         0.273026344089694,
                                         0.246706955511461,
                                         0.18422582025339,
                                         0.110745768111124,
                                         0.0511776530363734,
                                         0.0167244888828464,
                                         0.00327326395299636,
                                         0.000257407043576285,
                                         1.91693238514046e-06,
                                         5.50327962439248e-17,
                                         5.88442033851673e-12,
                                         2.89625089103146e-09,
                                         1.91757007785676e-07,
                                         4.35166493871875e-06,
                                         5.01550193194809e-05,
                                         0.000359310217315484,
                                         0.0017984991618313,
                                         0.00676665118758931,
                                         0.0200760383107107,
                                         0.0485088775943182,
                                         0.0975410654655965,
                                         0.165482940173645,
                                         0.238611440828838,
                                         0.292771097552771,
                                         0.303983317429305,
                                         0.263244521989266,
                                         0.184805806829698,
                                         0.09966261426451,
                                         0.0370080547618343,
                                         0.00725903064157441,
                                         0.000287165403367117,
                                         3.9360398022431e-20,
                                         2.23567519443995e-14,
                                         2.74463232245464e-11,
                                         3.44774428124334e-09,
                                         1.29116999420406e-07,
                                         2.26071295283782e-06,
                                         2.33310099536358e-05,
                                         0.000162377801200136,
                                         0.00082956477682189,
                                         0.00329156913949923,
                                         0.0105460051918296,
                                         0.0280414687778872,
                                         0.0630824104305571,
                                         0.121645141115628,
                                         0.202671089299678,
                                         0.29259425562497,
                                         0.365013005895598,
                                         0.389284986515361,
                                         0.346440366884036,
                                         0.244077801201264,
                                         0.119413554715562,
                                         0.025094250702827,
                                         1.25116580029229e-23,
                                         3.77512390534628e-17,
                                         1.15597821212236e-13,
                                         2.75509343045051e-11,
                                         1.70266372108629e-09,
                                         4.5289124482667e-08,
                                         6.73309888688083e-07,
                                         6.51569211636894e-06,
                                         4.52006103899493e-05,
                                         0.00023985315191114,
                                         0.00101899538596918,
                                         0.0035828737247701,
                                         0.0106876152955132,
                                         0.0275623188070307,
                                         0.0623552298574436,
                                         0.125169732118079,
                                         0.224944209396603,
                                         0.364449348393076,
                                         0.535232142709016,
                                         0.715447529495134,
                                         0.873064049696355,
                                         0.974616658711705,

                                         0.976706749418275,
                                         0.883013421630562,
                                         0.735797419760533,
                                         0.564147634373248,
                                         0.396993344705972,
                                         0.255530569683225,
                                         0.149769639842189,
                                         0.0794752535173561,
                                         0.0379061487201395,
                                         0.0161017561949927,
                                         0.0060212287408705,
                                         0.001953125,
                                         0.000539192592733389,
                                         0.000123569060658953,
                                         2.27388836579774e-05,
                                         3.20973640405379e-06,
                                         3.25681535964885e-07,
                                         2.15672339382966e-08,
                                         8.00346075363997e-10,
                                         1.28155603933718e-11,
                                         5.33444986831158e-14,
                                         1.73253918814211e-17,
                                         5.72456113923135e-24,
                                         0.0230499995662848,
                                         0.11062286421552,
                                         0.229634739645169,
                                         0.333431732192411,
                                         0.386241084858833,
                                         0.376464854132803,
                                         0.316581193304889,
                                         0.232422726795425,
                                         0.149609365204196,
                                         0.0843567445518452,
                                         0.0414466776438459,
                                         0.017578125,
                                         0.00634489353029577,
                                         0.00191050509099366,
                                         0.000466664796444511,
                                         8.89012191458712e-05,
                                         1.24800645062849e-05,
                                         1.18576299660849e-06,
                                         6.66327283781101e-08,
                                         1.75633947781612e-09,
                                         1.38450754818655e-11,
                                         1.12018690499317e-14,
                                         1.96480965811461e-20,
                                         0.000241765950423445,
                                         0.00615942221260558,
                                         0.0318518308531573,
                                         0.087586781472624,
                                         0.167013351871923,
                                         0.246503729384927,
                                         0.29741572030205,
                                         0.302094448216995,
                                         0.262437190711377,
                                         0.19641916392251,
                                         0.12679782458153,
                                         0.0703125,
                                         0.0331835039224164,
                                         0.0131281682872478,
                                         0.0042565567034128,
                                         0.00109436840782875,
                                         0.000212548480485652,
                                         2.89746914364752e-05,
                                         2.46555590986296e-06,
                                         1.0697857454012e-07,
                                         1.59704994958844e-09,
                                         3.21895865189322e-12,
                                         2.9972036467867e-17,
                                         1.47923149380999e-06,
                                         0.000200056121486318,
                                         0.00257719930640744,
                                         0.0134210656526396,
                                         0.0421270172047741,
                                         0.0941541234494396,
                                         0.162989460490785,
                                         0.229046515915445,
                                         0.268539869825518,
                                         0.266787021720342,
                                         0.226282347641461,
                                         0.1640625,
                                         0.101236457464819,
                                         0.0526231528918452,
                                         0.0226479344760009,
                                         0.00785843693045006,
                                         0.00211162100256013,
                                         0.000413006170125706,
                                         5.32180439557594e-05,
                                         3.80103566187481e-06,
                                         1.07462877406895e-07,
                                         5.39581559223739e-10,
                                         2.6670356100601e-14,
                                         5.81823993589731e-09,
                                         4.177131894892e-06,
                                         0.000134052860168403,
                                         0.00132205617104682,
                                         0.00683100654961429,
                                         0.0231190332036961,
                                         0.0574208475013835,
                                         0.111639815405839,
                                         0.176647152740454,
                                         0.232948550957951,
                                         0.25959960230732,
                                         0.24609375,
                                         0.198548271574707,
                                         0.135601367321613,
                                         0.0774663779387994,
                                         0.0362763238551099,
                                         0.0134861633296162,
                                         0.00378450195411515,
                                         0.000738443775943152,
                                         8.68203546394848e-05,
                                         4.64850073867707e-06,
                                         5.81451202715547e-08,
                                         1.52565329106471e-11,
                                         1.52565329106488e-11,
                                         5.81451202715547e-08,
                                         4.64850073867704e-06,
                                         8.68203546394848e-05,
                                         0.000738443775943152,
                                         0.00378450195411514,
                                         0.0134861633296162,
                                         0.0362763238551099,
                                         0.0774663779387994,
                                         0.135601367321613,
                                         0.198548271574707,
                                         0.24609375,
                                         0.25959960230732,
                                         0.232948550957951,
                                         0.176647152740454,
                                         0.11163981540584,
                                         0.0574208475013834,
                                         0.0231190332036961,
                                         0.00683100654961429,
                                         0.00132205617104682,
                                         0.000134052860168404,
                                         4.177131894892e-06,
                                         5.81823993589682e-09,
                                         2.66703561006044e-14,
                                         5.39581559223739e-10,
                                         1.07462877406894e-07,
                                         3.80103566187481e-06,
                                         5.32180439557594e-05,
                                         0.000413006170125705,
                                         0.00211162100256013,
                                         0.00785843693045005,
                                         0.0226479344760009,
                                         0.0526231528918452,
                                         0.101236457464819,
                                         0.1640625,
                                         0.226282347641461,
                                         0.266787021720342,
                                         0.268539869825518,
                                         0.229046515915446,
                                         0.162989460490785,
                                         0.0941541234494397,
                                         0.0421270172047741,
                                         0.0134210656526396,
                                         0.00257719930640745,
                                         0.000200056121486318,
                                         1.4792314938099e-06,
                                         2.99720364678714e-17,
                                         3.21895865189322e-12,
                                         1.59704994958843e-09,
                                         1.0697857454012e-07,
                                         2.46555590986296e-06,
                                         2.89746914364751e-05,
                                         0.000212548480485652,
                                         0.00109436840782874,
                                         0.0042565567034128,
                                         0.0131281682872478,
                                         0.0331835039224164,
                                         0.0703125,
                                         0.12679782458153,
                                         0.19641916392251,
                                         0.262437190711377,
                                         0.302094448216995,
                                         0.29741572030205,
                                         0.246503729384928,
                                         0.167013351871923,
                                         0.087586781472624,
                                         0.0318518308531574,
                                         0.00615942221260558,
                                         0.000241765950423435,
                                         1.96480965811495e-20,
                                         1.12018690499317e-14,
                                         1.38450754818654e-11,
                                         1.75633947781612e-09,
                                         6.66327283781101e-08,
                                         1.18576299660849e-06,
                                         1.24800645062849e-05,
                                         8.8901219145871e-05,
                                         0.000466664796444511,
                                         0.00191050509099366,
                                         0.00634489353029577,
                                         0.017578125,
                                         0.0414466776438459,
                                         0.0843567445518452,
                                         0.149609365204196,
                                         0.232422726795425,
                                         0.316581193304889,
                                         0.376464854132803,
                                         0.386241084858833,
                                         0.333431732192411,
                                         0.229634739645169,
                                         0.11062286421552,
                                         0.0230499995662844,
                                         5.72456113923244e-24,
                                         1.73253918814211e-17,
                                         5.3344498683115e-14,
                                         1.28155603933718e-11,
                                         8.00346075363997e-10,
                                         2.15672339382966e-08,
                                         3.25681535964886e-07,
                                         3.20973640405379e-06,
                                         2.27388836579774e-05,
                                         0.000123569060658953,
                                         0.000539192592733389,
                                         0.001953125,
                                         0.0060212287408705,
                                         0.0161017561949927,
                                         0.0379061487201395,
                                         0.0794752535173561,
                                         0.149769639842189,
                                         0.255530569683225,
                                         0.396993344705972,
                                         0.564147634373248,
                                         0.735797419760533,
                                         0.883013421630562,
                                         0.976706749418275,

                                         0.978549789347802,
                                         0.891860021751249,
                                         0.754167275467319,
                                         0.590835117846358,
                                         0.427934002739746,
                                         0.285727631684369,
                                         0.175213279433183,
                                         0.0982092773968659,
                                         0.0500160654579999,
                                         0.0229714638685451,
                                         0.00942596829901793,
                                         0.00341518066835026,
                                         0.00107640347478525,
                                         0.00028952921178113,
                                         6.48188978185254e-05,
                                         1.16816352835843e-05,
                                         1.6188637792307e-06,
                                         1.61649345146306e-07,
                                         1.05589982797579e-08,
                                         3.87382020348728e-10,
                                         6.14611589288535e-12,
                                         2.54043621500541e-14,
                                         8.21108533841033e-18,
                                         2.70579026459823e-24,
                                         0.0212440733872058,
                                         0.102721619625463,
                                         0.216151946098138,
                                         0.320177209498463,
                                         0.380903669880102,
                                         0.384043447407425,
                                         0.336709013486643,
                                         0.259990214173877,
                                         0.177762549148296,
                                         0.107684908786698,
                                         0.0576100279238728,
                                         0.0270358976559502,
                                         0.0110136938378086,
                                         0.00383711924623756,
                                         0.00112000635805999,
                                         0.000266230566909445,
                                         4.95325673693478e-05,
                                         6.81351544061705e-06,
                                         6.36325928578974e-07,
                                         3.52521912623293e-08,
                                         9.18674474670583e-10,
                                         7.17962643231725e-12,
                                         5.77458027621246e-15,
                                         1.00954174870232e-20,
                                         0.000204979363450245,
                                         0.00525828960755472,
                                         0.0275339232919359,
                                         0.077113783438445,
                                         0.150685339119523,
                                         0.229417191823365,
                                         0.287580840219192,
                                         0.305899642784826,
                                         0.280794434884442,
                                         0.224356418840312,
                                         0.156490392032082,
                                         0.0951229665484662,
                                         0.0500850821150531,
                                         0.0226014179199098,
                                         0.00860115583100336,
                                         0.00269668160649952,
                                         0.000673579488054378,
                                         0.000127639772420865,
                                         1.70433123232964e-05,
                                         1.42577257764786e-06,
                                         6.10295315046572e-08,
                                         9.01805505389795e-10,
                                         1.80491918977629e-12,
                                         1.67406346753235e-17,
                                         1.15371697132717e-06,
                                         0.00015701601075162,
                                         0.00204594446126108,
                                         0.0108340391764465,
                                         0.0347731181895651,
                                         0.0799444563316931,
                                         0.143278804160278,
                                         0.20995089573933,
                                         0.258734008409388,
                                         0.272670998110703,
                                         0.247967101339555,
                                         0.195230097901966,
                                         0.13286193542247,
                                         0.077657404215396,
                                         0.0385309696144217,
                                         0.0159337582202899,
                                         0.00534322745580544,
                                         0.00139481815615219,
                                         0.000266284065723303,
                                         3.36380793946429e-05,
                                         2.36502217130961e-06,
                                         6.60755384295351e-08,
                                         3.29087885765152e-10,
                                         1.61933367940633e-14,
                                         4.17448491528723e-09,
                                         3.01410134217117e-06,
                                         9.77313856169503e-05,
                                         0.000978505487779104,
                                         0.00515858685637683,
                                         0.0179087478226182,
                                         0.0458900384704673,
                                         0.0926341173259455,
                                         0.15326147863707,
                                         0.213036427342759,
                                         0.252589286306389,
                                         0.257586223531984,
                                         0.226572518843166,
                                         0.171531753505759,
                                         0.11096283234968,
                                         0.0605231114338218,
                                         0.027247894204148,
                                         0.00979859113687756,
                                         0.00267455066755711,
                                         0.000510183723141426,
                                         5.89175759855966e-05,
                                         3.11231118128581e-06,
                                         3.8572741116824e-08,
                                         1.00696703154803e-11,
                                         1.00696703154814e-11,
                                         3.8572741116824e-08,
                                         3.11231118128584e-06,
                                         5.89175759855966e-05,
                                         0.000510183723141426,
                                         0.00267455066755711,
                                         0.00979859113687756,
                                         0.027247894204148,
                                         0.0605231114338218,
                                         0.11096283234968,
                                         0.171531753505759,
                                         0.226572518843166,
                                         0.257586223531985,
                                         0.252589286306389,
                                         0.213036427342759,
                                         0.15326147863707,
                                         0.0926341173259455,
                                         0.0458900384704673,
                                         0.0179087478226181,
                                         0.00515858685637683,
                                         0.000978505487779104,
                                         9.77313856169496e-05,
                                         3.01410134217116e-06,
                                         4.17448491528684e-09,
                                         1.61933367940655e-14,
                                         3.29087885765152e-10,
                                         6.60755384295358e-08,
                                         2.36502217130961e-06,
                                         3.36380793946429e-05,
                                         0.000266284065723304,
                                         0.00139481815615219,
                                         0.00534322745580545,
                                         0.0159337582202899,
                                         0.0385309696144217,
                                         0.077657404215396,
                                         0.13286193542247,
                                         0.195230097901966,
                                         0.247967101339555,
                                         0.272670998110703,
                                         0.258734008409388,
                                         0.209950895739329,
                                         0.143278804160278,
                                         0.079944456331693,
                                         0.0347731181895651,
                                         0.0108340391764465,
                                         0.00204594446126107,
                                         0.00015701601075162,
                                         1.15371697132709e-06,
                                         1.67406346753262e-17,
                                         1.80491918977629e-12,
                                         9.01805505389807e-10,
                                         6.10295315046572e-08,
                                         1.42577257764786e-06,
                                         1.70433123232964e-05,
                                         0.000127639772420865,
                                         0.000673579488054379,
                                         0.00269668160649952,
                                         0.00860115583100336,
                                         0.0226014179199098,
                                         0.0500850821150531,
                                         0.0951229665484662,
                                         0.156490392032082,
                                         0.224356418840312,
                                         0.280794434884442,
                                         0.305899642784826,
                                         0.287580840219192,
                                         0.229417191823364,
                                         0.150685339119523,
                                         0.077113783438445,
                                         0.0275339232919358,
                                         0.00525828960755472,
                                         0.000204979363450235,
                                         1.0095417487025e-20,
                                         5.77458027621246e-15,
                                         7.17962643231735e-12,
                                         9.18674474670583e-10,
                                         3.52521912623293e-08,
                                         6.36325928578977e-07,
                                         6.81351544061705e-06,
                                         4.95325673693479e-05,
                                         0.000266230566909445,
                                         0.00112000635805999,
                                         0.00383711924623756,
                                         0.0110136938378085,
                                         0.0270358976559502,
                                         0.0576100279238728,
                                         0.107684908786698,
                                         0.177762549148296,
                                         0.259990214173877,
                                         0.336709013486643,
                                         0.384043447407425,
                                         0.380903669880102,
                                         0.320177209498463,
                                         0.216151946098137,
                                         0.102721619625463,
                                         0.0212440733872054,
                                         2.70579026459879e-24,
                                         8.21108533841033e-18,
                                         2.54043621500545e-14,
                                         6.14611589288535e-12,
                                         3.87382020348728e-10,
                                         1.0558998279758e-08,
                                         1.61649345146306e-07,
                                         1.61886377923071e-06,
                                         1.16816352835843e-05,
                                         6.48188978185254e-05,
                                         0.00028952921178113,
                                         0.00107640347478525,
                                         0.00341518066835026,
                                         0.00942596829901793,
                                         0.0229714638685451,
                                         0.0500160654579999,
                                         0.0982092773968659,
                                         0.175213279433183,
                                         0.285727631684369,
                                         0.427934002739746,
                                         0.590835117846358,
                                         0.754167275467319,
                                         0.891860021751249,
                                         0.978549789347802,

                                         0.0009765625,
                                         0.009765625,
                                         0.0439453125,
                                         0.1171875,
                                         0.205078125,
                                         0.24609375,
                                         0.205078125,
                                         0.1171875,
                                         0.0439453125,
                                         0.009765625,
                                         0.0009765625,

                                         0.0931068182589887,
                                         1.77625785062455e-07,
                                         0.249478967623273,
                                         6.6290845458739e-06,
                                         0.300814595564428,
                                         0.00011133036149792,
                                         0.214941407874622,
                                         0.00110797484142732,
                                         0.100788409155024,
                                         0.00723628220300098,
                                         0.0324074074074074,
                                         0.0324074074074074,
                                         0.00723628220300098,
                                         0.100788409155024,
                                         0.00110797484142732,
                                         0.214941407874622,
                                         0.00011133036149792,
                                         0.300814595564428,
                                         6.6290845458739e-06,
                                         0.249478967623273,
                                         1.77625785062455e-07,
                                         0.0931068182589887,

                                         0.302479999669399,
                                         0.0009765625,
                                         3.30600370633756e-10,
                                         0.384199973971888,
                                         0.009765625,
                                         2.60281121224955e-08,
                                         0.219599077864981,
                                         0.0439453125,
                                         9.22135019731318e-07,
                                         0.0743806401235915,
                                         0.1171875,
                                         1.93598764087981e-05,
                                         0.0165332650270357,
                                         0.205078125,
                                         0.000266734972964427,
                                         0.00252000000000002,
                                         0.24609375,
                                         0.00252000000000002,
                                         0.000266734972964427,
                                         0.205078125,
                                         0.0165332650270357,
                                         1.93598764087981e-05,
                                         0.1171875,
                                         0.0743806401235915,
                                         9.22135019731318e-07,
                                         0.0439453125,
                                         0.219599077864981,
                                         2.60281121224955e-08,
                                         0.009765625,
                                         0.384199973971888,
                                         3.30600370633756e-10,
                                         0.0009765625,
                                         0.302479999669399,

                                         0.486947194682945,
                                         0.0182257995178667,
                                         1.53201893980771e-05,
                                         2.60367641155454e-12,
                                         0.363322573910166,
                                         0.0897727116006939,
                                         0.000311032935918293,
                                         3.489606799885e-10,
                                         0.121987522198163,
                                         0.19898237567622,
                                         0.00284158818931722,
                                         2.10464326661081e-08,
                                         0.0242713904280416,
                                         0.26136118978215,
                                         0.0153841007962998,
                                         7.52205860083538e-07,
                                         0.00316915309159211,
                                         0.225287399376478,
                                         0.0546578331860515,
                                         1.76426674108627e-05,
                                         0.000283749417823995,
                                         0.133160648749606,
                                         0.133160648749606,
                                         0.000283749417823996,
                                         1.76426674108626e-05,
                                         0.0546578331860515,
                                         0.225287399376478,
                                         0.00316915309159212,
                                         7.52205860083534e-07,
                                         0.0153841007962998,
                                         0.26136118978215,
                                         0.0242713904280416,
                                         2.10464326661079e-08,
                                         0.00284158818931722,
                                         0.19898237567622,
                                         0.121987522198163,
                                         3.48960679988498e-10,
                                         0.000311032935918293,
                                         0.0897727116006939,
                                         0.363322573910167,
                                         2.60367641155452e-12,
                                         1.53201893980771e-05,
                                         0.0182257995178667,
                                         0.486947194682945,

                                         0.618498680869844,
                                         0.0725418146841953,
                                         0.0009765625,
                                         4.28258404388968e-07,
                                         5.16013971890298e-14,
                                         0.304418503057707,
                                         0.21762068022717,
                                         0.009765625,
                                         1.42755926393134e-05,
                                         1.04840526353964e-11,
                                         0.0674242040308062,
                                         0.293781487283146,
                                         0.0439453125,
                                         0.000214138577087528,
                                         9.5853822846309e-10,
                                         0.00884946118539785,
                                         0.23502004512031,
                                         0.1171875,
                                         0.00190349568611526,
                                         5.19332978701235e-08,
                                         0.000762231944535506,
                                         0.123382822776529,
                                         0.205078125,
                                         0.0111039679017566,
                                         1.84651007841844e-06,
                                         4.5019499258158e-05,
                                         0.0444168438926464,
                                         0.24609375,
                                         0.0444168438926464,
                                         4.50194992581583e-05,
                                         1.84651007841843e-06,
                                         0.0111039679017566,
                                         0.205078125,
                                         0.123382822776529,
                                         0.00076223194453551,
                                         5.19332978701231e-08,
                                         0.00190349568611526,
                                         0.1171875,
                                         0.23502004512031,
                                         0.00884946118539788,
                                         9.58538228463081e-10,
                                         0.000214138577087528,
                                         0.0439453125,
                                         0.293781487283146,
                                         0.0674242040308064,
                                         1.04840526353963e-11,
                                         1.42755926393134e-05,
                                         0.009765625,
                                         0.21762068022717,
                                         0.304418503057708,
                                         5.16013971890292e-14,
                                         4.28258404388968e-07,
                                         0.0009765625,
                                         0.0725418146841953,
                                         0.618498680869844,

                                         0.709294443061681,
                                         0.156294540172398,
                                         0.00829999961790695,
                                         6.39321531853861e-05,
                                         1.94542161479298e-08,
                                         1.92618848691545e-15,
                                         0.247864186011291,
                                         0.318750445238079,
                                         0.0510202048829451,
                                         0.0010400523640156,
                                         9.53908555322669e-07,
                                         5.51202984200498e-13,
                                         0.0389774583582405,
                                         0.292529929723274,
                                         0.141129836356469,
                                         0.00761383732127709,
                                         2.10480692847949e-05,
                                         7.09801399680946e-11,
                                         0.00363219763273559,
                                         0.159091153991528,
                                         0.231340513975248,
                                         0.0330299715585972,
                                         0.000275216206243659,
                                         5.41649518174078e-09,
                                         0.000222123619793501,
                                         0.0567794359268929,
                                         0.248859297435835,
                                         0.0940333963580539,
                                         0.00236159303710944,
                                         2.71249650521603e-07,
                                         9.31457857918842e-06,
                                         0.0138956642724186,
                                         0.183568957976467,
                                         0.183568957976467,
                                         0.0138956642724186,
                                         9.31457857918842e-06,
                                         2.71249650521603e-07,
                                         0.00236159303710944,
                                         0.0940333963580539,
                                         0.248859297435835,
                                         0.0567794359268928,
                                         0.000222123619793501,
                                         5.41649518174078e-09,
                                         0.00027521620624366,
                                         0.0330299715585972,
                                         0.231340513975248,
                                         0.159091153991528,
                                         0.00363219763273559,
                                         7.09801399680946e-11,
                                         2.10480692847949e-05,
                                         0.00761383732127709,
                                         0.141129836356469,
                                         0.292529929723274,
                                         0.0389774583582405,
                                         5.51202984200498e-13,
                                         9.53908555322672e-07,
                                         0.0010400523640156,
                                         0.0510202048829451,
                                         0.318750445238079,
                                         0.247864186011291,
                                         1.92618848691545e-15,
                                         1.94542161479299e-08,
                                         6.39321531853861e-05,
                                         0.00829999961790695,
                                         0.156294540172398,
                                         0.709294443061681,

                                         0.772785364063438,
                                         0.250618196918555,
                                         0.0294492960050725,
                                         0.0009765625,
                                         5.35422353688742e-06,
                                         1.29951575909081e-09,
                                         1.13815840211789e-16,
                                         0.201777747856344,
                                         0.371954224882065,
                                         0.124462085975776,
                                         0.009765625,
                                         0.000126687667637045,
                                         8.75597787641342e-08,
                                         4.35901463113136e-14,
                                         0.0237082864667015,
                                         0.248415622643954,
                                         0.236707352163797,
                                         0.0439453125,
                                         0.00134891534866512,
                                         2.65485174890424e-06,
                                         7.5125341372317e-12,
                                         0.00165075750525087,
                                         0.098316074948758,
                                         0.266773469998823,
                                         0.1171875,
                                  