/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include "ecs.h"
#include <stdio.h>
#include <stdlib.h> /* getenv, exit */
#include <signal.h>
#include <sys/types.h>
#include <memory.h>
#include <stropts.h>
#include <netconfig.h>
#include <sys/resource.h> /* rlimit */
#include <syslog.h>

#ifdef DEBUG
#define	RPC_SVC_FG
#endif

#define	_RPCSVC_CLOSEDOWN 120
#define main dummy 
static int _rpcpmstart;		/* Started by a port monitor ? */
	/* States a server can be in wrt request */

#define	_IDLE 0
#define	_SERVED 1
#define	_SERVING 2

static int _rpcsvcstate = _IDLE;	 /* Set when a request is serviced */

static
void _msgout(msg)
	char *msg;
{
#ifdef RPC_SVC_FG
	if (_rpcpmstart)
		syslog(LOG_ERR, msg);
	else
		(void) fprintf(stderr, "%s\n", msg);
#else
	syslog(LOG_ERR, msg);
#endif
}

static void
closedown(sig)
	int sig;
{
	if (_rpcsvcstate == _IDLE) {
		extern fd_set svc_fdset;
		static int size;
		int i, openfd;
		struct t_info tinfo;

		if (!t_getinfo(0, &tinfo) && (tinfo.servtype == T_CLTS))
			exit(0);
		if (size == 0) {
			struct rlimit rl;

			rl.rlim_max = 0;
			getrlimit(RLIMIT_NOFILE, &rl);
			if ((size = rl.rlim_max) == 0) {
				return;
			}
		}
		for (i = 0, openfd = 0; i < size && openfd < 2; i++)
			if (FD_ISSET(i, &svc_fdset))
				openfd++;
		if (openfd <= 1)
			exit(0);
	}
	if (_rpcsvcstate == _SERVED)
		_rpcsvcstate = _IDLE;

	(void) signal(SIGALRM, (void(*)()) closedown);
	(void) alarm(_RPCSVC_CLOSEDOWN/2);
}

void
ecsprog_1(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union {
		char *createserver_1_arg;
		ecs_LayerSelection selectlayer_1_arg;
		ecs_LayerSelection releaselayer_1_arg;
		ecs_Region selectregion_1_arg;
		char *getobject_1_arg;
		ecs_Coordinate getobjectidfromcoord_1_arg;
		char *updatedictionary_1_arg;
		u_int setserverlanguage_1_arg;
		char *setserverprojection_1_arg;
		ecs_RasterConversion setrasterconversion_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();

	_rpcsvcstate = _SERVING;
	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, xdr_void,
			(char *)NULL);
		_rpcsvcstate = _SERVED;
		return;

	case CREATESERVER:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) createserver_1;
		break;

	case DESTROYSERVER:
		xdr_argument = xdr_void;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) destroyserver_1;
		break;

	case SELECTLAYER:
		xdr_argument = xdr_ecs_LayerSelection;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) selectlayer_1;
		break;

	case RELEASELAYER:
		xdr_argument = xdr_ecs_LayerSelection;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) releaselayer_1;
		break;

	case SELECTREGION:
		xdr_argument = xdr_ecs_Region;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) selectregion_1;
		break;

	case GETDICTIONNARY:
		xdr_argument = xdr_void;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) getdictionnary_1;
		break;

	case GETATTRIBUTEFORMAT:
		xdr_argument = xdr_void;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) getattributeformat_1;
		break;

	case GETNEXTOBJECT:
		xdr_argument = xdr_void;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) getnextobject_1;
		break;

	case GETRASTERINFO:
		xdr_argument = xdr_void;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) getrasterinfo_1;
		break;

	case GETOBJECT:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) getobject_1;
		break;

	case GETOBJECTIDFROMCOORD:
		xdr_argument = xdr_ecs_Coordinate;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) getobjectidfromcoord_1;
		break;

	case UPDATEDICTIONARY:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) updatedictionary_1;
		break;

	case GETSERVERPROJECTION:
		xdr_argument = xdr_void;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) getserverprojection_1;
		break;

	case GETGLOBALBOUND:
		xdr_argument = xdr_void;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) getglobalbound_1;
		break;

	case SETSERVERLANGUAGE:
		xdr_argument = xdr_u_int;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) setserverlanguage_1;
		break;

	case SETSERVERPROJECTION:
		xdr_argument = xdr_wrapstring;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) setserverprojection_1;
		break;

	case SETRASTERCONVERSION:
		xdr_argument = xdr_ecs_RasterConversion;
		xdr_result = xdr_ecs_Result;
		local = (char *(*)()) setrasterconversion_1;
		break;

	default:
		svcerr_noproc(transp);
		_rpcsvcstate = _SERVED;
		return;
	}
	(void) memset((char *)&argument, 0, sizeof (argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		_rpcsvcstate = _SERVED;
		return;
	}
	result = (*local)(&argument, rqstp);
	if (result != NULL && !svc_sendreply(transp, xdr_result, result)) {
		svcerr_systemerr(transp);
	}
	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		_msgout("unable to free arguments");
		exit(1);
	}
	_rpcsvcstate = _SERVED;
	return;
}

main()
{
	pid_t pid;
	int i;
	char mname[FMNAMESZ + 1];

	if (!ioctl(0, I_LOOK, mname) &&
		(!strcmp(mname, "sockmod") || !strcmp(mname, "timod"))) {
		char *netid;
		struct netconfig *nconf = NULL;
		SVCXPRT *transp;
		int pmclose;

		_rpcpmstart = 1;
		openlog("ecs", LOG_PID, LOG_DAEMON);

		if ((netid = getenv("NLSPROVIDER")) == NULL) {
		/* started from inetd */
			pmclose = 1;
		} else {
			if ((nconf = getnetconfigent(netid)) == NULL)
				_msgout("cannot get transport info");

			pmclose = (t_getstate(0) != T_DATAXFER);
		}
		if (strcmp(mname, "sockmod") == 0) {
			if (ioctl(0, I_POP, 0) || ioctl(0, I_PUSH, "timod")) {
				_msgout("could not get the right module");
				exit(1);
			}
		}
		if ((transp = svc_tli_create(0, nconf, NULL, 0, 0)) == NULL) {
			_msgout("cannot create server handle");
			exit(1);
		}
		if (nconf)
			freenetconfigent(nconf);
		if (!svc_reg(transp, ECSPROG, ECSVERS, ecsprog_1, 0)) {
			_msgout("unable to register (ECSPROG, ECSVERS).");
			exit(1);
		}
		if (pmclose) {
			(void) signal(SIGALRM, (void(*)()) closedown);
			(void) alarm(_RPCSVC_CLOSEDOWN/2);
		}
		svc_run();
		exit(1);
		/* NOTREACHED */
	}	else {
#ifndef RPC_SVC_FG
		int size;
		struct rlimit rl;
		pid = fork();
		if (pid < 0) {
			perror("cannot fork");
			exit(1);
		}
		if (pid)
			exit(0);
		rl.rlim_max = 0;
		getrlimit(RLIMIT_NOFILE, &rl);
		if ((size = rl.rlim_max) == 0)
			exit(1);
		for (i = 0; i < size; i++)
			(void) close(i);
		i = open("/dev/console", 2);
		(void) dup2(i, 1);
		(void) dup2(i, 2);
		setsid();
		openlog("ecs", LOG_PID, LOG_DAEMON);
#endif
	}
	if (!svc_create(ecsprog_1, ECSPROG, ECSVERS, "netpath")) {
		_msgout("unable to create (ECSPROG, ECSVERS) for netpath.");
		exit(1);
	}

	svc_run();
	_msgout("svc_run returned");
	exit(1);
	/* NOTREACHED */
}
