// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _StdSelect_ViewerSelector3d_HeaderFile
#define _StdSelect_ViewerSelector3d_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_StdSelect_ViewerSelector3d.hxx>

#include <Handle_Select3D_Projector.hxx>
#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
#include <StdSelect_SensitivityMode.hxx>
#include <Standard_Integer.hxx>
#include <Handle_Graphic3d_Group.hxx>
#include <Handle_Graphic3d_Structure.hxx>
#include <Graphic3d_SequenceOfHClipPlane.hxx>
#include <SelectMgr_ViewerSelector.hxx>
#include <Handle_SelectMgr_Selection.hxx>
#include <Handle_V3d_View.hxx>
#include <Handle_SelectMgr_EntityOwner.hxx>
class Select3D_Projector;
class Graphic3d_Group;
class Graphic3d_Structure;
class SelectMgr_Selection;
class V3d_View;
class TColgp_Array1OfPnt2d;
class gp_Lin;
class SelectMgr_EntityOwner;


//! Selector Usable by Viewers from V3d
//! Accepts Only Sensitive Entities inheriting Select3D entities...
class StdSelect_ViewerSelector3d : public SelectMgr_ViewerSelector
{

public:

  
  //! Constructs an empty 3D selector object.
  Standard_EXPORT StdSelect_ViewerSelector3d();
  
  //! Constructs a 3D selector object defined by the projector <theProj>.
  Standard_EXPORT StdSelect_ViewerSelector3d(const Handle(Select3D_Projector)& theProj);
  
  //! Processes the projection of the sensitive  primitives
  //! in the active view ; to be done before the selection action...
  Standard_EXPORT   void Convert (const Handle(SelectMgr_Selection)& theSel) ;
  
  //! Sets the new projector <theProj> to replace the one used at construction time.
  Standard_EXPORT   void Set (const Handle(Select3D_Projector)& theProj) ;
  
  //! Sets the selection sensitivity mode. SM_WINDOW mode
  //! uses the specified pixel tolerance to compute the sensitivity
  //! value, SM_VIEW mode allows to define the sensitivity manually.
  Standard_EXPORT   void SetSensitivityMode (const StdSelect_SensitivityMode theMode) ;
  
  //! Returns the selection sensitivity mode.
      StdSelect_SensitivityMode SensitivityMode()  const;
  
  //! Sets the pixel tolerance <theTolerance>.
  Standard_EXPORT   void SetPixelTolerance (const Standard_Integer theTolerance) ;
  
  //! Returns the pixel tolerance.
      Standard_Integer PixelTolerance()  const;
  
  //! Picks the sensitive entity at the pixel coordinates of
  //! the mouse <theXPix> and <theYPix>. The selector looks for touched areas and owners.
  Standard_EXPORT   void Pick (const Standard_Integer theXPix, const Standard_Integer theYPix, const Handle(V3d_View)& theView) ;
  
  //! Picks the sensitive entity according to the minimum
  //! and maximum pixel values <theXPMin>, <theYPMin>, <theXPMax>
  //! and <theYPMax> defining a 2D area for selection in the 3D view aView.
  Standard_EXPORT   void Pick (const Standard_Integer theXPMin, const Standard_Integer theYPMin, const Standard_Integer theXPMax, const Standard_Integer theYPMax, const Handle(V3d_View)& theView) ;
  
  //! pick action - input pixel values for polyline selection for selection.
  Standard_EXPORT   void Pick (const TColgp_Array1OfPnt2d& thePolyline, const Handle(V3d_View)& theView) ;
  
  //! Returns the current Projector.
     const  Handle(Select3D_Projector)& Projector()  const;
  
  //! Displays sensitive areas found in the view <theView>.
  Standard_EXPORT   void DisplayAreas (const Handle(V3d_View)& theView) ;
  
  //! Clears the view aView of sensitive areas found in it.
  Standard_EXPORT   void ClearAreas (const Handle(V3d_View)& theView) ;
  
  //! Displays sensitives in view <theView>.
  Standard_EXPORT   void DisplaySensitive (const Handle(V3d_View)& theView) ;
  
  Standard_EXPORT   void ClearSensitive (const Handle(V3d_View)& theView) ;
  
  Standard_EXPORT   void DisplaySensitive (const Handle(SelectMgr_Selection)& theSel, const Handle(V3d_View)& theView, const Standard_Boolean theToClearOthers = Standard_True) ;
  
  Standard_EXPORT   void DisplayAreas (const Handle(SelectMgr_Selection)& theSel, const Handle(V3d_View)& theView, const Standard_Boolean theToClearOthers = Standard_True) ;




  DEFINE_STANDARD_RTTI(StdSelect_ViewerSelector3d)

protected:

  
  //! Set view clipping for the selector.
  //! @param thePlanes [in] the view planes.
  Standard_EXPORT   void SetClipping (const Graphic3d_SequenceOfHClipPlane& thePlanes) ;
  
  //! Computed depth boundaries for the passed set of clipping planes and picking line.
  //! @param thePlanes [in] the planes.
  //! @param thePickLine [in] the picking line.
  //! @param theDepthMin [out] minimum depth limit.
  //! @param theDepthMax [out] maximum depth limit.
  Standard_EXPORT   void ComputeClipRange (const Graphic3d_SequenceOfHClipPlane& thePlanes, const gp_Lin& thePickLine, Standard_Real& theDepthMin, Standard_Real& theDepthMax)  const;
  
  //! For more details please refer to base class.
  Standard_EXPORT virtual   gp_Lin PickingLine (const Standard_Real theX, const Standard_Real theY)  const;
  
  //! For more details please refer to base class.
  Standard_EXPORT virtual   void DepthClipping (const Standard_Real theX, const Standard_Real theY, Standard_Real& theMin, Standard_Real& theMax)  const;
  
  //! For more details please refer to base class.
  Standard_EXPORT virtual   void DepthClipping (const Standard_Real theX, const Standard_Real theY, const Handle(SelectMgr_EntityOwner)& theOwner, Standard_Real& theMin, Standard_Real& theMax)  const;
  
  //! For more details please refer to base class.
  Standard_EXPORT virtual   Standard_Boolean HasDepthClipping (const Handle(SelectMgr_EntityOwner)& theOwner)  const;



private: 

  
  Standard_EXPORT   Standard_Boolean UpdateProj (const Handle(V3d_View)& theView) ;
  
  Standard_EXPORT   void ComputeSensitivePrs (const Handle(SelectMgr_Selection)& theSel) ;
  
  Standard_EXPORT   void ComputeAreasPrs (const Handle(SelectMgr_Selection)& theSel) ;

  Handle(Select3D_Projector) myProjector;
  Standard_Real myPrevAt[3];
  Standard_Real myPrevUp[3];
  Standard_Real myPrevProj[3];
  Standard_Real myPrevAxialScale[3];
  Standard_Real myPrevFOV;
  Standard_Real myPrevScale;
  Standard_Boolean myPrevOrthographic;
  StdSelect_SensitivityMode mySensMode;
  Standard_Integer myPixelTolerance;
  Standard_Boolean myToUpdateTolerance;
  Handle(Graphic3d_Group) myareagroup;
  Handle(Graphic3d_Group) mysensgroup;
  Handle(Graphic3d_Structure) mystruct;
  Graphic3d_SequenceOfHClipPlane myClipPlanes;


};


#include <StdSelect_ViewerSelector3d.lxx>





#endif // _StdSelect_ViewerSelector3d_HeaderFile
