# -*- coding: utf-8 -*-
#
# «XineHandler» - Xine Application lirc creator
#
# Copyright (C) 2007, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuLircGenerator.core import ProgramHandler

class XineHandler(ProgramHandler):
    def __init__(self,lircd, lircrc,repeat,delay):
        application_name="xine"
        application_dictionary={ \
        "ok":"EventSelect", \
        "info":"OSDStreamInfos", \
        "vol+":"Volume+", \
        "vol-":"Volume-", \
        "forward":"SeekRelative+15", \
        "rewind":"SeekRelative-15", \
        "skip":"EventNext", \
        "replay":"EvenPrior", \
        "pause":"Pause", \
        "up":"EventUp", \
        "down":"EventDown", \
        "right":"EventRight", \
        "left":"EventLeft", \
        "enter":"Enter", \
        "mute":"Mute", \
        "play":"Play", \
        "stop":"Quit", \
        "home":"Menu", \
        "dvd":"RootMenu" \
        }
        ProgramHandler.__init__(self,application_name,application_dictionary,lircd,lircrc,repeat,delay)

