#!/bin/sh
PATH=/bin:/usr/bin:/sbin:/usr/sbin
MSCORE=$(which mscore.real)
pgrep -f pulseaudio > /dev/null; PULSEAUDIO=$?
PACTL=$(which pactl)

if [ "$PULSEAUDIO" -eq "0" ] && [ -e "$PACTL" ]; then

	JACK=$($PACTL list | grep jack-sink)
	PAMIXINGVER="0.9.19"
	MIXING=$(echo `$PACTL stat | grep Version | cut -d" " -f3` $PAMIXINGVER | gawk '{ print ($1 >= $2) ? 1 : 0 }')
	PASUSPENDER=$(which pasuspender)

	if [ "$PACTL" -a "$JACK" ]; then
		echo "Using JACK for audio";
		$MSCORE "$@";
	elif [ "$MIXING" ]; then
	    echo "PulseAudio found, but no need to suspend. Starting mscore.real...";
	    $MSCORE "$@";
	elif [ "$PASUSPENDER" ]; then
		echo "Suspending PulseAudio";
		$PASUSPENDER -- $MSCORE "$@";
	else
		echo "Warning: Cannot suspend PulseAudio";
		$MSCORE "$@";
	fi

elif [ "$PULSEAUDIO" -eq "0" ] && [ ! -e "$PACTL" ]; then

	echo "Warning: PulseAudio enabled, but pactl not available"
	echo "Please install pulseaudio-utils to get the best experience"

	$MSCORE "$@";

else

	$MSCORE "$@";

fi
