/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

/* -- THIS FILE IS AUTO-GENERATED -- */

#ifndef MPIR_IMPL_H_INCLUDED
#define MPIR_IMPL_H_INCLUDED


int MPIR_Attr_delete_impl(MPIR_Comm *comm_ptr, int keyval);
int MPIR_Attr_get_impl(MPIR_Comm *comm_ptr, int keyval, void *attribute_val, int *flag);
int MPIR_Attr_put_impl(MPIR_Comm *comm_ptr, int keyval, void *attribute_val);
int MPIR_Comm_create_keyval_impl(MPI_Comm_copy_attr_function *comm_copy_attr_fn, MPI_Comm_delete_attr_function *comm_delete_attr_fn, int *comm_keyval, void *extra_state);
int MPIR_Comm_delete_attr_impl(MPIR_Comm *comm_ptr, MPII_Keyval *comm_keyval_ptr);
int MPIR_Comm_get_attr_impl(MPIR_Comm *comm_ptr, int comm_keyval, void *attribute_val, int *flag, MPIR_Attr_type attr_type);
int MPIR_Comm_get_attr_impl(MPIR_Comm *comm_ptr, int comm_keyval, void *attribute_val, int *flag, MPIR_Attr_type attr_type);
int MPIR_Comm_set_attr_impl(MPIR_Comm *comm_ptr, MPII_Keyval *comm_keyval_ptr, void *attribute_val, MPIR_Attr_type attr_type);
int MPIR_Comm_set_attr_impl(MPIR_Comm *comm_ptr, MPII_Keyval *comm_keyval_ptr, void *attribute_val, MPIR_Attr_type attr_type);
int MPIR_Keyval_create_impl(MPI_Copy_function *copy_fn, MPI_Delete_function *delete_fn, int *keyval, void *extra_state);
int MPIR_Keyval_free_impl(int *keyval);
int MPIR_Type_create_keyval_impl(MPI_Type_copy_attr_function *type_copy_attr_fn, MPI_Type_delete_attr_function *type_delete_attr_fn, int *type_keyval, void *extra_state);
int MPIR_Type_delete_attr_impl(MPIR_Datatype *datatype_ptr, MPII_Keyval *type_keyval_ptr);
int MPIR_Type_get_attr_impl(MPIR_Datatype *datatype_ptr, int type_keyval, void *attribute_val, int *flag, MPIR_Attr_type attr_type);
int MPIR_Type_get_attr_impl(MPIR_Datatype *datatype_ptr, int type_keyval, void *attribute_val, int *flag, MPIR_Attr_type attr_type);
int MPIR_Type_set_attr_impl(MPIR_Datatype *datatype_ptr, MPII_Keyval *type_keyval_ptr, void *attribute_val, MPIR_Attr_type attr_type);
int MPIR_Type_set_attr_impl(MPIR_Datatype *datatype_ptr, MPII_Keyval *type_keyval_ptr, void *attribute_val, MPIR_Attr_type attr_type);
int MPIR_Win_create_keyval_impl(MPI_Win_copy_attr_function *win_copy_attr_fn, MPI_Win_delete_attr_function *win_delete_attr_fn, int *win_keyval, void *extra_state);
int MPIR_Win_delete_attr_impl(MPIR_Win *win_ptr, MPII_Keyval *win_keyval_ptr);
int MPIR_Win_get_attr_impl(MPIR_Win *win_ptr, int win_keyval, void *attribute_val, int *flag, MPIR_Attr_type attr_type);
int MPIR_Win_get_attr_impl(MPIR_Win *win_ptr, int win_keyval, void *attribute_val, int *flag, MPIR_Attr_type attr_type);
int MPIR_Win_set_attr_impl(MPIR_Win *win_ptr, MPII_Keyval *win_keyval_ptr, void *attribute_val, MPIR_Attr_type attr_type);
int MPIR_Win_set_attr_impl(MPIR_Win *win_ptr, MPII_Keyval *win_keyval_ptr, void *attribute_val, MPIR_Attr_type attr_type);
int MPIR_Allgather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Allgather_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Allgather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Allgather_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Allgather_init_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Allgather_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Allgatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Allgatherv_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Allgatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Allgatherv_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Allgatherv_init_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Allgatherv_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Allreduce(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Allreduce_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Allreduce(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Allreduce_init(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Allreduce_init_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Allreduce_init(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Alltoall(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Alltoall_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Alltoall(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Alltoall_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Alltoall_init_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Alltoall_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Alltoallv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Alltoallv_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Alltoallv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Alltoallv_init(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Alltoallv_init_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Alltoallv_init(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Alltoallw(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Alltoallw_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Alltoallw(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Alltoallw_init(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Alltoallw_init_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Alltoallw_init(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Barrier(MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Barrier_impl(MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Barrier(MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Barrier_init(MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Barrier_init_impl(MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Barrier_init(MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Bcast(void *buffer, MPI_Aint count, MPI_Datatype datatype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Bcast_impl(void *buffer, MPI_Aint count, MPI_Datatype datatype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Bcast(void *buffer, MPI_Aint count, MPI_Datatype datatype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Bcast_init(void *buffer, MPI_Aint count, MPI_Datatype datatype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Bcast_init_impl(void *buffer, MPI_Aint count, MPI_Datatype datatype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Bcast_init(void *buffer, MPI_Aint count, MPI_Datatype datatype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Exscan(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Exscan_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Exscan(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Exscan_init(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Exscan_init_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Exscan_init(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Gather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Gather_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Gather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Gather_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Gather_init_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Gather_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Gatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Gatherv_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Gatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Gatherv_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Gatherv_init_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Gatherv_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Iallgather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iallgather_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iallgather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iallgatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iallgatherv_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iallgatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iallreduce(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iallreduce_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iallreduce(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ialltoall(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ialltoall_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ialltoall(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ialltoallv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ialltoallv_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ialltoallv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ialltoallw(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ialltoallw_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ialltoallw(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ibarrier(MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ibarrier_impl(MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ibarrier(MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ibcast(void *buffer, MPI_Aint count, MPI_Datatype datatype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ibcast_impl(void *buffer, MPI_Aint count, MPI_Datatype datatype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ibcast(void *buffer, MPI_Aint count, MPI_Datatype datatype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iexscan(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iexscan_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iexscan(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Igather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Igather_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Igather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Igatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Igatherv_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Igatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_allgather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_allgather_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_allgather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_allgatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_allgatherv_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_allgatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_alltoall(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_alltoall_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_alltoall(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_alltoallv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_alltoallv_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_alltoallv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_alltoallw(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_alltoallw_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ineighbor_alltoallw(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ireduce(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ireduce_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ireduce(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ireduce_scatter(const void *sendbuf, void *recvbuf, const MPI_Aint recvcounts[], MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ireduce_scatter_impl(const void *sendbuf, void *recvbuf, const MPI_Aint recvcounts[], MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ireduce_scatter(const void *sendbuf, void *recvbuf, const MPI_Aint recvcounts[], MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ireduce_scatter_block(const void *sendbuf, void *recvbuf, MPI_Aint recvcount, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ireduce_scatter_block_impl(const void *sendbuf, void *recvbuf, MPI_Aint recvcount, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Ireduce_scatter_block(const void *sendbuf, void *recvbuf, MPI_Aint recvcount, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iscan(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iscan_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iscan(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iscatter(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iscatter_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iscatter(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iscatterv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint displs[], MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iscatterv_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint displs[], MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Iscatterv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint displs[], MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_allgather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_allgather_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_allgather(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_allgather_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_allgather_init_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_allgather_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_allgatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_allgatherv_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_allgatherv(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_allgatherv_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_allgatherv_init_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_allgatherv_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint displs[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_alltoall(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_alltoall_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_alltoall(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_alltoall_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_alltoall_init_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_alltoall_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_alltoallv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_alltoallv_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_alltoallv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr);
int MPIR_Neighbor_alltoallv_init(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_alltoallv_init_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_alltoallv_init(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], MPI_Datatype sendtype, void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], MPI_Datatype recvtype, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_alltoallw(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr);
int MPIR_Neighbor_alltoallw_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr);
int MPIR_Neighbor_alltoallw(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr);
int MPIR_Neighbor_alltoallw_init(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_alltoallw_init_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Neighbor_alltoallw_init(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint sdispls[], const MPI_Datatype sendtypes[], void *recvbuf, const MPI_Aint recvcounts[], const MPI_Aint rdispls[], const MPI_Datatype recvtypes[], MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Reduce(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Reduce_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Reduce(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Reduce_init(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Reduce_init_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Reduce_init(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Reduce_scatter(const void *sendbuf, void *recvbuf, const MPI_Aint recvcounts[], MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Reduce_scatter_impl(const void *sendbuf, void *recvbuf, const MPI_Aint recvcounts[], MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Reduce_scatter(const void *sendbuf, void *recvbuf, const MPI_Aint recvcounts[], MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Reduce_scatter_block(const void *sendbuf, void *recvbuf, MPI_Aint recvcount, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Reduce_scatter_block_impl(const void *sendbuf, void *recvbuf, MPI_Aint recvcount, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Reduce_scatter_block(const void *sendbuf, void *recvbuf, MPI_Aint recvcount, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Reduce_scatter_block_init(const void *sendbuf, void *recvbuf, MPI_Aint recvcount, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Reduce_scatter_block_init_impl(const void *sendbuf, void *recvbuf, MPI_Aint recvcount, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Reduce_scatter_block_init(const void *sendbuf, void *recvbuf, MPI_Aint recvcount, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Reduce_scatter_init(const void *sendbuf, void *recvbuf, const MPI_Aint recvcounts[], MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Reduce_scatter_init_impl(const void *sendbuf, void *recvbuf, const MPI_Aint recvcounts[], MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Reduce_scatter_init(const void *sendbuf, void *recvbuf, const MPI_Aint recvcounts[], MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Scan(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Scan_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Scan(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Scan_init(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Scan_init_impl(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Scan_init(const void *sendbuf, void *recvbuf, MPI_Aint count, MPI_Datatype datatype, MPI_Op op, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Scatter(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Scatter_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Scatter(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Scatter_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Scatter_init_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Scatter_init(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Scatterv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint displs[], MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Scatterv_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint displs[], MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Scatterv(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint displs[], MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Errflag_t *errflag);
int MPIR_Scatterv_init(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint displs[], MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Scatterv_init_impl(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint displs[], MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Scatterv_init(const void *sendbuf, const MPI_Aint sendcounts[], const MPI_Aint displs[], MPI_Datatype sendtype, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int root, MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Request **request_ptr);
int MPIR_Comm_compare_impl(MPIR_Comm *comm1_ptr, MPIR_Comm *comm2_ptr, int *result);
int MPIR_Comm_create_impl(MPIR_Comm *comm_ptr, MPIR_Group *group_ptr, MPIR_Comm **newcomm_ptr);
int MPIR_Comm_create_group_impl(MPIR_Comm *comm_ptr, MPIR_Group *group_ptr, int tag, MPIR_Comm **newcomm_ptr);
int MPIR_Comm_dup_impl(MPIR_Comm *comm_ptr, MPIR_Comm **newcomm_ptr);
int MPIR_Comm_dup_with_info_impl(MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Comm **newcomm_ptr);
int MPIR_Comm_free_impl(MPIR_Comm *comm_ptr);
int MPIR_Comm_get_info_impl(MPIR_Comm *comm_ptr, MPIR_Info **info_used_ptr);
int MPIR_Comm_get_name_impl(MPIR_Comm *comm_ptr, char *comm_name, int *resultlen);
int MPIR_Comm_group_impl(MPIR_Comm *comm_ptr, MPIR_Group **group_ptr);
int MPIR_Comm_idup_impl(MPIR_Comm *comm_ptr, MPIR_Comm **newcomm_ptr, MPIR_Request **request_ptr);
int MPIR_Comm_idup_with_info_impl(MPIR_Comm *comm_ptr, MPIR_Info *info_ptr, MPIR_Comm **newcomm_ptr, MPIR_Request **request_ptr);
int MPIR_Comm_remote_group_impl(MPIR_Comm *comm_ptr, MPIR_Group **group_ptr);
int MPIR_Comm_set_info_impl(MPIR_Comm *comm_ptr, MPIR_Info *info_ptr);
int MPIR_Comm_split_impl(MPIR_Comm *comm_ptr, int color, int key, MPIR_Comm **newcomm_ptr);
int MPIR_Comm_split_type_impl(MPIR_Comm *comm_ptr, int split_type, int key, MPIR_Info *info_ptr, MPIR_Comm **newcomm_ptr);
int MPIR_Intercomm_create_impl(MPIR_Comm *local_comm_ptr, int local_leader, MPIR_Comm *peer_comm_ptr, int remote_leader, int tag, MPIR_Comm **newintercomm_ptr);
int MPIR_Intercomm_create_from_groups_impl(MPIR_Group *local_group_ptr, int local_leader, MPIR_Group *remote_group_ptr, int remote_leader, const char *stringtag, MPIR_Info *info_ptr, MPIR_Errhandler *errhandler_ptr, MPIR_Comm **newintercomm_ptr);
int MPIR_Intercomm_merge_impl(MPIR_Comm *intercomm_ptr, int high, MPIR_Comm **newintracomm_ptr);
int MPIR_Comm_shrink_impl(MPIR_Comm *comm_ptr, MPIR_Comm **newcomm_ptr);
int MPIR_Comm_agree_impl(MPIR_Comm *comm_ptr, int *flag);
int MPIR_Get_count_impl(const MPI_Status *status, MPI_Datatype datatype, MPI_Aint *count);
int MPIR_Pack_impl(const void *inbuf, MPI_Aint incount, MPI_Datatype datatype, void *outbuf, MPI_Aint outsize, MPI_Aint *position, MPIR_Comm *comm_ptr);
int MPIR_Pack_external_impl(const char *datarep, const void *inbuf, MPI_Aint incount, MPI_Datatype datatype, void *outbuf, MPI_Aint outsize, MPI_Aint *position);
int MPIR_Pack_external_size_impl(const char *datarep, MPI_Aint incount, MPI_Datatype datatype, MPI_Aint *size);
int MPIR_Pack_size_impl(MPI_Aint incount, MPI_Datatype datatype, MPIR_Comm *comm_ptr, MPI_Aint *size);
int MPIR_Status_set_elements_x_impl(MPI_Status *status, MPI_Datatype datatype, MPI_Count count);
int MPIR_Type_commit_impl(MPI_Datatype *datatype);
int MPIR_Type_contiguous_impl(int count, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_contiguous_large_impl(MPI_Aint count, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_darray_impl(int size, int rank, int ndims, const int array_of_gsizes[], const int array_of_distribs[], const int array_of_dargs[], const int array_of_psizes[], int order, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_darray_large_impl(int size, int rank, int ndims, const MPI_Aint array_of_gsizes[], const int array_of_distribs[], const int array_of_dargs[], const int array_of_psizes[], int order, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_hindexed_impl(int count, const int array_of_blocklengths[], const MPI_Aint array_of_displacements[], MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_hindexed_large_impl(MPI_Aint count, const MPI_Aint array_of_blocklengths[], const MPI_Aint array_of_displacements[], MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_hindexed_block_impl(int count, int blocklength, const MPI_Aint array_of_displacements[], MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_hindexed_block_large_impl(MPI_Aint count, MPI_Aint blocklength, const MPI_Aint array_of_displacements[], MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_hvector_impl(int count, int blocklength, MPI_Aint stride, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_hvector_large_impl(MPI_Aint count, MPI_Aint blocklength, MPI_Aint stride, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_indexed_block_impl(int count, int blocklength, const int array_of_displacements[], MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_indexed_block_large_impl(MPI_Aint count, MPI_Aint blocklength, const MPI_Aint array_of_displacements[], MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_resized_impl(MPI_Datatype oldtype, MPI_Aint lb, MPI_Aint extent, MPI_Datatype *newtype);
int MPIR_Type_create_resized_large_impl(MPI_Datatype oldtype, MPI_Aint lb, MPI_Aint extent, MPI_Datatype *newtype);
int MPIR_Type_create_struct_impl(int count, const int array_of_blocklengths[], const MPI_Aint array_of_displacements[], const MPI_Datatype array_of_types[], MPI_Datatype *newtype);
int MPIR_Type_create_struct_large_impl(MPI_Aint count, const MPI_Aint array_of_blocklengths[], const MPI_Aint array_of_displacements[], const MPI_Datatype array_of_types[], MPI_Datatype *newtype);
int MPIR_Type_create_subarray_impl(int ndims, const int array_of_sizes[], const int array_of_subsizes[], const int array_of_starts[], int order, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_create_subarray_large_impl(int ndims, const MPI_Aint array_of_sizes[], const MPI_Aint array_of_subsizes[], const MPI_Aint array_of_starts[], int order, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_dup_impl(MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_get_contents_impl(MPI_Datatype datatype, int max_integers, int max_addresses, int max_datatypes, int array_of_integers[], MPI_Aint array_of_addresses[], MPI_Datatype array_of_datatypes[]);
int MPIR_Type_get_contents_large_impl(MPI_Datatype datatype, MPI_Aint max_integers, MPI_Aint max_addresses, MPI_Aint max_large_counts, MPI_Aint max_datatypes, int array_of_integers[], MPI_Aint array_of_addresses[], MPI_Count array_of_large_counts[], MPI_Datatype array_of_datatypes[]);
int MPIR_Type_get_envelope_impl(MPI_Datatype datatype, int *num_integers, int *num_addresses, int *num_datatypes, int *combiner);
int MPIR_Type_get_envelope_large_impl(MPI_Datatype datatype, MPI_Aint *num_integers, MPI_Aint *num_addresses, MPI_Aint *num_large_counts, MPI_Aint *num_datatypes, int *combiner);
int MPIR_Type_get_extent_impl(MPI_Datatype datatype, MPI_Aint *lb, MPI_Aint *extent);
int MPIR_Type_get_true_extent_impl(MPI_Datatype datatype, MPI_Aint *true_lb, MPI_Aint *true_extent);
int MPIR_Type_indexed_impl(int count, const int array_of_blocklengths[], const int array_of_displacements[], MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_indexed_large_impl(MPI_Aint count, const MPI_Aint array_of_blocklengths[], const MPI_Aint array_of_displacements[], MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_match_size_impl(int typeclass, int size, MPI_Datatype *datatype);
int MPIR_Type_size_impl(MPI_Datatype datatype, MPI_Aint *size);
int MPIR_Type_size_x_impl(MPI_Datatype datatype, MPI_Count *size);
int MPIR_Type_vector_impl(int count, int blocklength, int stride, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_vector_large_impl(MPI_Aint count, MPI_Aint blocklength, MPI_Aint stride, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Unpack_impl(const void *inbuf, MPI_Aint insize, MPI_Aint *position, void *outbuf, MPI_Aint outcount, MPI_Datatype datatype, MPIR_Comm *comm_ptr);
int MPIR_Unpack_external_impl(const char datarep[], const void *inbuf, MPI_Aint insize, MPI_Aint *position, void *outbuf, MPI_Aint outcount, MPI_Datatype datatype);
int MPIR_Address_impl(void *location, MPI_Aint *address);
int MPIR_Type_hindexed_impl(int count, int array_of_blocklengths[], MPI_Aint array_of_displacements[], MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_hvector_impl(int count, int blocklength, MPI_Aint stride, MPI_Datatype oldtype, MPI_Datatype *newtype);
int MPIR_Type_struct_impl(int count, int array_of_blocklengths[], MPI_Aint array_of_displacements[], MPI_Datatype array_of_types[], MPI_Datatype *newtype);
int MPIR_Add_error_class_impl(int *errorclass);
int MPIR_Add_error_code_impl(int errorclass, int *errorcode);
int MPIR_Add_error_string_impl(int errorcode, const char *string);
int MPIR_Comm_call_errhandler_impl(MPIR_Comm *comm_ptr, int errorcode);
int MPIR_Comm_create_errhandler_impl(MPI_Comm_errhandler_function *comm_errhandler_fn, MPIR_Errhandler **errhandler_ptr);
int MPIR_Comm_get_errhandler_impl(MPIR_Comm *comm_ptr, MPI_Errhandler *errhandler);
int MPIR_Comm_set_errhandler_impl(MPIR_Comm *comm_ptr, MPIR_Errhandler *errhandler_ptr);
int MPIR_Errhandler_free_impl(MPIR_Errhandler *errhandler_ptr);
int MPIR_File_call_errhandler_impl(MPI_File fh, int errorcode);
int MPIR_File_create_errhandler_impl(MPI_File_errhandler_function *file_errhandler_fn, MPIR_Errhandler **errhandler_ptr);
int MPIR_File_get_errhandler_impl(MPI_File file, MPI_Errhandler *errhandler);
int MPIR_File_set_errhandler_impl(MPI_File file, MPIR_Errhandler *errhandler_ptr);
int MPIR_Session_call_errhandler_impl(MPIR_Session *session_ptr, int errorcode);
int MPIR_Session_create_errhandler_impl(MPI_Session_errhandler_function *session_errhandler_fn, MPIR_Errhandler **errhandler_ptr);
int MPIR_Session_get_errhandler_impl(MPIR_Session *session_ptr, MPI_Errhandler *errhandler);
int MPIR_Session_set_errhandler_impl(MPIR_Session *session_ptr, MPIR_Errhandler *errhandler_ptr);
int MPIR_Win_call_errhandler_impl(MPIR_Win *win_ptr, int errorcode);
int MPIR_Win_create_errhandler_impl(MPI_Win_errhandler_function *win_errhandler_fn, MPIR_Errhandler **errhandler_ptr);
int MPIR_Win_get_errhandler_impl(MPIR_Win *win_ptr, MPI_Errhandler *errhandler);
int MPIR_Win_set_errhandler_impl(MPIR_Win *win_ptr, MPIR_Errhandler *errhandler_ptr);
int MPIR_Delete_error_class_impl(int errorclass);
int MPIR_Delete_error_code_impl(int errorcode);
int MPIR_Delete_error_string_impl(int errorcode);
int MPIR_Errhandler_create_impl(MPI_Comm_errhandler_function *comm_errhandler_fn, MPIR_Errhandler **errhandler_ptr);
int MPIR_Errhandler_get_impl(MPIR_Comm *comm_ptr, MPIR_Errhandler **errhandler_ptr);
int MPIR_Errhandler_set_impl(MPIR_Comm *comm_ptr, MPIR_Errhandler *errhandler_ptr);
int MPIR_Group_compare_impl(MPIR_Group *group1_ptr, MPIR_Group *group2_ptr, int *result);
int MPIR_Group_difference_impl(MPIR_Group *group1_ptr, MPIR_Group *group2_ptr, MPIR_Group **newgroup_ptr);
int MPIR_Group_excl_impl(MPIR_Group *group_ptr, int n, const int ranks[], MPIR_Group **newgroup_ptr);
int MPIR_Group_free_impl(MPIR_Group *group_ptr);
int MPIR_Group_incl_impl(MPIR_Group *group_ptr, int n, const int ranks[], MPIR_Group **newgroup_ptr);
int MPIR_Group_intersection_impl(MPIR_Group *group1_ptr, MPIR_Group *group2_ptr, MPIR_Group **newgroup_ptr);
int MPIR_Group_range_excl_impl(MPIR_Group *group_ptr, int n, int ranges[][3], MPIR_Group **newgroup_ptr);
int MPIR_Group_range_incl_impl(MPIR_Group *group_ptr, int n, int ranges[][3], MPIR_Group **newgroup_ptr);
int MPIR_Group_translate_ranks_impl(MPIR_Group *group1_ptr, int n, const int ranks1[], MPIR_Group *group2_ptr, int ranks2[]);
int MPIR_Group_union_impl(MPIR_Group *group1_ptr, MPIR_Group *group2_ptr, MPIR_Group **newgroup_ptr);
int MPIR_Info_create_env_impl(int argc, char *argv[], MPIR_Info **info_ptr);
int MPIR_Info_delete_impl(MPIR_Info *info_ptr, const char *key);
int MPIR_Info_dup_impl(MPIR_Info *info_ptr, MPIR_Info **newinfo_ptr);
int MPIR_Info_free_impl(MPIR_Info *info_ptr);
int MPIR_Info_get_impl(MPIR_Info *info_ptr, const char *key, int valuelen, char *value, int *flag);
int MPIR_Info_get_nkeys_impl(MPIR_Info *info_ptr, int *nkeys);
int MPIR_Info_get_nthkey_impl(MPIR_Info *info_ptr, int n, char *key);
int MPIR_Info_get_string_impl(MPIR_Info *info_ptr, const char *key, int *buflen, char *value, int *flag);
int MPIR_Info_get_valuelen_impl(MPIR_Info *info_ptr, const char *key, int *valuelen, int *flag);
int MPIR_Info_set_impl(MPIR_Info *info_ptr, const char *key, const char *value);
int MPIR_Abort_impl(MPIR_Comm *comm_ptr, int errorcode);
int MPIR_Comm_create_from_group_impl(MPIR_Group *group_ptr, const char *stringtag, MPIR_Info *info_ptr, MPIR_Errhandler *errhandler_ptr, MPIR_Comm **newcomm_ptr);
int MPIR_Finalize_impl(void);
int MPIR_Group_from_session_pset_impl(MPIR_Session *session_ptr, const char *pset_name, MPIR_Group **newgroup_ptr);
int MPIR_Init_impl(int *argc, char ***argv);
int MPIR_Init_thread_impl(int *argc, char ***argv, int required, int *provided);
int MPIR_Session_finalize_impl(MPIR_Session *session_ptr);
int MPIR_Session_get_info_impl(MPIR_Session *session_ptr, MPIR_Info **info_used_ptr);
int MPIR_Session_get_nth_pset_impl(MPIR_Session *session_ptr, MPIR_Info *info_ptr, int n, int *pset_len, char *pset_name);
int MPIR_Session_get_num_psets_impl(MPIR_Session *session_ptr, MPIR_Info *info_ptr, int *npset_names);
int MPIR_Session_get_pset_info_impl(MPIR_Session *session_ptr, const char *pset_name, MPIR_Info **info_ptr);
int MPIR_Session_init_impl(MPIR_Info *info_ptr, MPIR_Errhandler *errhandler_ptr, MPIR_Session **session_ptr);
int MPIR_T_category_get_categories_impl(int cat_index, int len, int indices[]);
int MPIR_T_category_get_cvars_impl(int cat_index, int len, int indices[]);
int MPIR_T_category_get_events_impl(int cat_index, int len, int indices[]);
int MPIR_T_category_get_num_events_impl(int cat_index, int *num_events);
int MPIR_T_category_get_pvars_impl(int cat_index, int len, int indices[]);
int MPIR_T_cvar_handle_alloc_impl(int cvar_index, void *obj_handle, MPI_T_cvar_handle *handle, int *count);
int MPIR_T_cvar_read_impl(MPI_T_cvar_handle handle, void *buf);
int MPIR_T_cvar_write_impl(MPI_T_cvar_handle handle, const void *buf);
int MPIR_T_event_callback_get_info_impl(MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, MPIR_Info **info_used_ptr);
int MPIR_T_event_callback_set_info_impl(MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, MPIR_Info *info_ptr);
int MPIR_T_event_copy_impl(MPI_T_event_instance event_instance, void *buffer);
int MPIR_T_event_get_index_impl(const char *name, int *event_index);
int MPIR_T_event_get_info_impl(int event_index, char *name, int *name_len, int *verbosity, MPI_Datatype array_of_datatypes[], MPI_Aint array_of_displacements[], int *num_elements, MPI_T_enum *enumtype, MPI_Info *info, char *desc, int *desc_len, int *bind);
int MPIR_T_event_get_num_impl(int *num_events);
int MPIR_T_event_get_source_impl(MPI_T_event_instance event_instance, int *source_index);
int MPIR_T_event_get_timestamp_impl(MPI_T_event_instance event_instance, MPI_Count *event_timestamp);
int MPIR_T_event_handle_alloc_impl(int event_index, void *obj_handle, MPIR_Info *info_ptr, MPI_T_event_registration *event_registration);
int MPIR_T_event_handle_free_impl(MPI_T_event_registration event_registration, void *user_data, MPI_T_event_free_cb_function free_cb_function);
int MPIR_T_event_handle_get_info_impl(MPI_T_event_registration event_registration, MPIR_Info **info_used_ptr);
int MPIR_T_event_handle_set_info_impl(MPI_T_event_registration event_registration, MPIR_Info *info_ptr);
int MPIR_T_event_read_impl(MPI_T_event_instance event_instance, int element_index, void *buffer);
int MPIR_T_event_register_callback_impl(MPI_T_event_registration event_registration, MPI_T_cb_safety cb_safety, MPIR_Info *info_ptr, void *user_data, MPI_T_event_cb_function event_cb_function);
int MPIR_T_event_set_dropped_handler_impl(MPI_T_event_registration event_registration, MPI_T_event_dropped_cb_function dropped_cb_function);
int MPIR_T_pvar_handle_alloc_impl(MPI_T_pvar_session session, int pvar_index, void *obj_handle, MPI_T_pvar_handle *handle, int *count);
int MPIR_T_pvar_handle_free_impl(MPI_T_pvar_session session, MPI_T_pvar_handle *handle);
int MPIR_T_pvar_read_impl(MPI_T_pvar_session session, MPI_T_pvar_handle handle, void *buf);
int MPIR_T_pvar_readreset_impl(MPI_T_pvar_session session, MPI_T_pvar_handle handle, void *buf);
int MPIR_T_pvar_session_create_impl(MPI_T_pvar_session *session);
int MPIR_T_pvar_session_free_impl(MPI_T_pvar_session *session);
int MPIR_T_pvar_write_impl(MPI_T_pvar_session session, MPI_T_pvar_handle handle, const void *buf);
int MPIR_T_source_get_info_impl(int source_index, char *name, int *name_len, char *desc, int *desc_len, MPI_T_source_order *ordering, MPI_Count *ticks_per_second, MPI_Count *max_ticks, MPI_Info *info);
int MPIR_T_source_get_num_impl(int *num_sources);
int MPIR_T_source_get_timestamp_impl(int source_index, MPI_Count *timestamp);
int MPIR_Op_commutative_impl(MPI_Op op, int *commute);
int MPIR_Op_create_impl(MPI_User_function *user_fn, int commute, MPIR_Op **op_ptr);
int MPIR_Op_create_large_impl(MPI_User_function_c *user_fn, int commute, MPIR_Op **op_ptr);
int MPIR_Op_free_impl(MPIR_Op *op_ptr);
int MPIR_Buffer_detach_impl(void *buffer_addr, MPI_Aint *size);
int MPIR_Isendrecv_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, int dest, int sendtag, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int source, int recvtag, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Isendrecv_replace_impl(void *buf, MPI_Aint count, MPI_Datatype datatype, int dest, int sendtag, int source, int recvtag, MPIR_Comm *comm_ptr, MPIR_Request **request_ptr);
int MPIR_Sendrecv_impl(const void *sendbuf, MPI_Aint sendcount, MPI_Datatype sendtype, int dest, int sendtag, void *recvbuf, MPI_Aint recvcount, MPI_Datatype recvtype, int source, int recvtag, MPIR_Comm *comm_ptr, MPI_Status *status);
int MPIR_Sendrecv_replace_impl(void *buf, MPI_Aint count, MPI_Datatype datatype, int dest, int sendtag, int source, int recvtag, MPIR_Comm *comm_ptr, MPI_Status *status);
int MPIR_Cancel_impl(MPIR_Request *request_ptr);
int MPIR_Grequest_complete_impl(MPIR_Request *request_ptr);
int MPIR_Grequest_start_impl(MPI_Grequest_query_function *query_fn, MPI_Grequest_free_function *free_fn, MPI_Grequest_cancel_function *cancel_fn, void *extra_state, MPIR_Request **request_ptr);
int MPIR_Request_free_impl(MPIR_Request *request_ptr);
int MPIR_Request_get_status_impl(MPIR_Request *request_ptr, int *flag, MPI_Status *status);
int MPIR_Grequest_class_create_impl(MPI_Grequest_query_function *query_fn, MPI_Grequest_free_function *free_fn, MPI_Grequest_cancel_function *cancel_fn, MPIX_Grequest_poll_function *poll_fn, MPIX_Grequest_wait_function *wait_fn, MPIX_Grequest_class *greq_class);
int MPIR_Grequest_class_allocate_impl(MPIX_Grequest_class greq_class, void *extra_state, MPIR_Request **request_ptr);
int MPIR_Close_port_impl(const char *port_name);
int MPIR_Comm_accept_impl(const char *port_name, MPIR_Info *info_ptr, int root, MPIR_Comm *comm_ptr, MPIR_Comm **newcomm_ptr);
int MPIR_Comm_connect_impl(const char *port_name, MPIR_Info *info_ptr, int root, MPIR_Comm *comm_ptr, MPIR_Comm **newcomm_ptr);
int MPIR_Comm_disconnect_impl(MPIR_Comm *comm_ptr);
int MPIR_Comm_join_impl(int fd, MPIR_Comm **intercomm_ptr);
int MPIR_Comm_spawn_impl(const char *command, char *argv[], int maxprocs, MPIR_Info *info_ptr, int root, MPIR_Comm *comm_ptr, MPIR_Comm **intercomm_ptr, int array_of_errcodes[]);
int MPIR_Comm_spawn_multiple_impl(int count, char *array_of_commands[], char **array_of_argv[], const int array_of_maxprocs[], MPIR_Info **array_of_info_ptrs, int root, MPIR_Comm *comm_ptr, MPIR_Comm **intercomm_ptr, int array_of_errcodes[]);
int MPIR_Lookup_name_impl(const char *service_name, MPIR_Info *info_ptr, char *port_name);
int MPIR_Open_port_impl(MPIR_Info *info_ptr, char *port_name);
int MPIR_Publish_name_impl(const char *service_name, MPIR_Info *info_ptr, const char *port_name);
int MPIR_Unpublish_name_impl(const char *service_name, MPIR_Info *info_ptr, const char *port_name);
int MPIR_Cart_coords_impl(MPIR_Comm *comm_ptr, int rank, int maxdims, int coords[]);
int MPIR_Cart_create_impl(MPIR_Comm *comm_old_ptr, int ndims, const int dims[], const int periods[], int reorder, MPIR_Comm **comm_cart_ptr);
int MPIR_Cart_get_impl(MPIR_Comm *comm_ptr, int maxdims, int dims[], int periods[], int coords[]);
int MPIR_Cart_map_impl(MPIR_Comm *comm_ptr, int ndims, const int dims[], const int periods[], int *newrank);
int MPIR_Cart_rank_impl(MPIR_Comm *comm_ptr, const int coords[], int *rank);
int MPIR_Cart_shift_impl(MPIR_Comm *comm_ptr, int direction, int disp, int *rank_source, int *rank_dest);
int MPIR_Cart_sub_impl(MPIR_Comm *comm_ptr, const int remain_dims[], MPIR_Comm **newcomm_ptr);
int MPIR_Cartdim_get_impl(MPIR_Comm *comm_ptr, int *ndims);
int MPIR_Dims_create_impl(int nnodes, int ndims, int dims[]);
int MPIR_Dist_graph_create_impl(MPIR_Comm *comm_old_ptr, int n, const int sources[], const int degrees[], const int destinations[], const int weights[], MPIR_Info *info_ptr, int reorder, MPIR_Comm **comm_dist_graph_ptr);
int MPIR_Dist_graph_create_adjacent_impl(MPIR_Comm *comm_old_ptr, int indegree, const int sources[], const int sourceweights[], int outdegree, const int destinations[], const int destweights[], MPIR_Info *info_ptr, int reorder, MPIR_Comm **comm_dist_graph_ptr);
int MPIR_Dist_graph_neighbors_impl(MPIR_Comm *comm_ptr, int maxindegree, int sources[], int sourceweights[], int maxoutdegree, int destinations[], int destweights[]);
int MPIR_Dist_graph_neighbors_count_impl(MPIR_Comm *comm_ptr, int *indegree, int *outdegree, int *weighted);
int MPIR_Graph_create_impl(MPIR_Comm *comm_old_ptr, int nnodes, const int indx[], const int edges[], int reorder, MPIR_Comm **comm_graph_ptr);
int MPIR_Graph_get_impl(MPIR_Comm *comm_ptr, int maxindex, int maxedges, int indx[], int edges[]);
int MPIR_Graph_map_impl(MPIR_Comm *comm_ptr, int nnodes, const int indx[], const int edges[], int *newrank);
int MPIR_Graph_neighbors_impl(MPIR_Comm *comm_ptr, int rank, int maxneighbors, int neighbors[]);
int MPIR_Graph_neighbors_count_impl(MPIR_Comm *comm_ptr, int rank, int *nneighbors);
int MPIR_Graphdims_get_impl(MPIR_Comm *comm_ptr, int *nnodes, int *nedges);
int MPIR_Topo_test_impl(MPIR_Comm *comm_ptr, int *status);

#endif /* MPIR_IMPL_H_INCLUDED */
