
skip_if(ostype == "Windows")
skip_if(string.sub(ostype, 1, 6) == "CYGWIN")
skip_if(not existsonpath("chmod"))
mtn_setup()

addfile("testfile", "blah blah")

-- unreadable file
check({"chmod", "a-rw", "test.db"})
check(mtn(), 2, false, false)
check(mtn("ls", "branches"), 1, false, false)
check(mtn("db", "info"), 1, false, false)
check(mtn("db", "version"), 1, false, false)
check(mtn("db", "migrate"), 1, false, false)
check(mtn("commit", "-mfoo"), 1, false, false)
check(mtn("db", "load"), 1, false, false)
check({"chmod", "a+rw", "test.db"})

-- unwritable file (read-only operations succeed)
check({"chmod", "a-w", "test.db"})
check(mtn(), 2, false, false)
check(mtn("ls", "branches"), 0, false, false)
check(mtn("db", "info"), 0, false, false)
check(mtn("db", "version"), 0, false, false)
check(mtn("db", "migrate"), 1, false, false)
check(mtn("commit", "-mfoo"), 1, false, false)
check(mtn("db", "load"), 1, false, false)
check({"chmod", "a+w", "test.db"})

mkdir("subdir")
check(mtn("--db=subdir/foo.db", "db", "init"), 0, false, false)

-- unreadable directory
check({"chmod", "a-rwx", "subdir"})
check(mtn("--db=subdir/foo.db"), 2, false, false)
check(mtn("--db=subdir/foo.db", "ls", "branches"), 1, false, false)
check(mtn("--db=subdir/foo.db", "db", "info"), 1, false, false)
check(mtn("--db=subdir/foo.db", "db", "version"), 1, false, false)
check(mtn("--db=subdir/foo.db", "db", "migrate"), 1, false, false)
check(mtn("--db=subdir/bar.db", "db", "load"), 1, false, false)
check(mtn("--db=subdir/baz.db", "db", "init"), 1, false, false)
check({"chmod", "a+rwx", "subdir"})

-- unwritable directory (read-only operations succeed)
check({"chmod", "a-w", "subdir"})
check(mtn("--db=subdir/foo.db"), 2, false, false)
check(mtn("--db=subdir/foo.db", "ls", "branches"), 0, false, false)
check(mtn("--db=subdir/foo.db", "db", "info"), 0, false, false)
check(mtn("--db=subdir/foo.db", "db", "version"), 0, false, false)
check(mtn("--db=subdir/bar.db", "db", "load"), 1, false, false)
check(mtn("--db=subdir/baz.db", "db", "init"), 1, false, false)
check({"chmod", "a+w", "subdir"})

-- search-only directory (-r, +x) (all operations succeed)
check({"chmod", "a-r", "subdir"})
check(mtn("--db=subdir/foo.db"), 2, false, false)
check(mtn("--db=subdir/foo.db", "ls", "branches"), 0, false, false)
check(mtn("--db=subdir/foo.db", "db", "info"), 0, false, false)
check(mtn("--db=subdir/foo.db", "db", "version"), 0, false, false)
check(mtn("--db=subdir/bar.db", "db", "load"), 0, false, false)

-- Since at least sqlite 3.5.9, these operations fail if the parent
-- directory is not readable. This is caused by sqlite3 trying to
-- read-write open a journal file in the same directory where the database
-- itself resides. So migrate and init fail, because they contain writing
-- transactions. On older sqlite versions (for sure 3.3.8 and before)
-- these tests succeed, because no journal file is opened and the db file
-- itself is still writable.
--
-- See: http://www.sqlite.org/tempfiles.html
--
-- check(mtn("--db=subdir/foo.db", "db", "migrate"), 0, false, false)
-- check(mtn("--db=subdir/baz.db", "db", "init"), 0, false, false)

check({"chmod", "a+r", "subdir"})
