#include <glib.h>

#include <caml/alloc.h>

CAMLprim value
_ml_g_date_current_time (value unit)
{
  GDate date, *p;
  GTimeVal current;
  value v;
  g_get_current_time (&current);
  g_date_clear (&date, 1);
  g_date_set_time (&date, current.tv_sec);
  v = caml_alloc_small (sizeof (GDate) / sizeof (value), Abstract_tag);
  p = (GDate *) v;
  *p = date;
  return v;
}

CAMLprim value
_ml_g_date_set_dmy (value d, value m, value y)
{
  GDate date, *p;
  value v;
  g_date_clear (&date, 1);
  g_date_set_dmy (&date, Int_val(d), Int_val(m), Int_val(y));
  v = caml_alloc_small (sizeof (GDate) / sizeof (value), Abstract_tag);
  p = (GDate *) v;
  *p = date;
  return v;
}

#define GDate_val(v)		(GDate *) (v)

CAMLprim value
_ml_g_date_strftime (value d, value fmt, value buff)
{
  GDate *date = (GDate *)(d);
  gsize n;
  n = g_date_strftime (String_val(buff), caml_string_length(buff) + 1, 
		       String_val(fmt), date);
  return Val_int (n);
}

CAMLprim value
_ml_g_date_add_months (value d, value n)
{
  GDate *date = GDate_val (d);
  g_date_add_months (date, Int_val(n));
  return Val_unit;
}

CAMLprim value
_ml_g_date_subtract_months (value d, value n)
{
  GDate *date = GDate_val (d);
  g_date_subtract_months (date, Int_val(n));
  return Val_unit;
}
