// this file was autogenerated by a tool.
using System;
using System.IO;
using NUnit.Framework;
using ICSharpCode.NRefactory.VB;
using ICSharpCode.NRefactory.VB.Parser;
using ICSharpCode.NRefactory.VB.PrettyPrinter;

namespace ICSharpCode.NRefactory.VB.Tests.Lexer
{
	[TestFixture]
	public sealed class LexerTests
	{
		VBLexer GenerateLexer(StringReader sr)
		{
			return new VBLexer(sr);
		}

		[Test]
		public void TestAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader("="));
			Assert.AreEqual(Tokens.Assign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestColon()
		{
			VBLexer lexer = GenerateLexer(new StringReader(":"));
			Assert.AreEqual(Tokens.Colon, lexer.NextToken().Kind);
		}

		[Test]
		public void TestComma()
		{
			VBLexer lexer = GenerateLexer(new StringReader(","));
			Assert.AreEqual(Tokens.Comma, lexer.NextToken().Kind);
		}

		[Test]
		public void TestConcatString()
		{
			VBLexer lexer = GenerateLexer(new StringReader("&"));
			Assert.AreEqual(Tokens.ConcatString, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDiv()
		{
			VBLexer lexer = GenerateLexer(new StringReader("/"));
			Assert.AreEqual(Tokens.Div, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDivInteger()
		{
			VBLexer lexer = GenerateLexer(new StringReader("\\"));
			Assert.AreEqual(Tokens.DivInteger, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDot()
		{
			VBLexer lexer = GenerateLexer(new StringReader("."));
			Assert.AreEqual(Tokens.Dot, lexer.NextToken().Kind);
		}

		[Test]
		public void TestTripleDot()
		{
			VBLexer lexer = GenerateLexer(new StringReader("..."));
			Assert.AreEqual(Tokens.TripleDot, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDotAt()
		{
			VBLexer lexer = GenerateLexer(new StringReader(".@"));
			Assert.AreEqual(Tokens.DotAt, lexer.NextToken().Kind);
		}

		[Test]
		public void TestExclamationMark()
		{
			VBLexer lexer = GenerateLexer(new StringReader("!"));
			Assert.AreEqual(Tokens.ExclamationMark, lexer.NextToken().Kind);
		}

		[Test]
		public void TestMinus()
		{
			VBLexer lexer = GenerateLexer(new StringReader("-"));
			Assert.AreEqual(Tokens.Minus, lexer.NextToken().Kind);
		}

		[Test]
		public void TestPlus()
		{
			VBLexer lexer = GenerateLexer(new StringReader("+"));
			Assert.AreEqual(Tokens.Plus, lexer.NextToken().Kind);
		}

		[Test]
		public void TestPower()
		{
			VBLexer lexer = GenerateLexer(new StringReader("^"));
			Assert.AreEqual(Tokens.Power, lexer.NextToken().Kind);
		}

		[Test]
		public void TestQuestionMark()
		{
			VBLexer lexer = GenerateLexer(new StringReader("?"));
			Assert.AreEqual(Tokens.QuestionMark, lexer.NextToken().Kind);
		}

		[Test]
		public void TestTimes()
		{
			VBLexer lexer = GenerateLexer(new StringReader("*"));
			Assert.AreEqual(Tokens.Times, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOpenCurlyBrace()
		{
			VBLexer lexer = GenerateLexer(new StringReader("{"));
			Assert.AreEqual(Tokens.OpenCurlyBrace, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCloseCurlyBrace()
		{
			VBLexer lexer = GenerateLexer(new StringReader("}"));
			Assert.AreEqual(Tokens.CloseCurlyBrace, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOpenParenthesis()
		{
			VBLexer lexer = GenerateLexer(new StringReader("("));
			Assert.AreEqual(Tokens.OpenParenthesis, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCloseParenthesis()
		{
			VBLexer lexer = GenerateLexer(new StringReader(")"));
			Assert.AreEqual(Tokens.CloseParenthesis, lexer.NextToken().Kind);
		}

		[Test]
		public void TestGreaterThan()
		{
			VBLexer lexer = GenerateLexer(new StringReader(">"));
			Assert.AreEqual(Tokens.GreaterThan, lexer.NextToken().Kind);
		}

		[Test]
		public void TestLessThan()
		{
			VBLexer lexer = GenerateLexer(new StringReader("<"));
			Assert.AreEqual(Tokens.LessThan, lexer.NextToken().Kind);
		}

		[Test]
		public void TestNotEqual()
		{
			VBLexer lexer = GenerateLexer(new StringReader("<>"));
			Assert.AreEqual(Tokens.NotEqual, lexer.NextToken().Kind);
		}

		[Test]
		public void TestGreaterEqual()
		{
			VBLexer lexer = GenerateLexer(new StringReader(">="));
			Assert.AreEqual(Tokens.GreaterEqual, lexer.NextToken().Kind);
		}

		[Test]
		public void TestLessEqual()
		{
			VBLexer lexer = GenerateLexer(new StringReader("<="));
			Assert.AreEqual(Tokens.LessEqual, lexer.NextToken().Kind);
		}

		[Test]
		public void TestShiftLeft()
		{
			VBLexer lexer = GenerateLexer(new StringReader("<<"));
			Assert.AreEqual(Tokens.ShiftLeft, lexer.NextToken().Kind);
		}

		[Test]
		public void TestShiftRight()
		{
			VBLexer lexer = GenerateLexer(new StringReader(">>"));
			Assert.AreEqual(Tokens.ShiftRight, lexer.NextToken().Kind);
		}

		[Test]
		public void TestPlusAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader("+="));
			Assert.AreEqual(Tokens.PlusAssign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestPowerAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader("^="));
			Assert.AreEqual(Tokens.PowerAssign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestMinusAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader("-="));
			Assert.AreEqual(Tokens.MinusAssign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestTimesAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader("*="));
			Assert.AreEqual(Tokens.TimesAssign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDivAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader("/="));
			Assert.AreEqual(Tokens.DivAssign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDivIntegerAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader("\\="));
			Assert.AreEqual(Tokens.DivIntegerAssign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestShiftLeftAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader("<<="));
			Assert.AreEqual(Tokens.ShiftLeftAssign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestShiftRightAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader(">>="));
			Assert.AreEqual(Tokens.ShiftRightAssign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestConcatStringAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader("&="));
			Assert.AreEqual(Tokens.ConcatStringAssign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestColonAssign()
		{
			VBLexer lexer = GenerateLexer(new StringReader(":="));
			Assert.AreEqual(Tokens.ColonAssign, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAddHandler()
		{
			VBLexer lexer = GenerateLexer(new StringReader("AddHandler"));
			Assert.AreEqual(Tokens.AddHandler, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAddressOf()
		{
			VBLexer lexer = GenerateLexer(new StringReader("AddressOf"));
			Assert.AreEqual(Tokens.AddressOf, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAggregate()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Aggregate"));
			Assert.AreEqual(Tokens.Aggregate, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAlias()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Alias"));
			Assert.AreEqual(Tokens.Alias, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAnd()
		{
			VBLexer lexer = GenerateLexer(new StringReader("And"));
			Assert.AreEqual(Tokens.And, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAndAlso()
		{
			VBLexer lexer = GenerateLexer(new StringReader("AndAlso"));
			Assert.AreEqual(Tokens.AndAlso, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAnsi()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Ansi"));
			Assert.AreEqual(Tokens.Ansi, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAs()
		{
			VBLexer lexer = GenerateLexer(new StringReader("As"));
			Assert.AreEqual(Tokens.As, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAscending()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Ascending"));
			Assert.AreEqual(Tokens.Ascending, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAssembly()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Assembly"));
			Assert.AreEqual(Tokens.Assembly, lexer.NextToken().Kind);
		}

		[Test]
		public void TestAuto()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Auto"));
			Assert.AreEqual(Tokens.Auto, lexer.NextToken().Kind);
		}

		[Test]
		public void TestBinary()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Binary"));
			Assert.AreEqual(Tokens.Binary, lexer.NextToken().Kind);
		}

		[Test]
		public void TestBoolean()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Boolean"));
			Assert.AreEqual(Tokens.Boolean, lexer.NextToken().Kind);
		}

		[Test]
		public void TestByRef()
		{
			VBLexer lexer = GenerateLexer(new StringReader("ByRef"));
			Assert.AreEqual(Tokens.ByRef, lexer.NextToken().Kind);
		}

		[Test]
		public void TestBy()
		{
			VBLexer lexer = GenerateLexer(new StringReader("By"));
			Assert.AreEqual(Tokens.By, lexer.NextToken().Kind);
		}

		[Test]
		public void TestByte()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Byte"));
			Assert.AreEqual(Tokens.Byte, lexer.NextToken().Kind);
		}

		[Test]
		public void TestByVal()
		{
			VBLexer lexer = GenerateLexer(new StringReader("ByVal"));
			Assert.AreEqual(Tokens.ByVal, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCall()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Call"));
			Assert.AreEqual(Tokens.Call, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCase()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Case"));
			Assert.AreEqual(Tokens.Case, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCatch()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Catch"));
			Assert.AreEqual(Tokens.Catch, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCBool()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CBool"));
			Assert.AreEqual(Tokens.CBool, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCByte()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CByte"));
			Assert.AreEqual(Tokens.CByte, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCChar()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CChar"));
			Assert.AreEqual(Tokens.CChar, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCDate()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CDate"));
			Assert.AreEqual(Tokens.CDate, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCDbl()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CDbl"));
			Assert.AreEqual(Tokens.CDbl, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCDec()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CDec"));
			Assert.AreEqual(Tokens.CDec, lexer.NextToken().Kind);
		}

		[Test]
		public void TestChar()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Char"));
			Assert.AreEqual(Tokens.Char, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCInt()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CInt"));
			Assert.AreEqual(Tokens.CInt, lexer.NextToken().Kind);
		}

		[Test]
		public void TestClass()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Class"));
			Assert.AreEqual(Tokens.Class, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCLng()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CLng"));
			Assert.AreEqual(Tokens.CLng, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCObj()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CObj"));
			Assert.AreEqual(Tokens.CObj, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCompare()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Compare"));
			Assert.AreEqual(Tokens.Compare, lexer.NextToken().Kind);
		}

		[Test]
		public void TestConst()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Const"));
			Assert.AreEqual(Tokens.Const, lexer.NextToken().Kind);
		}

		[Test]
		public void TestContinue()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Continue"));
			Assert.AreEqual(Tokens.Continue, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCSByte()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CSByte"));
			Assert.AreEqual(Tokens.CSByte, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCShort()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CShort"));
			Assert.AreEqual(Tokens.CShort, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCSng()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CSng"));
			Assert.AreEqual(Tokens.CSng, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCStr()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CStr"));
			Assert.AreEqual(Tokens.CStr, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCType()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CType"));
			Assert.AreEqual(Tokens.CType, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCUInt()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CUInt"));
			Assert.AreEqual(Tokens.CUInt, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCULng()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CULng"));
			Assert.AreEqual(Tokens.CULng, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCUShort()
		{
			VBLexer lexer = GenerateLexer(new StringReader("CUShort"));
			Assert.AreEqual(Tokens.CUShort, lexer.NextToken().Kind);
		}

		[Test]
		public void TestCustom()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Custom"));
			Assert.AreEqual(Tokens.Custom, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDate()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Date"));
			Assert.AreEqual(Tokens.Date, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDecimal()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Decimal"));
			Assert.AreEqual(Tokens.Decimal, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDeclare()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Declare"));
			Assert.AreEqual(Tokens.Declare, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDefault()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Default"));
			Assert.AreEqual(Tokens.Default, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDelegate()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Delegate"));
			Assert.AreEqual(Tokens.Delegate, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDescending()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Descending"));
			Assert.AreEqual(Tokens.Descending, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDim()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Dim"));
			Assert.AreEqual(Tokens.Dim, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDirectCast()
		{
			VBLexer lexer = GenerateLexer(new StringReader("DirectCast"));
			Assert.AreEqual(Tokens.DirectCast, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDistinct()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Distinct"));
			Assert.AreEqual(Tokens.Distinct, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDo()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Do"));
			Assert.AreEqual(Tokens.Do, lexer.NextToken().Kind);
		}

		[Test]
		public void TestDouble()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Double"));
			Assert.AreEqual(Tokens.Double, lexer.NextToken().Kind);
		}

		[Test]
		public void TestEach()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Each"));
			Assert.AreEqual(Tokens.Each, lexer.NextToken().Kind);
		}

		[Test]
		public void TestElse()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Else"));
			Assert.AreEqual(Tokens.Else, lexer.NextToken().Kind);
		}

		[Test]
		public void TestElseIf()
		{
			VBLexer lexer = GenerateLexer(new StringReader("ElseIf"));
			Assert.AreEqual(Tokens.ElseIf, lexer.NextToken().Kind);
		}

		[Test]
		public void TestEnd()
		{
			VBLexer lexer = GenerateLexer(new StringReader("End"));
			Assert.AreEqual(Tokens.End, lexer.NextToken().Kind);
		}

		[Test]
		public void TestEndIf()
		{
			VBLexer lexer = GenerateLexer(new StringReader("EndIf"));
			Assert.AreEqual(Tokens.EndIf, lexer.NextToken().Kind);
		}

		[Test]
		public void TestEnum()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Enum"));
			Assert.AreEqual(Tokens.Enum, lexer.NextToken().Kind);
		}

		[Test]
		public void TestEquals()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Equals"));
			Assert.AreEqual(Tokens.Equals, lexer.NextToken().Kind);
		}

		[Test]
		public void TestErase()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Erase"));
			Assert.AreEqual(Tokens.Erase, lexer.NextToken().Kind);
		}

		[Test]
		public void TestError()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Error"));
			Assert.AreEqual(Tokens.Error, lexer.NextToken().Kind);
		}

		[Test]
		public void TestEvent()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Event"));
			Assert.AreEqual(Tokens.Event, lexer.NextToken().Kind);
		}

		[Test]
		public void TestExit()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Exit"));
			Assert.AreEqual(Tokens.Exit, lexer.NextToken().Kind);
		}

		[Test]
		public void TestExplicit()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Explicit"));
			Assert.AreEqual(Tokens.Explicit, lexer.NextToken().Kind);
		}

		[Test]
		public void TestFalse()
		{
			VBLexer lexer = GenerateLexer(new StringReader("False"));
			Assert.AreEqual(Tokens.False, lexer.NextToken().Kind);
		}

		[Test]
		public void TestFinally()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Finally"));
			Assert.AreEqual(Tokens.Finally, lexer.NextToken().Kind);
		}

		[Test]
		public void TestFor()
		{
			VBLexer lexer = GenerateLexer(new StringReader("For"));
			Assert.AreEqual(Tokens.For, lexer.NextToken().Kind);
		}

		[Test]
		public void TestFriend()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Friend"));
			Assert.AreEqual(Tokens.Friend, lexer.NextToken().Kind);
		}

		[Test]
		public void TestFrom()
		{
			VBLexer lexer = GenerateLexer(new StringReader("From"));
			Assert.AreEqual(Tokens.From, lexer.NextToken().Kind);
		}

		[Test]
		public void TestFunction()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Function"));
			Assert.AreEqual(Tokens.Function, lexer.NextToken().Kind);
		}

		[Test]
		public void TestGet()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Get"));
			Assert.AreEqual(Tokens.Get, lexer.NextToken().Kind);
		}

		[Test]
		public void TestGetType()
		{
			VBLexer lexer = GenerateLexer(new StringReader("GetType"));
			Assert.AreEqual(Tokens.GetType, lexer.NextToken().Kind);
		}

		[Test]
		public void TestGlobal()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Global"));
			Assert.AreEqual(Tokens.Global, lexer.NextToken().Kind);
		}

		[Test]
		public void TestGoSub()
		{
			VBLexer lexer = GenerateLexer(new StringReader("GoSub"));
			Assert.AreEqual(Tokens.GoSub, lexer.NextToken().Kind);
		}

		[Test]
		public void TestGoTo()
		{
			VBLexer lexer = GenerateLexer(new StringReader("GoTo"));
			Assert.AreEqual(Tokens.GoTo, lexer.NextToken().Kind);
		}

		[Test]
		public void TestGroup()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Group"));
			Assert.AreEqual(Tokens.Group, lexer.NextToken().Kind);
		}

		[Test]
		public void TestHandles()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Handles"));
			Assert.AreEqual(Tokens.Handles, lexer.NextToken().Kind);
		}

		[Test]
		public void TestIf()
		{
			VBLexer lexer = GenerateLexer(new StringReader("If"));
			Assert.AreEqual(Tokens.If, lexer.NextToken().Kind);
		}

		[Test]
		public void TestImplements()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Implements"));
			Assert.AreEqual(Tokens.Implements, lexer.NextToken().Kind);
		}

		[Test]
		public void TestImports()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Imports"));
			Assert.AreEqual(Tokens.Imports, lexer.NextToken().Kind);
		}

		[Test]
		public void TestIn()
		{
			VBLexer lexer = GenerateLexer(new StringReader("In"));
			Assert.AreEqual(Tokens.In, lexer.NextToken().Kind);
		}

		[Test]
		public void TestInfer()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Infer"));
			Assert.AreEqual(Tokens.Infer, lexer.NextToken().Kind);
		}

		[Test]
		public void TestInherits()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Inherits"));
			Assert.AreEqual(Tokens.Inherits, lexer.NextToken().Kind);
		}

		[Test]
		public void TestInteger()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Integer"));
			Assert.AreEqual(Tokens.Integer, lexer.NextToken().Kind);
		}

		[Test]
		public void TestInterface()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Interface"));
			Assert.AreEqual(Tokens.Interface, lexer.NextToken().Kind);
		}

		[Test]
		public void TestInto()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Into"));
			Assert.AreEqual(Tokens.Into, lexer.NextToken().Kind);
		}

		[Test]
		public void TestIs()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Is"));
			Assert.AreEqual(Tokens.Is, lexer.NextToken().Kind);
		}

		[Test]
		public void TestIsNot()
		{
			VBLexer lexer = GenerateLexer(new StringReader("IsNot"));
			Assert.AreEqual(Tokens.IsNot, lexer.NextToken().Kind);
		}

		[Test]
		public void TestJoin()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Join"));
			Assert.AreEqual(Tokens.Join, lexer.NextToken().Kind);
		}

		[Test]
		public void TestKey()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Key"));
			Assert.AreEqual(Tokens.Key, lexer.NextToken().Kind);
		}

		[Test]
		public void TestLet()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Let"));
			Assert.AreEqual(Tokens.Let, lexer.NextToken().Kind);
		}

		[Test]
		public void TestLib()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Lib"));
			Assert.AreEqual(Tokens.Lib, lexer.NextToken().Kind);
		}

		[Test]
		public void TestLike()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Like"));
			Assert.AreEqual(Tokens.Like, lexer.NextToken().Kind);
		}

		[Test]
		public void TestLong()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Long"));
			Assert.AreEqual(Tokens.Long, lexer.NextToken().Kind);
		}

		[Test]
		public void TestLoop()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Loop"));
			Assert.AreEqual(Tokens.Loop, lexer.NextToken().Kind);
		}

		[Test]
		public void TestMe()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Me"));
			Assert.AreEqual(Tokens.Me, lexer.NextToken().Kind);
		}

		[Test]
		public void TestMod()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Mod"));
			Assert.AreEqual(Tokens.Mod, lexer.NextToken().Kind);
		}

		[Test]
		public void TestModule()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Module"));
			Assert.AreEqual(Tokens.Module, lexer.NextToken().Kind);
		}

		[Test]
		public void TestMustInherit()
		{
			VBLexer lexer = GenerateLexer(new StringReader("MustInherit"));
			Assert.AreEqual(Tokens.MustInherit, lexer.NextToken().Kind);
		}

		[Test]
		public void TestMustOverride()
		{
			VBLexer lexer = GenerateLexer(new StringReader("MustOverride"));
			Assert.AreEqual(Tokens.MustOverride, lexer.NextToken().Kind);
		}

		[Test]
		public void TestMyBase()
		{
			VBLexer lexer = GenerateLexer(new StringReader("MyBase"));
			Assert.AreEqual(Tokens.MyBase, lexer.NextToken().Kind);
		}

		[Test]
		public void TestMyClass()
		{
			VBLexer lexer = GenerateLexer(new StringReader("MyClass"));
			Assert.AreEqual(Tokens.MyClass, lexer.NextToken().Kind);
		}

		[Test]
		public void TestNamespace()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Namespace"));
			Assert.AreEqual(Tokens.Namespace, lexer.NextToken().Kind);
		}

		[Test]
		public void TestNarrowing()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Narrowing"));
			Assert.AreEqual(Tokens.Narrowing, lexer.NextToken().Kind);
		}

		[Test]
		public void TestNew()
		{
			VBLexer lexer = GenerateLexer(new StringReader("New"));
			Assert.AreEqual(Tokens.New, lexer.NextToken().Kind);
		}

		[Test]
		public void TestNext()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Next"));
			Assert.AreEqual(Tokens.Next, lexer.NextToken().Kind);
		}

		[Test]
		public void TestNot()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Not"));
			Assert.AreEqual(Tokens.Not, lexer.NextToken().Kind);
		}

		[Test]
		public void TestNothing()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Nothing"));
			Assert.AreEqual(Tokens.Nothing, lexer.NextToken().Kind);
		}

		[Test]
		public void TestNotInheritable()
		{
			VBLexer lexer = GenerateLexer(new StringReader("NotInheritable"));
			Assert.AreEqual(Tokens.NotInheritable, lexer.NextToken().Kind);
		}

		[Test]
		public void TestNotOverridable()
		{
			VBLexer lexer = GenerateLexer(new StringReader("NotOverridable"));
			Assert.AreEqual(Tokens.NotOverridable, lexer.NextToken().Kind);
		}

		[Test]
		public void TestObject()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Object"));
			Assert.AreEqual(Tokens.Object, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOf()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Of"));
			Assert.AreEqual(Tokens.Of, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOff()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Off"));
			Assert.AreEqual(Tokens.Off, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOn()
		{
			VBLexer lexer = GenerateLexer(new StringReader("On"));
			Assert.AreEqual(Tokens.On, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOperator()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Operator"));
			Assert.AreEqual(Tokens.Operator, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOption()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Option"));
			Assert.AreEqual(Tokens.Option, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOptional()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Optional"));
			Assert.AreEqual(Tokens.Optional, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOr()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Or"));
			Assert.AreEqual(Tokens.Or, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOrder()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Order"));
			Assert.AreEqual(Tokens.Order, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOrElse()
		{
			VBLexer lexer = GenerateLexer(new StringReader("OrElse"));
			Assert.AreEqual(Tokens.OrElse, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOut()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Out"));
			Assert.AreEqual(Tokens.Out, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOverloads()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Overloads"));
			Assert.AreEqual(Tokens.Overloads, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOverridable()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Overridable"));
			Assert.AreEqual(Tokens.Overridable, lexer.NextToken().Kind);
		}

		[Test]
		public void TestOverrides()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Overrides"));
			Assert.AreEqual(Tokens.Overrides, lexer.NextToken().Kind);
		}

		[Test]
		public void TestParamArray()
		{
			VBLexer lexer = GenerateLexer(new StringReader("ParamArray"));
			Assert.AreEqual(Tokens.ParamArray, lexer.NextToken().Kind);
		}

		[Test]
		public void TestPartial()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Partial"));
			Assert.AreEqual(Tokens.Partial, lexer.NextToken().Kind);
		}

		[Test]
		public void TestPreserve()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Preserve"));
			Assert.AreEqual(Tokens.Preserve, lexer.NextToken().Kind);
		}

		[Test]
		public void TestPrivate()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Private"));
			Assert.AreEqual(Tokens.Private, lexer.NextToken().Kind);
		}

		[Test]
		public void TestProperty()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Property"));
			Assert.AreEqual(Tokens.Property, lexer.NextToken().Kind);
		}

		[Test]
		public void TestProtected()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Protected"));
			Assert.AreEqual(Tokens.Protected, lexer.NextToken().Kind);
		}

		[Test]
		public void TestPublic()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Public"));
			Assert.AreEqual(Tokens.Public, lexer.NextToken().Kind);
		}

		[Test]
		public void TestRaiseEvent()
		{
			VBLexer lexer = GenerateLexer(new StringReader("RaiseEvent"));
			Assert.AreEqual(Tokens.RaiseEvent, lexer.NextToken().Kind);
		}

		[Test]
		public void TestReadOnly()
		{
			VBLexer lexer = GenerateLexer(new StringReader("ReadOnly"));
			Assert.AreEqual(Tokens.ReadOnly, lexer.NextToken().Kind);
		}

		[Test]
		public void TestReDim()
		{
			VBLexer lexer = GenerateLexer(new StringReader("ReDim"));
			Assert.AreEqual(Tokens.ReDim, lexer.NextToken().Kind);
		}

		[Test]
		public void TestRemoveHandler()
		{
			VBLexer lexer = GenerateLexer(new StringReader("RemoveHandler"));
			Assert.AreEqual(Tokens.RemoveHandler, lexer.NextToken().Kind);
		}

		[Test]
		public void TestResume()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Resume"));
			Assert.AreEqual(Tokens.Resume, lexer.NextToken().Kind);
		}

		[Test]
		public void TestReturn()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Return"));
			Assert.AreEqual(Tokens.Return, lexer.NextToken().Kind);
		}

		[Test]
		public void TestSByte()
		{
			VBLexer lexer = GenerateLexer(new StringReader("SByte"));
			Assert.AreEqual(Tokens.SByte, lexer.NextToken().Kind);
		}

		[Test]
		public void TestSelect()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Select"));
			Assert.AreEqual(Tokens.Select, lexer.NextToken().Kind);
		}

		[Test]
		public void TestSet()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Set"));
			Assert.AreEqual(Tokens.Set, lexer.NextToken().Kind);
		}

		[Test]
		public void TestShadows()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Shadows"));
			Assert.AreEqual(Tokens.Shadows, lexer.NextToken().Kind);
		}

		[Test]
		public void TestShared()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Shared"));
			Assert.AreEqual(Tokens.Shared, lexer.NextToken().Kind);
		}

		[Test]
		public void TestShort()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Short"));
			Assert.AreEqual(Tokens.Short, lexer.NextToken().Kind);
		}

		[Test]
		public void TestSingle()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Single"));
			Assert.AreEqual(Tokens.Single, lexer.NextToken().Kind);
		}

		[Test]
		public void TestSkip()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Skip"));
			Assert.AreEqual(Tokens.Skip, lexer.NextToken().Kind);
		}

		[Test]
		public void TestStatic()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Static"));
			Assert.AreEqual(Tokens.Static, lexer.NextToken().Kind);
		}

		[Test]
		public void TestStep()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Step"));
			Assert.AreEqual(Tokens.Step, lexer.NextToken().Kind);
		}

		[Test]
		public void TestStop()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Stop"));
			Assert.AreEqual(Tokens.Stop, lexer.NextToken().Kind);
		}

		[Test]
		public void TestStrict()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Strict"));
			Assert.AreEqual(Tokens.Strict, lexer.NextToken().Kind);
		}

		[Test]
		public void TestString()
		{
			VBLexer lexer = GenerateLexer(new StringReader("String"));
			Assert.AreEqual(Tokens.String, lexer.NextToken().Kind);
		}

		[Test]
		public void TestStructure()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Structure"));
			Assert.AreEqual(Tokens.Structure, lexer.NextToken().Kind);
		}

		[Test]
		public void TestSub()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Sub"));
			Assert.AreEqual(Tokens.Sub, lexer.NextToken().Kind);
		}

		[Test]
		public void TestSyncLock()
		{
			VBLexer lexer = GenerateLexer(new StringReader("SyncLock"));
			Assert.AreEqual(Tokens.SyncLock, lexer.NextToken().Kind);
		}

		[Test]
		public void TestTake()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Take"));
			Assert.AreEqual(Tokens.Take, lexer.NextToken().Kind);
		}

		[Test]
		public void TestText()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Text"));
			Assert.AreEqual(Tokens.Text, lexer.NextToken().Kind);
		}

		[Test]
		public void TestThen()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Then"));
			Assert.AreEqual(Tokens.Then, lexer.NextToken().Kind);
		}

		[Test]
		public void TestThrow()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Throw"));
			Assert.AreEqual(Tokens.Throw, lexer.NextToken().Kind);
		}

		[Test]
		public void TestTo()
		{
			VBLexer lexer = GenerateLexer(new StringReader("To"));
			Assert.AreEqual(Tokens.To, lexer.NextToken().Kind);
		}

		[Test]
		public void TestTrue()
		{
			VBLexer lexer = GenerateLexer(new StringReader("True"));
			Assert.AreEqual(Tokens.True, lexer.NextToken().Kind);
		}

		[Test]
		public void TestTry()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Try"));
			Assert.AreEqual(Tokens.Try, lexer.NextToken().Kind);
		}

		[Test]
		public void TestTryCast()
		{
			VBLexer lexer = GenerateLexer(new StringReader("TryCast"));
			Assert.AreEqual(Tokens.TryCast, lexer.NextToken().Kind);
		}

		[Test]
		public void TestTypeOf()
		{
			VBLexer lexer = GenerateLexer(new StringReader("TypeOf"));
			Assert.AreEqual(Tokens.TypeOf, lexer.NextToken().Kind);
		}

		[Test]
		public void TestUInteger()
		{
			VBLexer lexer = GenerateLexer(new StringReader("UInteger"));
			Assert.AreEqual(Tokens.UInteger, lexer.NextToken().Kind);
		}

		[Test]
		public void TestULong()
		{
			VBLexer lexer = GenerateLexer(new StringReader("ULong"));
			Assert.AreEqual(Tokens.ULong, lexer.NextToken().Kind);
		}

		[Test]
		public void TestUnicode()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Unicode"));
			Assert.AreEqual(Tokens.Unicode, lexer.NextToken().Kind);
		}

		[Test]
		public void TestUntil()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Until"));
			Assert.AreEqual(Tokens.Until, lexer.NextToken().Kind);
		}

		[Test]
		public void TestUShort()
		{
			VBLexer lexer = GenerateLexer(new StringReader("UShort"));
			Assert.AreEqual(Tokens.UShort, lexer.NextToken().Kind);
		}

		[Test]
		public void TestUsing()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Using"));
			Assert.AreEqual(Tokens.Using, lexer.NextToken().Kind);
		}

		[Test]
		public void TestVariant()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Variant"));
			Assert.AreEqual(Tokens.Variant, lexer.NextToken().Kind);
		}

		[Test]
		public void TestWend()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Wend"));
			Assert.AreEqual(Tokens.Wend, lexer.NextToken().Kind);
		}

		[Test]
		public void TestWhen()
		{
			VBLexer lexer = GenerateLexer(new StringReader("When"));
			Assert.AreEqual(Tokens.When, lexer.NextToken().Kind);
		}

		[Test]
		public void TestWhere()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Where"));
			Assert.AreEqual(Tokens.Where, lexer.NextToken().Kind);
		}

		[Test]
		public void TestWhile()
		{
			VBLexer lexer = GenerateLexer(new StringReader("While"));
			Assert.AreEqual(Tokens.While, lexer.NextToken().Kind);
		}

		[Test]
		public void TestWidening()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Widening"));
			Assert.AreEqual(Tokens.Widening, lexer.NextToken().Kind);
		}

		[Test]
		public void TestWith()
		{
			VBLexer lexer = GenerateLexer(new StringReader("With"));
			Assert.AreEqual(Tokens.With, lexer.NextToken().Kind);
		}

		[Test]
		public void TestWithEvents()
		{
			VBLexer lexer = GenerateLexer(new StringReader("WithEvents"));
			Assert.AreEqual(Tokens.WithEvents, lexer.NextToken().Kind);
		}

		[Test]
		public void TestWriteOnly()
		{
			VBLexer lexer = GenerateLexer(new StringReader("WriteOnly"));
			Assert.AreEqual(Tokens.WriteOnly, lexer.NextToken().Kind);
		}

		[Test]
		public void TestXor()
		{
			VBLexer lexer = GenerateLexer(new StringReader("Xor"));
			Assert.AreEqual(Tokens.Xor, lexer.NextToken().Kind);
		}

		[Test]
		public void TestGetXmlNamespace()
		{
			VBLexer lexer = GenerateLexer(new StringReader("GetXmlNamespace"));
			Assert.AreEqual(Tokens.GetXmlNamespace, lexer.NextToken().Kind);
		}
	}
}
