/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.framework;

import java.util.List;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import sharpen.core.framework.BindingUtils;

public class StaticImports {
    public static boolean isStaticMethodImport(ImportDeclaration imp, IMethodBinding method) {
        IBinding binding = imp.resolveBinding();
        switch (binding.getKind()) {
            case 2: {
                return imp.isOnDemand() && method.getDeclaringClass() == binding;
            }
            case 4: {
                IMethodBinding bound = (IMethodBinding)binding;
                return bound.getDeclaringClass() == method.getDeclaringClass() && binding.getName().equals(method.getMethodDeclaration().getName());
            }
        }
        return false;
    }

    public static boolean isStaticFieldImport(ImportDeclaration imp, IVariableBinding field) {
        IBinding binding = imp.resolveBinding();
        if (binding.getKind() == 3) {
            return binding == field;
        }
        return false;
    }

    public static boolean isStaticImport(IMethodBinding method, List imports) {
        if (!BindingUtils.isStatic(method)) {
            return false;
        }
        for (Object imp : imports) {
            if (!StaticImports.isStaticMethodImport((ImportDeclaration)imp, method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStaticImport(IVariableBinding field, List imports) {
        if (!BindingUtils.isStatic(field)) {
            return false;
        }
        for (Object imp : imports) {
            if (!StaticImports.isStaticFieldImport((ImportDeclaration)imp, field)) continue;
            return true;
        }
        return false;
    }

    public static IMethodBinding staticImportMethodBinding(SimpleName node, List imports) {
        if (node.getLocationInParent() != MethodInvocation.NAME_PROPERTY) {
            return null;
        }
        MethodInvocation invocation = StaticImports.parentMethodInvocation(node);
        if (invocation.getExpression() != null) {
            return null;
        }
        IMethodBinding method = invocation.resolveMethodBinding();
        if (!StaticImports.isStaticImport(method, imports)) {
            return null;
        }
        return method;
    }

    private static MethodInvocation parentMethodInvocation(SimpleName node) {
        return (MethodInvocation)node.getParent();
    }
}

