/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.framework;

public abstract class CommandLineParser {
    protected final String[] _args;
    protected int _current;

    public CommandLineParser(String[] args) {
        if (args == null) {
            CommandLineParser.illegalArgument("args cannot be null");
        }
        this._args = args;
    }

    protected void processOption(String arg) {
        CommandLineParser.illegalArgument(arg);
    }

    protected void processArgument(String arg) {
        CommandLineParser.illegalArgument(arg);
    }

    protected void processResponseFile(String arg) {
        CommandLineParser.illegalArgument(arg);
    }

    protected void validate() {
    }

    protected static void illegalArgument(String message) {
        throw new IllegalArgumentException(message);
    }

    protected void parse() {
        while (this._current < this._args.length) {
            this.parseArgument(this._args[this._current]);
            ++this._current;
        }
        this.validate();
    }

    private void parseArgument(String arg) {
        if (arg.startsWith("@")) {
            this.processResponseFile(arg);
        } else if (arg.startsWith("-")) {
            this.processOption(arg);
        } else {
            this.processArgument(arg);
        }
    }

    protected boolean areEqual(String arg, String value) {
        return arg.equals(value);
    }

    protected String consumeNext() {
        return this._args[++this._current];
    }
}

