/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.csharp.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sharpen.core.csharp.ast.CSExpression;
import sharpen.core.csharp.ast.CSExpressionStatement;
import sharpen.core.csharp.ast.CSStatement;
import sharpen.core.csharp.ast.CSVisitor;

public class CSBlock
extends CSStatement {
    private List<CSStatement> _statements = new ArrayList<CSStatement>();

    public boolean isEmpty() {
        return this._statements.isEmpty();
    }

    public void addStatement(CSStatement statement) {
        this._statements.add(statement);
    }

    public void addStatement(CSExpression expression) {
        this._statements.add(this.newStatement(expression));
    }

    private CSExpressionStatement newStatement(CSExpression expression) {
        return new CSExpressionStatement(Integer.MIN_VALUE, expression);
    }

    public void addStatement(int index, CSExpression expression) {
        this._statements.add(index, this.newStatement(expression));
    }

    public void removeStatement(CSStatement cs) {
        this._statements.remove(cs);
    }

    public List<CSStatement> statements() {
        return Collections.unmodifiableList(this._statements);
    }

    @Override
    public void accept(CSVisitor visitor) {
        visitor.visit(this);
    }

    public void addAll(CSBlock body) {
        this._statements.addAll(body._statements);
    }

    public void addStatement(int index, CSStatement stmt) {
        this._statements.add(index, stmt);
    }
}

